/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.clickhouse;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.extractors.ObjectFormatterUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CHouseDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public CHouseDialect() {
        super(new TypeHelper.CHouseTypeHelper());
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "ClickHouse";
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.CLICKHOUSE;
        if (dbms == null) {
            CHouseDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(1);
        }
        if (procedure == null) {
            CHouseDialect.$$$reportNull$$$0(2);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsTableInfo() {
        return super.supportsTableInfo();
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            CHouseDialect.$$$reportNull$$$0(3);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        String schema = this.getNamingService().catToScript(current.getDisplayName(), current.kind, this.getCodeStyle().getQuotesPriority());
        return String.format("use %s", schema);
    }

    @Override
    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return super.supportsInsertInto();
    }

    @Nullable
    private static DasObject getDB(@NotNull DasObject qualifier) {
        DasObject schema;
        if (qualifier == null) {
            CHouseDialect.$$$reportNull$$$0(4);
        }
        return (schema = DasUtil.getSchemaObject(qualifier)) != null && !StringUtil.isEmpty((String)schema.getName()) ? schema : DasUtil.getCatalogObject(qualifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(@NotNull DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(5);
        }
        if (identifier == null) {
            CHouseDialect.$$$reportNull$$$0(6);
        }
        if (qualifier == null) {
            CHouseDialect.$$$reportNull$$$0(7);
        }
        DasObject db = CHouseDialect.getDB(qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, db, DasUtil.getName(db), null, null, null, null);
        if (ddlBuilder == null) {
            CHouseDialect.$$$reportNull$$$0(8);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getBinaryLiteralString(byte @NotNull [] binaryData) {
        if (binaryData == null) {
            CHouseDialect.$$$reportNull$$$0(9);
        }
        String string = "0x" + ObjectFormatterUtil.toHexString((byte[])binaryData);
        if (string == null) {
            CHouseDialect.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnectionCore connection2) {
        if (element == null) {
            CHouseDialect.$$$reportNull$$$0(11);
        }
        if (connection2 == null) {
            CHouseDialect.$$$reportNull$$$0(12);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseConnectionCore connection2) throws SQLException {
        Dbms dbms;
        String s;
        if (connection2 == null) {
            CHouseDialect.$$$reportNull$$$0(13);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtilCore.concatStringResults(connection2, dbms = connection2.getDbms(), "select currentDatabase()", 1, DbImplUtilCore.ConcatenationProps.NO_CONCAT))) ? null : SearchPath.of(ObjectPath.create(s, ObjectKind.SCHEMA));
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnectionCore connection2) throws SQLException {
        if (connection2 == null) {
            CHouseDialect.$$$reportNull$$$0(14);
        }
        List<String> list = DbImplUtilCore.executeAndGetResult(connection2, "SHOW DATABASES", DbImplUtilCore.RS_AS_STRING_LIST);
        if (list == null) {
            CHouseDialect.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 9, 11, 12, 13, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/clickhouse/CHouseDialect";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/clickhouse/CHouseDialect";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryLiteralString";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropProcedure";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDB";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 9, 11, 12, 13, 14 -> new IllegalArgumentException(string);
        };
    }
}

