/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileStatus;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorageCore;
import com.intellij.database.dataSource.srcStorage.DbSrcModificationSession;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcValidator;
import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageManager;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.ModelEntityStorage;
import com.intellij.database.model.ModelEntityStoragePersistentBackend;
import com.intellij.database.model.ModelEntityStoragePersistentBackendKt;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.ObjectNamePart;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class DbSrcModelStorage
extends DbSrcModelStorageCore {
    private static final Logger LOG = Logger.getInstance(DbSrcModelStorage.class);
    private static boolean ourCheckStorage = true;
    private final DbSrcStorage myStorage;
    @Nullable
    private final Project myProject;
    private volatile DbSrcModificationSession myModSession;
    private final Alarm myInvalidUsageReporter;
    private static final int MESSAGE_DELAY = 500;

    DbSrcModelStorage(@Nullable Project project, @NotNull String dataSourceId) {
        if (dataSourceId == null) {
            DbSrcModelStorage.$$$reportNull$$$0(0);
        }
        this.myStorage = DbSrcStorageManager.getInstance(project).getStorage(dataSourceId, true);
        this.myProject = project;
        this.myInvalidUsageReporter = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)(project == null ? ApplicationManager.getApplication() : project));
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public GuardedRef<?> startWriteSession(@Nullable Project currentProject, final @NotNull BasicModel model, @NotNull ModalityState modality, final boolean asyncRefresh, boolean check) {
        DbSrcModificationSession session;
        DbSrcModificationSession prev2;
        if (model == null) {
            DbSrcModelStorage.$$$reportNull$$$0(1);
        }
        if (modality == null) {
            DbSrcModelStorage.$$$reportNull$$$0(2);
        }
        if (check) {
            this.checkRegistered();
        }
        if ((prev2 = this.myModSession) != null) {
            LOG.error("Parallel storage modification prevented");
            throw new ProcessCanceledException();
        }
        this.myModSession = session = new DbSrcModificationSession((Project)ObjectUtils.chooseNotNull((Object)this.myProject, (Object)currentProject), this.myProject == null, this.myStorage, modality);
        return new GuardedRef<DbSrcModificationSession>(session){

            @Override
            protected void close(@NotNull DbSrcModificationSession ref2) {
                if (ref2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    session.regenSources((BasicModModel)model);
                    session.waitForWriteFinished(asyncRefresh);
                }
                finally {
                    if (session == DbSrcModelStorage.this.myModSession) {
                        DbSrcModelStorage.this.myModSession = null;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage$1", "close"));
            }
        };
    }

    private void checkRegistered() {
        if (!ApplicationManager.getApplication().isUnitTestMode() || !ourCheckStorage) {
            return;
        }
        LocalDataSource dataSource = DbSrcUtils.findDataSource(this.myProject, this.myStorage.getDataSourceId());
        if (dataSource == null) {
            LOG.error("Data source " + this.myStorage.getDataSourceId() + " is not in storage. There would be no dialect...");
        }
    }

    @Nullable
    private DbSrcModificationSession getModSession() {
        LOG.assertTrue(this.myModSession != null, (Object)"Session not started");
        return this.myModSession;
    }

    @Override
    public void save(@NotNull BasicSourceAware element, @Nullable CompositeText text) {
        DbSrcModificationSession session;
        if (element == null) {
            DbSrcModelStorage.$$$reportNull$$$0(3);
        }
        if ((session = this.getModSession()) != null) {
            session.save(element, text);
        }
    }

    @Override
    public void clear() {
        DbSrcModificationSession session = this.getModSession();
        if (session != null) {
            session.clear();
        }
    }

    @Override
    public void queueDelete(@NotNull BasicElement element) {
        DbSrcModificationSession session;
        if (element == null) {
            DbSrcModelStorage.$$$reportNull$$$0(4);
        }
        if ((session = this.getModSession()) != null) {
            session.queueDelete(element);
        }
    }

    @Override
    public void flushQueues() {
        DbSrcModificationSession session = this.myModSession;
        if (session == null) {
            return;
        }
        session.beginWrite();
        session.endWrite();
    }

    @Override
    public void handleRename(@NotNull BasicElement e, @NotNull ObjectNamePart oldName) {
        DbSrcModificationSession session;
        if (e == null) {
            DbSrcModelStorage.$$$reportNull$$$0(5);
        }
        if (oldName == null) {
            DbSrcModelStorage.$$$reportNull$$$0(6);
        }
        if ((session = this.getModSession()) != null) {
            session.queueRename(e, oldName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSession(@NotNull BasicModModel model, @NotNull Runnable runnable) {
        DbSrcModificationSession session;
        if (model == null) {
            DbSrcModelStorage.$$$reportNull$$$0(7);
        }
        if (runnable == null) {
            DbSrcModelStorage.$$$reportNull$$$0(8);
        }
        if ((session = this.getModSession()) != null) {
            session.beginWrite();
            try {
                runnable.run();
            }
            finally {
                session.endWrite();
            }
        } else {
            runnable.run();
        }
    }

    @Override
    @Nullable
    public CompositeText load(@NotNull BasicSourceAware element) {
        DbSrcModificationSession session;
        CompositeText src;
        if (element == null) {
            DbSrcModelStorage.$$$reportNull$$$0(9);
        }
        CompositeText compositeText = src = (session = this.myModSession) == null ? null : session.getTmpSource(element);
        if (src != null) {
            return src;
        }
        return this.inspectAndGetSources(element, session);
    }

    @Nullable
    private CompositeText inspectAndGetSources(@NotNull BasicSourceAware element, DbSrcModificationSession session) {
        if (element == null) {
            DbSrcModelStorage.$$$reportNull$$$0(10);
        }
        ObjectPath srcPath = ObjectPaths.of(element, element.getModel());
        String text = this.getOriginalContent(srcPath, true);
        DbSrcStorageDsMetadata.MetaData md = this.myStorage.getMetaData(srcPath);
        if (session == null) {
            this.inspect(element, text, md);
        }
        if (text == null) {
            return null;
        }
        boolean noRanges = md == null || md.kinds == null || md.kinds.length == 0;
        return noRanges ? new SimpleCompositeText((CharSequence)text, CompositeText.Kind.ORIGINAL_TEXT) : new PersistentMarkup(text, md.offsets, md.kinds, null);
    }

    private void inspect(@NotNull BasicSourceAware element, String text, DbSrcStorageDsMetadata.MetaData md) {
        if (element == null) {
            DbSrcModelStorage.$$$reportNull$$$0(11);
        }
        if (text == null) {
            if (element.getSourceTextLength() != 0) {
                this.markAsInvalid(element);
                this.queueInvalidSourceUsageReport(element);
            }
        } else if (DbSrcModelStorage.isOutdated(element, md)) {
            this.markAsInvalid(element);
            this.queueInvalidSourceUsageReport(element);
        }
    }

    private void markAsInvalid(@NotNull BasicSourceAware element) {
        if (element == null) {
            DbSrcModelStorage.$$$reportNull$$$0(12);
        }
        try {
            ObjectPath srcPath = ObjectPaths.of(element, element.getModel());
            while (srcPath != null) {
                DbSrcStorageDsMetadata.MetaData md = this.myStorage.getMetaData(srcPath);
                if (md != null && md.srcVersion != null) {
                    this.myStorage.putMetaData(srcPath, DbSrcStorageDsMetadata.MetaData.modSrcVersion(md, null));
                }
                srcPath = srcPath.parent;
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static boolean isOutdated(@NotNull BasicSourceAware element, DbSrcStorageDsMetadata.MetaData md) {
        BasicModel model;
        if (element == null) {
            DbSrcModelStorage.$$$reportNull$$$0(13);
        }
        Dbms rdbms = (model = element.getModel()) == null ? Dbms.UNKNOWN : model.getDbms();
        return md != null && md.introContentVersion != DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(rdbms, element.getKind());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getOriginalContent(ObjectPath srcPath, boolean forceLoad) {
        if (!forceLoad) {
            DbSrcFileSystem fs = DbSrcFileSystem.getInstance();
            VirtualFile file = fs.findFileByPath(DbSrcFileSystem.getPathFromNormalized(this.myProject, this.myStorage.getDataSourceId(), srcPath, (DbSrcFileSystemCore.ItemTypeOrFolder)DbSrcFileSystemCore.ItemType.SRC));
            VirtualFile virtualFile = file = file == null ? null : fs.getBaseFile(file, false);
            if (file != null) {
                return DbSrcFileStatus.Companion.getContent(file, false);
            }
        }
        try (InputStream is = this.myStorage.getContentInputStream(srcPath, DbSrcFileSystemCore.ItemType.ORIG);){
            String string;
            if (is == null) {
                string = null;
                return string;
            }
            string = new String(FileUtil.adaptiveLoadText((Reader)new InputStreamReader(is, StandardCharsets.UTF_8)));
            return string;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Override
    public Long getVersion(@NotNull BasicElement element) {
        ObjectPath srcPath;
        DbSrcStorageDsMetadata.MetaData data;
        if (element == null) {
            DbSrcModelStorage.$$$reportNull$$$0(14);
        }
        return (data = this.myStorage.getMetaData(srcPath = ObjectPaths.of(element))) == null ? null : data.srcVersion;
    }

    @Override
    public void setVersion(@NotNull BasicElement element, Long version) {
        if (element == null) {
            DbSrcModelStorage.$$$reportNull$$$0(15);
        }
        ObjectPath srcPath = ObjectPaths.of(element);
        DbSrcStorageDsMetadata.MetaData data = this.myStorage.getMetaData(srcPath);
        try {
            this.myStorage.putMetaData(srcPath, DbSrcStorageDsMetadata.MetaData.modSrcVersion(data, version));
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @NotNull
    public Path getStorageRoot() {
        Path root = DbSrcStorageManager.getStorageRoot(this.myProject);
        Path path = root.resolve(this.myStorage.getDataSourceId());
        if (path == null) {
            DbSrcModelStorage.$$$reportNull$$$0(16);
        }
        return path;
    }

    private static Path getDataSourceCachesRoot(@Nullable Project project, @NotNull String dataSourceId) {
        if (dataSourceId == null) {
            DbSrcModelStorage.$$$reportNull$$$0(17);
        }
        return Paths.get(PathManager.getSystemPath(), "data-source", project == null ? "app" : project.getLocationHash(), dataSourceId);
    }

    @Override
    @NotNull
    public ModelEntityStorage.Backend createEntityStorage() {
        final ModelEntityStoragePersistentBackend backend = DbSrcModelStorage.createPersistentBackend(this.myProject, this.myStorage.getDataSourceId());
        if (backend == null) {
            ModelEntityStorage.Backend backend2 = ModelEntityStorage.NO_OP;
            if (backend2 == null) {
                DbSrcModelStorage.$$$reportNull$$$0(18);
            }
            return backend2;
        }
        ProgressManager.checkCanceled();
        Disposer.register((Disposable)DbSrcUtils.getDataSourceStorage(this.myProject), (Disposable)backend);
        (this.myProject == null ? ApplicationManager.getApplication() : this.myProject).getMessageBus().connect((Disposable)backend).subscribe(DataSourceStorage.TOPIC, (Object)new DataSourceStorage.Listener(){

            @Override
            public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (DbSrcModelStorage.this.myStorage.getDataSourceId().equals(dataSource.getUniqueId())) {
                    backend.close();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage$2", "dataSourceRemoved"));
            }
        });
        ModelEntityStoragePersistentBackend modelEntityStoragePersistentBackend = backend;
        if (modelEntityStoragePersistentBackend == null) {
            DbSrcModelStorage.$$$reportNull$$$0(19);
        }
        return modelEntityStoragePersistentBackend;
    }

    @Nullable
    public static ModelEntityStoragePersistentBackend createPersistentBackend(Project project, String dataSourceId) {
        Path entitiesDir = DbSrcModelStorage.getDataSourceCachesRoot(project, dataSourceId).resolve("entities");
        Path data = entitiesDir.resolve("entities.dat");
        try {
            return DbSrcModelStorage.createBackend(entitiesDir, data);
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    private static ModelEntityStoragePersistentBackend createBackend(Path entitiesDir, Path data) throws IOException {
        ModelEntityStoragePersistentBackend modelEntityStoragePersistentBackend;
        try {
            modelEntityStoragePersistentBackend = ModelEntityStoragePersistentBackendKt.create(data);
        }
        catch (IOException th) {
            LOG.warn("Will recreate", (Throwable)th);
            try {
                FileUtil.delete((Path)entitiesDir);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            ModelEntityStoragePersistentBackend modelEntityStoragePersistentBackend2 = ModelEntityStoragePersistentBackendKt.create(data);
            if (modelEntityStoragePersistentBackend2 == null) {
                DbSrcModelStorage.$$$reportNull$$$0(21);
            }
            return modelEntityStoragePersistentBackend2;
        }
        if (modelEntityStoragePersistentBackend == null) {
            DbSrcModelStorage.$$$reportNull$$$0(20);
        }
        return modelEntityStoragePersistentBackend;
    }

    private void queueInvalidSourceUsageReport(@NotNull BasicSourceAware object) {
        if (object == null) {
            DbSrcModelStorage.$$$reportNull$$$0(22);
        }
        if (!DbSrcValidator.isEnabled()) {
            return;
        }
        this.myInvalidUsageReporter.cancelAllRequests();
        this.myInvalidUsageReporter.addRequest(this::reportInvalidSourceUsage, 500);
    }

    private void reportInvalidSourceUsage() {
        Project project;
        LocalDataSource dataSource = DbSrcUtils.findDataSource(this.myProject, this.myStorage.getDataSourceId());
        if (dataSource == null) {
            return;
        }
        Project project2 = project = this.myProject == null ? DbImplUtilCore.getAnyProject() : this.myProject;
        if (project == null) {
            return;
        }
        DbSrcValidator.suggestIntrospecting(project, Collections.singletonList(dataSource));
    }

    @TestOnly
    public static void doNotCheckStorage(@NotNull Disposable d) {
        if (d == null) {
            DbSrcModelStorage.$$$reportNull$$$0(23);
        }
        ourCheckStorage = false;
        Disposer.register((Disposable)d, () -> {
            ourCheckStorage = true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16, 18, 19, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceId";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageRoot";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createEntityStorage";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createBackend";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startWriteSession";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "queueDelete";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleRename";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeSession";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "inspectAndGetSources";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "inspect";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "markAsInvalid";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isOutdated";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setVersion";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceCachesRoot";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "queueInvalidSourceUsageReport";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doNotCheckStorage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16, 18, 19, 20, 21 -> new IllegalStateException(string);
        };
    }
}

