/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.HSet;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.ui.AuthWidgetBuilder;
import com.intellij.database.dataSource.url.template.MutableParametersHolder;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.database.view.DatabaseCoreUiService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 $2\u00020\u0001:\u0004$%&'B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\r\u0010\u0006\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0007H\u0016J$\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010#\u00a8\u0006("}, d2={"Lcom/intellij/database/dataSource/AwsProfileAuthProvider;", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "<init>", "()V", "getId", "", "getDisplayName", "Lorg/jetbrains/annotations/Nls;", "loadAuthConfig", "", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "external", "", "saveAuthConfig", "", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "data", "createWidget", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$AuthWidget;", "project", "Lcom/intellij/openapi/project/Project;", "isApplicable", "dataSource", "getApplicability", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel$Result;", "level", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel;", "interceptConnection", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "silent", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "AwsCredentials", "Config", "AwsProfileCompletionProvider", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nAwsProfileAuthProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwsProfileAuthProvider.kt\ncom/intellij/database/dataSource/AwsProfileAuthProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,159:1\n1#2:160\n19#3:161\n19#3:162\n*S KotlinDebug\n*F\n+ 1 AwsProfileAuthProvider.kt\ncom/intellij/database/dataSource/AwsProfileAuthProvider\n*L\n58#1:161\n59#1:162\n*E\n"})
public final class AwsProfileAuthProvider
implements DatabaseAuthProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final HSet SUPPORTED;
    @NotNull
    public static final String ID = "dg.aws.profile";
    @NotNull
    public static final String AWS_PROFILE = "Profile";
    @NotNull
    public static final String AWS_USER = "DbUser";

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = DatabaseBundle.message("auth.provider.aws.profile.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @Nullable
    public Object loadAuthConfig(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials, boolean external) {
        Config config;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        if (external) {
            return null;
        }
        Config it = config = new Config(LocalDataSource.getUsername(point), point.getAdditionalProperty(AWS_PROFILE));
        boolean bl = false;
        return it.getProfile() != null || StringUtil.isNotEmpty((String)it.getUsername()) ? config : null;
    }

    @Override
    public void saveAuthConfig(@NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials, @Nullable Object data, boolean external) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (external) {
            return;
        }
        Object $this$asSafely$iv = data;
        boolean $i$f$asSafely = false;
        Object object = $this$asSafely$iv;
        if (!(object instanceof Config)) {
            object = null;
        }
        Config config2 = (Config)object;
        LocalDataSource.setUsername(config, config2 != null ? config2.getUsername() : null);
        $this$asSafely$iv = data;
        $i$f$asSafely = false;
        Object object2 = $this$asSafely$iv;
        if (!(object2 instanceof Config)) {
            object2 = null;
        }
        Config config3 = (Config)object2;
        config.setAdditionalProperty(AWS_PROFILE, config3 != null ? config3.getProfile() : null);
    }

    @Override
    @Nullable
    public DatabaseAuthProvider.AuthWidget createWidget(@Nullable Project project, @NotNull DatabaseCredentials credentials, @NotNull DatabaseConnectionConfig config) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        AuthWidgetBuilder authWidgetBuilder = DatabaseCoreUiService.getInstance().createAuthWidgetBuilder();
        if (authWidgetBuilder == null) {
            return null;
        }
        AuthWidgetBuilder builder = authWidgetBuilder;
        return builder.addUserField().addTextField(DatabaseBundle.messagePointer("auth.provider.aws.profile.profile", new Object[0]), new AwsProfileCompletionProvider(), AuthWidgetBuilder.additionalPropertySerializer(AWS_PROFILE), new AuthWidgetBuilder.UrlHandler<String>(){

            public String fromUrl(ParametersHolder holder) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                return null;
            }

            public void toUrl(String v, MutableParametersHolder model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                model.setParameter("iam", "iam:");
            }
        }).build(project, credentials, config);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isApplicable(DatabaseConnectionPoint dataSource) {
        if (dataSource.getDbms().in(SUPPORTED)) return true;
        String string = dataSource.getDriverClass();
        if (string == null) return false;
        String it = string;
        boolean bl = false;
        boolean bl2 = StringUtil.containsIgnoreCase((String)it, (String)"simba.athena.");
        if (!bl2) return false;
        return true;
    }

    @Override
    @NotNull
    public DatabaseAuthProvider.ApplicabilityLevel.Result getApplicability(@NotNull DatabaseConnectionPoint point, @NotNull DatabaseAuthProvider.ApplicabilityLevel level) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return !this.isApplicable(point) ? DatabaseAuthProvider.ApplicabilityLevel.Result.NOT_APPLICABLE : DatabaseAuthProvider.ApplicabilityLevel.Result.DEFAULT.clamp(level);
    }

    @Override
    @Nullable
    public Object interceptConnection(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent, @NotNull Continuation<? super Boolean> $completion) {
        proto2.getConnectionProperties().put(AWS_PROFILE, proto2.getConnectionPoint().getAdditionalProperty(AWS_PROFILE));
        proto2.getConnectionProperties().put(AWS_USER, proto2.getConnectionPoint().getDataSource().getUsername());
        return Boxing.boxBoolean((boolean)true);
    }

    static {
        HSet hSet = HSet.create("AWS_PROFILE_AUTH_SUPPORTED");
        Intrinsics.checkNotNullExpressionValue((Object)hSet, (String)"create(...)");
        SUPPORTED = hSet;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\t\u0018\u00002\u00020\u0001B)\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dataSource/AwsProfileAuthProvider$AwsCredentials;", "", "error", "", "stamp", "", "profiles", "", "<init>", "(Ljava/lang/String;JLjava/util/List;)V", "getError", "()Ljava/lang/String;", "getStamp", "()J", "getProfiles", "()Ljava/util/List;", "intellij.database.core.impl"})
    public static final class AwsCredentials {
        @Nullable
        private final String error;
        private final long stamp;
        @NotNull
        private final List<String> profiles;

        public AwsCredentials(@Nls @Nullable String error, long stamp, @NotNull List<String> profiles) {
            Intrinsics.checkNotNullParameter(profiles, (String)"profiles");
            this.error = error;
            this.stamp = stamp;
            this.profiles = profiles;
        }

        @Nullable
        public final String getError() {
            return this.error;
        }

        public final long getStamp() {
            return this.stamp;
        }

        @NotNull
        public final List<String> getProfiles() {
            return this.profiles;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cH\u0002J\b\u0010 \u001a\u00020\u0005H\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/database/dataSource/AwsProfileAuthProvider$AwsProfileCompletionProvider;", "Lcom/intellij/database/dataSource/ui/AuthWidgetBuilder$CompletionProvider;", "<init>", "()V", "file", "", "getFile", "()Ljava/lang/String;", "setFile", "(Ljava/lang/String;)V", "stamp", "", "getStamp", "()Ljava/lang/Long;", "setStamp", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "cache", "", "Lcom/intellij/database/dataSource/AwsProfileAuthProvider$AwsCredentials;", "getCredentials", "path", "parse", "getItems", "", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "error", "Ljava/util/function/Consumer;", "setCredentialsFile", "", "updateCompletion", "getCredentialsFile", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nAwsProfileAuthProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwsProfileAuthProvider.kt\ncom/intellij/database/dataSource/AwsProfileAuthProvider$AwsProfileCompletionProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
    private static final class AwsProfileCompletionProvider
    implements AuthWidgetBuilder.CompletionProvider {
        @Nullable
        private String file;
        @Nullable
        private Long stamp;
        @NotNull
        private final Map<String, AwsCredentials> cache;

        public AwsProfileCompletionProvider() {
            ConcurrentMap concurrentMap = ConcurrentFactoryMap.create(arg_0 -> AwsProfileCompletionProvider.cache$lambda$0((Function1)new Function1<String, AwsCredentials>((Object)this){

                public final AwsCredentials invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return AwsProfileCompletionProvider.access$parse((AwsProfileCompletionProvider)this.receiver, p0);
                }
            }, arg_0), ContainerUtil::createConcurrentSoftValueMap);
            Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"create(...)");
            this.cache = concurrentMap;
        }

        @Nullable
        public final String getFile() {
            return this.file;
        }

        public final void setFile(@Nullable String string) {
            this.file = string;
        }

        @Nullable
        public final Long getStamp() {
            return this.stamp;
        }

        public final void setStamp(@Nullable Long l) {
            this.stamp = l;
        }

        private final AwsCredentials getCredentials(String path) {
            File file = new File(path).getAbsoluteFile();
            String canonical = file.getCanonicalPath();
            AwsCredentials profile = this.cache.get(canonical);
            long stamp = file.exists() ? file.lastModified() : -1L;
            AwsCredentials awsCredentials = profile;
            if (!(awsCredentials != null ? awsCredentials.getStamp() == stamp : false)) {
                this.cache.remove(canonical);
                profile = this.cache.get(canonical);
            }
            AwsCredentials awsCredentials2 = profile;
            Intrinsics.checkNotNull((Object)awsCredentials2);
            return awsCredentials2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final AwsCredentials parse(String path) {
            File file = new File(path);
            if (!file.exists()) {
                Object[] objectArray = new Object[]{path};
                return new AwsCredentials(DatabaseBundle.message("path.does.not.exists", objectArray), -1L, CollectionsKt.emptyList());
            }
            long stamp = file.lastModified();
            try {
                Closeable closeable = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
                Throwable throwable = null;
                try {
                    BufferedReader reader = (BufferedReader)closeable;
                    boolean bl = false;
                    Regex pattern = new Regex("\\[(.*)]\\s*");
                    Stream<String> stream = reader.lines();
                    Intrinsics.checkNotNullExpressionValue(stream, (String)"lines(...)");
                    List names = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)StreamsKt.asSequence(stream), arg_0 -> AwsProfileCompletionProvider.parse$lambda$2$lambda$1(pattern, arg_0)));
                    AwsCredentials awsCredentials = new AwsCredentials(null, stamp, names);
                    return awsCredentials;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Throwable th) {
                return new AwsCredentials(th.getMessage(), stamp, CollectionsKt.emptyList());
            }
        }

        @Override
        @NotNull
        public List<String> getItems(@NotNull DatabaseConnectionPoint point, @NotNull Consumer<String> error) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            Intrinsics.checkNotNullParameter(error, (String)"error");
            this.setCredentialsFile();
            return this.updateCompletion(error);
        }

        private final void setCredentialsFile() {
            this.file = this.getCredentialsFile();
            this.stamp = null;
        }

        private final List<String> updateCompletion(Consumer<String> error) {
            if (this.file == null) {
                return CollectionsKt.emptyList();
            }
            String string = this.file;
            Intrinsics.checkNotNull((Object)string);
            AwsCredentials c2 = this.getCredentials(string);
            String string2 = c2.getError();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                error.accept(it);
            }
            Long l = this.stamp;
            long l2 = c2.getStamp();
            if (l != null && l == l2) {
                return CollectionsKt.emptyList();
            }
            this.stamp = c2.getStamp();
            return c2.getProfiles();
        }

        private final String getCredentialsFile() {
            return SystemInfo.isWindows ? EnvironmentUtil.getValue((String)"USERPROFILE") + "\\.aws\\credentials" : PathMacroUtil.getUserHomePath() + "/.aws/credentials";
        }

        private static final AwsCredentials cache$lambda$0(Function1 $tmp0, Object p0) {
            return (AwsCredentials)$tmp0.invoke(p0);
        }

        private static final String parse$lambda$2$lambda$1(Regex $pattern, String line) {
            Intrinsics.checkNotNull((Object)line);
            Object object = $pattern.matchEntire((CharSequence)line);
            return object != null && (object = object.getGroupValues()) != null ? (String)object.get(1) : null;
        }

        public static final /* synthetic */ AwsCredentials access$parse(AwsProfileCompletionProvider $this, String path) {
            return $this.parse(path);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dataSource/AwsProfileAuthProvider$Companion;", "", "<init>", "()V", "SUPPORTED", "Lcom/intellij/database/HSet;", "getSUPPORTED", "()Lcom/intellij/database/HSet;", "ID", "", "AWS_PROFILE", "AWS_USER", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HSet getSUPPORTED() {
            return SUPPORTED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J!\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dataSource/AwsProfileAuthProvider$Config;", "", "username", "", "profile", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getUsername", "()Ljava/lang/String;", "getProfile", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.database.core.impl"})
    private static final class Config {
        @Nullable
        private final String username;
        @Nullable
        private final String profile;

        public Config(@Nullable String username, @Nullable String profile) {
            this.username = username;
            this.profile = profile;
        }

        @Nullable
        public final String getUsername() {
            return this.username;
        }

        @Nullable
        public final String getProfile() {
            return this.profile;
        }

        @Nullable
        public final String component1() {
            return this.username;
        }

        @Nullable
        public final String component2() {
            return this.profile;
        }

        @NotNull
        public final Config copy(@Nullable String username, @Nullable String profile) {
            return new Config(username, profile);
        }

        public static /* synthetic */ Config copy$default(Config config, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = config.username;
            }
            if ((n & 2) != 0) {
                string2 = config.profile;
            }
            return config.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Config(username=" + this.username + ", profile=" + this.profile + ")";
        }

        public int hashCode() {
            int result2 = this.username == null ? 0 : this.username.hashCode();
            result2 = result2 * 31 + (this.profile == null ? 0 : this.profile.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Config)) {
                return false;
            }
            Config config = (Config)other;
            if (!Intrinsics.areEqual((Object)this.username, (Object)config.username)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.profile, (Object)config.profile);
        }
    }
}

