/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.evaluation;

import com.intellij.database.Dbms;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.console.evaluation.DasObjectRequestor;
import com.intellij.database.console.evaluation.DatabaseExpressionEvaluator;
import com.intellij.database.console.evaluation.EvaluationRequest;
import com.intellij.database.console.evaluation.EvaluationRequestor;
import com.intellij.database.console.evaluation.PsiRequestor;
import com.intellij.database.console.evaluation.TextRequestor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.SearchPath;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum EvaluationRequestorFactory {
    DAS_OBJECT{

        @Override
        @Nullable
        EvaluationRequestor<DataRequest.OwnerEx> getRequestor(@NotNull Project project, @NotNull PsiCodeFragment fragment, @NotNull DbDataSource source) {
            if (project == null) {
                1.$$$reportNull$$$0(0);
            }
            if (fragment == null) {
                1.$$$reportNull$$$0(1);
            }
            if (source == null) {
                1.$$$reportNull$$$0(2);
            }
            if (PsiTreeUtil.hasErrorElements((PsiElement)fragment)) {
                return null;
            }
            PsiElement child = fragment.getFirstChild();
            SqlReferenceExpression type = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)child, SqlReferenceExpression.class);
            DasObject object = type == null ? null : (DasObject)ObjectUtils.tryCast((Object)type.resolve(), DasObject.class);
            DasObjectRequestor requestor = object == null ? null : new DasObjectRequestor(project, source, object);
            return requestor == null || requestor.isEmpty() ? null : requestor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fragment";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/console/evaluation/EvaluationRequestorFactory$1";
            objectArray[2] = "getRequestor";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
    ,
    EXPRESSION{

        @Override
        @Nullable
        EvaluationRequestor<DataRequest.OwnerEx> getRequestor(@NotNull Project project, @NotNull PsiCodeFragment fragment, @NotNull DbDataSource source) {
            if (project == null) {
                2.$$$reportNull$$$0(0);
            }
            if (fragment == null) {
                2.$$$reportNull$$$0(1);
            }
            if (source == null) {
                2.$$$reportNull$$$0(2);
            }
            String fragmentText = fragment.getText();
            PsiElement child = fragment.getFirstChild();
            SqlExpression expression = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)child, SqlExpression.class);
            if (expression == null) {
                return null;
            }
            if (PsiRequestor.isUnsupportedExpression(expression)) {
                return null;
            }
            Dbms id = source.getDbms();
            ExecutionEnvironmentHelper helper = ExecutionEnvironmentHelper.EP.forDbms(id);
            return new TextRequestor(project, helper.getQuery(fragmentText, (SqlElement)expression), source);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fragment";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/console/evaluation/EvaluationRequestorFactory$2";
            objectArray[2] = "getRequestor";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
    ,
    SELECT{

        @Override
        @Nullable
        EvaluationRequestor<DataRequest.OwnerEx> getRequestor(@NotNull Project project, @NotNull PsiCodeFragment fragment, @NotNull DbDataSource source) {
            if (project == null) {
                3.$$$reportNull$$$0(0);
            }
            if (fragment == null) {
                3.$$$reportNull$$$0(1);
            }
            if (source == null) {
                3.$$$reportNull$$$0(2);
            }
            Language language = DbSqlUtil.getLanguage(source);
            String fragmentText = fragment.getText();
            List<String> queries = DbSqlUtilCore.getQueries(fragmentText, project, language);
            if (queries.size() > 1) {
                return null;
            }
            PsiElement child = fragment.getFirstChild();
            SqlSelectStatement selectStatement = (SqlSelectStatement)PsiTreeUtil.getChildOfType((PsiElement)child, SqlSelectStatement.class);
            return selectStatement == null ? null : new TextRequestor(project, fragmentText, source);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fragment";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/console/evaluation/EvaluationRequestorFactory$3";
            objectArray[2] = "getRequestor";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };


    @Nullable
    abstract EvaluationRequestor<DataRequest.OwnerEx> getRequestor(@NotNull Project var1, @NotNull PsiCodeFragment var2, @NotNull DbDataSource var3);

    @NotNull
    public static EvaluationRequestor<DataRequest.OwnerEx> create(@NotNull Project project, @NotNull String text, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath) {
        if (project == null) {
            EvaluationRequestorFactory.$$$reportNull$$$0(0);
        }
        if (text == null) {
            EvaluationRequestorFactory.$$$reportNull$$$0(1);
        }
        if (dataSource == null) {
            EvaluationRequestorFactory.$$$reportNull$$$0(2);
        }
        String trimmed = StringUtil.convertLineSeparators((String)StringUtil.trimTrailing((String)text, (char)';'));
        SqlLanguageDialect sqlDialect = DbSqlUtilCore.getSqlDialect(dataSource);
        SqlPsiFacade facade = SqlPsiFacade.getInstance((Project)project);
        PsiCodeFragment fragment = facade.createEvaluableExpressionFragment((Language)sqlDialect, dataSource, searchPath, trimmed);
        for (EvaluationRequestorFactory factory : EvaluationRequestorFactory.values()) {
            EvaluationRequestor<DataRequest.OwnerEx> result2 = factory.getRequestor(project, fragment, dataSource);
            if (result2 == null) continue;
            EvaluationRequestor<DataRequest.OwnerEx> evaluationRequestor = result2;
            if (evaluationRequestor == null) {
                EvaluationRequestorFactory.$$$reportNull$$$0(3);
            }
            return evaluationRequestor;
        }
        return new EmptyRequestor(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/evaluation/EvaluationRequestorFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/evaluation/EvaluationRequestorFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static final class EmptyRequestor
    implements EvaluationRequestor<DataRequest.OwnerEx> {
        private final String myExpression;

        private EmptyRequestor(@NotNull String expression) {
            if (expression == null) {
                EmptyRequestor.$$$reportNull$$$0(0);
            }
            this.myExpression = expression;
        }

        @Override
        @Nullable
        public EvaluationRequest createRequest(@NotNull DataRequest.OwnerEx base, @NotNull CompletableFuture<DatabaseExpressionEvaluator.Result> future) {
            if (base == null) {
                EmptyRequestor.$$$reportNull$$$0(1);
            }
            if (future == null) {
                EmptyRequestor.$$$reportNull$$$0(2);
            }
            return null;
        }

        @Override
        @NotNull
        public String getQuery() {
            String string = this.myExpression;
            if (string == null) {
                EmptyRequestor.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "base";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "future";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/EvaluationRequestorFactory$EmptyRequestor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/EvaluationRequestorFactory$EmptyRequestor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createRequest";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

