/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DataSourceExportImportHelperKt;
import com.intellij.database.dataSource.DataSourceSerializedSettingsTransferable;
import com.intellij.database.dataSource.DataSourceSettingsCapsule;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\t\u001a\u00020\u0001H\u0000\u001a\u0013\u0010\n\u001a\u00020\u00062\u000b\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r\u001a\n\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001\u001a&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001\u001a\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014\u001a\u0016\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f\u001a\u0018\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a \u0010\u001e\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a#\u0010\u001e\u001a\u00020\u00062\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0003\u00a2\u0006\u0002\b \u001a\u001c\u0010!\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00010#\u00a8\u0006$"}, d2={"doCopyDataSourceSettings", "", "dss", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "putExportedSettingsIntoTheClipboard", "", "ids", "", "text", "importDataSourcesFromClipboard", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/Nullable;", "getTextFromClipboard", "getTransferableFromClipboard", "Ljava/awt/datatransfer/Transferable;", "importDataSourcesFromTextDirectly", "groupPath", "importDataSourcesFromTextViaDialog", "", "Lcom/intellij/database/psi/DbDataSource;", "showDataSourcesConfigurationDialog", "dataSources", "applyDataSource", "ds", "finishTestDataSource", "dataSource", "storage", "Lcom/intellij/database/access/DatabaseCredentials;", "focusOnDataSources", "dbDataSources", "focusOnDbDataSources", "removeDataSources", "dsIds", "", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDataSourceSettingsHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceSettingsHelper.kt\ncom/intellij/database/actions/DataSourceSettingsHelperKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,151:1\n1557#2:152\n1628#2,3:153\n37#3,2:156\n*S KotlinDebug\n*F\n+ 1 DataSourceSettingsHelper.kt\ncom/intellij/database/actions/DataSourceSettingsHelperKt\n*L\n31#1:152\n31#1:153,3\n36#1:156,2\n*E\n"})
public final class DataSourceSettingsHelperKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String doCopyDataSourceSettings(@NotNull Collection<? extends LocalDataSource> dss) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(dss, (String)"dss");
        String string = DataSourceExportImportHelperKt.exportDataSourcesSettings(dss);
        if (string == null) {
            return null;
        }
        String text = string;
        Iterable $this$map$iv = dss;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LocalDataSource localDataSource = (LocalDataSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUniqueId(...)");
            collection.add(string2);
        }
        DataSourceSettingsHelperKt.putExportedSettingsIntoTheClipboard((List)destination$iv$iv, text);
        return text;
    }

    public static final void putExportedSettingsIntoTheClipboard(@NotNull Iterable<String> ids, @NotNull String text) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Collection $this$toTypedArray$iv = CollectionsKt.toList(ids);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        DataSourceSerializedSettingsTransferable transferHandle = new DataSourceSerializedSettingsTransferable(thisCollection$iv.toArray(new String[0]), text);
        CopyPasteManager.getInstance().setContents((Transferable)transferHandle);
    }

    public static final void importDataSourcesFromClipboard(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = DataSourceSettingsHelperKt.getTextFromClipboard();
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
            return;
        }
        String text = string;
        if (DataSourceExportImportHelperKt.isDataSourceSettings(text)) {
            DataSourceSettingsHelperKt.importDataSourcesFromTextViaDialog(text, project, "");
        }
    }

    private static final String getTextFromClipboard() {
        Transferable t = DataSourceSettingsHelperKt.getTransferableFromClipboard();
        if (t == null) {
            return null;
        }
        if (t.isDataFlavorSupported(DataSourceSerializedSettingsTransferable.FLAVOR)) {
            Object object = t.getTransferData(DataSourceSerializedSettingsTransferable.FLAVOR);
            DataSourceSettingsCapsule dataSourceSettingsCapsule = object instanceof DataSourceSettingsCapsule ? (DataSourceSettingsCapsule)object : null;
            return dataSourceSettingsCapsule != null ? dataSourceSettingsCapsule.content : null;
        }
        if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            Object object = t.getTransferData(DataFlavor.stringFlavor);
            return object instanceof String ? (String)object : null;
        }
        return null;
    }

    @Nullable
    public static final Transferable getTransferableFromClipboard() {
        CopyPasteManager cpm = CopyPasteManager.getInstance();
        return cpm.getContents();
    }

    @NotNull
    public static final Collection<LocalDataSource> importDataSourcesFromTextDirectly(@NotNull String text, @NotNull Project project, @Nullable String groupPath) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ArrayList<LocalDataSource> dataSources = DataSourceExportImportHelperKt.importDataSourceFromText(text, project);
        Iterator<LocalDataSource> iterator = dataSources.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<LocalDataSource> iterator2 = iterator;
        while (iterator2.hasNext()) {
            LocalDataSource dataSource;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            dataSource.setGroupName(groupPath);
            DataSourceSettingsHelperKt.applyDataSource(dataSource, project);
        }
        DataSourceSettingsHelperKt.focusOnDataSources((Collection<? extends LocalDataSource>)dataSources, project);
        return dataSources;
    }

    @NotNull
    public static final List<DbDataSource> importDataSourcesFromTextViaDialog(@NotNull String text, @NotNull Project project, @Nullable String groupPath) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ArrayList<LocalDataSource> dataSources = DataSourceExportImportHelperKt.importDataSourceFromText(text, project);
        if (!Intrinsics.areEqual((Object)groupPath, (Object)"")) {
            Iterator<LocalDataSource> iterator = dataSources.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<LocalDataSource> iterator2 = iterator;
            while (iterator2.hasNext()) {
                LocalDataSource dataSource;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                dataSource.setGroupName(groupPath);
            }
        }
        return DataSourceSettingsHelperKt.showDataSourcesConfigurationDialog(project, (List<? extends LocalDataSource>)dataSources);
    }

    @NotNull
    public static final List<DbDataSource> showDataSourcesConfigurationDialog(@NotNull Project project, @NotNull List<? extends LocalDataSource> dataSources) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(dataSources, (String)"dataSources");
        if (dataSources.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List<DbDataSource> list = DataSourceManagerDialog.showDialog(DbPsiFacade.getInstance(project), null, null, (Consumer<? super DatabaseConfigEditor>)((Consumer)arg_0 -> DataSourceSettingsHelperKt.showDataSourcesConfigurationDialog$lambda$2(arg_0 -> DataSourceSettingsHelperKt.showDataSourcesConfigurationDialog$lambda$1(dataSources, arg_0), arg_0)));
        Intrinsics.checkNotNullExpressionValue(list, (String)"showDialog(...)");
        List<DbDataSource> dss = list;
        DataSourceSettingsHelperKt.focusOnDbDataSources((Collection<? extends DbDataSource>)dss, project);
        return dss;
    }

    public static final void applyDataSource(@NotNull LocalDataSource ds, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DataSourceSettingsHelperKt.finishTestDataSource(ds, DatabaseCredentials.Companion.getInstance());
        DataSourceStorage.getProjectStorage(project).addDataSource(ds);
    }

    private static final void finishTestDataSource(LocalDataSource dataSource, DatabaseCredentials storage) {
        block0: {
            String key2 = "test-user-password";
            String string = dataSource.getAdditionalProperty(key2);
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            dataSource.setAdditionalProperty(key2, null);
            DatabaseCredentialsAuthProvider.Companion.saveCredentialsConfig(dataSource, storage, new DatabaseCredentialsAuthProvider.UserPassCredentials(dataSource.getUsername(), new OneTimeString(it), LocalDataSource.Storage.PERSIST), false);
            dataSource.setAutoSynchronize(true);
        }
    }

    private static final void focusOnDataSources(Collection<? extends LocalDataSource> dataSources, Project project) {
        Project project2 = project;
        if (project2 == null) {
            project2 = DefaultProjectFactory.getInstance().getDefaultProject();
        }
        Project p2 = project2;
        ArrayList dbDataSources = new ArrayList(dataSources.size());
        for (LocalDataSource localDataSource : dataSources) {
            DbDataSource x = DbImplUtil.getDbDataSource(p2, localDataSource);
            if (x == null) continue;
            ((Collection)dbDataSources).add(x);
        }
        if (dbDataSources.isEmpty()) {
            return;
        }
        Collection collection = dbDataSources;
        Intrinsics.checkNotNull((Object)p2);
        DataSourceSettingsHelperKt.focusOnDbDataSources(collection, p2);
    }

    @JvmName(name="focusOnDbDataSources")
    private static final void focusOnDbDataSources(Collection<? extends DbDataSource> dbDataSources, Project project) {
        List list = JBIterable.from((Iterable)dbDataSources).filterMap(arg_0 -> DataSourceSettingsHelperKt.focusOnDataSources$lambda$5(DataSourceSettingsHelperKt::focusOnDataSources$lambda$4, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List nodes2 = list;
        if (nodes2.isEmpty()) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> DataSourceSettingsHelperKt.focusOnDataSources$lambda$7(application, project, nodes2));
    }

    public static final void removeDataSources(@NotNull Project project, @NotNull Set<String> dsIds) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(dsIds, (String)"dsIds");
        DataSourceStorage dataSourceStorage = DataSourceStorage.getProjectStorage(project);
        ArrayList dsToRemove = new ArrayList(dsIds.size());
        for (String id : dsIds) {
            LocalDataSource ds = dataSourceStorage.getDataSourceById(id);
            if (ds == null) continue;
            ((Collection)dsToRemove).add(ds);
        }
        Iterator iterator = dsToRemove.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<String> iterator2 = iterator;
        while (iterator2.hasNext()) {
            String string = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"next(...)");
            LocalDataSource ds = (LocalDataSource)((Object)string);
            dataSourceStorage.removeDataSource(ds);
        }
    }

    private static final Unit showDataSourcesConfigurationDialog$lambda$1(List $dataSources, DatabaseConfigEditor editor2) {
        for (LocalDataSource dataSource : $dataSources) {
            DatabaseCredentials databaseCredentials = editor2.getSecretService();
            Intrinsics.checkNotNullExpressionValue((Object)databaseCredentials, (String)"getSecretService(...)");
            DataSourceSettingsHelperKt.finishTestDataSource(dataSource, databaseCredentials);
            editor2.onCreated(dataSource);
        }
        return Unit.INSTANCE;
    }

    private static final void showDataSourcesConfigurationDialog$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final DataSourceNode focusOnDataSources$lambda$4(DbDataSource x) {
        Intrinsics.checkNotNull((Object)x);
        return DataSourceNode.Companion.nodeIfExists(x);
    }

    private static final DataSourceNode focusOnDataSources$lambda$5(Function1 $tmp0, Object p0) {
        return (DataSourceNode)$tmp0.invoke(p0);
    }

    private static final void focusOnDataSources$lambda$7$lambda$6(Project $project, List $nodes) {
        DatabaseView.refreshViewAndSelect($project, $nodes);
    }

    private static final void focusOnDataSources$lambda$7(Application $application, Project $project, List $nodes) {
        $application.runReadAction(() -> DataSourceSettingsHelperKt.focusOnDataSources$lambda$7$lambda$6($project, $nodes));
    }
}

