/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.postprocessing.analyzer;

import com.intellij.ml.inline.completion.features.correctness.SuggestionEnricher;
import com.intellij.ml.inline.completion.impl.AnalyzedMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.MLCompletionProposalsDetails;
import com.intellij.ml.inline.completion.impl.RawMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionLanguageKit;
import com.intellij.ml.inline.completion.impl.postprocessing.analyzer.CorrectnessAnalysisState;
import com.intellij.ml.inline.completion.impl.postprocessing.analyzer.MLProposalSuffixComputer;
import com.intellij.ml.inline.completion.impl.postprocessing.analyzer.ProposalAnalyzer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/inline/completion/impl/postprocessing/analyzer/MLCompletionAnalyzer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/analyzer/ProposalAnalyzer;", "kit", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "<init>", "(Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;I)V", "suffixComputer", "Lcom/intellij/ml/inline/completion/impl/postprocessing/analyzer/MLProposalSuffixComputer;", "analyze", "Lcom/intellij/ml/inline/completion/impl/AnalyzedMLCompletionProposal;", "proposal", "Lcom/intellij/ml/inline/completion/impl/RawMLCompletionProposal;", "intellij.ml.inline.completion"})
@SourceDebugExtension(value={"SMAP\nMLCompletionAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLCompletionAnalyzer.kt\ncom/intellij/ml/inline/completion/impl/postprocessing/analyzer/MLCompletionAnalyzer\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,40:1\n79#2,5:41\n113#2,7:46\n*S KotlinDebug\n*F\n+ 1 MLCompletionAnalyzer.kt\ncom/intellij/ml/inline/completion/impl/postprocessing/analyzer/MLCompletionAnalyzer\n*L\n22#1:41,5\n22#1:46,7\n*E\n"})
public final class MLCompletionAnalyzer
implements ProposalAnalyzer {
    @NotNull
    private final MLCompletionLanguageKit kit;
    @NotNull
    private final PsiFile file;
    @NotNull
    private final Editor editor;
    private final int offset;
    @NotNull
    private final MLProposalSuffixComputer suffixComputer;

    public MLCompletionAnalyzer(@NotNull MLCompletionLanguageKit kit, @NotNull PsiFile file, @NotNull Editor editor, int offset) {
        Intrinsics.checkNotNullParameter((Object)kit, (String)"kit");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.kit = kit;
        this.file = file;
        this.editor = editor;
        this.offset = offset;
        this.suffixComputer = new MLProposalSuffixComputer(this.kit, this.file, this.editor, this.offset);
    }

    @Override
    @NotNull
    public AnalyzedMLCompletionProposal analyze(@NotNull RawMLCompletionProposal proposal) {
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        String suffix = this.suffixComputer.getSuffix(proposal);
        Project project = this.file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            return new AnalyzedMLCompletionProposal(proposal, suffix, CorrectnessAnalysisState.Unknown.INSTANCE, 0);
        }
        SuggestionEnricher.Enrichment checkResult = this.kit.getSuggestionEnricher().enrich(this.editor, this.file, this.offset, proposal.getSuggestion(), suffix, proposal.getDetails().get(MLCompletionProposalsDetails.INSTANCE.getMATCHED_SYMBOLS_INDICES()));
        Pair result$iv$iv = TuplesKt.to((Object)new CorrectnessAnalysisState.Analyzed(checkResult), (Object)suffix);
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        Pair stateAndSuffix = (Pair)timedValue.component1();
        long time = timedValue.component2-UwyO8pc();
        return new AnalyzedMLCompletionProposal(proposal, (String)stateAndSuffix.getSecond(), (CorrectnessAnalysisState)stateAndSuffix.getFirst(), (int)Duration.getInWholeMilliseconds-impl((long)time));
    }
}

