/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.jvm.gradle;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.qodana.staticAnalysis.projectDescription.QodanaProjectDescriber;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/qodana/jvm/gradle/GradleProjectDescriber;", "Lorg/jetbrains/qodana/staticAnalysis/projectDescription/QodanaProjectDescriber;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "description", "Lorg/jetbrains/qodana/jvm/gradle/GradleProjectDescriber$GradleDescription;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "GradleDescription", "LibraryDescription", "intellij.qodana.jvm.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleProjectDescriber.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleProjectDescriber.kt\norg/jetbrains/qodana/jvm/gradle/GradleProjectDescriber\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n1#2:45\n1863#3,2:46\n*S KotlinDebug\n*F\n+ 1 GradleProjectDescriber.kt\norg/jetbrains/qodana/jvm/gradle/GradleProjectDescriber\n*L\n21#1:46,2\n*E\n"})
public final class GradleProjectDescriber
implements QodanaProjectDescriber {
    @NotNull
    private final String id;

    public GradleProjectDescriber() {
        this.id = "Gradle";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public Object description(@NotNull Project project, @NotNull Continuation<? super GradleDescription> $completion) {
        GradleProjectSettings gradleProjectSettings;
        String string = project.getBasePath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            gradleProjectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(it);
        } else {
            gradleProjectSettings = null;
        }
        GradleProjectSettings projectSettings = gradleProjectSettings;
        Collection collection = ProjectDataManager.getInstance().getExternalProjectsData(project, GradleConstants.SYSTEM_ID);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getExternalProjectsData(...)");
        Collection externalProjects = collection;
        List libraries = new ArrayList();
        Iterable $this$forEach$iv = externalProjects;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExternalProjectInfo projectInfo = (ExternalProjectInfo)element$iv;
            boolean bl = false;
            DataNode dataNode = projectInfo.getExternalProjectStructure();
            if (dataNode == null) continue;
            dataNode.visit(arg_0 -> GradleProjectDescriber.description$lambda$3$lambda$2(arg_0 -> GradleProjectDescriber.description$lambda$3$lambda$1(libraries, arg_0), arg_0));
        }
        GradleProjectSettings gradleProjectSettings2 = projectSettings;
        return new GradleDescription(gradleProjectSettings2 != null ? gradleProjectSettings2.getGradleJvm() : null, libraries);
    }

    private static final Unit description$lambda$3$lambda$1(List $libraries, DataNode it) {
        if (Intrinsics.areEqual((Object)ProjectKeys.LIBRARY, (Object)it.getKey())) {
            Object object = it.getData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.externalSystem.model.project.LibraryData");
            LibraryData libraryData = (LibraryData)object;
            $libraries.add(new LibraryDescription(libraryData));
        }
        return Unit.INSTANCE;
    }

    private static final void description$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/qodana/jvm/gradle/GradleProjectDescriber$GradleDescription;", "", "gradleJvm", "", "libraries", "", "Lorg/jetbrains/qodana/jvm/gradle/GradleProjectDescriber$LibraryDescription;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getGradleJvm", "()Ljava/lang/String;", "getLibraries", "()Ljava/util/List;", "intellij.qodana.jvm.gradle"})
    public static final class GradleDescription {
        @Nullable
        private final String gradleJvm;
        @NotNull
        private final List<LibraryDescription> libraries;

        public GradleDescription(@Nullable String gradleJvm, @NotNull List<LibraryDescription> libraries) {
            Intrinsics.checkNotNullParameter(libraries, (String)"libraries");
            this.gradleJvm = gradleJvm;
            this.libraries = libraries;
        }

        @Nullable
        public final String getGradleJvm() {
            return this.gradleJvm;
        }

        @NotNull
        public final List<LibraryDescription> getLibraries() {
            return this.libraries;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0016\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\f0\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0018\u0010\u0015\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\nR\u0018\u0010\u0017\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\n\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/qodana/jvm/gradle/GradleProjectDescriber$LibraryDescription;", "", "data", "Lcom/intellij/openapi/externalSystem/model/project/LibraryData;", "<init>", "(Lcom/intellij/openapi/externalSystem/model/project/LibraryData;)V", "ideaName", "", "Lorg/jetbrains/annotations/NotNull;", "getIdeaName", "()Ljava/lang/String;", "gradleName", "Lcom/intellij/openapi/util/NlsSafe;", "getGradleName", "unresolved", "", "getUnresolved", "()Z", "groupId", "Lorg/jetbrains/annotations/Nullable;", "getGroupId", "artifactId", "getArtifactId", "version", "getVersion", "intellij.qodana.jvm.gradle"})
    public static final class LibraryDescription {
        @NotNull
        private final String ideaName;
        @NotNull
        private final String gradleName;
        private final boolean unresolved;
        @Nullable
        private final String groupId;
        @Nullable
        private final String artifactId;
        @Nullable
        private final String version;

        public LibraryDescription(@NotNull LibraryData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            String string = data.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInternalName(...)");
            this.ideaName = string;
            String string2 = data.getExternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExternalName(...)");
            this.gradleName = string2;
            this.unresolved = data.isUnresolved();
            this.groupId = data.getGroupId();
            this.artifactId = data.getArtifactId();
            this.version = data.getVersion();
        }

        @NotNull
        public final String getIdeaName() {
            return this.ideaName;
        }

        @NotNull
        public final String getGradleName() {
            return this.gradleName;
        }

        public final boolean getUnresolved() {
            return this.unresolved;
        }

        @Nullable
        public final String getGroupId() {
            return this.groupId;
        }

        @Nullable
        public final String getArtifactId() {
            return this.artifactId;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }
    }
}

