/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.terminal;

import com.intellij.cwm.plugin.following.ClientFollowMeManager;
import com.intellij.execution.ExecutionBundle;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.RdEventSource;
import com.intellij.openapi.rd.SourceExKt;
import com.intellij.terminal.TerminalTitle;
import com.intellij.terminal.TerminalTitleListener;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.util.ApplicationKt;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.TerminalResizeListener;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jetbrains.codeWithMe.model.RdTerminalSession;
import com.jetbrains.codeWithMe.model.RdTerminalSessionOrigin;
import com.jetbrains.codeWithMe.model.RdTerminalSize;
import com.jetbrains.codeWithMe.model.RdTerminalTitle;
import com.jetbrains.codeWithMe.model.SessionPortForwarding;
import com.jetbrains.codeWithMe.model.TerminalModel;
import com.jetbrains.codeWithMe.model.TerminalModel_GeneratedKt;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.codeWithMe.focus.UserFocusManager;
import com.jetbrains.rd.platform.codeWithMe.permissions.TerminalAccessLevel;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rdserver.core.RemoteClientSessionListener;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.permissions.ClientPermissionManager;
import com.jetbrains.rdserver.portForwarding.utils.PortForwardingSessionData;
import com.jetbrains.rdserver.portForwarding.utils.PortForwardingSessionUtils;
import com.jetbrains.rdserver.terminal.BackendTerminalHost;
import com.jetbrains.rdserver.terminal.BackendTerminalManager;
import com.jetbrains.rdserver.terminal.BackendTtyConnector;
import com.jetbrains.rdserver.ui.converters.TerminalWidgetConverterKt;
import com.jetbrains.rdserver.unattendedHost.status.UnattendedHostActivityTracker;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;
import org.jetbrains.plugins.terminal.ui.TerminalContainer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 22\u00020\u0001:\u0003234B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010\u001e\u001a\u00020\u001f*\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0014\u0010#\u001a\u00020$*\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J$\u0010(\u001a\u00020\u001d*\u00020\"2\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0*H\u0002J\f\u0010,\u001a\u00020\u001a*\u00020\u0018H\u0002J\u0018\u0010-\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010.\u001a\u00020/H\u0002J \u00100\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010.\u001a\u00020/2\u0006\u00101\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/jetbrains/rdserver/terminal/BackendTerminalHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "BackendTerminalHost", "(Lcom/intellij/openapi/client/ClientProjectSession;)V", "bindSessions", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "terminalToolWindowPortLabel", "terminalModel", "Lcom/jetbrains/codeWithMe/model/TerminalModel;", "getTerminalModel", "()Lcom/jetbrains/codeWithMe/model/TerminalModel;", "newlineByte", "", "setupPortForwarding", "Lcom/jetbrains/codeWithMe/model/SessionPortForwarding;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "connector", "Lcom/jetbrains/rdserver/terminal/BackendTtyConnector;", "widget", "Lorg/jetbrains/plugins/terminal/ShellTerminalWidget;", "isSessionBound", "", "sessionId", "bind", "", "fromTerminalTitle", "Lcom/jetbrains/codeWithMe/model/RdTerminalTitle;", "Lcom/jetbrains/codeWithMe/model/RdTerminalTitle$Companion;", "terminalTitle", "Lcom/intellij/terminal/TerminalTitle;", "fromTerminalSize", "Lcom/jetbrains/codeWithMe/model/RdTerminalSize;", "Lcom/jetbrains/codeWithMe/model/RdTerminalSize$Companion;", "termSize", "Lcom/jediterm/core/util/TermSize;", "bindTerminalTitle", "property", "Lcom/jetbrains/rd/util/reactive/IProperty;", "hasRunningCommandsErrorAlreadyReported", "hasRunningCommandsSafe", "syncTerminalSize", "model", "Lcom/jetbrains/codeWithMe/model/RdTerminalSession;", "syncTerminalScrolling", "id", "Companion", "MyProtocolListener", "MyRemoteClientListener", "intellij.terminal.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendTerminalHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendTerminalHost.kt\ncom/jetbrains/rdserver/terminal/BackendTerminalHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,311:1\n24#2:312\n14#2:313\n1755#3,3:314\n*S KotlinDebug\n*F\n+ 1 BackendTerminalHost.kt\ncom/jetbrains/rdserver/terminal/BackendTerminalHost\n*L\n90#1:312\n242#1:313\n177#1:314,3\n*E\n"})
public final class BackendTerminalHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final HashSet<String> bindSessions;
    @NotNull
    private final String terminalToolWindowPortLabel;
    private final byte newlineByte;
    private boolean hasRunningCommandsErrorAlreadyReported;
    private static String[] X;

    public BackendTerminalHost(@NotNull ClientProjectSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.bindSessions = new HashSet();
        this.terminalToolWindowPortLabel = "terminalToolWindowPort";
        this.newlineByte = (byte)10;
    }

    private final TerminalModel getTerminalModel() {
        return TerminalModel_GeneratedKt.getTerminalModel((Solution)RemoteSessionKt.getProtocolModel((ClientProjectSession)this.session));
    }

    /*
     * Loose catch block
     */
    private final SessionPortForwarding setupPortForwarding(Lifetime lifetime, BackendTtyConnector connector, ShellTerminalWidget widget) {
        PortForwardingSessionData portForwardingSessionData;
        Object object;
        long l = 92040545523762L;
        int[] nArray = BackendTtyConnector.X();
        try {
            Object object2;
            block15: {
                block14: {
                    block17: {
                        block16: {
                            if (nArray == null) break block14;
                            object2 = widget.getProcessTtyConnector();
                            if (object2 == null) break block14;
                            break block16;
                            catch (UnsupportedOperationException unsupportedOperationException) {
                                throw BackendTerminalHost.a(unsupportedOperationException);
                            }
                        }
                        if ((object2 = object2.getProcess()) == null) break block14;
                        break block17;
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            throw BackendTerminalHost.a(unsupportedOperationException);
                        }
                    }
                    try {
                        object2 = ((Process)object2).pid();
                        if (nArray != null) break block15;
                        break block14;
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            throw BackendTerminalHost.a(unsupportedOperationException);
                        }
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        throw BackendTerminalHost.a(unsupportedOperationException);
                    }
                }
                object2 = null;
            }
            object = object2;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            object = null;
        }
        ProcessTtyConnector processTtyConnector = object;
        if (processTtyConnector == null) {
            object = this;
            boolean bl = false;
            Logger logger = Logger.getInstance(BackendTerminalHost.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("shell pid is null -> port forwarding will not work");
            return null;
        }
        try {
            if (PortForwardingSessionUtils.INSTANCE.setupPortForwardingSession(lifetime, this.session.getAppSession(), processTtyConnector.longValue(), this.terminalToolWindowPortLabel, false) == null) {
                return null;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw BackendTerminalHost.a(unsupportedOperationException);
        }
        object = portForwardingSessionData;
        connector.getOutput().advise(lifetime, arg_0 -> BackendTerminalHost.setupPortForwarding$lambda$0(this, (PortForwardingSessionData)object, arg_0));
        return object.getSession();
    }

    public final boolean isSessionBound(@NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        return this.bindSessions.contains(sessionId);
    }

    public final void bind(@NotNull ShellTerminalWidget widget, @NotNull BackendTtyConnector connector) {
        RdTerminalSession rdTerminalSession;
        RdTerminalSession rdTerminalSession2;
        RdTerminalSession rdTerminalSession3;
        Lifetime lifetime;
        String string;
        block31: {
            block32: {
                int[] nArray;
                block30: {
                    TerminalContainer terminalContainer;
                    block27: {
                        block29: {
                            boolean bl;
                            block28: {
                                RdTerminalSession rdTerminalSession4;
                                RdTerminalSession rdTerminalSession5;
                                block26: {
                                    RdTerminalSession rdTerminalSession6;
                                    block25: {
                                        String string2;
                                        block24: {
                                            block23: {
                                                long l = 65354542765162L;
                                                int[] nArray2 = BackendTtyConnector.X();
                                                Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
                                                Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
                                                nArray = nArray2;
                                                try {
                                                    try {
                                                        if (nArray == null) break block23;
                                                        string2 = connector.getSessionId();
                                                        if (string2 != null) break block24;
                                                    }
                                                    catch (UnsupportedOperationException unsupportedOperationException) {
                                                        throw BackendTerminalHost.a(unsupportedOperationException);
                                                    }
                                                }
                                                catch (UnsupportedOperationException unsupportedOperationException) {
                                                    throw BackendTerminalHost.a(unsupportedOperationException);
                                                }
                                            }
                                            return;
                                        }
                                        string = string2;
                                        try {
                                            if (ClientPermissionManager.Companion.getInstance(this.session).getTerminalAccess() == TerminalAccessLevel.Disabled) {
                                                return;
                                            }
                                        }
                                        catch (UnsupportedOperationException unsupportedOperationException) {
                                            throw BackendTerminalHost.a(unsupportedOperationException);
                                        }
                                        lifetime = RLifetimeKt.intersect((Lifetime)this.getServiceLifetime(), (Lifetime)connector.getLifetime());
                                        rdTerminalSession5 = (RdTerminalSession)this.getTerminalModel().getSessions().get((Object)string);
                                        try {
                                            try {
                                                rdTerminalSession6 = rdTerminalSession5;
                                                if (nArray == null) break block25;
                                                rdTerminalSession4 = rdTerminalSession6;
                                                if (rdTerminalSession6 != null) break block26;
                                            }
                                            catch (UnsupportedOperationException unsupportedOperationException) {
                                                throw BackendTerminalHost.a(unsupportedOperationException);
                                            }
                                            rdTerminalSession6 = new RdTerminalSession(RdTerminalSessionOrigin.Host);
                                        }
                                        catch (UnsupportedOperationException unsupportedOperationException) {
                                            throw BackendTerminalHost.a(unsupportedOperationException);
                                        }
                                    }
                                    rdTerminalSession2 = rdTerminalSession3 = rdTerminalSession6;
                                    boolean bl2 = false;
                                    IProperty iProperty = rdTerminalSession2.getTitle();
                                    TerminalTitle terminalTitle = widget.getTerminalTitle();
                                    Intrinsics.checkNotNullExpressionValue((Object)terminalTitle, (String)"getTerminalTitle(...)");
                                    iProperty.set((Object)this.fromTerminalTitle(RdTerminalTitle.Companion, terminalTitle));
                                    ((Map)this.getTerminalModel().getSessions()).put(string, rdTerminalSession2);
                                    rdTerminalSession4 = rdTerminalSession3;
                                }
                                rdTerminalSession = rdTerminalSession4;
                                try {
                                    try {
                                        try {
                                            if (nArray == null) break block27;
                                            if (rdTerminalSession5 == null) break block28;
                                        }
                                        catch (UnsupportedOperationException unsupportedOperationException) {
                                            throw BackendTerminalHost.a(unsupportedOperationException);
                                        }
                                        bl = this.bindSessions.contains(string);
                                        if (nArray == null) break block29;
                                    }
                                    catch (UnsupportedOperationException unsupportedOperationException) {
                                        throw BackendTerminalHost.a(unsupportedOperationException);
                                    }
                                    if (!bl) break block28;
                                }
                                catch (UnsupportedOperationException unsupportedOperationException) {
                                    throw BackendTerminalHost.a(unsupportedOperationException);
                                }
                                return;
                            }
                            bl = this.bindSessions.add(string);
                        }
                        widget.getTerminalTitle().change(BackendTerminalHost::bind$lambda$2);
                        TerminalTitle terminalTitle = widget.getTerminalTitle();
                        Intrinsics.checkNotNullExpressionValue((Object)terminalTitle, (String)"getTerminalTitle(...)");
                        this.bindTerminalTitle(terminalTitle, lifetime, (IProperty<RdTerminalTitle>)rdTerminalSession.getTitle());
                    }
                    try {
                        if (nArray == null) break block30;
                        terminalContainer = TerminalToolWindowManager.getInstance((Project)widget.getProject()).getContainer(widget.asNewWidget());
                        if (terminalContainer == null) break block30;
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        throw BackendTerminalHost.a(unsupportedOperationException);
                    }
                    TerminalContainer terminalContainer2 = terminalContainer;
                    boolean bl = false;
                    Content content = terminalContainer2.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)content, (String)"getContent(...)");
                    Content content2 = content;
                    PropertyChangeListener propertyChangeListener = arg_0 -> BackendTerminalHost.bind$lambda$5$lambda$3(widget, arg_0);
                    content2.addPropertyChangeListener(propertyChangeListener);
                    lifetime.onTermination(() -> BackendTerminalHost.bind$lambda$5$lambda$4(content2, propertyChangeListener));
                }
                try {
                    try {
                        connector.getClosed().advise(lifetime, arg_0 -> BackendTerminalHost.bind$lambda$6(rdTerminalSession, arg_0));
                        if (nArray == null) break block31;
                        if (!this.session.isController()) break block32;
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        throw BackendTerminalHost.a(unsupportedOperationException);
                    }
                    BoolPropertyExKt.whenTrue((IViewable)((IViewable)rdTerminalSession.getClosed()), (Lifetime)lifetime, arg_0 -> BackendTerminalHost.bind$lambda$7(connector, arg_0));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw BackendTerminalHost.a(unsupportedOperationException);
                }
            }
            rdTerminalSession.getInput().advise(lifetime, arg_0 -> BackendTerminalHost.bind$lambda$9(this, widget, connector, arg_0));
        }
        rdTerminalSession3 = lifetime.createNested();
        rdTerminalSession2 = rdTerminalSession3.getLifetime();
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)rdTerminalSession.getOutputConnected()), (Lifetime)rdTerminalSession2, arg_0 -> BackendTerminalHost.bind$lambda$11(this, rdTerminalSession, widget, connector, lifetime, (LifetimeDefinition)rdTerminalSession3, arg_0));
        SessionPortForwarding sessionPortForwarding = this.setupPortForwarding(connector.getLifetime(), connector, widget);
        rdTerminalSession.getPortForwardingSession().set((Object)sessionPortForwarding);
        this.syncTerminalSize(widget, rdTerminalSession);
        this.syncTerminalScrolling(widget, rdTerminalSession, string);
    }

    private final RdTerminalTitle fromTerminalTitle(RdTerminalTitle.Companion $this$fromTerminalTitle, TerminalTitle terminalTitle) {
        String string;
        String string2;
        String string3;
        RdTerminalTitle rdTerminalTitle;
        RdTerminalTitle rdTerminalTitle2;
        long l = 11208737577888L;
        try {
            RdTerminalTitle rdTerminalTitle3;
            rdTerminalTitle2 = rdTerminalTitle3;
            rdTerminalTitle = rdTerminalTitle3;
            string3 = terminalTitle.getUserDefinedTitle();
            string2 = terminalTitle.getApplicationTitle();
            string = terminalTitle.getDefaultTitle();
            if (string == null) {
                String string4 = ExecutionBundle.message((String)"terminal.default.title", (Object[])new Object[0]);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw BackendTerminalHost.a(unsupportedOperationException);
        }
        rdTerminalTitle2(string3, string2, string);
        return rdTerminalTitle;
    }

    private final RdTerminalSize fromTerminalSize(RdTerminalSize.Companion $this$fromTerminalSize, TermSize termSize) {
        return new RdTerminalSize(termSize.getColumns(), termSize.getRows());
    }

    private final void bindTerminalTitle(TerminalTitle $this$bindTerminalTitle, Lifetime lifetime, IProperty<RdTerminalTitle> property) {
        property.set((Object)this.fromTerminalTitle(RdTerminalTitle.Companion, $this$bindTerminalTitle));
        SourceExKt.advise((ISource)((ISource)property), (Lifetime)lifetime, (arg_0, arg_1) -> BackendTerminalHost.bindTerminalTitle$lambda$13($this$bindTerminalTitle, arg_0, arg_1));
        $this$bindTerminalTitle.addTitleListener(new TerminalTitleListener(this, property){
            final /* synthetic */ BackendTerminalHost this$0;
            final /* synthetic */ IProperty<RdTerminalTitle> $property;
            {
                this.this$0 = $receiver;
                this.$property = $property;
            }

            public void onTitleChanged(TerminalTitle terminalTitle) {
                Intrinsics.checkNotNullParameter((Object)terminalTitle, (String)"terminalTitle");
                RdTerminalTitle rdTerminalTitle = BackendTerminalHost.access$fromTerminalTitle(this.this$0, RdTerminalTitle.Companion, terminalTitle);
                ApplicationKt.getApplication().invokeLater(() -> bindTerminalTitle.2.onTitleChanged$lambda$0(this.$property, rdTerminalTitle));
            }

            private static final void onTitleChanged$lambda$0(IProperty $property, RdTerminalTitle $rdTerminalTitle) {
                $property.set((Object)$rdTerminalTitle);
            }
        }, LifetimeDisposableExKt.createNestedDisposable((Lifetime)lifetime, (String)"backend terminal host"));
    }

    private final boolean hasRunningCommandsSafe(ShellTerminalWidget $this$hasRunningCommandsSafe) {
        long l = 112584780255576L;
        int[] nArray = BackendTtyConnector.X();
        try {
            return $this$hasRunningCommandsSafe.hasRunningCommands();
        }
        catch (Throwable throwable) {
            boolean bl;
            block4: {
                block5: {
                    try {
                        bl = this.hasRunningCommandsErrorAlreadyReported;
                        if (nArray == null) break block4;
                        if (bl) break block5;
                    }
                    catch (Throwable throwable2) {
                        throw BackendTerminalHost.a(throwable2);
                    }
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(BackendTerminalHost.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn(throwable);
                    this.hasRunningCommandsErrorAlreadyReported = true;
                }
                bl = false;
            }
            return bl;
        }
    }

    private final void syncTerminalSize(ShellTerminalWidget widget, RdTerminalSession model) {
        block8: {
            RdTerminalSession rdTerminalSession;
            block6: {
                long l = 49754959570327L;
                int[] nArray = BackendTtyConnector.X();
                try {
                    block7: {
                        try {
                            try {
                                rdTerminalSession = model;
                                if (nArray == null) break block6;
                                if (rdTerminalSession.getOrigin() != RdTerminalSessionOrigin.Client) break block7;
                            }
                            catch (UnsupportedOperationException unsupportedOperationException) {
                                throw BackendTerminalHost.a(unsupportedOperationException);
                            }
                            SourceExKt.advise((ISource)((ISource)model.getSize()), (Lifetime)this.getServiceLifetime(), (arg_0, arg_1) -> BackendTerminalHost.syncTerminalSize$lambda$14(widget, arg_0, arg_1));
                            if (nArray != null) break block8;
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            throw BackendTerminalHost.a(unsupportedOperationException);
                        }
                    }
                    rdTerminalSession = model;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw BackendTerminalHost.a(unsupportedOperationException);
                }
            }
            IOptProperty iOptProperty = rdTerminalSession.getSize();
            TermSize termSize = widget.getTerminal().getSize();
            Intrinsics.checkNotNullExpressionValue((Object)termSize, (String)"getSize(...)");
            iOptProperty.set((Object)this.fromTerminalSize(RdTerminalSize.Companion, termSize));
            TerminalResizeListener terminalResizeListener = new TerminalResizeListener(model, this, widget){
                final /* synthetic */ RdTerminalSession $model;
                final /* synthetic */ BackendTerminalHost this$0;
                final /* synthetic */ ShellTerminalWidget $widget;
                {
                    this.$model = $model;
                    this.this$0 = $receiver;
                    this.$widget = $widget;
                }

                public void onResize(TermSize oldTermSize, TermSize newTermSize) {
                    Intrinsics.checkNotNullParameter((Object)oldTermSize, (String)"oldTermSize");
                    Intrinsics.checkNotNullParameter((Object)newTermSize, (String)"newTermSize");
                    IOptProperty iOptProperty = this.$model.getSize();
                    TermSize termSize = this.$widget.getTerminal().getSize();
                    Intrinsics.checkNotNullExpressionValue((Object)termSize, (String)"getSize(...)");
                    iOptProperty.set((Object)BackendTerminalHost.access$fromTerminalSize(this.this$0, RdTerminalSize.Companion, termSize));
                }
            };
            widget.getTerminal().addResizeListener(terminalResizeListener);
            this.getServiceLifetime().onTermination(() -> BackendTerminalHost.syncTerminalSize$lambda$15(widget, terminalResizeListener));
        }
    }

    private final void syncTerminalScrolling(ShellTerminalWidget widget, RdTerminalSession model, String id) {
        BoundedRangeModel boundedRangeModel = widget.getTerminalPanel().getVerticalScrollModel();
        Intrinsics.checkNotNullExpressionValue((Object)boundedRangeModel, (String)"getVerticalScrollModel(...)");
        BoundedRangeModel boundedRangeModel2 = boundedRangeModel;
        ClientFollowMeManager clientFollowMeManager = ClientFollowMeManager.Companion.getInstance(this.session);
        boundedRangeModel2.addChangeListener(arg_0 -> BackendTerminalHost.syncTerminalScrolling$lambda$16(clientFollowMeManager, model, boundedRangeModel2, arg_0));
        SourceExKt.advise((ISource)((ISource)model.getScroll()), (Lifetime)this.getServiceLifetime(), (arg_0, arg_1) -> BackendTerminalHost.syncTerminalScrolling$lambda$17(clientFollowMeManager, boundedRangeModel2, id, arg_0, arg_1));
    }

    private static final Unit setupPortForwarding$lambda$0(BackendTerminalHost this$0, PortForwardingSessionData $sessionAndPortsWatcher, List it) {
        long l = 108165698486579L;
        try {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (it.contains(this$0.newlineByte)) {
                $sessionAndPortsWatcher.getWatcher().resetDelay();
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw BackendTerminalHost.a(unsupportedOperationException);
        }
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$2(TerminalTitle.State $this$change) {
        Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
        $this$change.setTrackTerminalApplicationTitleChanges(Boolean.valueOf(true));
        return Unit.INSTANCE;
    }

    private static final void bind$lambda$5$lambda$3(ShellTerminalWidget $widget, PropertyChangeEvent event) {
        long l = 21719620626917L;
        try {
            if (Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"displayName")) {
                Project project = $widget.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                UserFocusManager.Companion.getInstance(project).updateCurrentFocus();
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw BackendTerminalHost.a(unsupportedOperationException);
        }
    }

    private static final Unit bind$lambda$5$lambda$4(Content $content, PropertyChangeListener $listener) {
        $content.removePropertyChangeListener($listener);
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$6(RdTerminalSession $sessionModel, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $sessionModel.getClosed().set((Object)true);
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$7(BackendTtyConnector $connector, Lifetime it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $connector.getConnector().close();
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private static final Unit bind$lambda$9(BackendTerminalHost this$0, ShellTerminalWidget $widget, BackendTtyConnector $connector, List bytes) {
        block37: {
            block36: {
                block35: {
                    block34: {
                        block33: {
                            block31: {
                                block32: {
                                    var4_4 = 73696122560719L;
                                    v0 = BackendTtyConnector.X();
                                    Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                                    var6_5 = v0;
                                    var7_6 = ClientPermissionManager.Companion.getInstance(this$0.session).getTerminalAccess();
                                    try {
                                        if (var7_6 != TerminalAccessLevel.FullAccess) {
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    catch (UnsupportedOperationException v1) {
                                        throw BackendTerminalHost.a(v1);
                                    }
                                    try {
                                        if (this$0.session.isController()) {
                                            UnattendedHostActivityTracker.Companion.getInstance().controllerActivity();
                                        }
                                    }
                                    catch (UnsupportedOperationException v2) {
                                        throw BackendTerminalHost.a(v2);
                                    }
                                    var8_7 = CollectionsKt.toByteArray((Collection)bytes);
                                    var10_8 = bytes;
                                    var11_9 = false;
                                    try {
                                        try {
                                            try {
                                                try {
                                                    v3 = var10_8;
                                                    if (var6_5 == null) break block31;
                                                    if (!(v3 instanceof Collection)) break block32;
                                                }
                                                catch (UnsupportedOperationException v4) {
                                                    throw BackendTerminalHost.a(v4);
                                                }
                                                v3 = (Collection)var10_8;
                                                if (var6_5 == null) break block31;
                                            }
                                            catch (UnsupportedOperationException v5) {
                                                throw BackendTerminalHost.a(v5);
                                            }
                                            if (!v3.isEmpty()) break block32;
                                        }
                                        catch (UnsupportedOperationException v6) {
                                            throw BackendTerminalHost.a(v6);
                                        }
                                        v7 = false;
                                        break block33;
                                    }
                                    catch (UnsupportedOperationException v8) {
                                        throw BackendTerminalHost.a(v8);
                                    }
                                }
                                v3 = var10_8;
                            }
                            block24: for (T var13_11 : v3) {
                                var14_12 = ((Number)var13_11).byteValue();
                                var15_13 = false;
                                v9 = var14_12;
                                do {
                                    if (var6_5 != null) {
                                        try {
                                            v9 = v9 == 13 ? 1 : 0;
                                        }
                                        catch (UnsupportedOperationException v10) {
                                            throw BackendTerminalHost.a(v10);
                                        }
                                    }
                                    if (v9 == 0) continue block24;
                                    v11 = true;
                                } while (var6_5 == null);
                                break block33;
                            }
                            v7 = false;
                        }
                        try {
                            try {
                                if (!v7) break block34;
                                v12 = this$0.hasRunningCommandsSafe($widget);
                                if (var6_5 == null) break block35;
                            }
                            catch (UnsupportedOperationException v13) {
                                throw BackendTerminalHost.a(v13);
                            }
                            if (v12) break block34;
                        }
                        catch (UnsupportedOperationException v14) {
                            throw BackendTerminalHost.a(v14);
                        }
                        v12 = true;
                        break block35;
                    }
                    v12 = false;
                }
                var9_14 = v12;
                try {
                    try {
                        $connector.write(var8_7);
                        if (var6_5 == null) break block36;
                        if (var9_14) {
                        }
                        ** GOTO lbl97
                    }
                    catch (UnsupportedOperationException v15) {
                        throw BackendTerminalHost.a(v15);
                    }
                    $widget.handleEnterPressed();
                }
                catch (UnsupportedOperationException v16) {
                    throw BackendTerminalHost.a(v16);
                }
            }
            try {
                if (var6_5 != null) break block37;
lbl97:
                // 2 sources

                $widget.handleAnyKeyPressed();
            }
            catch (UnsupportedOperationException v17) {
                throw BackendTerminalHost.a(v17);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$11$lambda$10(BackendTerminalHost this$0, RdTerminalSession $sessionModel, List it) {
        long l = 137730212912075L;
        try {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (ClientPermissionManager.Companion.getInstance(this$0.session).getTerminalAccess() != TerminalAccessLevel.Disabled) {
                $sessionModel.getOutput().fire((Object)it);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw BackendTerminalHost.a(unsupportedOperationException);
        }
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$11(BackendTerminalHost this$0, RdTerminalSession $sessionModel, ShellTerminalWidget $widget, BackendTtyConnector $connector, Lifetime $lifetime, LifetimeDefinition $initialSyncLifetimeDef, Lifetime it) {
        block4: {
            block5: {
                long l = 70376956718101L;
                int[] nArray = BackendTtyConnector.X();
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                int[] nArray2 = nArray;
                try {
                    try {
                        if (nArray2 == null) break block4;
                        if (ClientPermissionManager.Companion.getInstance(this$0.session).getTerminalAccess() == TerminalAccessLevel.Disabled) break block5;
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        throw BackendTerminalHost.a(unsupportedOperationException);
                    }
                    $sessionModel.getInitialState().set((Object)TerminalWidgetConverterKt.createScreenStateModel((JediTermWidget)((JediTermWidget)$widget)));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw BackendTerminalHost.a(unsupportedOperationException);
                }
            }
            $connector.getOutput().advise($lifetime, arg_0 -> BackendTerminalHost.bind$lambda$11$lambda$10(this$0, $sessionModel, arg_0));
            LifetimeDefinition.terminate$default((LifetimeDefinition)$initialSyncLifetimeDef, (boolean)false, (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit bindTerminalTitle$lambda$13$lambda$12(RdTerminalTitle $title, TerminalTitle.State $this$change) {
        String string;
        TerminalTitle.State state;
        block5: {
            block4: {
                long l = 63480406269939L;
                int[] nArray = BackendTtyConnector.X();
                Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
                int[] nArray2 = nArray;
                try {
                    RdTerminalTitle rdTerminalTitle;
                    try {
                        state = $this$change;
                        if (nArray2 == null || (rdTerminalTitle = $title) == null) break block4;
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        throw BackendTerminalHost.a(unsupportedOperationException);
                    }
                    string = rdTerminalTitle.getUserDefinedTitle();
                    break block5;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw BackendTerminalHost.a(unsupportedOperationException);
                }
            }
            string = null;
        }
        state.setUserDefinedTitle(string);
        return Unit.INSTANCE;
    }

    private static final Unit bindTerminalTitle$lambda$13(TerminalTitle $this_bindTerminalTitle, RdTerminalTitle title, RdEventSource source) {
        block4: {
            block5: {
                long l = 126080822586227L;
                int[] nArray = BackendTtyConnector.X();
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                int[] nArray2 = nArray;
                try {
                    try {
                        if (nArray2 == null) break block4;
                        if (source != RdEventSource.Local) break block5;
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        throw BackendTerminalHost.a(unsupportedOperationException);
                    }
                    return Unit.INSTANCE;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw BackendTerminalHost.a(unsupportedOperationException);
                }
            }
            $this_bindTerminalTitle.change(arg_0 -> BackendTerminalHost.bindTerminalTitle$lambda$13$lambda$12(title, arg_0));
        }
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Unit syncTerminalSize$lambda$14(ShellTerminalWidget $widget, RdTerminalSize clientSize, RdEventSource source) {
        int n;
        int n2;
        block26: {
            block27: {
                int n3;
                int[] nArray;
                block24: {
                    block25: {
                        block22: {
                            block23: {
                                block21: {
                                    RdTerminalSize rdTerminalSize;
                                    block20: {
                                        long l = 55454169557458L;
                                        nArray = BackendTtyConnector.X();
                                        try {
                                            try {
                                                rdTerminalSize = clientSize;
                                                if (nArray == null) break block20;
                                                Intrinsics.checkNotNullParameter((Object)rdTerminalSize, (String)"clientSize");
                                                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                                                if (source == RdEventSource.Local) return Unit.INSTANCE;
                                            }
                                            catch (UnsupportedOperationException unsupportedOperationException) {
                                                throw BackendTerminalHost.a(unsupportedOperationException);
                                            }
                                            rdTerminalSize = clientSize;
                                        }
                                        catch (UnsupportedOperationException unsupportedOperationException) {
                                            throw BackendTerminalHost.a(unsupportedOperationException);
                                        }
                                    }
                                    try {
                                        try {
                                            n3 = rdTerminalSize.getWidth();
                                            if (nArray == null) break block21;
                                            if (n3 == 0) return Unit.INSTANCE;
                                        }
                                        catch (UnsupportedOperationException unsupportedOperationException) {
                                            throw BackendTerminalHost.a(unsupportedOperationException);
                                        }
                                        n3 = clientSize.getHeight();
                                    }
                                    catch (UnsupportedOperationException unsupportedOperationException) {
                                        throw BackendTerminalHost.a(unsupportedOperationException);
                                    }
                                }
                                try {
                                    try {
                                        if (nArray == null) break block22;
                                        if (n3 != 0) break block23;
                                        return Unit.INSTANCE;
                                    }
                                    catch (UnsupportedOperationException unsupportedOperationException) {
                                        throw BackendTerminalHost.a(unsupportedOperationException);
                                    }
                                }
                                catch (UnsupportedOperationException unsupportedOperationException) {
                                    throw BackendTerminalHost.a(unsupportedOperationException);
                                }
                            }
                            n3 = clientSize.getWidth();
                        }
                        try {
                            try {
                                if (nArray == null) break block24;
                                if (n3 <= 0) break block25;
                            }
                            catch (UnsupportedOperationException unsupportedOperationException) {
                                throw BackendTerminalHost.a(unsupportedOperationException);
                            }
                            n3 = clientSize.getWidth();
                            break block24;
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            throw BackendTerminalHost.a(unsupportedOperationException);
                        }
                    }
                    n3 = $widget.getTerminal().getTerminalWidth();
                }
                n2 = n3;
                try {
                    try {
                        n = clientSize.getHeight();
                        if (nArray == null) break block26;
                        if (n <= 0) break block27;
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        throw BackendTerminalHost.a(unsupportedOperationException);
                    }
                    n = clientSize.getHeight();
                    break block26;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw BackendTerminalHost.a(unsupportedOperationException);
                }
            }
            n = $widget.getTerminal().getTerminalHeight();
        }
        int n4 = n;
        TermSize termSize = new TermSize(n2, n4);
        $widget.getTerminal().resize(termSize, RequestOrigin.User);
        $widget.getTtyConnector().resize(termSize);
        return Unit.INSTANCE;
    }

    private static final Unit syncTerminalSize$lambda$15(ShellTerminalWidget $widget, syncTerminalSize.resizeListener.1 $resizeListener) {
        $widget.getTerminal().removeResizeListener((TerminalResizeListener)$resizeListener);
        return Unit.INSTANCE;
    }

    private static final void syncTerminalScrolling$lambda$16(ClientFollowMeManager $followMeManager, RdTerminalSession $model, BoundedRangeModel $verticalScrollModel, ChangeEvent it) {
        long l = 3243622954823L;
        try {
            if ($followMeManager.isFollowingHost()) {
                $model.getScroll().set((Object)$verticalScrollModel.getValue());
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw BackendTerminalHost.a(unsupportedOperationException);
        }
    }

    private static final Unit syncTerminalScrolling$lambda$17(ClientFollowMeManager $followMeManager, BoundedRangeModel $verticalScrollModel, String $id, int clientScroll, RdEventSource origin) {
        ClientFollowMeManager clientFollowMeManager;
        int[] nArray;
        block16: {
            block17: {
                long l = 95975769076294L;
                int[] nArray2 = BackendTtyConnector.X();
                Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
                nArray = nArray2;
                try {
                    if (origin != RdEventSource.Remote) {
                        return Unit.INSTANCE;
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw BackendTerminalHost.a(unsupportedOperationException);
                }
                try {
                    try {
                        clientFollowMeManager = $followMeManager;
                        if (nArray == null) break block16;
                        if (!clientFollowMeManager.isFollowedByHost()) break block17;
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        throw BackendTerminalHost.a(unsupportedOperationException);
                    }
                    $verticalScrollModel.setValue(clientScroll);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw BackendTerminalHost.a(unsupportedOperationException);
                }
            }
            clientFollowMeManager = $followMeManager;
        }
        for (ClientProjectSession clientProjectSession : clientFollowMeManager.getFollowerSessions()) {
            block19: {
                Object object;
                block18: {
                    try {
                        object = clientProjectSession;
                        if (nArray == null) break block18;
                        if (object.isLocal()) continue;
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        throw BackendTerminalHost.a(unsupportedOperationException);
                    }
                    object = Companion.getInstance(clientProjectSession).getTerminalModel().getSessions().get((Object)$id);
                }
                RdTerminalSession rdTerminalSession = (RdTerminalSession)object;
                try {
                    RdTerminalSession rdTerminalSession2;
                    try {
                        try {
                            if (nArray == null || (rdTerminalSession2 = rdTerminalSession) == null) break block19;
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            throw BackendTerminalHost.a(unsupportedOperationException);
                        }
                        if ((rdTerminalSession2 = rdTerminalSession2.getScroll()) == null) break block19;
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        throw BackendTerminalHost.a(unsupportedOperationException);
                    }
                    rdTerminalSession2.set((Object)clientScroll);
                    continue;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw BackendTerminalHost.a(unsupportedOperationException);
                }
            }
            if (nArray != null) continue;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ RdTerminalTitle access$fromTerminalTitle(BackendTerminalHost $this, RdTerminalTitle.Companion $receiver, TerminalTitle terminalTitle) {
        return $this.fromTerminalTitle($receiver, terminalTitle);
    }

    public static final /* synthetic */ RdTerminalSize access$fromTerminalSize(BackendTerminalHost $this, RdTerminalSize.Companion $receiver, TermSize termSize) {
        return $this.fromTerminalSize($receiver, termSize);
    }

    static {
        if (BackendTerminalHost.X() == null) {
            BackendTerminalHost.X(new String[4]);
        }
        Companion = new Companion(null);
    }

    public static void X(String[] stringArray) {
        X = stringArray;
    }

    public static String[] X() {
        return X;
    }

    private static Throwable a(Throwable throwable) {
        return throwable;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/terminal/BackendTerminalHost$Companion;", "", "BackendTerminalHost$Companion", "()V", "getInstance", "Lcom/jetbrains/rdserver/terminal/BackendTerminalHost;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "intellij.terminal.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendTerminalHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendTerminalHost.kt\ncom/jetbrains/rdserver/terminal/BackendTerminalHost$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,311:1\n23#2:312\n*S KotlinDebug\n*F\n+ 1 BackendTerminalHost.kt\ncom/jetbrains/rdserver/terminal/BackendTerminalHost$Companion\n*L\n40#1:312\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BackendTerminalHost getInstance(@NotNull ClientProjectSession session) {
            Object object;
            block5: {
                ClientSession clientSession;
                block4: {
                    long l = 131904532602941L;
                    Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    clientSession = (ClientSession)session;
                    boolean bl = false;
                    int[] nArray = BackendTtyConnector.X();
                    try {
                        try {
                            if (nArray == null) break block4;
                            object = clientSession.getService(BackendTerminalHost.class);
                            if (object != null) break block5;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw com.jetbrains.rdserver.terminal.BackendTerminalHost$Companion.a(illegalStateException);
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw com.jetbrains.rdserver.terminal.BackendTerminalHost$Companion.a(illegalStateException);
                    }
                }
                throw new IllegalStateException(("Can't find service for " + clientSession).toString());
            }
            return (BackendTerminalHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static IllegalStateException a(IllegalStateException illegalStateException) {
            return illegalStateException;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdserver/terminal/BackendTerminalHost$MyProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/codeWithMe/model/TerminalModel;", "BackendTerminalHost$MyProtocolListener", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.terminal.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendTerminalHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendTerminalHost.kt\ncom/jetbrains/rdserver/terminal/BackendTerminalHost$MyProtocolListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,311:1\n774#2:312\n865#2,2:313\n*S KotlinDebug\n*F\n+ 1 BackendTerminalHost.kt\ncom/jetbrains/rdserver/terminal/BackendTerminalHost$MyProtocolListener\n*L\n54#1:312\n54#1:313,2\n*E\n"})
    public static final class MyProtocolListener
    implements SolutionExtListener<TerminalModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull TerminalModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            model.getSessions().view(lifetime, (arg_0, arg_1, arg_2) -> MyProtocolListener.extensionCreated$lambda$1(session, arg_0, arg_1, arg_2));
        }

        private static final Unit extensionCreated$lambda$1(ClientProjectSession $session, Lifetime lifetime, String sessionId, RdTerminalSession terminalSession) {
            block21: {
                long l = 123641593312848L;
                int[] nArray = BackendTtyConnector.X();
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
                Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
                int[] nArray2 = nArray;
                try {
                    Intrinsics.checkNotNullParameter((Object)terminalSession, (String)"terminalSession");
                    if (terminalSession.getOrigin() == RdTerminalSessionOrigin.Host) {
                        return Unit.INSTANCE;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw MyProtocolListener.a(illegalStateException);
                }
                TerminalAccessLevel terminalAccessLevel = ClientPermissionManager.Companion.getInstance($session).getTerminalAccess();
                try {
                    if (terminalAccessLevel != TerminalAccessLevel.FullAccess) {
                        return Unit.INSTANCE;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw MyProtocolListener.a(illegalStateException);
                }
                Set set = TerminalToolWindowManager.getInstance((Project)$session.getProject()).getTerminalWidgets();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTerminalWidgets(...)");
                Iterable iterable = set;
                boolean bl = false;
                Object object = iterable;
                Collection collection = new ArrayList();
                boolean bl2 = false;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    boolean bl3;
                    Object t = iterator.next();
                    TerminalWidget terminalWidget = (TerminalWidget)t;
                    boolean bl4 = false;
                    try {
                        bl3 = ShellTerminalWidget.asShellJediTermWidget((TerminalWidget)terminalWidget) != null;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw MyProtocolListener.a(illegalStateException);
                    }
                    if (!bl3) continue;
                    collection.add(t);
                    if (nArray2 != null) continue;
                    break;
                }
                List list = (List)collection;
                for (TerminalWidget terminalWidget : list) {
                    block24: {
                        BackendTtyConnector backendTtyConnector;
                        BackendTtyConnector backendTtyConnector2;
                        block25: {
                            block23: {
                                TtyConnector ttyConnector;
                                block22: {
                                    TtyConnector ttyConnector2 = terminalWidget.getTtyConnector();
                                    try {
                                        try {
                                            try {
                                                if (nArray2 == null) break block21;
                                                ttyConnector = ttyConnector2;
                                                if (nArray2 == null) break block22;
                                            }
                                            catch (IllegalStateException illegalStateException) {
                                                throw MyProtocolListener.a(illegalStateException);
                                            }
                                            if (!(ttyConnector instanceof BackendTtyConnector)) break block23;
                                        }
                                        catch (IllegalStateException illegalStateException) {
                                            throw MyProtocolListener.a(illegalStateException);
                                        }
                                        ttyConnector = ttyConnector2;
                                    }
                                    catch (IllegalStateException illegalStateException) {
                                        throw MyProtocolListener.a(illegalStateException);
                                    }
                                }
                                backendTtyConnector2 = (BackendTtyConnector)ttyConnector;
                                break block25;
                            }
                            backendTtyConnector2 = null;
                        }
                        try {
                            if (backendTtyConnector2 == null) {
                                continue;
                            }
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw MyProtocolListener.a(illegalStateException);
                        }
                        object = backendTtyConnector;
                        try {
                            if (nArray2 == null) break block24;
                            if (!Intrinsics.areEqual((Object)((BackendTtyConnector)object).getSessionId(), (Object)sessionId)) continue;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw MyProtocolListener.a(illegalStateException);
                        }
                        BackendTerminalHost backendTerminalHost = Companion.getInstance($session);
                        ShellTerminalWidget shellTerminalWidget = ShellTerminalWidget.asShellJediTermWidget((TerminalWidget)terminalWidget);
                        Intrinsics.checkNotNull((Object)shellTerminalWidget);
                        backendTerminalHost.bind(shellTerminalWidget, (BackendTtyConnector)object);
                    }
                    return Unit.INSTANCE;
                }
                BackendTerminalManager.Companion.getInstance($session.getProject()).createWidgetForSpecificId(sessionId, null);
            }
            return Unit.INSTANCE;
        }

        private static IllegalStateException a(IllegalStateException illegalStateException) {
            return illegalStateException;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/terminal/BackendTerminalHost$MyRemoteClientListener;", "Lcom/jetbrains/rdserver/core/RemoteClientSessionListener;", "BackendTerminalHost$MyRemoteClientListener", "()V", "projectSessionInitialized", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "intellij.terminal.backend.split"})
    public static final class MyRemoteClientListener
    implements RemoteClientSessionListener {
        public void projectSessionInitialized(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            BackendTerminalManager.Companion.getInstance(session.getProject()).connectClientToAllTerminals(session);
        }
    }
}

