/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.docker.gateway.ideSettings;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/clouds/docker/gateway/ideSettings/DevcontainerPluginManager;", "", "pluginIds", "", "", "<init>", "(Ljava/util/List;)V", "setupPlugins", "", "installPlugin", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "createDownloader", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Companion", "intellij.clouds.docker.gateway"})
@SourceDebugExtension(value={"SMAP\nDevcontainerPluginManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevcontainerPluginManager.kt\ncom/intellij/clouds/docker/gateway/ideSettings/DevcontainerPluginManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,79:1\n1863#2,2:80\n14#3:82\n*S KotlinDebug\n*F\n+ 1 DevcontainerPluginManager.kt\ncom/intellij/clouds/docker/gateway/ideSettings/DevcontainerPluginManager\n*L\n40#1:80,2\n36#1:82\n*E\n"})
public final class DevcontainerPluginManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> pluginIds;
    @NotNull
    private static final Logger log;

    public DevcontainerPluginManager(@NotNull List<String> pluginIds) {
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        this.pluginIds = pluginIds;
    }

    public final void setupPlugins() {
        Iterable $this$forEach$iv = this.pluginIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PluginId pluginId;
            IdeaPluginDescriptorImpl descriptor;
            String it = (String)element$iv;
            boolean bl = false;
            log.info("Processing plugin " + it);
            PluginId pluginId2 = PluginId.findId((String)it);
            if (pluginId2 == null) {
                PluginId pluginId3 = PluginId.getId((String)it);
                pluginId2 = pluginId3;
                Intrinsics.checkNotNullExpressionValue((Object)pluginId3, (String)"getId(...)");
            }
            if ((descriptor = PluginManagerCore.findPlugin((PluginId)(pluginId = pluginId2))) != null) continue;
            this.installPlugin(pluginId);
        }
    }

    private final void installPlugin(PluginId pluginId) {
        block0: {
            PluginDownloader downloader;
            log.info("Installing plugin " + pluginId);
            DumbProgressIndicator dumbProgressIndicator = DumbProgressIndicator.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)dumbProgressIndicator, (String)"INSTANCE");
            PluginDownloader pluginDownloader = downloader = this.createDownloader(pluginId, (ProgressIndicator)dumbProgressIndicator);
            if (pluginDownloader == null) break block0;
            PluginDownloader it = pluginDownloader;
            boolean bl = false;
            ActionsKt.runInEdt$default(null, () -> DevcontainerPluginManager.installPlugin$lambda$2$lambda$1(it, pluginId), (int)1, null);
        }
    }

    private final PluginDownloader createDownloader(PluginId pluginId, ProgressIndicator indicator) {
        PluginNode descriptor = MarketplaceRequests.getLastCompatiblePluginUpdate$default((MarketplaceRequests)MarketplaceRequests.Companion.getInstance(), (PluginId)pluginId, null, (ProgressIndicator)indicator, (int)2, null);
        if (descriptor != null) {
            PluginDownloader pluginDownloader = PluginDownloader.createDownloader((IdeaPluginDescriptor)((IdeaPluginDescriptor)descriptor));
            Intrinsics.checkNotNullExpressionValue((Object)pluginDownloader, (String)"createDownloader(...)");
            PluginDownloader downloader = pluginDownloader;
            if (downloader.prepareToInstall(indicator)) {
                return downloader;
            }
        } else {
            log.error("No compatible plugin found for " + pluginId.getIdString());
        }
        return null;
    }

    private static final Unit installPlugin$lambda$2$lambda$1(PluginDownloader $it, PluginId $pluginId) {
        if ($it.installDynamically(null)) {
            log.info("Installed " + $pluginId);
        } else {
            log.info("Plugin " + $pluginId + " requires IDE restart");
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DevcontainerPluginManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/clouds/docker/gateway/ideSettings/DevcontainerPluginManager$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.clouds.docker.gateway"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

