/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.lcov;

import com.intellij.coverage.lcov.LcovCoverageReport;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class LcovSerializationUtils {
    private static final String SOURCE_FILE_PREFIX = "SF:";
    private static final String LINE_HIT_PREFIX = "DA:";
    private static final String FUNCTION_PREFIX = "FN:";
    private static final String END_OF_RECORD = "end_of_record";
    private static final Pattern FN_PATTERN = Pattern.compile("^FN:(\\d+),(.+)$");

    @NotNull
    public static LcovCoverageReport readLCOV(@NotNull List<File> lcovFiles) throws IOException {
        if (lcovFiles == null) {
            LcovSerializationUtils.$$$reportNull$$$0(0);
        }
        LcovCoverageReport report = new LcovCoverageReport();
        for (File lcovFile : lcovFiles) {
            try (BufferedReader reader = new BufferedReader(new FileReader(lcovFile, StandardCharsets.UTF_8));){
                String line;
                String currentFileName = null;
                String currentFunction = null;
                ArrayList<LcovCoverageReport.LineHits> lineDataList = null;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith(SOURCE_FILE_PREFIX)) {
                        currentFileName = line.substring(SOURCE_FILE_PREFIX.length());
                        currentFunction = null;
                        lineDataList = new ArrayList<LcovCoverageReport.LineHits>();
                        continue;
                    }
                    if (line.startsWith(FUNCTION_PREFIX)) {
                        Matcher fnMatcher = FN_PATTERN.matcher(line);
                        if (!fnMatcher.find()) continue;
                        currentFunction = fnMatcher.group(2);
                        continue;
                    }
                    if (line.startsWith(LINE_HIT_PREFIX)) {
                        if (lineDataList == null) {
                            throw new RuntimeException("lineDataList is null!");
                        }
                        String[] values = line.substring(LINE_HIT_PREFIX.length()).split(",");
                        int lineNum = Integer.parseInt(values[0]);
                        int hitCount = Integer.parseInt(values[1]);
                        LcovCoverageReport.LineHits lineHits = new LcovCoverageReport.LineHits(lineNum, hitCount, currentFunction);
                        lineDataList.add(lineHits);
                        continue;
                    }
                    if (!END_OF_RECORD.equals(line)) continue;
                    if (lineDataList == null) {
                        throw new RuntimeException("lineDataList is null!");
                    }
                    report.mergeFileReport(LcovSerializationUtils.normalizeFilePath(currentFileName), lineDataList);
                    currentFileName = null;
                    lineDataList = null;
                }
            }
        }
        LcovCoverageReport lcovCoverageReport = report;
        if (lcovCoverageReport == null) {
            LcovSerializationUtils.$$$reportNull$$$0(1);
        }
        return lcovCoverageReport;
    }

    public static ProjectData convertToProjectData(@NotNull LcovCoverageReport report, @NotNull Function<? super String, String> toLocalPathConvertor) {
        if (report == null) {
            LcovSerializationUtils.$$$reportNull$$$0(2);
        }
        if (toLocalPathConvertor == null) {
            LcovSerializationUtils.$$$reportNull$$$0(3);
        }
        ProjectData projectData = new ProjectData();
        for (Map.Entry<String, List<LcovCoverageReport.LineHits>> entry : report.getInfo().entrySet()) {
            String filePath = entry.getKey();
            String localPath = toLocalPathConvertor.apply(filePath);
            ClassData classData = projectData.getOrCreateClassData(LcovSerializationUtils.normalizeFilePath(localPath));
            int max = 0;
            List<LcovCoverageReport.LineHits> lineHitsList = entry.getValue();
            if (!lineHitsList.isEmpty()) {
                LcovCoverageReport.LineHits lastLineHits = lineHitsList.get(lineHitsList.size() - 1);
                max = lastLineHits.getLineNumber();
            }
            LineData[] lines = new LineData[max + 1];
            for (LcovCoverageReport.LineHits lineHits : lineHitsList) {
                LineData lineData = new LineData(lineHits.getLineNumber(), lineHits.getFunctionName());
                lineData.setHits(lineHits.getHits());
                lines[lineHits.getLineNumber()] = lineData;
            }
            classData.setLines(lines);
        }
        return projectData;
    }

    @NotNull
    private static String normalizeFilePath(@NotNull String filePath) {
        if (filePath == null) {
            LcovSerializationUtils.$$$reportNull$$$0(4);
        }
        if (SystemInfo.isWindows) {
            filePath = StringUtil.toLowerCase((String)filePath);
        }
        String string = FileUtil.toSystemIndependentName((String)filePath);
        if (string == null) {
            LcovSerializationUtils.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lcovFiles";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/lcov/LcovSerializationUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "report";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toLocalPathConvertor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/lcov/LcovSerializationUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readLCOV";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readLCOV";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertToProjectData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "normalizeFilePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5 -> new IllegalStateException(string);
        };
    }
}

