/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.navigation;

import com.intellij.codeWithMe.ClientId;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.model.psi.ImplicitReferenceProvider;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.platform.lsp.impl.navigation.CurrentActionHolder;
import com.intellij.platform.lsp.impl.navigation.LspServerAndLocationLinks;
import com.intellij.platform.lsp.impl.navigation.LspSymbolReference;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/lsp/impl/navigation/LspImplicitReferenceProvider;", "Lcom/intellij/model/psi/ImplicitReferenceProvider;", "LspImplicitReferenceProvider", "()V", "getImplicitReference", "Lcom/intellij/model/psi/PsiSymbolReference;", "element", "Lcom/intellij/psi/PsiElement;", "offsetInElement", "", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspImplicitReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspImplicitReferenceProvider.kt\ncom/intellij/platform/lsp/impl/navigation/LspImplicitReferenceProvider\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n40#2,3:191\n1611#3,9:194\n1863#3:203\n1864#3:205\n1620#3:206\n1368#3:207\n1454#3,5:208\n1755#3,3:213\n1#4:204\n*S KotlinDebug\n*F\n+ 1 LspImplicitReferenceProvider.kt\ncom/intellij/platform/lsp/impl/navigation/LspImplicitReferenceProvider\n*L\n48#1:191,3\n65#1:194,9\n65#1:203\n65#1:205\n65#1:206\n75#1:207\n75#1:208,5\n75#1:213,3\n65#1:204\n*E\n"})
public final class LspImplicitReferenceProvider
implements ImplicitReferenceProvider {
    @Nullable
    public PsiSymbolReference getImplicitReference(@NotNull PsiElement element, int offsetInElement) {
        boolean bl;
        Iterable iterable;
        List list;
        Object object3;
        Document document;
        PsiFile psiFile;
        block23: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiFile psiFile2 = element instanceof PsiFile ? (PsiFile)element : null;
            if (psiFile2 == null) {
                return null;
            }
            psiFile = psiFile2;
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            VirtualFile virtualFile2 = virtualFile;
            if (virtualFile2 instanceof VirtualFileWindow) {
                return null;
            }
            boolean bl2 = false;
            document = CurrentActionHolder.class;
            Object object2 = ApplicationManager.getApplication().getService(document);
            if (object2 == null) {
                throw new RuntimeException("Cannot find service " + document.getName() + " (classloader=" + document.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            if (!((CurrentActionHolder)object2).getRunningGoToDeclarationAction()) {
                return null;
            }
            Project project = ((PsiFile)element).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Collection<LspServerImpl> collection = LspServerManagerImpl.Companion.getInstanceImpl(project).getServersWithThisFileOpen$intellij_platform_lsp_impl(virtualFile2);
            if (collection.isEmpty()) {
                return null;
            }
            Document document2 = FileDocumentManager.getInstance().getCachedDocument(virtualFile2);
            if (document2 == null) {
                return null;
            }
            document = document2;
            Iterable iterable2 = collection;
            boolean bl3 = false;
            Iterable iterable3 = iterable2;
            Iterator iterator = new ArrayList();
            boolean bl4 = false;
            Iterable iterable4 = iterable3;
            boolean bl5 = false;
            for (Object object3 : iterable4) {
                LspServerAndLocationLinks lspServerAndLocationLinks;
                List<LocationLink> list2;
                Object t2 = object3;
                boolean bl6 = false;
                LspServerImpl lspServerImpl = (LspServerImpl)t2;
                boolean bl7 = false;
                if ((!lspServerImpl.supportsGotoDefinition$intellij_platform_lsp_impl() ? null : (!lspServerImpl.getDescriptor().getLspGoToDefinitionSupport() ? null : (!((Collection)(list2 = lspServerImpl.getRequestExecutor().getElementDefinitions(virtualFile2, offsetInElement))).isEmpty() ? new LspServerAndLocationLinks(lspServerImpl, list2) : null))) == null) continue;
                lspServerAndLocationLinks = lspServerAndLocationLinks;
                boolean bl8 = false;
                iterator.add(lspServerAndLocationLinks);
            }
            list = (List)((Object)iterator);
            if (list.isEmpty()) {
                return null;
            }
            iterable = list;
            boolean bl9 = false;
            iterator = iterable;
            Object object42 = new ArrayList();
            boolean bl10 = false;
            Iterator iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                LocationLink locationLink = iterator2.next();
                object3 = (LspServerAndLocationLinks)locationLink;
                boolean bl11 = false;
                object3 = ((LspServerAndLocationLinks)object3).getLocationLinks();
                CollectionsKt.addAll((Collection)object42, (Iterable)object3);
            }
            iterable = (List)object42;
            bl9 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object object42 : iterable) {
                    boolean bl12;
                    LocationLink locationLink = (LocationLink)object42;
                    boolean bl13 = false;
                    if (locationLink.getOriginSelectionRange() == null) {
                        bl12 = false;
                    } else {
                        Position position = locationLink.getOriginSelectionRange().getEnd();
                        Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getEnd(...)");
                        Integer n2 = Lsp4jUtilKt.getOffsetInDocument(document, position);
                        if (n2 == null) {
                            bl12 = false;
                        } else {
                            int n3 = n2;
                            bl12 = n3 > offsetInElement;
                        }
                    }
                    if (!bl12) continue;
                    bl = true;
                    break block23;
                }
                bl = false;
            }
        }
        boolean bl14 = bl;
        iterable = null;
        List list3 = new ArrayList();
        for (Object object42 : list) {
            List list4 = new ArrayList();
            for (LocationLink locationLink : ((LspServerAndLocationLinks)object42).getLocationLinks()) {
                TextRange textRange;
                object3 = locationLink.getOriginSelectionRange();
                if (object3 != null) {
                    v9 = Lsp4jUtilKt.getRangeInDocument(document, (Range)object3);
                    if (v9 == null) {
                        continue;
                    }
                } else {
                    v9 = textRange = new TextRange(offsetInElement, offsetInElement);
                }
                if (bl14 && textRange.getEndOffset() <= offsetInElement) continue;
                Iterable iterable5 = iterable;
                iterable = iterable5 == null ? textRange : iterable5.union(textRange);
                list4.add(locationLink);
            }
            if (!(!((Collection)list4).isEmpty())) continue;
            list3.add(new LspServerAndLocationLinks(((LspServerAndLocationLinks)object42).getLspServer(), list4));
        }
        if (iterable == null) {
            return null;
        }
        return new LspSymbolReference(psiFile, (TextRange)iterable, list3);
    }
}

