/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/lsp/impl/LspFileDocumentManagerListener;", "Lcom/intellij/openapi/fileEditor/FileDocumentManagerListener;", "LspFileDocumentManagerListener", "()V", "unsavedDocumentDropped", "", "document", "Lcom/intellij/openapi/editor/Document;", "beforeDocumentSaving", "intellij.platform.lsp.impl"})
public final class LspFileDocumentManagerListener
implements FileDocumentManagerListener {
    public void unsavedDocumentDropped(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.beforeDocumentSaving(document);
    }

    public void beforeDocumentSaving(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (!virtualFile2.isInLocalFileSystem()) {
            return;
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            if (FileEditorManager.getInstance((Project)project2).isFileOpen(virtualFile2)) continue;
            LspServerManagerImpl.Companion.getInstanceImpl(project2).scheduleClosingFilesThatAreNotOfInterest$intellij_platform_lsp_impl();
        }
    }
}

