/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url.references;

import com.intellij.microservices.url.FrameworkUrlPathSpecification;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlPathModelKt;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolverManager;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPksParser;
import com.intellij.openapi.project.Project;
import com.intellij.psi.util.PartiallyKnownString;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a0\u0010\u0006\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n\u001a\u001c\u0010\r\u001a\u00020\u0003*\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001f\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017\u00a2\u0006\u0002\u0010\u0018\u001a\n\u0010\u0019\u001a\u00020\u001a*\u00020\u001a\u001a\n\u0010\u001b\u001a\u00020\u001a*\u00020\u001a\u001a\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002\u001a\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002\u001a\u0016\u0010\u001f\u001a\u00020\n2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002\"\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"resolveTargets", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "Lcom/intellij/microservices/url/references/UrlPathContext;", "project", "Lcom/intellij/openapi/project/Project;", "applyFromParsed", "parsedUrl", "Lcom/intellij/microservices/url/references/UrlPksParser$ParsedPksUrl;", "scheme", "", "auth", "path", "configureFromStringHeuristically", "url", "", "specification", "Lcom/intellij/microservices/url/FrameworkUrlPathSpecification;", "canBuildUrlContext", "Ljava/lang/ThreadLocal;", "forbidExpensiveUrlContext", "T", "call", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "chopLeadingEmptyBlock", "Lcom/intellij/microservices/url/UrlPath;", "chopTrailingEmptyBlock", "", "Lcom/intellij/microservices/url/UrlPath$PathSegment;", "segments", "X", "intellij.microservices"})
@SourceDebugExtension(value={"SMAP\nUrlPathContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlPathContext.kt\ncom/intellij/microservices/url/references/UrlPathContextKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,283:1\n1#2:284\n*E\n"})
public final class UrlPathContextKt {
    @NotNull
    private static final ThreadLocal<Boolean> canBuildUrlContext;

    @NotNull
    public static final Set<UrlTargetInfo> resolveTargets(@NotNull UrlPathContext $this$resolveTargets, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveTargets, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        UrlResolverManager urlResolverManager = UrlResolverManager.Companion.getInstance(project);
        return UrlPathModelKt.filterBestUrlPathMatches$default(SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence($this$resolveTargets.getResolveRequests()), arg_0 -> UrlPathContextKt.X(urlResolverManager, arg_0))), null, 2, null);
    }

    @NotNull
    public static final UrlPathContext applyFromParsed(@NotNull UrlPathContext $this$applyFromParsed, @NotNull UrlPksParser.ParsedPksUrl parsedUrl, boolean scheme, boolean auth, boolean path) {
        UrlPathContext urlPathContext;
        block9: {
            Object object;
            block10: {
                Object object2;
                block7: {
                    Object object3;
                    block8: {
                        Object object4;
                        Intrinsics.checkNotNullParameter((Object)$this$applyFromParsed, (String)"<this>");
                        Intrinsics.checkNotNullParameter((Object)parsedUrl, (String)"parsedUrl");
                        urlPathContext = null;
                        urlPathContext = $this$applyFromParsed;
                        if (!scheme) break block7;
                        object3 = parsedUrl.getScheme();
                        if (object3 == null || (object3 = object3.getValueIfKnown()) == null) break block8;
                        object2 = object4 = object3;
                        boolean bl = false;
                        object3 = ((CharSequence)object2).length() > 0 ? object4 : null;
                        if (object3 == null) break block8;
                        Object object5 = object3;
                        boolean bl2 = false;
                        UrlPathContext urlPathContext2 = urlPathContext.withSchemes(SetsKt.setOf((Object)object5));
                        object3 = urlPathContext2;
                        if (urlPathContext2 != null) break block7;
                    }
                    object3 = urlPathContext = urlPathContext;
                }
                if (!auth) break block9;
                object = parsedUrl.getAuthority();
                if (object == null || (object = object.getValueIfKnown()) == null) break block10;
                object2 = object;
                boolean bl = false;
                UrlPathContext urlPathContext3 = urlPathContext.withAuthorities(SetsKt.setOf((Object)object2));
                object = urlPathContext3;
                if (urlPathContext3 != null) break block9;
            }
            object = urlPathContext = urlPathContext;
        }
        if (path) {
            UrlPath urlPath = parsedUrl.getUrlPath();
            boolean bl = false;
            urlPathContext = urlPathContext.subContext(urlPath);
        }
        return urlPathContext;
    }

    public static /* synthetic */ UrlPathContext applyFromParsed$default(UrlPathContext urlPathContext, UrlPksParser.ParsedPksUrl parsedPksUrl, boolean bl, boolean bl2, boolean bl3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            bl2 = true;
        }
        if ((n2 & 8) != 0) {
            bl3 = true;
        }
        return UrlPathContextKt.applyFromParsed(urlPathContext, parsedPksUrl, bl, bl2, bl3);
    }

    @NotNull
    public static final UrlPathContext configureFromStringHeuristically(@NotNull UrlPathContext $this$configureFromStringHeuristically, @Nullable String url, @NotNull FrameworkUrlPathSpecification specification) {
        Intrinsics.checkNotNullParameter((Object)$this$configureFromStringHeuristically, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)specification, (String)"specification");
        if (url == null) {
            return $this$configureFromStringHeuristically;
        }
        PartiallyKnownString partiallyKnownString = new PartiallyKnownString(url);
        UrlPathContext urlPathContext = $this$configureFromStringHeuristically;
        UrlPksParser.ParsedPksUrl parsedPksUrl = specification.getParser().parseFullUrl(partiallyKnownString);
        PartiallyKnownString partiallyKnownString2 = parsedPksUrl.getAuthority();
        CharSequence charSequence = partiallyKnownString2 != null ? partiallyKnownString2.getValueIfKnown() : null;
        urlPathContext = !(charSequence == null || charSequence.length() == 0) ? UrlPathContextKt.applyFromParsed$default(urlPathContext, parsedPksUrl, false, false, false, 14, null) : urlPathContext.subContext(specification.getParser().parseUrlPath(partiallyKnownString).getUrlPath());
        return urlPathContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T forbidExpensiveUrlContext(@NotNull Function0<? extends T> call) {
        Intrinsics.checkNotNullParameter(call, (String)"call");
        Boolean bl = canBuildUrlContext.get();
        try {
            canBuildUrlContext.set(false);
            Object object = call.invoke();
            return (T)object;
        }
        finally {
            canBuildUrlContext.set(bl);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final UrlPath chopLeadingEmptyBlock(@NotNull UrlPath $this$chopLeadingEmptyBlock) {
        UrlPath urlPath;
        Intrinsics.checkNotNullParameter((Object)$this$chopLeadingEmptyBlock, (String)"<this>");
        if ($this$chopLeadingEmptyBlock != UrlPath.Companion.getEMPTY()) {
            UrlPath.PathSegment pathSegment = (UrlPath.PathSegment)CollectionsKt.firstOrNull($this$chopLeadingEmptyBlock.getSegments());
            boolean bl = pathSegment != null ? pathSegment.isEmpty() : false;
            if (bl) {
                List<UrlPath.PathSegment> list = UrlPathContextKt.X($this$chopLeadingEmptyBlock.getSegments());
                if (list.isEmpty()) {
                    urlPath = UrlPath.Companion.getEMPTY();
                    return urlPath;
                }
                urlPath = new UrlPath(list);
                return urlPath;
            }
        }
        urlPath = $this$chopLeadingEmptyBlock;
        return urlPath;
    }

    @NotNull
    public static final UrlPath chopTrailingEmptyBlock(@NotNull UrlPath $this$chopTrailingEmptyBlock) {
        List<UrlPath.PathSegment> list;
        Intrinsics.checkNotNullParameter((Object)$this$chopTrailingEmptyBlock, (String)"<this>");
        return $this$chopTrailingEmptyBlock != UrlPath.Companion.getEMPTY() && UrlPathContextKt.X($this$chopTrailingEmptyBlock.getSegments()) ? ((list = UrlPathContextKt.i($this$chopTrailingEmptyBlock.getSegments())).isEmpty() ? UrlPath.Companion.getEMPTY() : new UrlPath(list)) : $this$chopTrailingEmptyBlock;
    }

    private static final List<UrlPath.PathSegment> X(List<? extends UrlPath.PathSegment> list) {
        UrlPath.PathSegment pathSegment = (UrlPath.PathSegment)CollectionsKt.firstOrNull(list);
        return (pathSegment != null ? pathSegment.isEmpty() : false) ? list.subList(1, list.size()) : list;
    }

    private static final List<UrlPath.PathSegment> i(List<? extends UrlPath.PathSegment> list) {
        return UrlPathContextKt.X(list) ? list.subList(0, list.size() - 1) : list;
    }

    private static final boolean X(List<? extends UrlPath.PathSegment> list) {
        return list.size() > 1 && ((UrlPath.PathSegment)CollectionsKt.last(list)).isEmpty();
    }

    private static final Sequence X(UrlResolverManager urlResolverManager, UrlResolveRequest urlResolveRequest) {
        Intrinsics.checkNotNullParameter((Object)urlResolveRequest, (String)"it");
        return CollectionsKt.asSequence(urlResolverManager.resolve(urlResolveRequest));
    }

    private static final Boolean X() {
        return true;
    }

    public static final /* synthetic */ ThreadLocal access$getCanBuildUrlContext$p() {
        return canBuildUrlContext;
    }

    public static final /* synthetic */ List access$chopTrailingEmptyBlock(List segments) {
        return UrlPathContextKt.i(segments);
    }

    public static final /* synthetic */ List access$chopLeadingEmptyBlock(List segments) {
        return UrlPathContextKt.X(segments);
    }

    static {
        ThreadLocal<Boolean> threadLocal = ThreadLocal.withInitial(UrlPathContextKt::X);
        Intrinsics.checkNotNullExpressionValue(threadLocal, (String)"withInitial(...)");
        canBuildUrlContext = threadLocal;
    }
}

