/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url.inlay;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.ScaleAwarePresentationFactory;
import com.intellij.microservices.url.inlay.UrlPathInlayHint;
import com.intellij.microservices.url.inlay.UrlPathInlayHintsProviderSemElementKt;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lcom/intellij/microservices/url/inlay/PsiElementUrlPathInlayHint;", "Lcom/intellij/microservices/url/inlay/UrlPathInlayHint;", "psiElement", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/microservices/url/references/UrlPathContext;", "PsiElementUrlPathInlayHint", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/microservices/url/references/UrlPathContext;)V", "getContext", "()Lcom/intellij/microservices/url/references/UrlPathContext;", "offset", "", "getOffset", "()I", "priority", "getPriority", "style", "Lcom/intellij/microservices/url/inlay/UrlPathInlayHint$Style;", "getStyle", "()Lcom/intellij/microservices/url/inlay/UrlPathInlayHint$Style;", "attachedTo", "Lcom/intellij/psi/SmartPsiElementPointer;", "getAttachedTo", "()Lcom/intellij/psi/SmartPsiElementPointer;", "getPresentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "editor", "Lcom/intellij/openapi/editor/Editor;", "factory", "Lcom/intellij/codeInsight/hints/presentation/PresentationFactory;", "intellij.microservices"})
public final class PsiElementUrlPathInlayHint
implements UrlPathInlayHint {
    @NotNull
    private final UrlPathContext context;
    private final int offset;
    private final int priority;
    @NotNull
    private final UrlPathInlayHint.Style style;
    @NotNull
    private final SmartPsiElementPointer<PsiElement> attachedTo;

    public PsiElementUrlPathInlayHint(@NotNull PsiElement psiElement, @NotNull UrlPathContext context) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.offset = psiElement.getTextRange().getStartOffset();
        this.style = UrlPathInlayHint.Style.INLINE;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)psiElement);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        this.attachedTo = smartPsiElementPointer;
    }

    @Override
    @NotNull
    public UrlPathContext getContext() {
        return this.context;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    @NotNull
    public UrlPathInlayHint.Style getStyle() {
        return this.style;
    }

    @Override
    @NotNull
    public SmartPsiElementPointer<PsiElement> getAttachedTo() {
        return this.attachedTo;
    }

    @Override
    @NotNull
    public InlayPresentation getPresentation(@NotNull Editor editor, @NotNull PresentationFactory factory) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        ScaleAwarePresentationFactory scaleAwarePresentationFactory = new ScaleAwarePresentationFactory(editor, factory);
        boolean bl = false;
        return UrlPathInlayHintsProviderSemElementKt.urlInlayPresentation(scaleAwarePresentationFactory);
    }
}

