import {addIjServerPlugin} from "./add-ij-server-plugin";
import {createConnection, createServer, loadTsdkByPath} from '@volar/language-server/node';
import {initialize, type VueInitializationOptions} from '@vue/language-server';

const connection = createConnection();
const server = createServer(connection);

connection.listen();

connection.onInitialize(params => {
  const options: VueInitializationOptions = params.initializationOptions;
  const { typescript: ts, diagnosticMessages } = loadTsdkByPath(options.typescript.tsdk, params.locale);
  const hybridMode = options.vue?.hybridMode ?? true; // todo hybridMode
  if (hybridMode) {
    throw new Error("Not Implemented");
  }
  else {
    addIjServerPlugin(ts, connection, server);
    return initialize(server, params, ts, diagnosticMessages);
  }
});

connection.onInitialized(server.initialized);

connection.onShutdown(server.shutdown);
