/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.data.types.ConversionGraph;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DataConverter;
import com.intellij.database.data.types.PointSet;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseConversionGraph
implements ConversionGraph {
    private static final Function<Object, Object> IDENTITY = o -> o;
    private static final Key<ConversionGraph> CONVERSION_GRAPH_KEY = new Key("CONVERSION_GRAPH_KEY");
    private final MultiMap<PointSet, Node> myMap;

    public BaseConversionGraph(@NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator, @NotNull Supplier<ObjectFormatter> objectFormatter) {
        if (formatsCache == null) {
            BaseConversionGraph.$$$reportNull$$$0(0);
        }
        if (formatterCreator == null) {
            BaseConversionGraph.$$$reportNull$$$0(1);
        }
        if (objectFormatter == null) {
            BaseConversionGraph.$$$reportNull$$$0(2);
        }
        this.myMap = new MultiMap<PointSet, Node>(){

            @NotNull
            protected Collection<Node> createCollection() {
                return new LinkedHashSet<Node>();
            }
        };
        this.register(new DataConverter.TimestampToTemporal(formatsCache, formatterCreator));
        this.register(new DataConverter.TimeToTemporal());
        this.register(new DataConverter.BinaryTextToText());
        this.register(new DataConverter.BitStringToText());
        this.register(new DataConverter.BinaryToText());
        this.register(new DataConverter.BooleanToBinary());
        this.register(new DataConverter.BooleanToNumber());
        this.register(new DataConverter.BooleanToText());
        this.register(new DataConverter.BooleanNumberToText());
        this.register(new DataConverter.DateToNumber());
        this.register(new DataConverter.DateToText(formatsCache, formatterCreator));
        this.register(new DataConverter.DateToTimestamp());
        this.register(new DataConverter.NumberToText());
        this.register(new DataConverter.NumberToTimestamp());
        this.register(new DataConverter.TimestampToText(formatterCreator));
        this.register(new DataConverter.TimeToNumber());
        this.register(new DataConverter.TimeToText(formatterCreator));
        this.register(new DataConverter.TemporalTimeToTemporalTimestamp());
        this.register(new DataConverter.StringUuidToText());
        this.register(new DataConverter.UuidToText());
        this.register(new DataConverter.MapToText(objectFormatter));
        this.register(new DataConverter.ObjectToText(objectFormatter));
        this.register(new DataConverter.MoneyToText());
    }

    @Nullable
    private List<Node> shortestPath(@NotNull PointSet from, @NotNull PointSet to) {
        if (from == null) {
            BaseConversionGraph.$$$reportNull$$$0(3);
        }
        if (to == null) {
            BaseConversionGraph.$$$reportNull$$$0(4);
        }
        JBTreeTraverser traverser = JBTreeTraverser.from(node -> this.myMap.get((Object)node.pointSet));
        TreeTraversal.TracingIt iterator = (TreeTraversal.TracingIt)((JBTreeTraverser)traverser.withRoots((Iterable)this.myMap.get((Object)from))).tracingBfsTraversal().unique(node -> node.pointSet).typedIterator();
        Ref parent = Ref.create((Object)from);
        HashMap<PointSet, PointSet> path = new HashMap<PointSet, PointSet>();
        iterator.forEachRemaining(node -> {
            Node itParent = (Node)iterator.parent();
            if (itParent != null && itParent.pointSet != parent.get()) {
                parent.set((Object)itParent.pointSet);
            }
            path.put(node.pointSet, (PointSet)parent.get());
        });
        return path.containsKey(to) && path.containsKey(from) ? this.flat(path, from, to) : null;
    }

    @NotNull
    private List<Node> flat(@NotNull Map<PointSet, PointSet> path, @NotNull PointSet start, @NotNull PointSet end2) {
        if (path == null) {
            BaseConversionGraph.$$$reportNull$$$0(5);
        }
        if (start == null) {
            BaseConversionGraph.$$$reportNull$$$0(6);
        }
        if (end2 == null) {
            BaseConversionGraph.$$$reportNull$$$0(7);
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        while (path.get(end2) != null) {
            PointSet previous = path.get(end2);
            PointSet current = end2;
            Node node = (Node)ContainerUtil.find((Iterable)this.myMap.get((Object)previous), currentNode -> Comparing.equal((Object)currentNode.pointSet, (Object)current));
            if (node == null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    BaseConversionGraph.$$$reportNull$$$0(8);
                }
                return list;
            }
            nodes.add(node);
            if ((end2 = path.get(end2)) != start) continue;
            break;
        }
        List list = ContainerUtil.reverse(nodes);
        if (list == null) {
            BaseConversionGraph.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @Nullable
    public Function<Object, Object> getConverter(@NotNull ConversionPoint<?> startPoint, @NotNull ConversionPoint<?> endPoint) {
        PointSet end2;
        PointSet start;
        List<Node> nodes;
        if (startPoint == null) {
            BaseConversionGraph.$$$reportNull$$$0(10);
        }
        if (endPoint == null) {
            BaseConversionGraph.$$$reportNull$$$0(11);
        }
        if ((nodes = this.shortestPath(start = PointSet.of(startPoint), end2 = PointSet.of(endPoint))) == null) {
            return null;
        }
        List functions = ContainerUtil.map(nodes, node -> node.function);
        Function resultFunction = null;
        for (Function function : functions) {
            if (resultFunction == null) {
                resultFunction = function;
                continue;
            }
            resultFunction = Functions.compose((Function)resultFunction, (Function)function);
        }
        return resultFunction;
    }

    public void register(@NotNull DataConverter converter) {
        if (converter == null) {
            BaseConversionGraph.$$$reportNull$$$0(12);
        }
        PointSet start = converter.getStart();
        PointSet end2 = converter.getEnd();
        this.myMap.putValue(start, (Object)new Node(end2, (Function<Object, Object>)((Function)converter::convert)));
        this.myMap.putValue(end2, (Object)new Node(start, (Function<Object, Object>)((Function)converter::convertReverse)));
        this.myMap.putValue(start, (Object)new Node(start, IDENTITY));
        this.myMap.putValue(end2, (Object)new Node(end2, IDENTITY));
    }

    @NotNull
    public static ConversionGraph get(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (grid == null) {
            BaseConversionGraph.$$$reportNull$$$0(13);
        }
        ConversionGraph conversionGraph = Objects.requireNonNull((ConversionGraph)grid.getUserData(CONVERSION_GRAPH_KEY));
        if (conversionGraph == null) {
            BaseConversionGraph.$$$reportNull$$$0(14);
        }
        return conversionGraph;
    }

    public static void set(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ConversionGraph graph) {
        if (grid == null) {
            BaseConversionGraph.$$$reportNull$$$0(15);
        }
        if (graph == null) {
            BaseConversionGraph.$$$reportNull$$$0(16);
        }
        grid.putUserData(CONVERSION_GRAPH_KEY, graph);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatsCache";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatterCreator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectFormatter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 8: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/BaseConversionGraph";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoint";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endPoint";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/BaseConversionGraph";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "flat";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shortestPath";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "flat";
                break;
            }
            case 8: 
            case 9: 
            case 14: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getConverter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 14 -> new IllegalStateException(string);
        };
    }

    private static final class Node {
        private final PointSet pointSet;
        private final Function<Object, Object> function;

        private Node(@NotNull PointSet pointSet, @Nullable Function<Object, Object> function) {
            if (pointSet == null) {
                Node.$$$reportNull$$$0(0);
            }
            this.pointSet = pointSet;
            this.function = function;
        }

        public boolean equals(Object obj) {
            return obj instanceof Node && this.pointSet.equals(((Node)obj).pointSet) && this.function == ((Node)obj).function;
        }

        public int hashCode() {
            return this.pointSet.hashCode() + Objects.hashCode(this.function);
        }

        public String toString() {
            return this.pointSet.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointSet", "com/intellij/database/data/types/BaseConversionGraph$Node", "<init>"));
        }
    }
}

