/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.files;

import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionLogger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.RequestBuilder;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.LocalModelDescriptor;
import org.jetbrains.completion.full.line.LocalModelDescriptorKt;
import org.jetbrains.completion.full.line.local.HostApi;
import org.jetbrains.completion.full.line.local.JarModelExtractException;
import org.jetbrains.completion.full.line.local.ModelDownloadNetworkException;
import org.jetbrains.completion.full.line.local.ModelSchema;
import org.jetbrains.completion.full.line.local.ModelSchemaKt;
import org.jetbrains.completion.full.line.local.NativeServerExtractException;
import org.jetbrains.completion.full.line.local.NativeServerSchema;
import org.jetbrains.completion.full.line.local.files.LocalModelsBundleManager;
import org.jetbrains.completion.full.line.local.files.LocalModelsDownloadManager;
import org.jetbrains.completion.full.line.logs.FullLineDetailsLogs;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J6\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/completion/full/line/local/files/LocalModelsDownloadManager;", "", "root", "Ljava/io/File;", "(Ljava/io/File;)V", "collectFilesToDownload", "", "Lcom/intellij/util/download/DownloadableFileDescription;", "model", "Lorg/jetbrains/completion/full/line/local/ModelSchema;", "hasBundledNative", "", "downloadableService", "Lcom/intellij/util/download/DownloadableFileService;", "localModelDescriptor", "Lorg/jetbrains/completion/full/line/LocalModelDescriptor;", "download", "downloadFiles", "", "filesToDownload", "schema", "downloadModelSchema", "version", "", "extractModel", "tag", "modelFolder", "extractNativeServer", "modelJar", "Companion", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nLocalModelsDownloadManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalModelsDownloadManager.kt\norg/jetbrains/completion/full/line/local/files/LocalModelsDownloadManager\n+ 2 converter.kt\norg/jetbrains/completion/full/line/local/ConverterKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,174:1\n13#2,2:175\n766#3:177\n857#3,2:178\n1109#4,2:180\n13309#4,2:182\n*S KotlinDebug\n*F\n+ 1 LocalModelsDownloadManager.kt\norg/jetbrains/completion/full/line/local/files/LocalModelsDownloadManager\n*L\n59#1:175,2\n122#1:177\n122#1:178,2\n158#1:180,2\n158#1:182,2\n*E\n"})
public final class LocalModelsDownloadManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File root;
    @NotNull
    private static final Lazy<MLCompletionLogger> LOG$delegate = LazyKt.lazy((Function0)Companion.LOG.2.INSTANCE);

    public LocalModelsDownloadManager(@NotNull File root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
    }

    @RequiresBackgroundThread
    @NotNull
    public final ModelSchema download(@NotNull LocalModelDescriptor localModelDescriptor) {
        Intrinsics.checkNotNullParameter((Object)localModelDescriptor, (String)"localModelDescriptor");
        String version = LocalModelDescriptorKt.selectModelVersion(localModelDescriptor);
        try {
            ModelSchema schema = this.downloadModelSchema(localModelDescriptor, version);
            boolean hasBundledNative = LocalModelsBundleManager.Companion.getInstance().hasBundledServerWithSameVersion(schema.getNative());
            DownloadableFileService downloadService = DownloadableFileService.getInstance();
            Intrinsics.checkNotNull((Object)downloadService);
            List<DownloadableFileDescription> filesToDownload = this.collectFilesToDownload(schema, hasBundledNative, downloadService, localModelDescriptor);
            LocalModelsDownloadManager.Companion.getLOG().info(CollectionsKt.joinToString$default((Iterable)filesToDownload, (CharSequence)"\n", (CharSequence)"Files to download:\n", null, (int)0, null, (Function1)download.1.INSTANCE, (int)28, null));
            this.downloadFiles(downloadService, filesToDownload, localModelDescriptor, schema, hasBundledNative);
            FullLineDetailsLogs.INSTANCE.successfullyDownload(localModelDescriptor, version);
            return schema;
        }
        catch (ModelDownloadNetworkException e) {
            FullLineDetailsLogs.INSTANCE.failedDownload(localModelDescriptor, version);
            throw e;
        }
    }

    private final ModelSchema downloadModelSchema(LocalModelDescriptor localModelDescriptor, String version) {
        String string;
        String host = HostApi.Companion.getInstance(version).model(localModelDescriptor);
        LocalModelsDownloadManager.Companion.getLOG().info("Schema to download: " + host + "/" + version + "/model.xml");
        RequestBuilder request = HttpRequests.request((String)(host + "/" + version + "/model.xml"));
        try {
            string = (String)request.connect(LocalModelsDownloadManager::downloadModelSchema$lambda$0);
        }
        catch (IOException e) {
            throw new ModelDownloadNetworkException(e);
        }
        String content = string;
        Intrinsics.checkNotNull((Object)content);
        String xml$iv = content;
        boolean $i$f$decodeFromXml = false;
        Element element = JDOMUtil.load((CharSequence)xml$iv);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
        Element a$iv = element;
        return (ModelSchema)XmlSerializer.deserialize((Element)a$iv, ModelSchema.class);
    }

    private final List<DownloadableFileDescription> collectFilesToDownload(ModelSchema model, boolean hasBundledNative, DownloadableFileService downloadableService, LocalModelDescriptor localModelDescriptor) {
        List list;
        String modelHost = HostApi.Companion.getInstance(model).model(localModelDescriptor);
        String tag = localModelDescriptor.tag();
        String fileName = this.modelJar(tag, model.getVersion());
        List $this$collectFilesToDownload_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        DownloadableFileDescription downloadableFileDescription = downloadableService.createFileDescription(modelHost + "/" + model.getVersion() + "/" + fileName, fileName);
        Intrinsics.checkNotNullExpressionValue((Object)downloadableFileDescription, (String)"createFileDescription(...)");
        $this$collectFilesToDownload_u24lambda_u241.add(downloadableFileDescription);
        NativeServerSchema nativeServerSchema = model.getNative();
        if (nativeServerSchema != null) {
            NativeServerSchema nativeSchema = nativeServerSchema;
            if (!hasBundledNative) {
                String serverHost = HostApi.Companion.getInstance(nativeSchema).server(nativeSchema.getVersion(), nativeSchema.getArchive());
                DownloadableFileDescription downloadableFileDescription2 = downloadableService.createFileDescription(serverHost, nativeSchema.getArchive());
                Intrinsics.checkNotNullExpressionValue((Object)downloadableFileDescription2, (String)"createFileDescription(...)");
                $this$collectFilesToDownload_u24lambda_u241.add(downloadableFileDescription2);
            }
        }
        return CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    private final void downloadFiles(DownloadableFileService downloadableService, List<? extends DownloadableFileDescription> filesToDownload, LocalModelDescriptor localModelDescriptor, ModelSchema schema, boolean hasBundledNative) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object server;
        FileDownloader fileDownloader = downloadableService.createDownloader(filesToDownload, localModelDescriptor.getLanguage().getDisplayName() + " model");
        Intrinsics.checkNotNullExpressionValue((Object)fileDownloader, (String)"createDownloader(...)");
        FileDownloader downloader = fileDownloader;
        File modelFolder = FilesKt.resolve((File)this.root, (String)schema.uid());
        try {
            downloader.download(modelFolder);
            LocalModelsDownloadManager.Companion.getLOG().info(filesToDownload.size() + " files successfully download to " + modelFolder.getAbsolutePath());
        }
        catch (IOException e) {
            throw new ModelDownloadNetworkException(e);
        }
        this.extractModel(localModelDescriptor.tag(), schema.getVersion(), modelFolder);
        if (hasBundledNative) {
            server = LocalModelsBundleManager.Companion.getInstance().unpackBundledServer(schema);
            if (server == null) {
                NativeServerSchema nativeServerSchema = schema.getNative();
                throw new NativeServerExtractException(new NullPointerException("Couldn't extract model for " + (nativeServerSchema != null ? nativeServerSchema.getVersion() : null)));
            }
            NativeServerSchema nativeServerSchema = schema.getNative();
            LocalModelsDownloadManager.Companion.getLOG().info("Bundled native server unpacked (" + (nativeServerSchema != null ? nativeServerSchema.getVersion() : null) + ").");
        } else {
            this.extractNativeServer(schema, modelFolder);
        }
        server = SequencesKt.toList((Sequence)((Sequence)FilesKt.walkTopDown((File)modelFolder)));
        MLCompletionLogger mLCompletionLogger = LocalModelsDownloadManager.Companion.getLOG();
        boolean $i$f$filter = false;
        void var10_12 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.isFile()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        mLCompletionLogger.info(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", (CharSequence)"Result files:\n", null, (int)0, null, (Function1)downloadFiles.2.INSTANCE, (int)28, null));
    }

    private final void extractNativeServer(ModelSchema schema, File modelFolder) {
        block2: {
            NativeServerSchema nativeServerSchema = schema.getNative();
            if (nativeServerSchema == null) break block2;
            NativeServerSchema nativeSchema = nativeServerSchema;
            boolean bl = false;
            Path archive = FilesKt.resolve((File)modelFolder, (String)nativeSchema.getArchive()).toPath();
            Path extracted = FilesKt.resolve((File)modelFolder, (String)ModelSchemaKt.extractedName(nativeSchema)).toPath();
            try {
                ZipUtil.extract((Path)archive, (Path)extracted, null, (boolean)true);
                MLCompletionLogger mLCompletionLogger = LocalModelsDownloadManager.Companion.getLOG();
                Intrinsics.checkNotNull((Object)extracted);
                mLCompletionLogger.info("Archive with native server extracted to " + ((Object)extracted.toAbsolutePath()).toString());
            }
            catch (IOException e) {
                throw new NativeServerExtractException(e);
            }
            Intrinsics.checkNotNull((Object)archive);
            PathKt.delete$default((Path)archive, (boolean)false, (int)1, null);
        }
    }

    private final void extractModel(String tag, String version, File modelFolder) {
        Object element$iv2;
        File extracted;
        block5: {
            Path archive = FilesKt.resolve((File)modelFolder, (String)this.modelJar(tag, version)).toPath();
            extracted = FilesKt.resolve((File)modelFolder, (String)("temp-" + tag + ".zip"));
            try {
                ZipUtil.extract((Path)archive, (Path)extracted.toPath(), null, (boolean)true);
                LocalModelsDownloadManager.Companion.getLOG().info("Jar file with model extracted to " + extracted.getAbsolutePath());
            }
            catch (IOException e) {
                throw new JarModelExtractException(e);
            }
            Intrinsics.checkNotNull((Object)archive);
            PathKt.delete$default((Path)archive, (boolean)false, (int)1, null);
            File[] fileArray = extracted.listFiles();
            Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles(...)");
            Object[] $this$first$iv = fileArray;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                File it = (File)element$iv2;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string, (String)(tag + "-"), (boolean)false, (int)2, null)) {
                    continue;
                }
                break block5;
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        File[] fileArray = ((File)element$iv2).listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles(...)");
        Object[] $this$forEach$iv = fileArray;
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            Path path2;
            Path path3;
            File it = (File)element$iv3;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.toPath(), (String)"toPath(...)");
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Intrinsics.checkNotNullExpressionValue((Object)FilesKt.resolve((File)modelFolder, (String)string).toPath(), (String)"toPath(...)");
            CopyOption[] copyOptionArray = new CopyOption[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.move(path3, path2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"move(...)");
        }
        FilesKt.deleteRecursively((File)extracted);
    }

    private final String modelJar(String tag, String version) {
        String string = tag.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String fixedId = string;
        return "local-model-" + fixedId + "-" + version + ".jar";
    }

    private static final String downloadModelSchema$lambda$0(HttpRequests.Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BufferedReader bufferedReader = it.getReader();
        Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"getReader(...)");
        return TextStreamsKt.readText((Reader)bufferedReader);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/completion/full/line/local/files/LocalModelsDownloadManager$Companion;", "", "()V", "LOG", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger;", "getLOG", "()Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger;", "LOG$delegate", "Lkotlin/Lazy;", "intellij.fullLine"})
    public static final class Companion {
        private Companion() {
        }

        private final MLCompletionLogger getLOG() {
            Lazy lazy = LOG$delegate;
            return (MLCompletionLogger)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

