/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.cpu;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionDiagnosticsService;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionLogger;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.io.ZipUtil;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.local.HostApi;
import org.jetbrains.completion.full.line.local.files.LocalModelsFilesService;
import org.jetbrains.completion.full.line.local.services.SignManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u0004\u0018\u00010\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/completion/full/line/cpu/CpuDetector;", "", "()V", "LOG", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger;", "detectorExecutable", "Ljava/io/File;", "getDetectorExecutable", "()Ljava/io/File;", "detectorExecutable$delegate", "Lkotlin/Lazy;", "getCpuInfo", "", "getFileFromZip", "", "zipFilePath", "name", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nCpuDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CpuDetector.kt\norg/jetbrains/completion/full/line/cpu/CpuDetector\n+ 2 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/DiagnosticLoggersKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n36#2:88\n13#3:89\n179#4,2:90\n1#5:92\n*S KotlinDebug\n*F\n+ 1 CpuDetector.kt\norg/jetbrains/completion/full/line/cpu/CpuDetector\n*L\n17#1:88\n17#1:89\n58#1:90,2\n*E\n"})
public final class CpuDetector {
    @NotNull
    private final MLCompletionLogger LOG;
    @NotNull
    private final Lazy detectorExecutable$delegate;

    public CpuDetector() {
        boolean $i$f$logger = false;
        MLCompletionDiagnosticsService mLCompletionDiagnosticsService = MLCompletionDiagnosticsService.Companion.getInstance();
        boolean $i$f$logger2 = false;
        Logger logger = Logger.getInstance(CpuDetector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = mLCompletionDiagnosticsService.logger(logger);
        this.detectorExecutable$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ CpuDetector this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final File invoke() {
                String baseName = "cpu-detector";
                File root = FilesKt.resolve((File)LocalModelsFilesService.Companion.getInstance().getRoot(), (String)baseName);
                if (!SystemInfoRt.isWindows) {
                    return null;
                }
                String name = baseName + ".exe";
                File fullPath = FilesKt.resolve((File)root, (String)name);
                if (fullPath.exists()) {
                    CpuDetector.access$getLOG$p(this.this$0).info("CPU detector found: " + fullPath);
                    return fullPath;
                }
                File temp = FilesKt.resolve((File)LocalModelsFilesService.Companion.getInstance().getRoot(), (String)("temp-" + UUID.randomUUID() + ".zip"));
                try {
                    byte[] byArray;
                    File file2;
                    if (PluginPathManager.getPluginResource(this.this$0.getClass(), (String)("full-line-" + baseName + ".zip")) == null) {
                        File file3 = null;
                        return file3;
                    }
                    File bundledDetectorArchive = file2;
                    CpuDetector.access$getLOG$p(this.this$0).info("Getting CPU detector from: " + bundledDetectorArchive);
                    if (CpuDetector.access$getFileFromZip(this.this$0, bundledDetectorArchive, HostApi.Companion.getOs() + "/" + HostApi.Companion.getCpu() + "/" + baseName + ".zip") == null) {
                        File file4 = null;
                        return file4;
                    }
                    byte[] nativeBytes = byArray;
                    FilesKt.writeBytes((File)temp, (byte[])nativeBytes);
                    ZipUtil.extract((Path)temp.toPath(), (Path)root.toPath(), null, (boolean)true);
                }
                catch (Throwable e) {
                    CpuDetector.access$getLOG$p(this.this$0).warn("Cannot extract CPU detector: " + e);
                    File file5 = null;
                    return file5;
                }
                finally {
                    temp.delete();
                }
                CpuDetector.access$getLOG$p(this.this$0).info("CPU detector is ready: " + fullPath);
                return fullPath;
            }
        }));
    }

    private final File getDetectorExecutable() {
        Lazy lazy = this.detectorExecutable$delegate;
        return (File)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final byte[] getFileFromZip(File zipFilePath, String name) {
        byte[] byArray;
        Closeable closeable = new ZipFile(zipFilePath);
        Throwable throwable = null;
        try {
            byte[] byArray2;
            Object v2;
            ZipFile zip2;
            block8: {
                void $this$firstOrNull$iv;
                zip2 = (ZipFile)closeable;
                boolean bl = false;
                Enumeration<? extends ZipEntry> enumeration = zip2.entries();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
                Sequence sequence2 = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ZipEntry it = (ZipEntry)element$iv;
                    boolean bl2 = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!StringsKt.endsWith$default((String)string, (String)name, (boolean)false, (int)2, null)) continue;
                    v2 = element$iv;
                    break block8;
                }
                v2 = null;
            }
            ZipEntry zipEntry = v2;
            if (zipEntry != null) {
                ZipEntry it = zipEntry;
                boolean bl = false;
                InputStream inputStream2 = zip2.getInputStream(it);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getInputStream(...)");
                byArray2 = ByteStreamsKt.readBytes((InputStream)inputStream2);
            } else {
                byArray2 = null;
            }
            byArray = byArray2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    @Nullable
    public final String getCpuInfo() {
        if (this.getDetectorExecutable() == null) {
            return null;
        }
        File file2 = this.getDetectorExecutable();
        Intrinsics.checkNotNull((Object)file2);
        if (file2.getParentFile() == null) {
            this.LOG.warn("There's no parent dir for CPU detector");
            return null;
        }
        try {
            SignManager signManager = SignManager.Companion.getInstance();
            File file3 = this.getDetectorExecutable();
            Intrinsics.checkNotNull((Object)file3);
            File file4 = this.getDetectorExecutable();
            Intrinsics.checkNotNull((Object)file4);
            File file5 = file4.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file5, (String)"getParentFile(...)");
            signManager.verify(file3, FilesKt.resolve((File)file5, (String)"sign"));
        }
        catch (Throwable e) {
            this.LOG.warn("CPU detector check failed: " + e);
            return null;
        }
        try {
            String[] stringArray = new String[]{String.valueOf(this.getDetectorExecutable())};
            ProcessOutput res = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(stringArray));
            String string = res.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
            if (!(((CharSequence)string).length() == 0)) {
                this.LOG.warn("CPU detector call stderr: " + res.getStderr());
            }
            return res.getStdout();
        }
        catch (Throwable e) {
            this.LOG.warn("CPU detector call failed: " + e);
            return null;
        }
    }

    public static final /* synthetic */ MLCompletionLogger access$getLOG$p(CpuDetector $this) {
        return $this.LOG;
    }

    public static final /* synthetic */ byte[] access$getFileFromZip(CpuDetector $this, File zipFilePath, String name) {
        return $this.getFileFromZip(zipFilePath, name);
    }
}

