/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.actions;

import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.internal.DumpLookupElementWeights;
import com.intellij.ml.inline.completion.impl.diagnostic.DiagnosticsLog;
import com.intellij.ml.inline.completion.impl.diagnostic.ui.logs.MLCompletionFullLogsWindow;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipOutputStream;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.FileTransferable;
import org.jetbrains.completion.full.line.FullLineNotifications;
import org.jetbrains.completion.full.line.PathUtilsKt;
import org.jetbrains.completion.full.line.UtilsKt;
import org.jetbrains.completion.full.line.ZipKt;
import org.jetbrains.completion.full.line.actions.InternalGenerationAction;
import org.jetbrains.completion.full.line.starter.FullLineInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\r*\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u001cH\u0002J\f\u0010\u001d\u001a\u00020\r*\u00020\u0013H\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\r*\u00020\u0013H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/completion/full/line/actions/FullLineGenerateContextAction;", "Lorg/jetbrains/completion/full/line/actions/InternalGenerationAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "root", "Ljava/io/File;", "getRoot", "()Ljava/io/File;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getDescription", "", "language", "contextFile", "getFile", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "markerTemplate", "file", "offset", "", "completionInfo", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "createImage", "Ljava/awt/image/BufferedImage;", "Ljavax/swing/JComponent;", "fullLineDiagnostics", "fullLineLastSessionDiagnostics", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nFullLineGenerateContextAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineGenerateContextAction.kt\norg/jetbrains/completion/full/line/actions/FullLineGenerateContextAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1#2:153\n350#3,7:154\n*S KotlinDebug\n*F\n+ 1 FullLineGenerateContextAction.kt\norg/jetbrains/completion/full/line/actions/FullLineGenerateContextAction\n*L\n132#1:154,7\n*E\n"})
public final class FullLineGenerateContextAction
extends InternalGenerationAction
implements DumbAware {
    @NotNull
    private final File root = FilesKt.resolve((File)new File(System.getProperty("user.home")), (String)".flcc/issues");

    @NotNull
    public final File getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        PsiFile psiFile2 = this.getFile(e, project2);
        if (psiFile2 == null) {
            return;
        }
        PsiFile file3 = psiFile2;
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        int caretOffset = editor2.getCaretModel().getPrimaryCaret().getOffset();
        String string = file3.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String context2 = StringsKt.take((String)string, (int)caretOffset);
        String path2 = PathUtilsKt.projectFilePath(file3);
        String string2 = file3.getLanguage().getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String language2 = string3;
        LookupEx lookupEx = LookupManager.getActiveLookup((Editor)editor2);
        LookupImpl lookup = lookupEx instanceof LookupImpl ? (LookupImpl)lookupEx : null;
        ByteArrayOutputStream zip2 = ZipKt.zip((Function1<? super ZipOutputStream, Unit>)((Function1)new Function1<ZipOutputStream, Unit>(path2, context2, file3, this, caretOffset, lookup, editor2, project2){
            final /* synthetic */ String $path;
            final /* synthetic */ String $context;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ FullLineGenerateContextAction this$0;
            final /* synthetic */ int $caretOffset;
            final /* synthetic */ LookupImpl $lookup;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ Project $project;
            {
                this.$path = $path;
                this.$context = $context;
                this.$file = $file;
                this.this$0 = $receiver;
                this.$caretOffset = $caretOffset;
                this.$lookup = $lookup;
                this.$editor = $editor;
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull ZipOutputStream $this$zip) {
                block2: {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)$this$zip, (String)"$this$zip");
                    ZipKt.file($this$zip, this.$path, this.$context);
                    String string = "fl-context." + this.$file.getVirtualFile().getExtension();
                    String string2 = this.$file.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                    ZipKt.file($this$zip, string, string2);
                    ZipKt.file($this$zip, "marker-template." + this.$file.getVirtualFile().getExtension(), FullLineGenerateContextAction.access$markerTemplate(this.this$0, this.$file, this.$caretOffset));
                    ZipKt.file($this$zip, "system-info.txt", FullLineInfo.INSTANCE.systemInfo());
                    ZipKt.file($this$zip, "plugin-info.txt", FullLineInfo.INSTANCE.pluginDescriptor());
                    ZipKt.file($this$zip, "languages.txt", FullLineInfo.INSTANCE.languages());
                    LookupImpl lookupImpl = this.$lookup;
                    if (lookupImpl != null) {
                        object = lookupImpl;
                        FullLineGenerateContextAction fullLineGenerateContextAction = this.this$0;
                        LookupImpl $this$invoke_u24lambda_u240 = object;
                        boolean bl = false;
                        ZipKt.file($this$zip, "completion-info.txt", FullLineGenerateContextAction.access$completionInfo(fullLineGenerateContextAction, $this$invoke_u24lambda_u240));
                        JComponent jComponent = $this$invoke_u24lambda_u240.getComponent();
                        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
                        ZipKt.file$default($this$zip, "lookup.jpg", FullLineGenerateContextAction.access$createImage(fullLineGenerateContextAction, jComponent), null, 4, null);
                    }
                    Editor editor = this.$editor;
                    object = this.this$0;
                    Editor $this$invoke_u24lambda_u241 = editor;
                    boolean bl = false;
                    JComponent jComponent = $this$invoke_u24lambda_u241.getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
                    ZipKt.file$default($this$zip, "editor.jpg", FullLineGenerateContextAction.access$createImage((FullLineGenerateContextAction)((Object)object), jComponent), null, 4, null);
                    if (!Registry.is((String)"ai.completion.enable.diagnostics")) break block2;
                    ZipKt.file($this$zip, "ai-completion-diagnostics.txt", FullLineGenerateContextAction.access$fullLineDiagnostics(this.this$0, this.$project));
                    String string3 = FullLineGenerateContextAction.access$fullLineLastSessionDiagnostics(this.this$0, this.$project);
                    if (string3 != null) {
                        String it = string3;
                        boolean bl2 = false;
                        ZipKt.file($this$zip, "ai-completion-diagnostics-last-section.txt", it);
                    }
                }
            }
        }));
        if (!this.root.exists()) {
            this.root.mkdirs();
        }
        File it = file2 = FilesKt.resolve((File)this.root, (String)("flcc-data-" + System.currentTimeMillis() + ".zip"));
        boolean bl = false;
        Closeable closeable = new FileOutputStream(it);
        Throwable throwable = null;
        try {
            OutputStream p0 = (OutputStream)closeable;
            boolean bl2 = false;
            zip2.writeTo(p0);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        File contextFile = file2;
        String description = this.getDescription(language2, contextFile);
        String query2 = "project=ML&summary=<TBD>&description=" + description + "&c=Full Line. IDE";
        URI uri = new URI("https", "youtrack.jetbrains.com", "/newIssue", query2, null);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new FileTransferable(CollectionsKt.listOf((Object)contextFile)), FullLineGenerateContextAction::actionPerformed$lambda$1);
        FullLineNotifications.Internal.INSTANCE.showGenerateFLContextAction(project2, contextFile, uri);
    }

    private final String getDescription(String language2, File contextFile) {
        return StringsKt.trimMargin$default((String)("\n      |> Context was auto-generated to `" + contextFile.getName() + "`\n      |\n      |Language: `" + language2 + "`\n      |\n      |**Problem:**\n      |=TBD=\n      |\n      |**The expected result:**\n      |=TBD=\n      |\n      |**The actual result:**\n      |=TBD=\n    "), null, (int)1, null);
    }

    private final String markerTemplate(PsiFile file2, int offset) {
        StringBuilder context2 = new StringBuilder();
        UtilsKt.plusAssign(context2, "# result = <>\n");
        UtilsKt.plusAssign(context2, "# prefix = <>\n");
        String string = file2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        UtilsKt.plusAssign(context2, string);
        context2.insert(offset, "<caret>");
        String string2 = context2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final String completionInfo(LookupImpl $this$completionInfo) {
        List list = DumpLookupElementWeights.getLookupElementWeights((LookupImpl)$this$completionInfo, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLookupElementWeights(...)");
        return CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final String fullLineDiagnostics(Project $this$fullLineDiagnostics) {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance($this$fullLineDiagnostics).getToolWindow("ML Completion Diagnostics");
        Intrinsics.checkNotNull((Object)toolWindow);
        ToolWindow tool = toolWindow;
        Content[] contentArray = tool.getContentManager().getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        JComponent jComponent = ((Content)ArraysKt.first((Object[])contentArray)).getComponent();
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.ml.inline.completion.impl.diagnostic.ui.logs.MLCompletionFullLogsWindow");
        MLCompletionFullLogsWindow content = (MLCompletionFullLogsWindow)jComponent;
        JComponent jComponent2 = content.getContent();
        Intrinsics.checkNotNull((Object)jComponent2, (String)"null cannot be cast to non-null type com.intellij.ml.inline.completion.impl.diagnostic.DiagnosticsLog.Console");
        DiagnosticsLog.Console console = (DiagnosticsLog.Console)jComponent2;
        String string = console.getOriginalDocument().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String fullLineLastSessionDiagnostics(Project $this$fullLineLastSessionDiagnostics) {
        int n;
        List diagnosticLines;
        block3: {
            Regex lastSessionReg = new Regex("\\[.*]\\s*--==New for .*local.* session started==--");
            diagnosticLines = StringsKt.lines((CharSequence)this.fullLineDiagnostics($this$fullLineLastSessionDiagnostics));
            List $this$indexOfFirst$iv = CollectionsKt.reversed((Iterable)diagnosticLines);
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                String it = (String)item$iv;
                boolean bl = false;
                if (lastSessionReg.matches((CharSequence)it)) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        Integer n2 = n;
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = it >= 0 ? n2 : null;
        if (n3 == null) {
            return null;
        }
        int lastSessionIndex = n3;
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.takeLast((List)diagnosticLines, (int)(lastSessionIndex + 1)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final BufferedImage createImage(JComponent $this$createImage) {
        BufferedImage bufferedImage = UIUtil.createImage((Component)$this$createImage, (int)$this$createImage.getWidth(), (int)$this$createImage.getHeight(), (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        BufferedImage img = bufferedImage;
        Graphics2D g = img.createGraphics();
        $this$createImage.paint(g);
        return img;
    }

    private final PsiFile getFile(AnActionEvent e, Project project) {
        PsiFile psiFile2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile2 == null) {
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor != null) {
                Editor it = editor;
                boolean bl = false;
                psiFile2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(it.getDocument());
            } else {
                psiFile2 = null;
            }
        }
        return psiFile2;
    }

    private static final void actionPerformed$lambda$1(Clipboard clipboard, Transferable transferable) {
    }

    public static final /* synthetic */ String access$markerTemplate(FullLineGenerateContextAction $this, PsiFile file2, int offset) {
        return $this.markerTemplate(file2, offset);
    }

    public static final /* synthetic */ String access$fullLineDiagnostics(FullLineGenerateContextAction $this, Project $receiver) {
        return $this.fullLineDiagnostics($receiver);
    }

    public static final /* synthetic */ String access$fullLineLastSessionDiagnostics(FullLineGenerateContextAction $this, Project $receiver) {
        return $this.fullLineLastSessionDiagnostics($receiver);
    }

    public static final /* synthetic */ String access$completionInfo(FullLineGenerateContextAction $this, LookupImpl $receiver) {
        return $this.completionInfo($receiver);
    }

    public static final /* synthetic */ BufferedImage access$createImage(FullLineGenerateContextAction $this, JComponent $receiver) {
        return $this.createImage($receiver);
    }
}

