/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.tagtoattribute;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.psi.TagSearchVisitor;
import com.sixrr.xrp.tagtoattribute.ReplaceTagWithAttribute;
import com.sixrr.xrp.tagtoattribute.TagToAttributeUsageViewDescriptor;
import com.sixrr.xrp.utils.RefactorXBundle;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class TagToAttributeProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlTag tag;
    private final String attributeName;
    private final Context context;

    TagToAttributeProcessor(XmlTag tag, String attributeName, Context context) {
        super(tag.getProject());
        this.tag = tag;
        this.attributeName = attributeName;
        this.context = context;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usageInfos) {
        if (usageInfos == null) {
            TagToAttributeProcessor.$$$reportNull$$$0(0);
        }
        return new TagToAttributeUsageViewDescriptor(this.tag);
    }

    @Override
    public void findUsages(@NotNull List<? super XRPUsageInfo> usages) {
        if (usages == null) {
            TagToAttributeProcessor.$$$reportNull$$$0(1);
        }
        XmlTag parentTag = (XmlTag)this.tag.getParent();
        String parentTagName = parentTag.getName();
        String tagName = this.tag.getName();
        TagSearchVisitor visitor = new TagSearchVisitor(tagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            XmlTag testParentTag;
            XmlTag[] subTags = xmlTag.getSubTags();
            if (subTags.length != 0 || (testParentTag = xmlTag.getParentTag()) == null || !parentTagName.equals(testParentTag.getName())) continue;
            usages.add(new ReplaceTagWithAttribute(xmlTag, this.attributeName));
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactorXBundle.message("command.name.replace.tag.0.with.attribute", this.tag.getName());
        if (string == null) {
            TagToAttributeProcessor.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/xrp/tagtoattribute/TagToAttributeProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/xrp/tagtoattribute/TagToAttributeProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

