/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.thinClientLink;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.gateway.thinClientLink.ClientLifetimeTracker;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Signal;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Lcom/jetbrains/gateway/thinClientLink/ClientVersionContext;", "Lcom/jetbrains/gateway/thinClientLink/ClientLifetimeTracker;", "version", "", "(Ljava/lang/String;)V", "aliveProcessCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "clientHandlesLifetimeDef", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "clientsTerminated", "Lcom/jetbrains/rd/util/reactive/ISource;", "", "Lcom/jetbrains/rd/util/reactive/IVoidSource;", "getClientsTerminated", "()Lcom/jetbrains/rd/util/reactive/ISource;", "clientsTerminatedSignal", "Lcom/jetbrains/rd/util/reactive/Signal;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "openHandleCount", "getVersion", "()Ljava/lang/String;", "handleClosed", "uid", "processTerminated", "registerClientHandleLifetime", "clientHandleLifetime", "registerClientProcessLifetime", "processLifetime", "Companion", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nClientVersionContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientVersionContext.kt\ncom/jetbrains/gateway/thinClientLink/ClientVersionContext\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,69:1\n58#2,5:70\n58#2,5:75\n58#2,5:80\n58#2,5:85\n13#2:90\n*S KotlinDebug\n*F\n+ 1 ClientVersionContext.kt\ncom/jetbrains/gateway/thinClientLink/ClientVersionContext\n*L\n32#1:70,5\n38#1:75,5\n47#1:80,5\n55#1:85,5\n67#1:90\n*E\n"})
public final class ClientVersionContext
implements ClientLifetimeTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String version;
    @NotNull
    private final AtomicInteger aliveProcessCount;
    @NotNull
    private final AtomicInteger openHandleCount;
    @NotNull
    private final LifetimeDefinition clientHandlesLifetimeDef;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Signal<Unit> clientsTerminatedSignal;
    @NotNull
    private final ISource<Unit> clientsTerminated;
    @NotNull
    private static final Logger logger;

    public ClientVersionContext(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.version = version;
        this.aliveProcessCount = new AtomicInteger();
        this.openHandleCount = new AtomicInteger();
        this.clientHandlesLifetimeDef = new LifetimeDefinition();
        this.lifetime = (Lifetime)this.clientHandlesLifetimeDef;
        this.clientsTerminatedSignal = new Signal();
        this.clientsTerminated = (ISource)this.clientsTerminatedSignal;
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.version;
    }

    @Override
    @NotNull
    public Lifetime getLifetime() {
        return this.lifetime;
    }

    @Override
    @NotNull
    public ISource<Unit> getClientsTerminated() {
        return this.clientsTerminated;
    }

    @Override
    public void registerClientHandleLifetime(@NotNull Lifetime clientHandleLifetime, @NotNull String uid) {
        Intrinsics.checkNotNullParameter((Object)clientHandleLifetime, (String)"clientHandleLifetime");
        Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
        int newHandlesCount = this.openHandleCount.incrementAndGet();
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Registered new client handle for " + this.getVersion() + " with uid " + uid + ", current count is " + newHandlesCount, e$iv);
        }
        clientHandleLifetime.onTermination((Function0)new Function0<Unit>(this, uid){
            final /* synthetic */ ClientVersionContext this$0;
            final /* synthetic */ String $uid;
            {
                this.this$0 = $receiver;
                this.$uid = $uid;
                super(0);
            }

            public final void invoke() {
                ClientVersionContext.access$handleClosed(this.this$0, this.$uid);
            }
        });
    }

    @Override
    public void registerClientProcessLifetime(@NotNull Lifetime processLifetime, @NotNull String uid) {
        Intrinsics.checkNotNullParameter((Object)processLifetime, (String)"processLifetime");
        Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
        int newProcessCount = this.aliveProcessCount.incrementAndGet();
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Registered new process for " + this.getVersion() + " uid " + uid + ", current count is " + newProcessCount, e$iv);
        }
        if (!processLifetime.onTerminationIfAlive((Function0)new Function0<Unit>(this, uid){
            final /* synthetic */ ClientVersionContext this$0;
            final /* synthetic */ String $uid;
            {
                this.this$0 = $receiver;
                this.$uid = $uid;
                super(0);
            }

            public final void invoke() {
                ClientVersionContext.access$processTerminated(this.this$0, this.$uid);
            }
        })) {
            this.processTerminated(uid);
        }
    }

    private final void handleClosed(String uid) {
        int newHandlesCount = this.openHandleCount.decrementAndGet();
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Client handle with uid " + uid + " is closed, current count is " + newHandlesCount, e$iv);
        }
        if (newHandlesCount == 0) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)this.clientHandlesLifetimeDef, (boolean)false, (int)1, null);
        }
    }

    private final void processTerminated(String uid) {
        int newProcessCount = this.aliveProcessCount.decrementAndGet();
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Process for version " + this.getVersion() + " uid " + uid + " terminated, current count is " + newProcessCount, e$iv);
        }
        if (newProcessCount < 0) {
            logger.error("Process count for version " + this.getVersion() + " uid " + uid + " is negative: " + newProcessCount);
            this.aliveProcessCount.incrementAndGet();
            return;
        }
        if (newProcessCount == 0) {
            this.clientsTerminatedSignal.fire((Object)Unit.INSTANCE);
        }
    }

    public static final /* synthetic */ void access$handleClosed(ClientVersionContext $this, String uid) {
        $this.handleClosed(uid);
    }

    public static final /* synthetic */ void access$processTerminated(ClientVersionContext $this, String uid) {
        $this.processTerminated(uid);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ClientVersionContext.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ClientVersionContext.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/gateway/thinClientLink/ClientVersionContext$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

