/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.internal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ApplicationKt;
import com.jetbrains.gateway.GatewayBundle;
import com.jetbrains.gateway.api.ConnectionRequestor;
import com.jetbrains.gateway.api.GatewayConnectionHandle;
import com.jetbrains.gateway.api.GatewayConnectionProvider;
import com.jetbrains.gateway.thinClientLink.LinkedClientManager;
import com.jetbrains.gateway.thinClientLink.ThinClientHandle;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/gateway/internal/LinkedProxyConnectionProvider;", "Lcom/jetbrains/gateway/api/GatewayConnectionProvider;", "()V", "connect", "Lcom/jetbrains/gateway/api/GatewayConnectionHandle;", "parameters", "", "", "requestor", "Lcom/jetbrains/gateway/api/ConnectionRequestor;", "(Ljava/util/Map;Lcom/jetbrains/gateway/api/ConnectionRequestor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isApplicable", "", "Companion", "intellij.gateway.core"})
public final class LinkedProxyConnectionProvider
implements GatewayConnectionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String LINKED_PROXY_INTERNAL_CONNECTOR_TYPE = "internal_lpc";

    @Override
    public boolean isApplicable(@NotNull Map<String, String> parameters) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        return Intrinsics.areEqual((Object)parameters.get("type"), (Object)LINKED_PROXY_INTERNAL_CONNECTOR_TYPE) && parameters.containsKey("url") && ApplicationKt.getApplication().isInternal();
    }

    @Override
    @Nullable
    public Object connect(@NotNull Map<String, String> parameters, @NotNull ConnectionRequestor requestor, @NotNull Continuation<? super GatewayConnectionHandle> $completion) {
        String string = parameters.get("url");
        if (string == null) {
            return null;
        }
        String url2 = string;
        URI initialLink = URI.create(url2);
        LinkedClientManager linkedClientManager = LinkedClientManager.Companion.getInstance();
        Lifetime lifetime = (Lifetime)LifetimeDisposableExKt.defineNestedLifetime((Disposable)((Disposable)ApplicationKt.getApplication()));
        Intrinsics.checkNotNull((Object)initialLink);
        ThinClientHandle clientHandle = LinkedClientManager.startNewClient$default(linkedClientManager, lifetime, initialLink, initialLink.getHost(), null, 8, null);
        return new GatewayConnectionHandle(clientHandle, url2){
            final /* synthetic */ ThinClientHandle $clientHandle;
            final /* synthetic */ String $url;
            {
                this.$clientHandle = $clientHandle;
                this.$url = $url;
                super($clientHandle);
            }

            @NotNull
            public String getTitle() {
                return GatewayBundle.INSTANCE.message("internal.dialog.title.linked.client.proxy", new Object[0]);
            }

            public boolean hideToTrayOnStart() {
                return false;
            }

            @NotNull
            public JComponent createComponent() {
                return (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this.$url, this.$clientHandle){
                    final /* synthetic */ String $url;
                    final /* synthetic */ ThinClientHandle $clientHandle;
                    {
                        this.$url = $url;
                        this.$clientHandle = $clientHandle;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$panel) {
                        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                        Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$url, this.$clientHandle){
                            final /* synthetic */ String $url;
                            final /* synthetic */ ThinClientHandle $clientHandle;
                            {
                                this.$url = $url;
                                this.$clientHandle = $clientHandle;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                Cell tf = $this$row.textField();
                                Ref.ObjectRef check = new Ref.ObjectRef();
                                ((JBTextField)tf.getComponent()).setText(this.$url);
                                $this$row.button(GatewayBundle.INSTANCE.message("internal.linked.proxy.button.update.link", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(this.$clientHandle, (Cell<? extends JBTextField>)tf, (Ref.ObjectRef<JCheckBox>)check){
                                    final /* synthetic */ ThinClientHandle $clientHandle;
                                    final /* synthetic */ Cell<JBTextField> $tf;
                                    final /* synthetic */ Ref.ObjectRef<JCheckBox> $check;
                                    {
                                        this.$clientHandle = $clientHandle;
                                        this.$tf = $tf;
                                        this.$check = $check;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull ActionEvent it) {
                                        JCheckBox jCheckBox;
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        String string = ((JBTextField)this.$tf.getComponent()).getText();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                                        URI uRI = URI.create(((Object)StringsKt.trim((CharSequence)string)).toString());
                                        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
                                        if (this.$check.element == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"check");
                                            jCheckBox = null;
                                        } else {
                                            jCheckBox = (JCheckBox)this.$check.element;
                                        }
                                        this.$clientHandle.updateJoinLink(uRI, jCheckBox.isSelected());
                                    }
                                });
                                check.element = $this$row.checkBox(GatewayBundle.INSTANCE.message("internal.linked.proxy.checkbox.force", new Object[0])).getComponent();
                            }
                        }), (int)1, null);
                        Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$clientHandle){
                            final /* synthetic */ ThinClientHandle $clientHandle;
                            {
                                this.$clientHandle = $clientHandle;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.button(GatewayBundle.INSTANCE.message("internal.linked.proxy.button.put.client.in.reconnect.mode", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(this.$clientHandle){
                                    final /* synthetic */ ThinClientHandle $clientHandle;
                                    {
                                        this.$clientHandle = $clientHandle;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull ActionEvent it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        this.$clientHandle.notifyReconnect();
                                    }
                                });
                            }
                        }), (int)1, null);
                        Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$clientHandle){
                            final /* synthetic */ ThinClientHandle $clientHandle;
                            {
                                this.$clientHandle = $clientHandle;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.button(GatewayBundle.INSTANCE.message("internal.linked.proxy.button.request.focus.on.client", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(this.$clientHandle){
                                    final /* synthetic */ ThinClientHandle $clientHandle;
                                    {
                                        this.$clientHandle = $clientHandle;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull ActionEvent it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        this.$clientHandle.focusClientWindow();
                                    }
                                });
                            }
                        }), (int)1, null);
                        Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$clientHandle){
                            final /* synthetic */ ThinClientHandle $clientHandle;
                            {
                                this.$clientHandle = $clientHandle;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.button(GatewayBundle.INSTANCE.message("internal.linked.proxy.button.close.client", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(this.$clientHandle){
                                    final /* synthetic */ ThinClientHandle $clientHandle;
                                    {
                                        this.$clientHandle = $clientHandle;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull ActionEvent it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        this.$clientHandle.close();
                                    }
                                });
                            }
                        }), (int)1, null);
                    }
                }));
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/gateway/internal/LinkedProxyConnectionProvider$Companion;", "", "()V", "LINKED_PROXY_INTERNAL_CONNECTOR_TYPE", "", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

