/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.driver.JTableCellPreconditions;
import org.assertj.swing.edt.GuiActionRunner;

final class JTableStopCellEditingTask {
    @RunsInEDT
    static void stopEditing(@Nonnull TableCellEditor cellEditor) {
        GuiActionRunner.execute(() -> JTableStopCellEditingTask.doStopCellEditing(cellEditor));
    }

    @RunsInEDT
    static void stopEditing(@Nonnull JTable table, int row, int column) {
        GuiActionRunner.execute(() -> JTableStopCellEditingTask.doStopCellEditing(table, row, column));
    }

    @RunsInEDT
    static void checkStateAndStopEditing(@Nonnull JTable table, int row, int column) {
        GuiActionRunner.execute(() -> {
            JTableCellPreconditions.checkCellIndicesInBounds(table, row, column);
            JTableCellPreconditions.validateCellIsEditable(table, row, column);
            JTableStopCellEditingTask.doStopCellEditing(table, row, column);
        });
    }

    @RunsInCurrentThread
    private static void doStopCellEditing(@Nonnull JTable table, int row, int column) {
        TableCellEditor editor2 = Preconditions.checkNotNull(table.getCellEditor(row, column));
        JTableStopCellEditingTask.doStopCellEditing(editor2);
    }

    @RunsInCurrentThread
    private static void doStopCellEditing(@Nonnull TableCellEditor cellEditor) {
        Preconditions.checkNotNull(cellEditor);
        cellEditor.stopCellEditing();
    }

    private JTableStopCellEditingTask() {
    }
}

