/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import java.util.regex.Pattern;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.description.Description;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.cell.JComboBoxCellReader;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.BasicJComboBoxCellReader;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.driver.JComboBoxContentQuery;
import org.assertj.swing.driver.JComboBoxDropDownListFinder;
import org.assertj.swing.driver.JComboBoxEditableQuery;
import org.assertj.swing.driver.JComboBoxItemCountQuery;
import org.assertj.swing.driver.JComboBoxItemIndexPreconditions;
import org.assertj.swing.driver.JComboBoxMatchingItemQuery;
import org.assertj.swing.driver.JComboBoxSelectedIndexQuery;
import org.assertj.swing.driver.JComboBoxSelectionValueQuery;
import org.assertj.swing.driver.JComboBoxSetSelectedIndexTask;
import org.assertj.swing.driver.JComponentDriver;
import org.assertj.swing.driver.JListDriver;
import org.assertj.swing.driver.TextAssert;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.exception.ActionFailedException;
import org.assertj.swing.exception.ComponentLookupException;
import org.assertj.swing.exception.LocationUnavailableException;
import org.assertj.swing.format.Formatting;
import org.assertj.swing.internal.annotation.InternalApi;
import org.assertj.swing.util.Arrays;
import org.assertj.swing.util.Pair;
import org.assertj.swing.util.PatternTextMatcher;
import org.assertj.swing.util.StringTextMatcher;
import org.assertj.swing.util.TextMatcher;

@InternalApi
public class JComboBoxDriver
extends JComponentDriver {
    private static final String EDITABLE_PROPERTY = "editable";
    private static final String SELECTED_INDEX_PROPERTY = "selectedIndex";
    private final JListDriver listDriver;
    private final JComboBoxDropDownListFinder dropDownListFinder;
    private JComboBoxCellReader cellReader;

    public JComboBoxDriver(@Nonnull Robot robot) {
        super(robot);
        this.listDriver = new JListDriver(robot);
        this.dropDownListFinder = new JComboBoxDropDownListFinder(robot);
        this.replaceCellReader(new BasicJComboBoxCellReader());
    }

    @Nonnull
    @RunsInEDT
    public String[] contentsOf(@Nonnull JComboBox<?> comboBox) {
        return JComboBoxContentQuery.contents(comboBox, this.cellReader());
    }

    @RunsInEDT
    public void selectItem(@Nonnull JComboBox<?> comboBox, @Nullable String value) {
        this.selectItem(comboBox, new StringTextMatcher(value));
    }

    @RunsInEDT
    public void selectItem(@Nonnull JComboBox<?> comboBox, @Nonnull Pattern pattern) {
        this.selectItem(comboBox, new PatternTextMatcher(pattern));
    }

    @RunsInEDT
    private void selectItem(@Nonnull JComboBox<?> comboBox, @Nonnull TextMatcher matcher) {
        int index = JComboBoxMatchingItemQuery.matchingItemIndex(comboBox, matcher, this.cellReader());
        if (index < 0) {
            String format = "Unable to find item matching %s among the JComboBox contents: ";
            String msg = String.format(format, matcher.description(), Arrays.format(this.contentsOf(comboBox)));
            throw new LocationUnavailableException(msg);
        }
        this.selectItem(comboBox, index);
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JComboBox<?> comboBox, @Nullable String value) {
        String selection = this.requiredSelectionOf(comboBox);
        ((TextAssert)TextAssert.verifyThat(selection).as(this.selectedIndexProperty(comboBox))).isEqualOrMatches(value);
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JComboBox<?> comboBox, @Nonnull Pattern pattern) {
        String selection = this.requiredSelectionOf(comboBox);
        ((TextAssert)TextAssert.verifyThat(selection).as(this.selectedIndexProperty(comboBox))).matches(pattern);
    }

    @Nullable
    @RunsInEDT
    private String requiredSelectionOf(@Nonnull JComboBox<?> comboBox) throws AssertionError {
        Pair<Boolean, String> selection = JComboBoxSelectionValueQuery.selection(comboBox, this.cellReader());
        boolean hasSelection = (Boolean)selection.first;
        if (!hasSelection) {
            this.failNoSelection(comboBox);
        }
        return (String)selection.second;
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JComboBox<?> comboBox, int index) {
        int selectedIndex = JComboBoxSelectedIndexQuery.selectedIndexOf(comboBox);
        if (selectedIndex == -1) {
            this.failNoSelection(comboBox);
        }
        ((AbstractIntegerAssert)Assertions.assertThat(selectedIndex).as(this.selectedIndexProperty(comboBox))).isEqualTo(index);
    }

    private void failNoSelection(@Nonnull JComboBox<?> comboBox) {
        Fail.fail(String.format("[%s] No selection", this.selectedIndexProperty(comboBox).value()));
    }

    @RunsInEDT
    public void requireNoSelection(@Nonnull JComboBox<?> comboBox) {
        Pair<Boolean, String> selection = JComboBoxSelectionValueQuery.selection(comboBox, this.cellReader());
        boolean hasSelection = (Boolean)selection.first;
        if (!hasSelection) {
            return;
        }
        String format = "[%s] Expecting no selection, but found:<%s>";
        Fail.fail(String.format(format, this.selectedIndexProperty(comboBox).value(), Strings.quote((String)selection.second)));
    }

    @Nullable
    public String value(@Nonnull JComboBox<?> comboBox, int index) {
        return JComboBoxDriver.valueAsText(comboBox, index, this.cellReader());
    }

    @Nullable
    @RunsInEDT
    private static String valueAsText(@Nonnull JComboBox<?> comboBox, int index, @Nonnull JComboBoxCellReader cellReader) {
        return GuiActionRunner.execute(() -> {
            JComboBoxItemIndexPreconditions.checkItemIndexInBounds(comboBox, index);
            return cellReader.valueAt(comboBox, index);
        });
    }

    @Nonnull
    private Description selectedIndexProperty(@Nonnull JComboBox<?> comboBox) {
        return JComboBoxDriver.propertyName(comboBox, SELECTED_INDEX_PROPERTY);
    }

    public void clearSelection(@Nonnull JComboBox<?> comboBox) {
        JComboBoxSetSelectedIndexTask.setSelectedIndex(comboBox, -1);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public void selectItem(@Nonnull JComboBox<?> comboBox, int index) {
        JComboBoxDriver.validateCanSelectItem(comboBox, index);
        this.showDropDownList(comboBox);
        this.selectItemAtIndex(comboBox, index);
        this.hideDropDownListIfVisible(comboBox);
    }

    @RunsInEDT
    private static void validateCanSelectItem(@Nonnull JComboBox<?> comboBox, int index) {
        GuiActionRunner.execute(() -> {
            ComponentPreconditions.checkEnabledAndShowing(comboBox);
            JComboBoxItemIndexPreconditions.checkItemIndexInBounds(comboBox, index);
        });
    }

    @VisibleForTesting
    @RunsInEDT
    void showDropDownList(@Nonnull JComboBox<?> comboBox) {
        this.dropDownVisibleThroughUIDelegate(comboBox, true);
    }

    @RunsInEDT
    private void selectItemAtIndex(@Nonnull JComboBox<?> comboBox, int index) {
        JList<?> dropDownList = this.dropDownListFinder.findDropDownList();
        if (dropDownList != null) {
            this.listDriver.selectItem(dropDownList, index);
            return;
        }
        JComboBoxSetSelectedIndexTask.setSelectedIndex(comboBox, index);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void hideDropDownListIfVisible(@Nonnull JComboBox<?> comboBox) {
        this.dropDownVisibleThroughUIDelegate(comboBox, false);
    }

    @RunsInEDT
    private void dropDownVisibleThroughUIDelegate(@Nonnull JComboBox<?> comboBox, boolean visible) {
        GuiActionRunner.execute(() -> comboBox.setPopupVisible(visible));
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public void deleteText(@Nonnull JComboBox<?> comboBox) {
        this.selectAllText(comboBox);
        Component editor2 = JComboBoxDriver.accessibleEditorOf(comboBox);
        if (!(editor2 instanceof JComponent)) {
            return;
        }
        this.invokeAction((JComponent)editor2, "delete-previous");
    }

    @RunsInEDT
    public void replaceText(@Nonnull JComboBox<?> comboBox, @Nonnull String text2) {
        Preconditions.checkNotNull(text2);
        if (text2.isEmpty()) {
            this.deleteText(comboBox);
        } else {
            this.selectAllText(comboBox);
            this.enterText(comboBox, text2);
        }
    }

    @RunsInEDT
    public void selectAllText(@Nonnull JComboBox<?> comboBox) {
        Component editor2 = JComboBoxDriver.accessibleEditorOf(comboBox);
        if (!(editor2 instanceof JComponent)) {
            return;
        }
        this.focus(editor2);
        this.invokeAction((JComponent)editor2, "select-all");
    }

    @Nullable
    @RunsInEDT
    private static Component accessibleEditorOf(@Nonnull JComboBox<?> comboBox) {
        return GuiActionRunner.execute(() -> {
            JComboBoxDriver.checkAccessibleEditor(comboBox);
            return JComboBoxDriver.editorComponentOf(comboBox);
        });
    }

    @RunsInEDT
    public void enterText(@Nonnull JComboBox<?> comboBox, @Nonnull String text2) {
        GuiActionRunner.execute(() -> JComboBoxDriver.checkAccessibleEditor(comboBox));
        Component editor2 = JComboBoxDriver.editorComponentOf(comboBox);
        if (editor2 == null) {
            throw ActionFailedException.actionFailure("JComboBox does not have an editor");
        }
        this.focusAndWaitForFocusGain(editor2);
        this.robot.enterText(text2);
    }

    @RunsInEDT
    public void pressAndReleaseKeys(@Nonnull JComboBox<?> comboBox, int ... keyCodes) {
        Preconditions.checkNotNull(keyCodes);
        JComboBoxDriver.checkInEdtEnabledAndShowing(comboBox);
        JComboBox<?> target = JComboBoxDriver.editorIfEditable(comboBox);
        if (target == null) {
            target = comboBox;
        }
        this.focusAndWaitForFocusGain(target);
        this.robot.pressAndReleaseKeys(keyCodes);
    }

    @RunsInEDT
    private static Component editorIfEditable(JComboBox<?> comboBox) {
        return GuiActionRunner.execute(() -> {
            if (!comboBox.isEditable()) {
                return null;
            }
            return JComboBoxDriver.editorComponent(comboBox);
        });
    }

    @RunsInCurrentThread
    private static void checkAccessibleEditor(@Nonnull JComboBox<?> comboBox) {
        ComponentPreconditions.checkEnabledAndShowing(comboBox);
        if (!comboBox.isEditable()) {
            String msg = String.format("Expecting component %s to be editable", Formatting.format(comboBox));
            throw new IllegalStateException(msg);
        }
    }

    @Nullable
    @RunsInEDT
    private static Component editorComponentOf(@Nonnull JComboBox<?> comboBox) {
        return GuiActionRunner.execute(() -> JComboBoxDriver.editorComponent(comboBox));
    }

    @Nullable
    @RunsInCurrentThread
    private static Component editorComponent(@Nonnull JComboBox<?> comboBox) {
        ComboBoxEditor editor2 = comboBox.getEditor();
        if (editor2 == null) {
            return null;
        }
        return editor2.getEditorComponent();
    }

    @Nonnull
    @RunsInEDT
    public JList<?> dropDownList() {
        JList<?> list = this.dropDownListFinder.findDropDownList();
        if (list == null) {
            throw new ComponentLookupException("Unable to find the pop-up list for the JComboBox");
        }
        return list;
    }

    @RunsInEDT
    public void requireEditable(@Nonnull JComboBox<?> comboBox) {
        this.checkEditable(comboBox, true);
    }

    @RunsInEDT
    public void requireNotEditable(@Nonnull JComboBox<?> comboBox) {
        this.checkEditable(comboBox, false);
    }

    @RunsInEDT
    private void checkEditable(@Nonnull JComboBox<?> comboBox, boolean expected) {
        ((AbstractBooleanAssert)Assertions.assertThat(JComboBoxEditableQuery.isEditable(comboBox)).as(JComboBoxDriver.editableProperty(comboBox))).isEqualTo(expected);
    }

    @RunsInEDT
    private static Description editableProperty(@Nonnull JComboBox<?> comboBox) {
        return JComboBoxDriver.propertyName(comboBox, EDITABLE_PROPERTY);
    }

    public void replaceCellReader(@Nonnull JComboBoxCellReader newCellReader) {
        this.cellReader = Preconditions.checkNotNull(newCellReader);
    }

    @RunsInEDT
    public void requireItemCount(@Nonnull JComboBox<?> comboBox, int expected) {
        int actual = JComboBoxItemCountQuery.itemCountIn(comboBox);
        ((AbstractIntegerAssert)Assertions.assertThat(actual).as(JComboBoxDriver.propertyName(comboBox, "itemCount"))).isEqualTo(expected);
    }

    @Nullable
    public String selectedItemOf(@Nonnull JComboBox<?> comboBox) {
        return (String)JComboBoxSelectionValueQuery.selection(comboBox, (JComboBoxCellReader)this.cellReader()).second;
    }

    @Nonnull
    private JComboBoxCellReader cellReader() {
        return this.cellReader;
    }
}

