/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.performancePlugin.commands.ExceptionWithTime;
import com.jetbrains.performancePlugin.commands.ListenerState;
import com.jetbrains.performancePlugin.commands.SimpleEditedDocumentsListener;
import com.jetbrains.performancePlugin.commands.WaitForFinishedCodeAnalysis;
import com.jetbrains.performancePlugin.commands.WaitForFinishedCodeAnalysisKt;
import java.awt.Component;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\b\u0007\u0018\u0000 *2\u00020\u0001:\u0002*+B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0015\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u001aJ!\u0010\u001b\u001a\u00020\u00152\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001e0\u001dH\u0000\u00a2\u0006\u0002\b\u001fJ\u0014\u0010 \u001a\u00020\u00152\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\"J\u0014\u0010#\u001a\u00020\u00152\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110%J\u0014\u0010&\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110%J\b\u0010(\u001a\u00020\u0015H\u0002J\u0006\u0010)\u001a\u00020\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/jetbrains/performancePlugin/commands/ListenerState;", "", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "highlightingFinishedEverywhere", "Ljava/util/concurrent/Semaphore;", "locked", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "sessions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/fileEditor/TextEditor;", "Lcom/jetbrains/performancePlugin/commands/ExceptionWithTime;", "stateLock", "ensureLockedIfNeeded", "", "printCodeAnalyzerStatistic", "editor", "Lcom/intellij/openapi/editor/Editor;", "printFileStatus", "printFileStatus$intellij_performanceTesting", "registerAnalysisFinished", "highlightedEditors", "", "Lcom/jetbrains/performancePlugin/commands/ListenerState$HighlightedEditor;", "registerAnalysisFinished$intellij_performanceTesting", "registerAnalysisStarted", "fileEditors", "", "registerEditedDocuments", "textEditors", "", "registerOpenedEditors", "openedEditors", "unlockIfNeeded", "waitAnalysisToFinish", "Companion", "HighlightedEditor", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nWaitForFinishedCodeAnalysis.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaitForFinishedCodeAnalysis.kt\ncom/jetbrains/performancePlugin/commands/ListenerState\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,405:1\n215#2,2:406\n1#3:408\n13#4:409\n*S KotlinDebug\n*F\n+ 1 WaitForFinishedCodeAnalysis.kt\ncom/jetbrains/performancePlugin/commands/ListenerState\n*L\n124#1:406,2\n90#1:409\n*E\n"})
public final class ListenerState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final Object stateLock;
    @NotNull
    private final ConcurrentHashMap<TextEditor, ExceptionWithTime> sessions;
    @NotNull
    private final Semaphore highlightingFinishedEverywhere;
    private boolean locked;
    @NotNull
    private static final Logger LOG;

    public ListenerState(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
        this.stateLock = new Object();
        this.sessions = new ConcurrentHashMap();
        this.highlightingFinishedEverywhere = new Semaphore(1);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getCs() {
        return this.cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ensureLockedIfNeeded() {
        Object object = this.stateLock;
        synchronized (object) {
            boolean bl = false;
            if (!this.sessions.isEmpty() && !this.locked) {
                Set set = this.sessions.keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
                LOG.info("Highlighting began with " + CollectionsKt.joinToString$default((Iterable)set, (CharSequence)",\n", null, null, (int)0, null, (Function1)ensureLockedIfNeeded.1.1.INSTANCE, (int)30, null));
                this.highlightingFinishedEverywhere.acquire();
                this.locked = true;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unlockIfNeeded() {
        Object object = this.stateLock;
        synchronized (object) {
            boolean bl = false;
            if (!this.locked) {
                return;
            }
            if (this.sessions.isEmpty()) {
                LOG.info("Highlighting done");
                LOG.info("Total opening time is : " + Duration.ofNanos(System.nanoTime() - StartUpMeasurer.getStartTime()).toMillis());
                this.highlightingFinishedEverywhere.release();
                this.locked = false;
            } else {
                Map $this$forEach$iv = this.sessions;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    Editor editor2 = ((TextEditor)it.getKey()).getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                    this.printCodeAnalyzerStatistic(editor2);
                    Editor editor3 = ((TextEditor)it.getKey()).getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"getEditor(...)");
                    this.printFileStatus$intellij_performanceTesting(editor3);
                }
                Set set = this.sessions.keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
                LOG.info("Highlighting still in progress: " + CollectionsKt.joinToString$default((Iterable)set, (CharSequence)",\n", null, null, (int)0, null, (Function1)unlockIfNeeded.1.2.INSTANCE, (int)30, null));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void waitAnalysisToFinish() {
        LOG.info("Waiting for code analysis to finish");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
        if (((ApplicationEx)application).isLightEditMode()) {
            return;
        }
        long timeout = 5L;
        if (this.highlightingFinishedEverywhere.tryAcquire(timeout, TimeUnit.MINUTES)) {
            this.highlightingFinishedEverywhere.release();
        } else {
            LOG.error("Waiting for highlight to finish took more than " + timeout + " minutes.");
        }
        LOG.info("Code analysis finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerOpenedEditors(@NotNull List<? extends TextEditor> openedEditors) {
        Intrinsics.checkNotNullParameter(openedEditors, (String)"openedEditors");
        SimpleEditedDocumentsListener listener = new SimpleEditedDocumentsListener(this.project);
        Object object = this.stateLock;
        synchronized (object) {
            boolean bl = false;
            for (TextEditor fileEditor : WaitForFinishedCodeAnalysisKt.access$getWorthy(openedEditors)) {
                ((Map)this.sessions).put(fileEditor, ExceptionWithTime.Companion.createForOpenedEditor(fileEditor));
                fileEditor.getEditor().getDocument().addDocumentListener((DocumentListener)listener, (Disposable)fileEditor);
            }
            this.ensureLockedIfNeeded();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerEditedDocuments(@NotNull List<? extends TextEditor> textEditors) {
        Intrinsics.checkNotNullParameter(textEditors, (String)"textEditors");
        Object object = this.stateLock;
        synchronized (object) {
            boolean bl = false;
            for (TextEditor fileEditor : WaitForFinishedCodeAnalysisKt.access$getWorthy(textEditors)) {
                ((Map)this.sessions).put(fileEditor, ExceptionWithTime.Companion.createForEditedEditor(fileEditor));
            }
            this.ensureLockedIfNeeded();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerAnalysisStarted(@NotNull Collection<? extends TextEditor> fileEditors) {
        Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
        List errors = new ArrayList();
        boolean isStartedInDumbMode2 = (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ ListenerState this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return DumbService.Companion.isDumb(this.this$0.getProject());
            }
        }));
        Object object = this.stateLock;
        synchronized (object) {
            boolean bl = false;
            for (TextEditor textEditor : fileEditors) {
                AssertionError it;
                LOG.info("daemon starting for " + WaitForFinishedCodeAnalysisKt.access$getDescription((FileEditor)textEditor));
                ExceptionWithTime previousSessionStartTrace = this.sessions.put(textEditor, ExceptionWithTime.Companion.createForAnalysisStart(textEditor, isStartedInDumbMode2));
                if (ExceptionWithTime.Companion.createIntersectionErrorIfNeeded((FileEditor)textEditor, previousSessionStartTrace) == null) continue;
                boolean bl2 = false;
                errors.add(it);
            }
            this.ensureLockedIfNeeded();
            Unit unit = Unit.INSTANCE;
        }
        if (errors.isEmpty()) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<AssertionError>)errors, null){
            int label;
            final /* synthetic */ List<AssertionError> $errors;
            {
                this.$errors = $errors;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Iterable $this$forEach$iv = this.$errors;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            AssertionError it = (AssertionError)element$iv;
                            boolean bl = false;
                            ListenerState.Companion.getLOG().error((Throwable)((Object)it));
                            Throwable[] throwableArray = ((Throwable)((Object)it)).getSuppressed();
                            Intrinsics.checkNotNullExpressionValue((Object)throwableArray, (String)"getSuppressed(...)");
                            Object[] $this$forEach$iv2 = throwableArray;
                            boolean $i$f$forEach2 = false;
                            for (Object element$iv2 : $this$forEach$iv2) {
                                Throwable suppressed = (Throwable)element$iv2;
                                boolean bl2 = false;
                                ListenerState.Companion.getLOG().error("   Suppressed exception: ", suppressed);
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerAnalysisFinished$intellij_performanceTesting(@NotNull Map<TextEditor, ? extends HighlightedEditor> highlightedEditors2) {
        Intrinsics.checkNotNullParameter(highlightedEditors2, (String)"highlightedEditors");
        long currentTime = System.currentTimeMillis();
        Object object = this.stateLock;
        synchronized (object) {
            boolean bl = false;
            Iterator<Map.Entry<TextEditor, ExceptionWithTime>> iterator2 = this.sessions.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<TextEditor, ExceptionWithTime> entry = iterator2.next();
                Intrinsics.checkNotNull(entry);
                TextEditor editor2 = entry.getKey();
                ExceptionWithTime exceptionWithTime = entry.getValue();
                HighlightedEditor highlightedEditor = highlightedEditors2.get(editor2);
                if (highlightedEditor == null) {
                    if (UIUtil.isShowing((Component)editor2.getComponent())) continue;
                    iterator2.remove();
                    continue;
                }
                boolean shouldWait = highlightedEditor.getShouldWaitForNextHighlighting() || exceptionWithTime.getWasStartedInLimitedSetup();
                LOG.info("daemon stopped for " + WaitForFinishedCodeAnalysisKt.access$getDescription((FileEditor)highlightedEditor.getEditor()) + ", shouldWaitForHighlighting=" + shouldWait + ", editor.shouldWaitForNextHighlighting=" + highlightedEditor.getShouldWaitForNextHighlighting());
                if (shouldWait) {
                    ExceptionWithTime.Companion.markAnalysisFinished(exceptionWithTime);
                    continue;
                }
                iterator2.remove();
                LOG.info(ExceptionWithTime.Companion.getLogHighlightingMessage(currentTime, highlightedEditor.getEditor(), exceptionWithTime));
            }
            this.unlockIfNeeded();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void printCodeAnalyzerStatistic(Editor editor2) {
        try {
            ReadAction.run(() -> ListenerState.printCodeAnalyzerStatistic$lambda$8(editor2, this));
        }
        catch (Throwable throwable) {
            LOG.warn("Print Analyzer status failed");
        }
    }

    public final void printFileStatus$intellij_performanceTesting(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        try {
            DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzerImpl.getInstance((Project)this.project);
            Intrinsics.checkNotNull((Object)daemonCodeAnalyzer, (String)"null cannot be cast to non-null type com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl");
            String fileStatus = ((DaemonCodeAnalyzerImpl)daemonCodeAnalyzer).getFileStatusMap().toString(editor2.getDocument());
            LOG.info("File status map " + fileStatus);
        }
        catch (Throwable throwable) {
            LOG.warn("Print Analyzer status map failed");
        }
    }

    private static final void printCodeAnalyzerStatistic$lambda$8(Editor $editor, ListenerState this$0) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        LOG.info("Analyzer status for " + $editor.getVirtualFile().getPath() + "\n " + new TrafficLightRenderer(this$0.project, $editor.getDocument()).getDaemonCodeAnalyzerStatus());
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WaitForFinishedCodeAnalysis.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/performancePlugin/commands/ListenerState$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\bf\u0018\u0000 \n2\u00020\u0001:\u0004\n\u000b\f\rR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/performancePlugin/commands/ListenerState$HighlightedEditor;", "", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "getEditor", "()Lcom/intellij/openapi/fileEditor/TextEditor;", "shouldWaitForNextHighlighting", "", "getShouldWaitForNextHighlighting", "()Z", "Companion", "IncompletelyHighlightedEditor", "InvisibleEditor", "VisibleEditor", "intellij.performanceTesting"})
    public static interface HighlightedEditor {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @NotNull
        public TextEditor getEditor();

        public boolean getShouldWaitForNextHighlighting();

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/performancePlugin/commands/ListenerState$HighlightedEditor$Companion;", "", "()V", "create", "Lcom/jetbrains/performancePlugin/commands/ListenerState$HighlightedEditor;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "project", "Lcom/intellij/openapi/project/Project;", "isCancelled", "", "isFinishedInDumbMode", "intellij.performanceTesting"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            @RequiresReadLock
            @NotNull
            public final HighlightedEditor create(@NotNull TextEditor editor2, @NotNull Project project, boolean isCancelled, boolean isFinishedInDumbMode) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (!UIUtil.isShowing((Component)editor2.getComponent())) {
                    ListenerState.Companion.getLOG().info("Invisible editor " + WaitForFinishedCodeAnalysisKt.access$getDescription((FileEditor)editor2));
                    return new InvisibleEditor(editor2);
                }
                if (isFinishedInDumbMode || isCancelled) {
                    ListenerState.Companion.getLOG().info("Unfinished editor isFinishedInDumbMode=" + isFinishedInDumbMode + ", isCancelled=" + isCancelled + " " + WaitForFinishedCodeAnalysisKt.access$getDescription((FileEditor)editor2));
                    return new IncompletelyHighlightedEditor(editor2);
                }
                boolean isHighlighted = DaemonCodeAnalyzerImpl.isHighlightingCompleted((FileEditor)((FileEditor)editor2), (Project)project);
                ListenerState.Companion.getLOG().info("Visible editor " + WaitForFinishedCodeAnalysisKt.access$getDescription((FileEditor)editor2) + "\nisHighlighted " + isHighlighted);
                return new VisibleEditor(editor2, isHighlighted);
            }

            static {
                $$INSTANCE = new Companion();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/performancePlugin/commands/ListenerState$HighlightedEditor$IncompletelyHighlightedEditor;", "Lcom/jetbrains/performancePlugin/commands/ListenerState$HighlightedEditor;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "(Lcom/intellij/openapi/fileEditor/TextEditor;)V", "getEditor", "()Lcom/intellij/openapi/fileEditor/TextEditor;", "shouldWaitForNextHighlighting", "", "getShouldWaitForNextHighlighting", "()Z", "intellij.performanceTesting"})
        private static final class IncompletelyHighlightedEditor
        implements HighlightedEditor {
            @NotNull
            private final TextEditor editor;

            public IncompletelyHighlightedEditor(@NotNull TextEditor editor2) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                this.editor = editor2;
            }

            @Override
            @NotNull
            public TextEditor getEditor() {
                return this.editor;
            }

            @Override
            public boolean getShouldWaitForNextHighlighting() {
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/performancePlugin/commands/ListenerState$HighlightedEditor$InvisibleEditor;", "Lcom/jetbrains/performancePlugin/commands/ListenerState$HighlightedEditor;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "(Lcom/intellij/openapi/fileEditor/TextEditor;)V", "getEditor", "()Lcom/intellij/openapi/fileEditor/TextEditor;", "shouldWaitForNextHighlighting", "", "getShouldWaitForNextHighlighting", "()Z", "intellij.performanceTesting"})
        private static final class InvisibleEditor
        implements HighlightedEditor {
            @NotNull
            private final TextEditor editor;

            public InvisibleEditor(@NotNull TextEditor editor2) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                this.editor = editor2;
            }

            @Override
            @NotNull
            public TextEditor getEditor() {
                return this.editor;
            }

            @Override
            public boolean getShouldWaitForNextHighlighting() {
                return false;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/performancePlugin/commands/ListenerState$HighlightedEditor$VisibleEditor;", "Lcom/jetbrains/performancePlugin/commands/ListenerState$HighlightedEditor;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "isHighlighted", "", "(Lcom/intellij/openapi/fileEditor/TextEditor;Z)V", "getEditor", "()Lcom/intellij/openapi/fileEditor/TextEditor;", "shouldWaitForNextHighlighting", "getShouldWaitForNextHighlighting", "()Z", "intellij.performanceTesting"})
        private static final class VisibleEditor
        implements HighlightedEditor {
            @NotNull
            private final TextEditor editor;
            private final boolean isHighlighted;

            public VisibleEditor(@NotNull TextEditor editor2, boolean isHighlighted) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                this.editor = editor2;
                this.isHighlighted = isHighlighted;
            }

            @Override
            @NotNull
            public TextEditor getEditor() {
                return this.editor;
            }

            @Override
            public boolean getShouldWaitForNextHighlighting() {
                return !this.isHighlighted;
            }
        }
    }
}

