/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.PlaybackCommandCoroutineAdapter;
import com.jetbrains.performancePlugin.commands.FindUsagesDumper;
import com.jetbrains.performancePlugin.utils.DataDumper;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0094@\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/performancePlugin/commands/AssertFindUsagesCommand;", "Lcom/intellij/openapi/ui/playback/commands/PlaybackCommandCoroutineAdapter;", "text", "", "line", "", "(Ljava/lang/String;I)V", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nAssertFindUsagesCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssertFindUsagesCommand.kt\ncom/jetbrains/performancePlugin/commands/AssertFindUsagesCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n819#2:34\n847#2,2:35\n*S KotlinDebug\n*F\n+ 1 AssertFindUsagesCommand.kt\ncom/jetbrains/performancePlugin/commands/AssertFindUsagesCommand\n*L\n22#1:34\n22#1:35,2\n*E\n"})
public final class AssertFindUsagesCommand
extends PlaybackCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%assertFindUsagesCommand";

    public AssertFindUsagesCommand(@NotNull String text2, int line) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(text2, line);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context, @NotNull Continuation<? super Unit> $completion) {
        void $this$filterNotTo$iv$iv;
        Path lastUsageReport = FindUsagesDumper.getFoundUsagesJsonPath();
        if (lastUsageReport == null) {
            throw new IllegalStateException("Find usages report is null");
        }
        if (!Files.exists(lastUsageReport, new LinkOption[0]) || !Files.isRegularFile(lastUsageReport, new LinkOption[0])) {
            throw new IllegalStateException("Find usages report file not exists " + lastUsageReport);
        }
        String[] stringArray = new String[]{" "};
        Iterable $this$filterNot$iv = StringsKt.split$default((CharSequence)this.extractCommandArgument(PREFIX), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)it)).toString(), (Object)"")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List args = (List)destination$iv$iv;
        if (args.isEmpty()) {
            throw new IllegalStateException("Provide expected count of usages");
        }
        FindUsagesDumper.FoundUsagesReport foundUsagesReport = DataDumper.read(lastUsageReport, FindUsagesDumper.FoundUsagesReport.class);
        Intrinsics.checkNotNullExpressionValue((Object)foundUsagesReport, (String)"read(...)");
        FindUsagesDumper.FoundUsagesReport data = foundUsagesReport;
        int expected = Integer.parseInt((String)args.get(0));
        if (data.totalNumberOfUsages != expected) {
            throw new IllegalStateException("Expected " + expected + " find usages, but got " + data.totalNumberOfUsages);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/performancePlugin/commands/AssertFindUsagesCommand$Companion;", "", "()V", "PREFIX", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

