/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webpack.jsonschema;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.json.JSJsonSchemaProviderBase;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.webpack.WebpackConfigHighlightingInspection;
import com.intellij.webpack.WebpackUtil;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebpackInJavaScriptJsonSchemaProvider
extends JSJsonSchemaProviderBase {
    @NotNull
    private final WebpackUtil.WebpackVersion myVersion;

    @Nullable
    private static VirtualFile getWebpackSchemaFile(@NotNull WebpackUtil.WebpackVersion version) {
        if (version == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(0);
        }
        if (WebpackUtil.WebpackVersion.LIKE2.equals((Object)version)) {
            return WebpackInJavaScriptJsonSchemaProvider.loadFile(WebpackInJavaScriptJsonSchemaProvider.class, (String)"/jsonSchemas/webpack-schema.json");
        }
        if (WebpackUtil.WebpackVersion.LIKE4.equals((Object)version)) {
            return WebpackInJavaScriptJsonSchemaProvider.loadFile(WebpackInJavaScriptJsonSchemaProvider.class, (String)"/jsonSchemas/webpack-schema4.json");
        }
        return null;
    }

    public WebpackInJavaScriptJsonSchemaProvider(@NotNull WebpackUtil.WebpackVersion version) {
        if (version == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(1);
        }
        this.myVersion = version;
    }

    public VirtualFile getSchemaFile() {
        return WebpackInJavaScriptJsonSchemaProvider.getWebpackSchemaFile(this.myVersion);
    }

    public boolean isAvailable(@NotNull PsiElement element) {
        if (element == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(2);
        }
        return WebpackInJavaScriptJsonSchemaProvider.isWebpackInspectionAllowed(element) && WebpackInJavaScriptJsonSchemaProvider.isApplicable(element) && this.myVersion.equals((Object)WebpackUtil.getWebpackVersion(element.getProject()));
    }

    static boolean isAvailableForFile(@NotNull PsiFile file) {
        if (file == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(3);
        }
        if (!Registry.is((String)"JavaScript.WebPack.With.JsonSchema", (boolean)true)) {
            return false;
        }
        String fileName = file.getName();
        FileType fileType = file.getFileType();
        return WebpackInJavaScriptJsonSchemaProvider.isWebpackFile(fileName, fileType);
    }

    static boolean isWebpackFile(String fileName, @NotNull FileType fileType) {
        if (fileType == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(4);
        }
        return StringUtil.containsIgnoreCase((String)fileName, (String)"webpack") && DialectDetector.JAVASCRIPT_FILE_TYPES.contains(fileType);
    }

    @Nullable
    public static VirtualFile getSchemaIfApplicable(@NotNull PsiElement element) {
        if (element == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(5);
        }
        if (!WebpackInJavaScriptJsonSchemaProvider.isApplicable(element)) {
            return null;
        }
        WebpackUtil.WebpackVersion version = WebpackUtil.getWebpackVersion(element.getProject());
        return WebpackInJavaScriptJsonSchemaProvider.getWebpackSchemaFile(version);
    }

    protected static boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(6);
        }
        return element.getContainingFile() != null && WebpackInJavaScriptJsonSchemaProvider.isAvailableForFile(element.getContainingFile()) && WebpackInJavaScriptJsonSchemaProvider.isInSupportedArea((PsiElement)element, WebpackInJavaScriptJsonSchemaProvider::getModuleExportsParts) && WebpackInJavaScriptJsonSchemaProvider.isInTopLevelObject((PsiElement)element);
    }

    static boolean isWebpackInspectionAllowed(@NotNull PsiElement element) {
        if (element == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(7);
        }
        if (element.getContainingFile() == null) {
            return false;
        }
        InspectionProfileImpl profile = InspectionProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        String name = InspectionProfileEntry.getShortName((String)WebpackConfigHighlightingInspection.class.getSimpleName());
        InspectionToolWrapper tool = profile.getInspectionTool(name, element.getProject());
        return profile.isToolEnabled(HighlightDisplayKey.find((String)name), element) && tool != null && !tool.getTool().isSuppressedFor(element);
    }

    @NotNull
    static List<TextRange> getModuleExportsParts(@NotNull PsiFile file) {
        if (file == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(8);
        }
        List list = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)file).forceIgnore(Conditions.instanceOf(JSFunction.class))).filter(Conditions.instanceOf((Class[])new Class[]{JSAssignmentExpression.class, JSVariable.class}))).traverse().map(WebpackInJavaScriptJsonSchemaProvider::getInitializer).flatten(WebpackInJavaScriptJsonSchemaProvider::collectFromInitializer).map(PsiElement::getTextRange).sort(Comparator.comparingInt(TextRange::getStartOffset)).toList();
        if (list == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    private static JSExpression getInitializer(PsiElement element) {
        if (element instanceof JSAssignmentExpression) {
            return WebpackInJavaScriptJsonSchemaProvider.getModuleExportsAssignmentInitializer((JSAssignmentExpression)((JSAssignmentExpression)element));
        }
        if (element instanceof JSVariable && "webpackConfig".equalsIgnoreCase(((JSVariable)element).getName())) {
            return ((JSVariable)element).getInitializer();
        }
        return null;
    }

    @NotNull
    private static JBIterable<JSExpression> collectFromInitializer(@Nullable JSExpression initializer) {
        if (initializer instanceof JSFunction) {
            JBIterable jBIterable = WebpackInJavaScriptJsonSchemaProvider.computeInitializersFromFunction((JSFunction)((JSFunction)initializer)).flatten(e -> WebpackInJavaScriptJsonSchemaProvider.getConfigOrConfigArray(e));
            if (jBIterable == null) {
                WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(10);
            }
            return jBIterable;
        }
        return WebpackInJavaScriptJsonSchemaProvider.getConfigOrConfigArray(WebpackInJavaScriptJsonSchemaProvider.computeDefaultInitializer((JSExpression)initializer));
    }

    @NotNull
    private static JBIterable<JSExpression> getConfigOrConfigArray(@Nullable JSExpression expression) {
        if ((expression = JSUtils.unparenthesize((JSExpression)expression)) instanceof JSObjectLiteralExpression || expression instanceof JSArrayLiteralExpression) {
            JBIterable jBIterable = JBIterable.of((Object)expression);
            if (jBIterable == null) {
                WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(11);
            }
            return jBIterable;
        }
        if (expression instanceof JSNewExpression) {
            return WebpackInJavaScriptJsonSchemaProvider.getFromPromise((JSNewExpression)expression);
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(12);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<JSExpression> getFromPromise(@NotNull JSNewExpression expression) {
        JSParameterListElement firstParameter;
        JSBlockStatement block;
        JSExpression methodExpression;
        if (expression == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(13);
        }
        if (!JSSymbolUtil.isAccurateReferenceExpressionName((JSExpression)(methodExpression = expression.getMethodExpression()), (String)"Promise")) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(14);
            }
            return jBIterable;
        }
        JSExpression[] arguments = expression.getArguments();
        if (arguments.length == 0) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(15);
            }
            return jBIterable;
        }
        JSExpression first = arguments[0];
        if (first instanceof JSFunctionExpression && (block = ((JSFunctionExpression)first).getBlock()) != null && (firstParameter = (JSParameterListElement)ArrayUtil.getFirstElement((Object[])((JSFunctionExpression)first).getParameters())) instanceof JSParameter) {
            JBIterable jBIterable = SyntaxTraverser.psiTraverser((PsiElement)block).filter(JSCallExpression.class).filter(e -> WebpackInJavaScriptJsonSchemaProvider.isReferenceToParameter(e.getMethodExpression(), (JSParameter)firstParameter)).flatten(e -> JBIterable.of((Object[])e.getArguments())).take(1).filter(Conditions.instanceOf(JSObjectLiteralExpression.class));
            if (jBIterable == null) {
                WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(16);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(17);
        }
        return jBIterable;
    }

    @Contract(value="null, _ -> false")
    private static boolean isReferenceToParameter(@Nullable JSExpression expression, @NotNull JSParameter element) {
        if (element == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(18);
        }
        return expression instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSExpression)expression, (String)element.getName()) && ((JSReferenceExpression)expression).resolve() == element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11, 12, 14, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webpack/jsonschema/WebpackInJavaScriptJsonSchemaProvider";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webpack/jsonschema/WebpackInJavaScriptJsonSchemaProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleExportsParts";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFromInitializer";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigOrConfigArray";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromPromise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getWebpackSchemaFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isWebpackFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaIfApplicable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isWebpackInspectionAllowed";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getModuleExportsParts";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFromPromise";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceToParameter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11, 12, 14, 15, 16, 17 -> new IllegalStateException(string);
        };
    }
}

