/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh.deploy;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.EnvironmentUtil;
import com.jetbrains.gateway.ssh.AvailableIde;
import com.jetbrains.gateway.ssh.CachingProductsJsonWrapper;
import com.jetbrains.gateway.ssh.DeployTargetOS;
import com.jetbrains.gateway.ssh.Download;
import com.jetbrains.gateway.ssh.HighLevelHostAccessor;
import com.jetbrains.gateway.ssh.HostDeployInputs;
import com.jetbrains.gateway.ssh.IdeInfo;
import com.jetbrains.gateway.ssh.IntelliJPlatformProduct;
import com.jetbrains.gateway.ssh.deploy.DeployTargetInfo;
import com.jetbrains.gateway.ssh.util.IdeInstallDir;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u000b2\u00020\u0001:\u0006\u000b\f\r\u000e\u000f\u0010B\u0011\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010\n\u001a\u00020\tH\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo;", "", "ideInfo", "Lcom/jetbrains/gateway/ssh/IdeInfo;", "(Lcom/jetbrains/gateway/ssh/IdeInfo;)V", "getIdeInfo", "()Lcom/jetbrains/gateway/ssh/IdeInfo;", "getGtwLinkParameters", "", "", "toString", "Companion", "DeployBase", "DeployFromLocalFile", "DeployOptions", "DeployWithDownload", "NoDeploy", "Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo$DeployBase;", "Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo$NoDeploy;", "intellij.gateway.core"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nDeployTargetInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeployTargetInfo.kt\ncom/jetbrains/gateway/ssh/deploy/DeployTargetInfo\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,151:1\n13#2:152\n*S KotlinDebug\n*F\n+ 1 DeployTargetInfo.kt\ncom/jetbrains/gateway/ssh/deploy/DeployTargetInfo\n*L\n80#1:152\n*E\n"})
public abstract class DeployTargetInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final IdeInfo ideInfo;
    @NotNull
    private static final Logger logger;

    private DeployTargetInfo(IdeInfo ideInfo) {
        this.ideInfo = ideInfo;
    }

    @Nullable
    public IdeInfo getIdeInfo() {
        return this.ideInfo;
    }

    @NotNull
    public Map<String, String> getGtwLinkParameters() {
        Object object;
        block3: {
            block2: {
                object = this.getIdeInfo();
                if (object == null) break block2;
                IdeInfo it = object;
                boolean bl = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"buildNumber", (Object)it.getBuildNumber()), TuplesKt.to((Object)"productCode", (Object)it.getProduct().getProductCode())};
                Map map = MapsKt.mutableMapOf((Pair[])pairArray);
                object = map;
                if (map != null) break block3;
            }
            object = MapsKt.emptyMap();
        }
        return object;
    }

    @NotNull
    public String toString() {
        Map<String, String> params = this.getGtwLinkParameters();
        Iterable iterable = params.entrySet();
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return CollectionsKt.joinToString$default((Iterable)iterable, null, (CharSequence)string, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)29, null);
    }

    public /* synthetic */ DeployTargetInfo(IdeInfo ideInfo, DefaultConstructorMarker $constructor_marker) {
        this(ideInfo);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DeployTargetInfo.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DeployTargetInfo.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "fromGtwLinkParameters", "Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo;", "parameters", "", "", "allowLocalPaths", "", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DeployTargetInfo fromGtwLinkParameters(@NotNull Map<String, String> parameters, boolean allowLocalPaths) {
            IdeInstallDir ideInstallDir;
            boolean deploy2;
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            String buildNumber = parameters.get("buildNumber");
            String productCode = parameters.get("productCode");
            DeployOptions deployOptions = new DeployOptions(parameters.get("heapSize"), null, 2, null);
            CharSequence charSequence = buildNumber;
            IntelliJPlatformProduct product = charSequence == null || charSequence.length() == 0 || (charSequence = (CharSequence)productCode) == null || charSequence.length() == 0 ? null : IntelliJPlatformProduct.Companion.fromProductCode(productCode);
            IdeInfo ide = product != null && buildNumber != null ? new IdeInfo(product, buildNumber) : null;
            boolean bl = deploy2 = !Intrinsics.areEqual((Object)parameters.get("deploy"), (Object)"false");
            if (!deploy2) {
                String pathToIde = parameters.get("idePath");
                CharSequence charSequence2 = pathToIde;
                if (charSequence2 == null || charSequence2.length() == 0) {
                    logger.info("Link requests no deploy, but does not provide path to IDE; ignoring");
                    return null;
                }
                return new NoDeploy(pathToIde, ide);
            }
            CharSequence charSequence3 = parameters.get("downloadLocation");
            if (!(charSequence3 == null || StringsKt.isBlank((CharSequence)charSequence3))) {
                String string = parameters.get("downloadLocation");
                Intrinsics.checkNotNull((Object)string);
                ideInstallDir = IdeInstallDir.Companion.fromJson(string);
            } else {
                ideInstallDir = null;
            }
            IdeInstallDir downloadLocation = ideInstallDir;
            String sourceUrl = parameters.get("sourceUrl");
            if (sourceUrl != null) {
                URI uRI = URI.create(sourceUrl);
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
                return new DeployWithDownload(uRI, downloadLocation, ide, deployOptions);
            }
            String localPath = parameters.get("localUploadPath");
            if (localPath != null) {
                boolean forceAllowPath;
                String urlToken = parameters.get("runFromIdeToken");
                String envVar = EnvironmentUtil.getValue((String)"GTW_FROM_IDE_TOKEN");
                CharSequence charSequence4 = urlToken;
                boolean bl2 = !(charSequence4 == null || StringsKt.isBlank((CharSequence)charSequence4)) && !((charSequence4 = (CharSequence)envVar) == null || StringsKt.isBlank((CharSequence)charSequence4)) && Intrinsics.areEqual((Object)urlToken, (Object)envVar) ? true : (forceAllowPath = false);
                if (!allowLocalPaths && !forceAllowPath) {
                    logger.info("Link requests a local path (" + localPath + ") when it's not allowed by policy, ignoring");
                    return null;
                }
                Path path = Path.of(localPath, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                return new DeployFromLocalFile(path, downloadLocation, deployOptions);
            }
            String it = parameters.get("download");
            boolean bl3 = false;
            CharSequence charSequence5 = it;
            Download download = charSequence5 == null || StringsKt.isBlank((CharSequence)charSequence5) ? null : Download.Companion.fromJson(it);
            if (download != null) {
                logger.info("Link contains legacy 'download' parameter; support for this will be dropped eventually");
                if (StringsKt.startsWith$default((String)download.getLink(), (String)"https://", (boolean)false, (int)2, null)) {
                    URI uRI = URI.create(download.getLink());
                    Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
                    return new DeployWithDownload(uRI, downloadLocation, ide, deployOptions);
                }
                logger.info("Download link doesn't point to an HTTPS URL, ignoring");
            }
            if (ide == null) {
                logger.info("No IDE specified in URL and no direct link or path, ignoring");
                return null;
            }
            AvailableIde downloadInfo = CachingProductsJsonWrapper.Companion.getInstance().getDownloadForIde(ide.getProduct(), new DeployTargetOS(DeployTargetOS.OSKind.Linux, DeployTargetOS.OSArch.X86_64), ide.getBuildNumber());
            if (downloadInfo == null) {
                logger.info("No download info available for IDE " + ide.getProduct() + " " + ide.getBuildNumber());
                return null;
            }
            URI uRI = URI.create(downloadInfo.getDownload().getLink());
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
            return new DeployWithDownload(uRI, downloadLocation, ide, deployOptions);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fRF\u0010\r\u001a,\b\u0001\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0019\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo$DeployBase;", "Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo;", "installDir", "Lcom/jetbrains/gateway/ssh/util/IdeInstallDir;", "ideInfo", "Lcom/jetbrains/gateway/ssh/IdeInfo;", "(Lcom/jetbrains/gateway/ssh/util/IdeInstallDir;Lcom/jetbrains/gateway/ssh/IdeInfo;)V", "deployOptions", "Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo$DeployOptions;", "getDeployOptions", "()Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo$DeployOptions;", "getInstallDir", "()Lcom/jetbrains/gateway/ssh/util/IdeInstallDir;", "postDeployCallback", "Lkotlin/Function4;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Lcom/jetbrains/gateway/ssh/HighLevelHostAccessor;", "Lcom/jetbrains/gateway/ssh/HostDeployInputs$FullySpecified;", "Lkotlin/coroutines/Continuation;", "", "", "getPostDeployCallback", "()Lkotlin/jvm/functions/Function4;", "setPostDeployCallback", "(Lkotlin/jvm/functions/Function4;)V", "Lkotlin/jvm/functions/Function4;", "getGtwLinkParameters", "", "", "intellij.gateway.core"})
    @SourceDebugExtension(value={"SMAP\nDeployTargetInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeployTargetInfo.kt\ncom/jetbrains/gateway/ssh/deploy/DeployTargetInfo$DeployBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1#2:152\n*E\n"})
    public static abstract class DeployBase
    extends DeployTargetInfo {
        @Nullable
        private final IdeInstallDir installDir;
        @Nullable
        private final DeployOptions deployOptions;
        @Nullable
        private Function4<? super ProgressIndicator, ? super HighLevelHostAccessor, ? super HostDeployInputs.FullySpecified, ? super Continuation<? super Unit>, ? extends Object> postDeployCallback;

        public DeployBase(@Nullable IdeInstallDir installDir, @Nullable IdeInfo ideInfo) {
            super(ideInfo, null);
            this.installDir = installDir;
        }

        @Nullable
        public final IdeInstallDir getInstallDir() {
            return this.installDir;
        }

        @Override
        @NotNull
        public Map<String, String> getGtwLinkParameters() {
            Object object;
            Map<String, String> map;
            block3: {
                block2: {
                    map = super.getGtwLinkParameters();
                    object = this.installDir;
                    if (object == null) break block2;
                    IdeInstallDir it = object;
                    Map<String, String> map2 = map;
                    boolean bl = false;
                    Map map3 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"downloadLocation", (Object)it.toJson()));
                    map = map2;
                    object = map3;
                    if (map3 != null) break block3;
                }
                object = MapsKt.emptyMap();
            }
            return MapsKt.plus(map, (Map)object);
        }

        @Nullable
        public DeployOptions getDeployOptions() {
            return this.deployOptions;
        }

        @Nullable
        public final Function4<ProgressIndicator, HighLevelHostAccessor, HostDeployInputs.FullySpecified, Continuation<? super Unit>, Object> getPostDeployCallback() {
            return this.postDeployCallback;
        }

        public final void setPostDeployCallback(@Nullable Function4<? super ProgressIndicator, ? super HighLevelHostAccessor, ? super HostDeployInputs.FullySpecified, ? super Continuation<? super Unit>, ? extends Object> function4) {
            this.postDeployCallback = function4;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo$DeployFromLocalFile;", "Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo$DeployBase;", "localFile", "Ljava/nio/file/Path;", "installDir", "Lcom/jetbrains/gateway/ssh/util/IdeInstallDir;", "deployOptions", "Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo$DeployOptions;", "(Ljava/nio/file/Path;Lcom/jetbrains/gateway/ssh/util/IdeInstallDir;Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo$DeployOptions;)V", "getDeployOptions", "()Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo$DeployOptions;", "getLocalFile", "()Ljava/nio/file/Path;", "getGtwLinkParameters", "", "", "intellij.gateway.core"})
    public static final class DeployFromLocalFile
    extends DeployBase {
        @NotNull
        private final Path localFile;
        @Nullable
        private final DeployOptions deployOptions;

        @JvmOverloads
        public DeployFromLocalFile(@NotNull Path localFile, @Nullable IdeInstallDir installDir, @Nullable DeployOptions deployOptions) {
            Intrinsics.checkNotNullParameter((Object)localFile, (String)"localFile");
            super(installDir, null);
            this.localFile = localFile;
            this.deployOptions = deployOptions;
        }

        public /* synthetic */ DeployFromLocalFile(Path path, IdeInstallDir ideInstallDir, DeployOptions deployOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                deployOptions = null;
            }
            this(path, ideInstallDir, deployOptions);
        }

        @NotNull
        public final Path getLocalFile() {
            return this.localFile;
        }

        @Override
        @Nullable
        public DeployOptions getDeployOptions() {
            return this.deployOptions;
        }

        @Override
        @NotNull
        public Map<String, String> getGtwLinkParameters() {
            Pair[] pairArray = new Pair[2];
            pairArray[0] = TuplesKt.to((Object)"localUploadPath", (Object)((Object)this.localFile).toString());
            DeployOptions deployOptions = this.getDeployOptions();
            pairArray[1] = TuplesKt.to((Object)"heapSize", (Object)String.valueOf(deployOptions != null ? deployOptions.getHeapSize() : null));
            return MapsKt.plus(super.getGtwLinkParameters(), (Map)MapsKt.mapOf((Pair[])pairArray));
        }

        @JvmOverloads
        public DeployFromLocalFile(@NotNull Path localFile, @Nullable IdeInstallDir installDir) {
            Intrinsics.checkNotNullParameter((Object)localFile, (String)"localFile");
            this(localFile, installDir, null, 4, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J!\u0010\u000b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo$DeployOptions;", "", "heapSize", "", "ideaUpdateUrl", "(Ljava/lang/String;Ljava/lang/String;)V", "getHeapSize", "()Ljava/lang/String;", "getIdeaUpdateUrl", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "toVmOptions", "", "intellij.gateway.core"})
    public static final class DeployOptions {
        @Nullable
        private final String heapSize;
        @Nullable
        private final String ideaUpdateUrl;

        @JvmOverloads
        public DeployOptions(@Nullable String heapSize, @Nullable String ideaUpdateUrl) {
            this.heapSize = heapSize;
            this.ideaUpdateUrl = ideaUpdateUrl;
        }

        public /* synthetic */ DeployOptions(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }

        @Nullable
        public final String getHeapSize() {
            return this.heapSize;
        }

        @Nullable
        public final String getIdeaUpdateUrl() {
            return this.ideaUpdateUrl;
        }

        @NotNull
        public final List<String> toVmOptions() {
            String suppressedPluginsSet;
            String string;
            String updatesUrlProperty;
            String string2;
            List list;
            List $this$toVmOptions_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            CharSequence charSequence = this.heapSize;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && !Intrinsics.areEqual((Object)this.heapSize, (Object)"null")) {
                $this$toVmOptions_u24lambda_u240.add("-Xmx" + this.heapSize + "m");
            }
            if (!((charSequence = (CharSequence)this.ideaUpdateUrl) == null || charSequence.length() == 0)) {
                $this$toVmOptions_u24lambda_u240.add("-Didea.updates.url=" + this.ideaUpdateUrl);
            }
            String string3 = System.getProperty("gateway.forward.host.updates.url.to.backend", "false");
            boolean forwardUrlToBackend = string3 != null ? Boolean.parseBoolean(string3) : false;
            String string4 = string2 = System.getProperty("idea.updates.url");
            if (string4 == null) {
                v2 = "";
            } else {
                Intrinsics.checkNotNull((Object)string4);
                v2 = updatesUrlProperty = string2;
            }
            if (forwardUrlToBackend && ((CharSequence)updatesUrlProperty).length() > 0) {
                $this$toVmOptions_u24lambda_u240.add("-Didea.updates.url=" + updatesUrlProperty);
            }
            String string5 = string = System.getProperty("idea.suppressed.plugins.set.selector");
            if (string5 == null) {
                v4 = "";
            } else {
                Intrinsics.checkNotNull((Object)string5);
                v4 = suppressedPluginsSet = string;
            }
            if (((CharSequence)suppressedPluginsSet).length() > 0) {
                $this$toVmOptions_u24lambda_u240.add("-Didea.suppressed.plugins.set.selector=" + suppressedPluginsSet);
            }
            return CollectionsKt.build((List)list);
        }

        @Nullable
        public final String component1() {
            return this.heapSize;
        }

        @Nullable
        public final String component2() {
            return this.ideaUpdateUrl;
        }

        @NotNull
        public final DeployOptions copy(@Nullable String heapSize, @Nullable String ideaUpdateUrl) {
            return new DeployOptions(heapSize, ideaUpdateUrl);
        }

        public static /* synthetic */ DeployOptions copy$default(DeployOptions deployOptions, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = deployOptions.heapSize;
            }
            if ((n & 2) != 0) {
                string2 = deployOptions.ideaUpdateUrl;
            }
            return deployOptions.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "DeployOptions(heapSize=" + this.heapSize + ", ideaUpdateUrl=" + this.ideaUpdateUrl + ")";
        }

        public int hashCode() {
            int result2 = this.heapSize == null ? 0 : this.heapSize.hashCode();
            result2 = result2 * 31 + (this.ideaUpdateUrl == null ? 0 : this.ideaUpdateUrl.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeployOptions)) {
                return false;
            }
            DeployOptions deployOptions = (DeployOptions)other;
            if (!Intrinsics.areEqual((Object)this.heapSize, (Object)deployOptions.heapSize)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.ideaUpdateUrl, (Object)deployOptions.ideaUpdateUrl);
        }

        @JvmOverloads
        public DeployOptions(@Nullable String heapSize) {
            this(heapSize, null, 2, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo$DeployWithDownload;", "Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo$DeployBase;", "downloadUrl", "Ljava/net/URI;", "installDir", "Lcom/jetbrains/gateway/ssh/util/IdeInstallDir;", "ideInfo", "Lcom/jetbrains/gateway/ssh/IdeInfo;", "deployOptions", "Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo$DeployOptions;", "(Ljava/net/URI;Lcom/jetbrains/gateway/ssh/util/IdeInstallDir;Lcom/jetbrains/gateway/ssh/IdeInfo;Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo$DeployOptions;)V", "getDeployOptions", "()Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo$DeployOptions;", "getDownloadUrl", "()Ljava/net/URI;", "getGtwLinkParameters", "", "", "intellij.gateway.core"})
    @SourceDebugExtension(value={"SMAP\nDeployTargetInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeployTargetInfo.kt\ncom/jetbrains/gateway/ssh/deploy/DeployTargetInfo$DeployWithDownload\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1#2:152\n*E\n"})
    public static final class DeployWithDownload
    extends DeployBase {
        @NotNull
        private final URI downloadUrl;
        @Nullable
        private final DeployOptions deployOptions;

        @JvmOverloads
        public DeployWithDownload(@NotNull URI downloadUrl, @Nullable IdeInstallDir installDir, @Nullable IdeInfo ideInfo, @Nullable DeployOptions deployOptions) {
            Intrinsics.checkNotNullParameter((Object)downloadUrl, (String)"downloadUrl");
            super(installDir, ideInfo);
            this.downloadUrl = downloadUrl;
            this.deployOptions = deployOptions;
            String it = this.downloadUrl.getScheme();
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it, (Object)"http") || Intrinsics.areEqual((Object)it, (Object)"https"))) {
                boolean bl2 = false;
                String string = "Only http[s] downloads are allowed";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public /* synthetic */ DeployWithDownload(URI uRI, IdeInstallDir ideInstallDir, IdeInfo ideInfo, DeployOptions deployOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                deployOptions = null;
            }
            this(uRI, ideInstallDir, ideInfo, deployOptions);
        }

        @NotNull
        public final URI getDownloadUrl() {
            return this.downloadUrl;
        }

        @Override
        @Nullable
        public DeployOptions getDeployOptions() {
            return this.deployOptions;
        }

        @Override
        @NotNull
        public Map<String, String> getGtwLinkParameters() {
            Pair[] pairArray = new Pair[2];
            pairArray[0] = TuplesKt.to((Object)"sourceUrl", (Object)this.downloadUrl.toString());
            DeployOptions deployOptions = this.getDeployOptions();
            pairArray[1] = TuplesKt.to((Object)"heapSize", (Object)String.valueOf(deployOptions != null ? deployOptions.getHeapSize() : null));
            return MapsKt.plus(super.getGtwLinkParameters(), (Map)MapsKt.mapOf((Pair[])pairArray));
        }

        @JvmOverloads
        public DeployWithDownload(@NotNull URI downloadUrl, @Nullable IdeInstallDir installDir, @Nullable IdeInfo ideInfo) {
            Intrinsics.checkNotNullParameter((Object)downloadUrl, (String)"downloadUrl");
            this(downloadUrl, installDir, ideInfo, null, 8, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo$NoDeploy;", "Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo;", "remoteIdePath", "", "ideInfo", "Lcom/jetbrains/gateway/ssh/IdeInfo;", "(Ljava/lang/String;Lcom/jetbrains/gateway/ssh/IdeInfo;)V", "getRemoteIdePath", "()Ljava/lang/String;", "getGtwLinkParameters", "", "intellij.gateway.core"})
    public static final class NoDeploy
    extends DeployTargetInfo {
        @NotNull
        private final String remoteIdePath;

        public NoDeploy(@NotNull String remoteIdePath, @Nullable IdeInfo ideInfo) {
            Intrinsics.checkNotNullParameter((Object)remoteIdePath, (String)"remoteIdePath");
            super(ideInfo, null);
            this.remoteIdePath = remoteIdePath;
        }

        @NotNull
        public final String getRemoteIdePath() {
            return this.remoteIdePath;
        }

        @Override
        @NotNull
        public Map<String, String> getGtwLinkParameters() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"deploy", (Object)"false"), TuplesKt.to((Object)"idePath", (Object)this.remoteIdePath)};
            return MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), super.getGtwLinkParameters());
        }
    }
}

