/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.rd.util.ProgressIndocatorExKt;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.remoteDev.downloader.CodeWithMeClientDownloader;
import com.intellij.remoteDev.downloader.ExtractedJetBrainsClientData;
import com.intellij.remoteDev.hostStatus.UnattendedHostStatus;
import com.intellij.util.ApplicationKt;
import com.intellij.util.Futures;
import com.jetbrains.gateway.GatewayBundle;
import com.jetbrains.gateway.internal.GatewayCoreRegistry;
import com.jetbrains.gateway.ssh.DeployFlowUtil;
import com.jetbrains.gateway.ssh.DeployTargetOS;
import com.jetbrains.gateway.ssh.FileSystemItem;
import com.jetbrains.gateway.ssh.HighLevelHostAccessor;
import com.jetbrains.gateway.ssh.HostDeployInputs;
import com.jetbrains.gateway.ssh.HostTunnelConnector;
import com.jetbrains.gateway.ssh.RemoteCommandException;
import com.jetbrains.gateway.ssh.SshDeployFlowUtil;
import com.jetbrains.gateway.ssh.SshMultistagePanelContext;
import com.jetbrains.gateway.ssh.deploy.ClientDownloaderForDeploy;
import com.jetbrains.gateway.ssh.deploy.DeployException;
import com.jetbrains.gateway.ssh.deploy.ExtensionsKt;
import com.jetbrains.gateway.ssh.deploy.ShellArgument;
import com.jetbrains.gateway.ssh.deploy.ShellFacade;
import com.jetbrains.gateway.thinClientLink.ThinClientHandle;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.net.InetAddress;
import java.time.Duration;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0015J \u0010\u0016\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0015J,\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0015J \u0010\u001a\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0015J6\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0086@\u00a2\u0006\u0002\u0010\u001eJ\u001e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0086@\u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0096@\u00a2\u0006\u0002\u0010'J\u0018\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010(\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010)J%\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b0J6\u00101\u001a\u0010\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020&\u0018\u00010\u000e2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\b\b\u0002\u0010-\u001a\u00020.H\u0086@\u00a2\u0006\u0002\u00107J \u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u00142\u0006\u0010;\u001a\u000209H\u0080@\u00a2\u0006\u0004\b<\u0010=J \u0010>\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/jetbrains/gateway/ssh/SshDeployFlowUtil;", "Lcom/jetbrains/gateway/ssh/deploy/ClientDownloaderForDeploy;", "()V", "GIGABYTE_TO_BYTES", "", "GIGABYTE_TO_KILOBYTES", "MEMORY_MULTIPLIER", "", "MINIMAL_CPU", "MINIMAL_MEMORY", "MINIMAL_MEMORY_SHOWN", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "checkAvailableMemory", "Lkotlin/Pair;", "", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "executor", "Lcom/jetbrains/gateway/ssh/HighLevelHostAccessor;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/jetbrains/gateway/ssh/HighLevelHostAccessor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkAvailableSpace", "", "worker", "checkCPUCount", "checkFileLockingSupport", "checkPortForwarding", "hostTunnelConnector", "Lcom/jetbrains/gateway/ssh/HostTunnelConnector;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/jetbrains/gateway/ssh/HighLevelHostAccessor;Lcom/jetbrains/gateway/ssh/HostTunnelConnector;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkRemoteOS", "shell", "Lcom/jetbrains/gateway/ssh/deploy/ShellFacade;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/jetbrains/gateway/ssh/deploy/ShellFacade;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "downloadThinClient", "Lcom/intellij/remoteDev/downloader/ExtractedJetBrainsClientData;", "hostStatus", "Lcom/intellij/remoteDev/hostStatus/UnattendedHostStatus;", "(Lcom/intellij/remoteDev/hostStatus/UnattendedHostStatus;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "buildNumber", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "errorOnTimeout", "startTime", "", "timeout", "Ljava/time/Duration;", "errorMessage", "errorOnTimeout$intellij_gateway_core", "fullDeployCycle", "Lcom/jetbrains/gateway/thinClientLink/ThinClientHandle;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "context", "Lcom/jetbrains/gateway/ssh/SshMultistagePanelContext;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/gateway/ssh/SshMultistagePanelContext;Ljava/time/Duration;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRealProjectPath", "Lcom/jetbrains/gateway/ssh/deploy/ShellArgument$RemotePath;", "hostAccessor", "projectPath", "getRealProjectPath$intellij_gateway_core", "(Lcom/jetbrains/gateway/ssh/HighLevelHostAccessor;Lcom/jetbrains/gateway/ssh/deploy/ShellArgument$RemotePath;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "prepareCacheAndConfigDirectories", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nSshDeployFlowUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshDeployFlowUtil.kt\ncom/jetbrains/gateway/ssh/SshDeployFlowUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,215:1\n13#2:216\n*S KotlinDebug\n*F\n+ 1 SshDeployFlowUtil.kt\ncom/jetbrains/gateway/ssh/SshDeployFlowUtil\n*L\n30#1:216\n*E\n"})
public final class SshDeployFlowUtil
implements ClientDownloaderForDeploy {
    @NotNull
    public static final SshDeployFlowUtil INSTANCE = new SshDeployFlowUtil();
    @NotNull
    private static final Logger logger;
    private static final int GIGABYTE_TO_KILOBYTES = 0x100000;
    private static final int GIGABYTE_TO_BYTES = 0x40000000;
    private static final double MEMORY_MULTIPLIER = 3.8;
    private static final int MINIMAL_MEMORY_SHOWN = 4;
    private static final double MINIMAL_MEMORY = 3984588.8;
    private static final int MINIMAL_CPU = 4;

    private SshDeployFlowUtil() {
    }

    @Nullable
    public final Object fullDeployCycle(@NotNull Lifetime lifetime, @NotNull SshMultistagePanelContext context, @NotNull Duration timeout, @NotNull Continuation<? super Pair<ThinClientHandle, UnattendedHostStatus>> $completion) {
        logger.info("Deploy cycle started. Context=" + context);
        HostDeployInputs hostDeployInputs = context.getDeployData();
        Intrinsics.checkNotNull((Object)hostDeployInputs, (String)"null cannot be cast to non-null type com.jetbrains.gateway.ssh.HostDeployInputs.FullySpecified");
        return DeployFlowUtil.INSTANCE.fullDeployCycle(lifetime, (HostDeployInputs.FullySpecified)hostDeployInputs, $completion);
    }

    public static /* synthetic */ Object fullDeployCycle$default(SshDeployFlowUtil sshDeployFlowUtil, Lifetime lifetime, SshMultistagePanelContext sshMultistagePanelContext, Duration duration, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofMinutes(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(...)");
            duration = duration2;
        }
        return sshDeployFlowUtil.fullDeployCycle(lifetime, sshMultistagePanelContext, duration, (Continuation<? super Pair<ThinClientHandle, UnattendedHostStatus>>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getRealProjectPath$intellij_gateway_core(@NotNull HighLevelHostAccessor var1_1, @NotNull ShellArgument.RemotePath var2_2, @NotNull Continuation<? super ShellArgument.RemotePath> var3_3) {
        if (!(var3_3 instanceof getRealProjectPath.1)) ** GOTO lbl-1000
        var7_4 = var3_3;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ SshDeployFlowUtil this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getRealProjectPath$intellij_gateway_core(null, null, (Continuation<? super ShellArgument.RemotePath>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = projectPath;
                $continuation.label = 1;
                v0 = hostAccessor.realpath(projectPath, (Continuation<? super ShellArgument.RemotePath>)$continuation);
                ** if (v0 != var8_6) goto lbl19
lbl18:
                // 1 sources

                return var8_6;
lbl19:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                projectPath = (ShellArgument.RemotePath)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    var4_7 = (ShellArgument.RemotePath)v0;
                }
                catch (RemoteCommandException var5_8) {
                    SshDeployFlowUtil.logger.warn("Failed to get realpath for '" + projectPath + "'. Continue deploy with initial value.");
                    var4_7 = projectPath;
                }
                return var4_7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object checkRemoteOS(@NotNull ProgressIndicator indicator, @NotNull ShellFacade shell, @NotNull Continuation<? super Boolean> $completion) {
        indicator.setText(GatewayBundle.INSTANCE.message("ssh.deploy.checkingRemoteHost", new Object[0]));
        indicator.setFraction(0.5);
        ProgressIndicatorEx progressIndicatorEx = indicator instanceof ProgressIndicatorEx ? (ProgressIndicatorEx)indicator : null;
        if (progressIndicatorEx != null) {
            ProgressIndocatorExKt.subscribeOnCancel((ProgressIndicatorEx)progressIndicatorEx, (Function0)checkRemoteOS.2.INSTANCE);
        }
        DeployTargetOS remoteOs = shell.getOs();
        logger.info("Remote OS guessed as " + remoteOs);
        if (remoteOs.getOsKind() == DeployTargetOS.OSKind.Linux && (remoteOs.getOsArch() == DeployTargetOS.OSArch.X86_64 || remoteOs.getOsArch() == DeployTargetOS.OSArch.ARM_64)) {
            return Boxing.boxBoolean((boolean)true);
        }
        if (GatewayCoreRegistry.INSTANCE.isMacDeployEnabled() && remoteOs.getOsKind() == DeployTargetOS.OSKind.MacOs) {
            return Boxing.boxBoolean((boolean)true);
        }
        if (GatewayCoreRegistry.INSTANCE.isWindowsDeployEnabled() && remoteOs.getOsKind() == DeployTargetOS.OSKind.Windows) {
            return Boxing.boxBoolean((boolean)true);
        }
        ApplicationKt.getApplication().invokeLater(SshDeployFlowUtil::checkRemoteOS$lambda$0);
        return Boxing.boxBoolean((boolean)false);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object checkFileLockingSupport(@Nullable ProgressIndicator var1_1, @NotNull HighLevelHostAccessor var2_2, @NotNull Continuation<? super Boolean> var3_3) {
        if (!(var3_3 instanceof checkFileLockingSupport.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ SshDeployFlowUtil this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.checkFileLockingSupport(null, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (indicator != null) {
                    indicator.setText(GatewayBundle.INSTANCE.message("ssh.deploy.file.locking.check.test", new Object[0]));
                    indicator.setFraction(0.5);
                }
                $continuation.label = 1;
                v0 = executor.checkFileLockingSupport((Continuation<? super String>)$continuation);
                ** if (v0 != var9_6) goto lbl21
lbl20:
                // 1 sources

                return var9_6;
lbl21:
                // 1 sources

                ** GOTO lbl27
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl27:
                    // 2 sources

                    var5_7 = null;
                    ** GOTO lbl39
                }
                catch (RemoteCommandException e) {
                    $continuation.label = 2;
                    v1 = ExtensionsKt.getFullStdout(e.getExecResult(), (Continuation<? super String>)$continuation);
                    if (v1 == var9_6) {
                        return var9_6;
                    }
                    ** GOTO lbl38
                }
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl38:
                // 2 sources

                var5_7 = (String)v1;
lbl39:
                // 2 sources

                result = var5_7;
                if (result != null) {
                    SshDeployFlowUtil.logger.warn("File locking check failed.");
                    v2 = false;
                } else {
                    v2 = true;
                }
                return Boxing.boxBoolean((boolean)v2);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object checkAvailableMemory(@NotNull ProgressIndicator var1_1, @NotNull HighLevelHostAccessor var2_2, @NotNull Continuation<? super Pair<Boolean, String>> var3_3) {
        if (!(var3_3 instanceof checkAvailableMemory.1)) ** GOTO lbl-1000
        var10_4 = var3_3;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ SshDeployFlowUtil this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.checkAvailableMemory(null, null, (Continuation<? super Pair<Boolean, String>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                indicator.setText(GatewayBundle.INSTANCE.message("ssh.deploy.minimal.requirements.progress", new Object[0]));
                indicator.setFraction(0.5);
                $continuation.label = 1;
                v0 = executor.getAvailableMemory((Continuation<? super Long>)$continuation);
                ** if (v0 != var11_6) goto lbl20
lbl19:
                // 1 sources

                return var11_6;
lbl20:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    var6_7 = ((Number)v0).longValue();
                }
                catch (Throwable e) {
                    if (Futures.isCancellation((Throwable)e)) {
                        throw e;
                    }
                    var6_7 = -1L;
                }
                availableMemory = var6_7;
                if (availableMemory >= 0L) {
                    var7_12 = "%.2f";
                    var8_10 = new Object[]{Boxing.boxDouble((double)((double)availableMemory / (double)0x100000))};
                    v1 = String.format((String)var7_12, Arrays.copyOf(var8_10, var8_10.length));
                    v2 = v1;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"format(...)");
                } else {
                    v2 = availableMemoryInGb = "N/A";
                }
                if ((double)availableMemory < 3984588.8) {
                    SshDeployFlowUtil.logger.warn("Minimal requirements check failed. The host doesn't have enough memory: " + (double)availableMemory / (double)0x100000 + " GB");
                    var7_12 = new Object[]{"4", availableMemoryInGb};
                    v3 = new Pair((Object)Boxing.boxBoolean((boolean)false), (Object)GatewayBundle.INSTANCE.message("ssh.deploy.minimal.requirements.memory.message", var7_12));
                    v4 = v3;
                } else {
                    v4 = new Pair((Object)Boxing.boxBoolean((boolean)true), null);
                }
                return v4;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object checkCPUCount(@NotNull ProgressIndicator var1_1, @NotNull HighLevelHostAccessor var2_2, @NotNull Continuation<? super Pair<Boolean, String>> var3_3) {
        if (!(var3_3 instanceof checkCPUCount.1)) ** GOTO lbl-1000
        var10_4 = var3_3;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ SshDeployFlowUtil this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.checkCPUCount(null, null, (Continuation<? super Pair<Boolean, String>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                indicator.setText(GatewayBundle.INSTANCE.message("ssh.deploy.minimal.requirements.progress", new Object[0]));
                indicator.setFraction(0.5);
                $continuation.label = 1;
                v0 = executor.getCPUCount((Continuation<? super Long>)$continuation);
                ** if (v0 != var11_6) goto lbl20
lbl19:
                // 1 sources

                return var11_6;
lbl20:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    var6_7 = ((Number)v0).longValue();
                }
                catch (Throwable e) {
                    if (Futures.isCancellation((Throwable)e)) {
                        throw e;
                    }
                    var6_7 = -1L;
                }
                availableCpus = var6_7;
                v1 = availableCpuText = availableCpus >= 0L ? String.valueOf(availableCpus) : "N/A";
                if (availableCpus < 4L) {
                    SshDeployFlowUtil.logger.warn("Minimal requirements check failed. The host doesn't have enough cores: " + availableCpus);
                    var7_11 = new Object[]{availableCpuText};
                    v2 = new Pair((Object)Boxing.boxBoolean((boolean)false), (Object)GatewayBundle.INSTANCE.message("ssh.deploy.minimal.requirements.cpu.message", var7_11));
                    v3 = v2;
                } else {
                    v3 = new Pair((Object)Boxing.boxBoolean((boolean)true), null);
                }
                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object checkPortForwarding(@Nullable ProgressIndicator var1_1, @NotNull HighLevelHostAccessor var2_2, @NotNull HostTunnelConnector var3_3, @NotNull Continuation<? super Pair<Boolean, String>> var4_4) {
        if (!(var4_4 instanceof checkPortForwarding.1)) ** GOTO lbl-1000
        var7_5 = var4_4;
        if ((var7_5.label & -2147483648) != 0) {
            var7_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                /* synthetic */ Object result;
                final /* synthetic */ SshDeployFlowUtil this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.checkPortForwarding(null, null, null, (Continuation<? super Pair<Boolean, String>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = indicator;
                if (v0 != null) {
                    v0.setText(GatewayBundle.INSTANCE.message("ssh.deploy.port.forwarding.progress", new Object[0]));
                }
                $continuation.label = 1;
                v1 = executor.testPortForwarding((Function4<? super Lifetime, ? super InetAddress, ? super Integer, ? super Continuation<? super Integer>, ? extends Object>)((Function4)new Function4<Lifetime, InetAddress, Integer, Continuation<? super Integer>, Object>((HostTunnelConnector)hostTunnelConnector, null){
                    int label;
                    /* synthetic */ Object L$0;
                    /* synthetic */ Object L$1;
                    /* synthetic */ int I$0;
                    final /* synthetic */ HostTunnelConnector $hostTunnelConnector;
                    {
                        this.$hostTunnelConnector = $hostTunnelConnector;
                        super(4, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                Lifetime lt = (Lifetime)this.L$0;
                                InetAddress address = (InetAddress)this.L$1;
                                int port = this.I$0;
                                Object object3 = InetAddress.getLoopbackAddress();
                                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getLoopbackAddress(...)");
                                InetAddress inetAddress = object3;
                                object3 = address.getHostAddress();
                                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getHostAddress(...)");
                                this.L$0 = null;
                                this.label = 1;
                                Object object4 = this.$hostTunnelConnector.connect(lt, inetAddress, (String)object3, port, (Continuation<? super Integer>)((Continuation)this));
                                if (object4 != object2) return object4;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object4 = $result;
                                return object4;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @Nullable
                    public final Object invoke(@NotNull Lifetime p1, @NotNull InetAddress p2, int p3, @Nullable Continuation<? super Integer> p4) {
                        var var5_5 = new /* invalid duplicate definition of identical inner class */;
                        var5_5.L$0 = p1;
                        var5_5.L$1 = p2;
                        var5_5.I$0 = p3;
                        return var5_5.invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super Boolean>)$continuation);
                if (v1 == var8_7) {
                    return var8_7;
                }
                ** GOTO lbl23
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl23:
                // 2 sources

                if (!(res = ((Boolean)v1).booleanValue())) {
                    SshDeployFlowUtil.logger.warn("Port forwarding test failed");
                    v2 = TuplesKt.to((Object)Boxing.boxBoolean((boolean)false), (Object)GatewayBundle.INSTANCE.message("ssh.deploy.port.forwarding.check.message", new Object[0]));
                } else {
                    v2 = TuplesKt.to((Object)Boxing.boxBoolean((boolean)true), null);
                }
                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object checkAvailableSpace(@Nullable ProgressIndicator var1_1, @NotNull HighLevelHostAccessor var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof checkAvailableSpace.1)) ** GOTO lbl-1000
        var12_4 = var3_3;
        if ((var12_4.label & -2147483648) != 0) {
            var12_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                double D$0;
                /* synthetic */ Object result;
                final /* synthetic */ SshDeployFlowUtil this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.checkAvailableSpace(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = indicator;
                if (v0 != null) {
                    v0.setText(GatewayBundle.INSTANCE.message("ssh.deploy.available.space.title", new Object[0]));
                }
                $continuation.L$0 = worker;
                $continuation.label = 1;
                v1 = worker.getCachePath((Continuation<? super ShellArgument.RemotePath>)$continuation);
                if (v1 == var13_6) {
                    return var13_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                worker = (HighLevelHostAccessor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl25:
                // 2 sources

                cachePath = (ShellArgument.RemotePath)v1;
                $continuation.L$0 = worker;
                $continuation.L$1 = cachePath;
                $continuation.label = 2;
                v2 = worker.getConfigPath((Continuation<? super ShellArgument.RemotePath>)$continuation);
                if (v2 == var13_6) {
                    return var13_6;
                }
                ** GOTO lbl38
            }
            case 2: {
                cachePath = (ShellArgument.RemotePath)$continuation.L$1;
                worker = (HighLevelHostAccessor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl38:
                // 2 sources

                configPath = (ShellArgument.RemotePath)v2;
                $continuation.L$0 = worker;
                $continuation.L$1 = cachePath;
                $continuation.L$2 = configPath;
                $continuation.label = 3;
                v3 = worker.getAvailableSpace(cachePath, (Continuation<? super Long>)$continuation);
                if (v3 == var13_6) {
                    return var13_6;
                }
                ** GOTO lbl53
            }
            case 3: {
                configPath = (ShellArgument.RemotePath)$continuation.L$2;
                cachePath = (ShellArgument.RemotePath)$continuation.L$1;
                worker = (HighLevelHostAccessor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl53:
                // 2 sources

                cachePathAvailableSpace = (double)((Number)v3).longValue() / (double)0x40000000;
                $continuation.L$0 = cachePath;
                $continuation.L$1 = configPath;
                $continuation.L$2 = null;
                $continuation.D$0 = cachePathAvailableSpace;
                $continuation.label = 4;
                v4 = worker.getAvailableSpace(configPath, (Continuation<? super Long>)$continuation);
                if (v4 == var13_6) {
                    return var13_6;
                }
                ** GOTO lbl69
            }
            case 4: {
                cachePathAvailableSpace = $continuation.D$0;
                configPath = (ShellArgument.RemotePath)$continuation.L$1;
                cachePath = (ShellArgument.RemotePath)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl69:
                // 2 sources

                configPathAvailableSpace = (double)((Number)v4).longValue() / (double)0x40000000;
                if (cachePathAvailableSpace < 0.5 || configPathAvailableSpace < 0.5) {
                    var10_11 = new Object[]{cachePath.getRawValue$intellij_gateway_core(), configPath.getRawValue$intellij_gateway_core()};
                    throw new DeployException(GatewayBundle.INSTANCE.message("ssh.deploy.available.space.error", var10_11), null, null, 6, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object prepareCacheAndConfigDirectories(@Nullable ProgressIndicator var1_1, @NotNull HighLevelHostAccessor var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof prepareCacheAndConfigDirectories.1)) ** GOTO lbl-1000
        var7_4 = var3_3;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ SshDeployFlowUtil this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.prepareCacheAndConfigDirectories(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = indicator;
                if (v0 != null) {
                    v0.setText(GatewayBundle.INSTANCE.message("ssh.deploy.prepare.directories.text", new Object[0]));
                }
                $continuation.L$0 = worker;
                $continuation.label = 1;
                v1 = worker.getCachePath((Continuation<? super ShellArgument.RemotePath>)$continuation);
                if (v1 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                worker = (HighLevelHostAccessor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl25:
                // 2 sources

                cachePath = (ShellArgument.RemotePath)v1;
                $continuation.L$0 = worker;
                $continuation.L$1 = cachePath;
                $continuation.label = 2;
                v2 = worker.getConfigPath((Continuation<? super ShellArgument.RemotePath>)$continuation);
                if (v2 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl38
            }
            case 2: {
                cachePath = (ShellArgument.RemotePath)$continuation.L$1;
                worker = (HighLevelHostAccessor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl38:
                // 2 sources

                configPath = (ShellArgument.RemotePath)v2;
                $continuation.L$0 = worker;
                $continuation.L$1 = cachePath;
                $continuation.L$2 = configPath;
                $continuation.label = 3;
                v3 = HighLevelHostAccessor.isPathPresentOnRemote$default(worker, cachePath, null, (Continuation)$continuation, 2, null);
                if (v3 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl53
            }
            case 3: {
                configPath = (ShellArgument.RemotePath)$continuation.L$2;
                cachePath = (ShellArgument.RemotePath)$continuation.L$1;
                worker = (HighLevelHostAccessor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl53:
                // 2 sources

                if (!((Boolean)v3).booleanValue()) {
                    $continuation.L$0 = worker;
                    $continuation.L$1 = configPath;
                    $continuation.L$2 = null;
                    $continuation.label = 4;
                    v4 = worker.createPathOnRemote(cachePath, FileSystemItem.Directory, (Continuation<? super Unit>)$continuation);
                    if (v4 == var8_6) {
                        return var8_6;
                    }
                }
                ** GOTO lbl67
            }
            case 4: {
                configPath = (ShellArgument.RemotePath)$continuation.L$1;
                worker = (HighLevelHostAccessor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl67:
                // 2 sources

                $continuation.L$0 = worker;
                $continuation.L$1 = configPath;
                $continuation.L$2 = null;
                $continuation.label = 5;
                v5 = HighLevelHostAccessor.isPathPresentOnRemote$default(worker, configPath, null, (Continuation)$continuation, 2, null);
                if (v5 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl80
            }
            case 5: {
                configPath = (ShellArgument.RemotePath)$continuation.L$1;
                worker = (HighLevelHostAccessor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl80:
                // 2 sources

                if (((Boolean)v5).booleanValue()) break;
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 6;
                v6 = worker.createPathOnRemote(configPath, FileSystemItem.Directory, (Continuation<? super Unit>)$continuation);
                if (v6 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl91
            }
            case 6: {
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl91:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void errorOnTimeout$intellij_gateway_core(long startTime, @NotNull Duration timeout, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        long elapsedNs = System.nanoTime() - startTime;
        if (elapsedNs > timeout.toNanos()) {
            throw new IllegalStateException(errorMessage.toString());
        }
    }

    @Override
    @Nullable
    public Object downloadThinClient(@NotNull UnattendedHostStatus hostStatus, @NotNull Continuation<? super ExtractedJetBrainsClientData> $completion) {
        ModalTaskOwner modalTaskOwner = ModalTaskOwner.guess();
        Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner, (String)"guess(...)");
        String string = GatewayBundle.INSTANCE.message("ssh.deploy.downloadingThinClient", new Object[0]);
        TaskCancellation.Cancellable cancellable = TaskCancellation.cancellable();
        Intrinsics.checkNotNullExpressionValue((Object)cancellable, (String)"cancellable(...)");
        return TasksKt.withModalProgress((ModalTaskOwner)modalTaskOwner, (String)string, (TaskCancellation)((TaskCancellation)cancellable), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ExtractedJetBrainsClientData>, Object>(hostStatus, null){
            int label;
            final /* synthetic */ UnattendedHostStatus $hostStatus;
            {
                this.$hostStatus = $hostStatus;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ExtractedJetBrainsClientData>, Object>(this.$hostStatus, null){
                            int label;
                            final /* synthetic */ UnattendedHostStatus $hostStatus;
                            {
                                this.$hostStatus = $hostStatus;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = CoroutinesKt.coroutineToIndicator((Function0)((Function0)new Function0<ExtractedJetBrainsClientData>(this.$hostStatus){
                                            final /* synthetic */ UnattendedHostStatus $hostStatus;
                                            {
                                                this.$hostStatus = $hostStatus;
                                                super(0);
                                            }

                                            @Nullable
                                            public final ExtractedJetBrainsClientData invoke() {
                                                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                                                ProgressIndicatorEx progressIndicatorEx = indicator instanceof ProgressIndicatorEx ? (ProgressIndicatorEx)indicator : null;
                                                if (progressIndicatorEx != null) {
                                                    ProgressIndocatorExKt.subscribeOnCancel((ProgressIndicatorEx)progressIndicatorEx, (Function0)downloadThinClient.1.INSTANCE);
                                                }
                                                String[] stringArray = new String[]{"-"};
                                                String buildNumber = (String)StringsKt.split$default((CharSequence)this.$hostStatus.getAppVersion(), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
                                                String jreBuild = CodeWithMeClientDownloader.INSTANCE.isClientWithBundledJre(buildNumber) ? null : this.$hostStatus.getRuntimeVersion();
                                                Intrinsics.checkNotNull((Object)indicator);
                                                return CodeWithMeClientDownloader.INSTANCE.downloadClientAndJdk(buildNumber, jreBuild, indicator);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ExtractedJetBrainsClientData> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ExtractedJetBrainsClientData> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object downloadThinClient(@NotNull String buildNumber, @NotNull Continuation<? super ExtractedJetBrainsClientData> $completion) {
        ModalTaskOwner modalTaskOwner = ModalTaskOwner.guess();
        Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner, (String)"guess(...)");
        String string = GatewayBundle.INSTANCE.message("ssh.deploy.downloadingThinClient", new Object[0]);
        TaskCancellation.Cancellable cancellable = TaskCancellation.cancellable();
        Intrinsics.checkNotNullExpressionValue((Object)cancellable, (String)"cancellable(...)");
        return TasksKt.withModalProgress((ModalTaskOwner)modalTaskOwner, (String)string, (TaskCancellation)((TaskCancellation)cancellable), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ExtractedJetBrainsClientData>, Object>(buildNumber, null){
            int label;
            final /* synthetic */ String $buildNumber;
            {
                this.$buildNumber = $buildNumber;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ExtractedJetBrainsClientData>, Object>(this.$buildNumber, null){
                            int label;
                            final /* synthetic */ String $buildNumber;
                            {
                                this.$buildNumber = $buildNumber;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = CoroutinesKt.coroutineToIndicator((Function0)((Function0)new Function0<ExtractedJetBrainsClientData>(this.$buildNumber){
                                            final /* synthetic */ String $buildNumber;
                                            {
                                                this.$buildNumber = $buildNumber;
                                                super(0);
                                            }

                                            @Nullable
                                            public final ExtractedJetBrainsClientData invoke() {
                                                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                                                ProgressIndicatorEx progressIndicatorEx = indicator instanceof ProgressIndicatorEx ? (ProgressIndicatorEx)indicator : null;
                                                if (progressIndicatorEx != null) {
                                                    ProgressIndocatorExKt.subscribeOnCancel((ProgressIndicatorEx)progressIndicatorEx, (Function0)downloadThinClient.1.INSTANCE);
                                                }
                                                Intrinsics.checkNotNull((Object)indicator);
                                                return CodeWithMeClientDownloader.INSTANCE.downloadClientAndJdk(this.$buildNumber, indicator);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ExtractedJetBrainsClientData> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ExtractedJetBrainsClientData> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private static final void checkRemoteOS$lambda$0() {
        Messages.showErrorDialog((String)GatewayBundle.INSTANCE.message("ssh.deploy.unsupported.os.error.dialog.message", new Object[0]), (String)GatewayBundle.INSTANCE.message("ssh.deploy.unsupported.os.error.dialog.title", new Object[0]));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SshDeployFlowUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SshDeployFlowUtil.logger = logger;
    }
}

