/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.UriUtilKt;
import com.jetbrains.gateway.ssh.DeployTargetOS;
import com.jetbrains.gateway.ssh.HighLevelHostAccessor;
import com.jetbrains.gateway.ssh.LinkRemoteHostDownloader;
import com.jetbrains.gateway.ssh.RemoteHostBackendDownloader;
import com.jetbrains.gateway.ssh.RemoteHostBackendDownloaderKt;
import com.jetbrains.gateway.ssh.TransferProgressAdapter;
import com.jetbrains.gateway.ssh.deploy.ShellArgument;
import java.net.URI;
import java.security.MessageDigest;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/gateway/ssh/LinkRemoteHostDownloader;", "Lcom/jetbrains/gateway/ssh/RemoteHostBackendDownloader;", "downloadLink", "Ljava/net/URI;", "(Ljava/net/URI;)V", "downloadArchiveOnRemote", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "hostAccessor", "Lcom/jetbrains/gateway/ssh/HighLevelHostAccessor;", "remoteArchiveLocation", "Lcom/jetbrains/gateway/ssh/deploy/ShellArgument$RemotePath;", "availableSpace", "", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/jetbrains/gateway/ssh/HighLevelHostAccessor;Lcom/jetbrains/gateway/ssh/deploy/ShellArgument$RemotePath;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getArchiveExtension", "", "getDownloadHash", "os", "Lcom/jetbrains/gateway/ssh/DeployTargetOS;", "toString", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nRemoteHostBackendDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteHostBackendDownloader.kt\ncom/jetbrains/gateway/ssh/LinkRemoteHostDownloader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,231:1\n23#2:232\n*S KotlinDebug\n*F\n+ 1 RemoteHostBackendDownloader.kt\ncom/jetbrains/gateway/ssh/LinkRemoteHostDownloader\n*L\n49#1:232\n*E\n"})
public final class LinkRemoteHostDownloader
implements RemoteHostBackendDownloader {
    @NotNull
    private final URI downloadLink;

    public LinkRemoteHostDownloader(@NotNull URI downloadLink) {
        Intrinsics.checkNotNullParameter((Object)downloadLink, (String)"downloadLink");
        this.downloadLink = downloadLink;
    }

    @Override
    @NotNull
    public String getArchiveExtension() {
        String string = UriUtilKt.withFragment((URI)UriUtilKt.withQuery((URI)this.downloadLink, null), null).toASCIIString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toASCIIString(...)");
        return RemoteHostBackendDownloaderKt.access$getArchiveExtension(string);
    }

    @Override
    @NotNull
    public String getDownloadHash(@NotNull DeployTargetOS os) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        MessageDigest digestMethod = MessageDigest.getInstance("SHA-256");
        String stringUri = UriUtilKt.withFragment((URI)UriUtilKt.withQuery((URI)this.downloadLink, null), null).toASCIIString();
        Intrinsics.checkNotNull((Object)stringUri);
        byte[] digest = digestMethod.digest(StringsKt.encodeToByteArray((String)stringUri));
        Object object = new String[]{"/"};
        String lastPathComponent = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)stringUri, (String[])object, (boolean)false, (int)0, (int)6, null));
        Intrinsics.checkNotNull((Object)digest);
        Object hash = object = RemoteHostBackendDownloaderKt.access$combineHumanReadableHash(os, lastPathComponent, digest);
        boolean bl = false;
        LinkRemoteHostDownloader $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(LinkRemoteHostDownloader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("download hash for name: " + lastPathComponent + " is " + (String)hash);
        return object;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object downloadArchiveOnRemote(@NotNull ProgressIndicator var1_1, @NotNull HighLevelHostAccessor var2_2, @NotNull ShellArgument.RemotePath var3_3, long var4_4, @NotNull Continuation<? super Unit> var6_5) {
        if (!(var6_5 instanceof downloadArchiveOnRemote.1)) ** GOTO lbl-1000
        var11_6 = var6_5;
        if ((var11_6.label & -2147483648) != 0) {
            var11_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var6_5){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ LinkRemoteHostDownloader this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.downloadArchiveOnRemote(null, null, null, 0L, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!remoteArchiveLocation.isRooted()) {
                    throw new IllegalStateException(("Download location must be rooted. Download location: '" + remoteArchiveLocation + "'").toString());
                }
                $continuation.L$0 = this;
                $continuation.L$1 = progressIndicator;
                $continuation.L$2 = hostAccessor;
                $continuation.L$3 = remoteArchiveLocation;
                $continuation.J$0 = availableSpace;
                $continuation.label = 1;
                v0 = hostAccessor.canDownload((Continuation<? super HighLevelHostAccessor.DependencyCheckResult>)$continuation);
                if (v0 == var12_8) {
                    return var12_8;
                }
                ** GOTO lbl32
            }
            case 1: {
                availableSpace = $continuation.J$0;
                remoteArchiveLocation = (ShellArgument.RemotePath)$continuation.L$3;
                hostAccessor = (HighLevelHostAccessor)$continuation.L$2;
                progressIndicator = (ProgressIndicator)$continuation.L$1;
                this = (LinkRemoteHostDownloader)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                it = (HighLevelHostAccessor.DependencyCheckResult)v0;
                $i$a$-let-LinkRemoteHostDownloader$downloadArchiveOnRemote$2 = false;
                if (!it.isDependencyPresent()) {
                    throw new IllegalStateException(("Cannot download IDE on the remote host: " + it.getErrorMessage()).toString());
                }
                $continuation.L$0 = this;
                $continuation.L$1 = progressIndicator;
                $continuation.L$2 = hostAccessor;
                $continuation.L$3 = remoteArchiveLocation;
                $continuation.J$0 = availableSpace;
                $continuation.label = 2;
                v1 = hostAccessor.canUnarchive(remoteArchiveLocation, (Continuation<? super HighLevelHostAccessor.DependencyCheckResult>)$continuation);
                if (v1 == var12_8) {
                    return var12_8;
                }
                ** GOTO lbl54
            }
            case 2: {
                availableSpace = $continuation.J$0;
                remoteArchiveLocation = (ShellArgument.RemotePath)$continuation.L$3;
                hostAccessor = (HighLevelHostAccessor)$continuation.L$2;
                progressIndicator = (ProgressIndicator)$continuation.L$1;
                this = (LinkRemoteHostDownloader)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl54:
                // 2 sources

                it = (HighLevelHostAccessor.DependencyCheckResult)v1;
                $i$a$-let-LinkRemoteHostDownloader$downloadArchiveOnRemote$3 = false;
                if (!it.isDependencyPresent()) {
                    throw new IllegalStateException(("Cannot unarchive IDE on the remote host: " + it.getErrorMessage()).toString());
                }
                $continuation.L$0 = this;
                $continuation.L$1 = progressIndicator;
                $continuation.L$2 = hostAccessor;
                $continuation.L$3 = remoteArchiveLocation;
                $continuation.J$0 = availableSpace;
                $continuation.label = 3;
                v2 = hostAccessor.getContentLength(this.downloadLink, (Continuation<? super Long>)$continuation);
                if (v2 == var12_8) {
                    return var12_8;
                }
                ** GOTO lbl76
            }
            case 3: {
                availableSpace = $continuation.J$0;
                remoteArchiveLocation = (ShellArgument.RemotePath)$continuation.L$3;
                hostAccessor = (HighLevelHostAccessor)$continuation.L$2;
                progressIndicator = (ProgressIndicator)$continuation.L$1;
                this = (LinkRemoteHostDownloader)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl76:
                // 2 sources

                if (availableSpace <= (long)4 * (archiveSize = ((Number)v2).longValue())) {
                    throw new IllegalStateException(("Not enough space to download IDE backend. Required space: " + (long)4 * archiveSize).toString());
                }
                tracker = new TransferProgressAdapter(progressIndicator, archiveSize);
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.label = 4;
                v3 = HighLevelHostAccessor.downloadFile$default(hostAccessor, progressIndicator, this.downloadLink, remoteArchiveLocation, tracker, 0L, (Continuation)$continuation, 16, null);
                if (v3 == var12_8) {
                    return var12_8;
                }
                ** GOTO lbl91
            }
            case 4: {
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl91:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public String toString() {
        return "LinkDownloader(" + this.downloadLink + ")";
    }
}

