/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.project;

import com.goide.GoLibrariesUtil;
import com.goide.vgo.VgoRootToModule;
import com.goide.vgo.VgoStatusTracker;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.project.VgoModule;
import com.goide.vgo.project.VgoModuleOrWorkspace;
import com.goide.vgo.project.VgoWorkspace;
import com.goide.vgo.project.VgoWorkspaceModule;
import com.intellij.internal.performanceTests.ProjectInitializationDiagnosticService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VgoModulesRegistry
extends SimpleModificationTracker {
    private static final Comparator<VgoModule> VGO_MODULE_COMPARATOR = Comparator.comparing(VgoModule::getImportPath);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<Module, Map<VirtualFile, VgoModule>> myModules;
    @NotNull
    private final Map<Module, Map<VirtualFile, VgoWorkspace>> myWorkspaces;
    @NotNull
    private volatile List<VgoModule> mySortedVgoModulesList;
    private volatile boolean myRestoredFromEntities;

    public VgoModulesRegistry(@NotNull Project project) {
        if (project == null) {
            VgoModulesRegistry.$$$reportNull$$$0(0);
        }
        this.myModules = new HashMap<Module, Map<VirtualFile, VgoModule>>(1);
        this.myWorkspaces = new HashMap<Module, Map<VirtualFile, VgoWorkspace>>(1);
        this.mySortedVgoModulesList = new ArrayList<VgoModule>();
        this.myRestoredFromEntities = false;
        this.myProject = project;
    }

    public static VgoModulesRegistry getInstance(@NotNull Project project) {
        if (project == null) {
            VgoModulesRegistry.$$$reportNull$$$0(1);
        }
        return (VgoModulesRegistry)((Object)project.getService(VgoModulesRegistry.class));
    }

    @NotNull
    public synchronized Collection<VgoModule> getModules() {
        if (this.myModules.size() == 1) {
            List<VgoModule> list = this.mySortedVgoModulesList;
            if (list == null) {
                VgoModulesRegistry.$$$reportNull$$$0(2);
            }
            return list;
        }
        Collection collection = ((StreamEx)StreamEx.ofValues(this.myModules).flatMap(m -> m.values().stream()).sorted(VGO_MODULE_COMPARATOR)).toCollection(LinkedHashSet::new);
        if (collection == null) {
            VgoModulesRegistry.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public synchronized Collection<VgoModule> getModules(@NotNull Module module) {
        if (module == null) {
            VgoModulesRegistry.$$$reportNull$$$0(4);
        }
        if (this.myModules.size() == 1) {
            List<VgoModule> list = this.mySortedVgoModulesList;
            if (list == null) {
                VgoModulesRegistry.$$$reportNull$$$0(5);
            }
            return list;
        }
        Map map = this.myModules.getOrDefault(module, Collections.emptyMap());
        List list = ((StreamEx)StreamEx.ofValues(map).sorted(VGO_MODULE_COMPARATOR)).toList();
        if (list == null) {
            VgoModulesRegistry.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public synchronized VgoModule findVgoModuleByRoot(@NotNull Module module, @NotNull VirtualFile vgoModuleRoot) {
        Map<VirtualFile, VgoModule> map;
        if (module == null) {
            VgoModulesRegistry.$$$reportNull$$$0(7);
        }
        if (vgoModuleRoot == null) {
            VgoModulesRegistry.$$$reportNull$$$0(8);
        }
        return (map = this.myModules.get(module)) != null ? map.get(vgoModuleRoot) : null;
    }

    @Nullable
    public synchronized VgoWorkspace findWorkspaceByRoot(@NotNull Module module, @NotNull VirtualFile workspaceRoot) {
        Map<VirtualFile, VgoWorkspace> map;
        if (module == null) {
            VgoModulesRegistry.$$$reportNull$$$0(9);
        }
        if (workspaceRoot == null) {
            VgoModulesRegistry.$$$reportNull$$$0(10);
        }
        return (map = this.myWorkspaces.get(module)) != null ? map.get(workspaceRoot) : null;
    }

    @Nullable
    public VgoModule findVgoModule(@NotNull Module module, @Nullable VirtualFile contextFile) {
        VirtualFile vgoModuleRoot;
        if (module == null) {
            VgoModulesRegistry.$$$reportNull$$$0(11);
        }
        if ((vgoModuleRoot = VgoUtil.findModuleRootSkippingVendor(module, contextFile)) == null) {
            return null;
        }
        return this.findVgoModuleByRoot(module, vgoModuleRoot);
    }

    @Nullable
    public VgoModuleOrWorkspace findVgoModuleOrWorkspace(@NotNull Module module, @NotNull VirtualFile file) {
        if (module == null) {
            VgoModulesRegistry.$$$reportNull$$$0(12);
        }
        if (file == null) {
            VgoModulesRegistry.$$$reportNull$$$0(13);
        }
        return "go.work".equals(file.getName()) ? this.findWorkspaceByRoot(module, file.getParent()) : this.findVgoModule(module, file);
    }

    public synchronized void updateModules(@NotNull Module module, @NotNull Collection<VgoRootToModule> vgoModules) {
        if (module == null) {
            VgoModulesRegistry.$$$reportNull$$$0(14);
        }
        if (vgoModules == null) {
            VgoModulesRegistry.$$$reportNull$$$0(15);
        }
        if (module.isDisposed()) {
            this.myModules.remove(module);
            this.myWorkspaces.remove(module);
            this.updateSortedVgoModulesList();
            this.incModificationCount();
            return;
        }
        Map existingModules = this.myModules.computeIfAbsent(module, __ -> new HashMap());
        boolean modified = ContainerUtil.or(vgoModules, vgoModule -> {
            VgoModule existingModule = (VgoModule)existingModules.get(vgoModule.getRoot());
            return !Comparing.equal((Object)vgoModule.getModule(), (Object)existingModule);
        });
        if (modified) {
            VgoStatusTracker.LOG.debug("Updating modules in registry: " + vgoModules);
            this.updateModuleDependencies(module, () -> this.changeRoots(module, vgoModules, existingModules));
        }
        this.myRestoredFromEntities = false;
    }

    private synchronized void changeRoots(@NotNull Module module, @NotNull Collection<VgoRootToModule> vgoModules, @NotNull Map<VirtualFile, VgoModule> existingModules) {
        if (module == null) {
            VgoModulesRegistry.$$$reportNull$$$0(16);
        }
        if (vgoModules == null) {
            VgoModulesRegistry.$$$reportNull$$$0(17);
        }
        if (existingModules == null) {
            VgoModulesRegistry.$$$reportNull$$$0(18);
        }
        for (VgoRootToModule vgoModule : vgoModules) {
            if (vgoModule.getModule() != null) {
                existingModules.put(vgoModule.getRoot(), vgoModule.getModule());
                continue;
            }
            existingModules.remove(vgoModule.getRoot());
        }
        this.recalculateWorkspaces(module);
        this.updateSortedVgoModulesList();
        this.incModificationCount();
    }

    private void recalculateWorkspaces(@NotNull Module module) {
        Map<VirtualFile, VgoModule> vgoModules;
        if (module == null) {
            VgoModulesRegistry.$$$reportNull$$$0(19);
        }
        if ((vgoModules = this.myModules.get(module)) == null) {
            return;
        }
        HashMap<VirtualFile, VgoWorkspace> workspaces = new HashMap<VirtualFile, VgoWorkspace>();
        for (VgoModule vgoModule : vgoModules.values()) {
            if (!(vgoModule instanceof VgoWorkspaceModule)) continue;
            VgoWorkspace workspace = ((VgoWorkspaceModule)vgoModule).getWorkspace();
            workspaces.put(workspace.getRoot(), workspace);
        }
        this.myWorkspaces.put(module, workspaces);
    }

    public synchronized void updateAllModules(@NotNull Module module, @NotNull Collection<VgoRootToModule> vgoModules) {
        if (module == null) {
            VgoModulesRegistry.$$$reportNull$$$0(20);
        }
        if (vgoModules == null) {
            VgoModulesRegistry.$$$reportNull$$$0(21);
        }
        if (module.isDisposed()) {
            this.myModules.remove(module);
            this.myWorkspaces.remove(module);
            this.updateSortedVgoModulesList();
            this.incModificationCount();
            return;
        }
        Map newModules = ContainerUtil.map2MapNotNull(vgoModules, pair -> pair.getModule() != null ? pair : null);
        if (!newModules.equals(this.myModules.get(module))) {
            VgoStatusTracker.LOG.debug("Updating all modules in registry: " + vgoModules);
            this.updateModuleDependencies(module, () -> this.changeRoots(module, newModules));
        }
    }

    public void restoreModules(@NotNull Module module, @NotNull Map<VirtualFile, VgoModule> newModules) {
        if (module == null) {
            VgoModulesRegistry.$$$reportNull$$$0(22);
        }
        if (newModules == null) {
            VgoModulesRegistry.$$$reportNull$$$0(23);
        }
        this.changeRoots(module, newModules);
        this.myRestoredFromEntities = true;
    }

    private synchronized void changeRoots(@NotNull Module module, @NotNull Map<VirtualFile, VgoModule> newModules) {
        if (module == null) {
            VgoModulesRegistry.$$$reportNull$$$0(24);
        }
        if (newModules == null) {
            VgoModulesRegistry.$$$reportNull$$$0(25);
        }
        this.myModules.put(module, newModules);
        this.recalculateWorkspaces(module);
        this.updateSortedVgoModulesList();
        this.incModificationCount();
    }

    private void updateModuleDependencies(@NotNull Module module, Runnable changeRoots) {
        if (module == null) {
            VgoModulesRegistry.$$$reportNull$$$0(26);
        }
        VirtualFile dependenciesRoot = VgoUtil.getDependenciesRoot(this.myProject, module);
        ProjectInitializationDiagnosticService.ActivityTracker activityTracker = ProjectInitializationDiagnosticService.registerTracker((Project)this.myProject, (String)"VgoModulesRegistry.updateModuleDependencies");
        if (dependenciesRoot != null && (!ApplicationManager.getApplication().isHeadlessEnvironment() || CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode())) {
            dependenciesRoot.refresh(true, true, () -> {
                GoLibrariesUtil.updateProjectModel(this.myProject, changeRoots);
                activityTracker.activityFinished();
            });
        } else {
            GoLibrariesUtil.updateProjectModel(this.myProject, changeRoots);
            activityTracker.activityFinished();
        }
    }

    public boolean isRestoredFromEntities() {
        return this.myRestoredFromEntities;
    }

    private void updateSortedVgoModulesList() {
        ArrayList<VgoModule> updatedList = new ArrayList<VgoModule>();
        if (this.myModules.size() == 1) {
            for (Map<VirtualFile, VgoModule> map : this.myModules.values()) {
                updatedList.addAll(map.values());
            }
            updatedList.sort(VGO_MODULE_COMPARATOR);
        }
        this.mySortedVgoModulesList = updatedList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/project/VgoModulesRegistry";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vgoModuleRoot";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaceRoot";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vgoModules";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingModules";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/project/VgoModulesRegistry";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModules";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findVgoModuleByRoot";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findWorkspaceByRoot";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findVgoModule";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findVgoModuleOrWorkspace";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateModules";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "changeRoots";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "recalculateWorkspaces";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateAllModules";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "restoreModules";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "updateModuleDependencies";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

