/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.project;

import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.workspaceModel.entities.VgoDependencyEntity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VgoDependencyImpl
implements VgoDependency {
    @NotNull
    @NlsSafe
    private final String myImportPath;
    @Nullable
    private final String myVersion;
    @Nullable
    private final String myGoVersion;
    @Nullable
    private final String myDirPath;
    @Nullable
    private final VgoDependencyImpl myReplace;
    @Nullable
    private final Boolean myIndirect;
    @Nullable
    private volatile VirtualFile myRoot;
    @Nullable
    private final VgoDependencyImpl myUpdate;
    @Nullable
    private final List<String> myVersions;
    @Nullable
    private final String myDeprecationNotice;
    @Nullable
    private final String myRetractionNotice;

    public VgoDependencyImpl(@NotNull String importPath, @Nullable String version2, @Nullable String goVersion, @Nullable String dirPath, @Nullable VgoDependencyImpl replace, @Nullable Boolean indirect, @Nullable VgoDependencyImpl update, @Nullable List<String> versions, @Nullable String deprecationNotice, @Nullable String retractionNotice) {
        if (importPath == null) {
            VgoDependencyImpl.$$$reportNull$$$0(0);
        }
        this.myImportPath = importPath;
        this.myVersion = version2;
        this.myGoVersion = goVersion;
        this.myDirPath = dirPath;
        this.myReplace = replace;
        this.myIndirect = indirect;
        this.myUpdate = update;
        this.myVersions = versions;
        this.myDeprecationNotice = deprecationNotice;
        this.myRetractionNotice = retractionNotice;
    }

    @Nullable
    public String getDirPath() {
        return this.myReplace != null ? this.myReplace.getDirPath() : this.myDirPath;
    }

    @Override
    @NotNull
    public String getImportPath() {
        String string = this.myImportPath;
        if (string == null) {
            VgoDependencyImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isIndirect() {
        return this.myIndirect != null && this.myIndirect != false;
    }

    @Nullable
    public String getDeprecationNotice() {
        return this.myDeprecationNotice;
    }

    @Nullable
    public String getRetractionNotice() {
        return this.myRetractionNotice;
    }

    @Nullable
    public List<String> getVersions() {
        return this.myVersions;
    }

    @Nullable
    public String getUpdateCandidateVersion() {
        return (String)ObjectUtils.doIfNotNull((Object)this.myUpdate, it -> it.myVersion);
    }

    @Override
    @NotNull
    public String getVersion() {
        String replaced;
        if (this.myReplace != null && StringUtil.isNotEmpty((String)(replaced = this.myReplace.getVersion()))) {
            String string = replaced;
            if (string == null) {
                VgoDependencyImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)this.myVersion);
        if (string == null) {
            VgoDependencyImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getOriginalVersion() {
        String string = StringUtil.notNullize((String)this.myVersion);
        if (string == null) {
            VgoDependencyImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    public String getGoVersion() {
        return this.myGoVersion;
    }

    @Override
    @Nullable
    public VirtualFile getRoot() {
        return this.myReplace != null ? this.myReplace.getRootInner() : this.getRootInner();
    }

    @Nullable
    private VirtualFile getRootInner() {
        if (StringUtil.isEmpty((String)this.myDirPath)) {
            return null;
        }
        VirtualFile root = this.myRoot;
        if (root != null && root.isValid()) {
            return root;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && this.myDirPath.contains("://")) {
            this.myRoot = VirtualFileManager.getInstance().findFileByUrl(this.myDirPath);
            return this.myRoot;
        }
        this.myRoot = LocalFileSystem.getInstance().findFileByPath(this.myDirPath);
        return this.myRoot;
    }

    @Nullable
    public VgoDependencyImpl getReplace() {
        return this.myReplace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VgoDependencyImpl)) {
            return false;
        }
        VgoDependencyImpl that = (VgoDependencyImpl)o;
        return this.myImportPath.equals(that.myImportPath) && Objects.equals(this.myVersion, that.myVersion) && Objects.equals(this.myGoVersion, that.myGoVersion) && Objects.equals(this.myDirPath, that.myDirPath) && Objects.equals(this.myReplace, that.myReplace);
    }

    public int hashCode() {
        return Objects.hash(this.myImportPath, this.myVersion, this.myGoVersion, this.myDirPath, this.myReplace);
    }

    public String toString() {
        return this.myImportPath + "@" + this.myVersion + " (" + this.myDirPath + ")";
    }

    public void fillOutEntityBuilder(@NotNull VgoDependencyEntity.Builder builder, @NotNull VirtualFileUrlManager urlManager) {
        VirtualFileUrl root;
        if (builder == null) {
            VgoDependencyImpl.$$$reportNull$$$0(5);
        }
        if (urlManager == null) {
            VgoDependencyImpl.$$$reportNull$$$0(6);
        }
        VirtualFileUrl virtualFileUrl = root = this.myDirPath != null ? VgoDependencyImpl.dirPathToVirtualFileUrl(this.myDirPath, urlManager) : null;
        if (this.myVersion != null) {
            builder.setVersion(this.myVersion);
        }
        if (this.myGoVersion != null) {
            builder.setGoVersion(this.myGoVersion);
        }
        if (root != null) {
            builder.setRoot(root);
        }
        if (this.myIndirect != null) {
            builder.setIndirect(this.myIndirect);
        }
    }

    @NotNull
    private static VirtualFileUrl dirPathToVirtualFileUrl(@NotNull String dirPath, @NotNull VirtualFileUrlManager urlManager) {
        if (dirPath == null) {
            VgoDependencyImpl.$$$reportNull$$$0(7);
        }
        if (urlManager == null) {
            VgoDependencyImpl.$$$reportNull$$$0(8);
        }
        VirtualFileUrl virtualFileUrl = dirPath.contains("://") ? urlManager.getOrCreateFromUrl(dirPath) : urlManager.getOrCreateFromUrl(VfsUtilCore.pathToUrl((String)dirPath));
        if (virtualFileUrl == null) {
            VgoDependencyImpl.$$$reportNull$$$0(9);
        }
        return virtualFileUrl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/project/VgoDependencyImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/project/VgoDependencyImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalVersion";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "dirPathToVirtualFileUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fillOutEntityBuilder";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dirPathToVirtualFileUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 9 -> new IllegalStateException(string);
        };
    }
}

