/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.mod.inspections;

import com.goide.i18n.GoBundle;
import com.goide.index.GoImportPathPrefixIndexKt;
import com.goide.index.GoImportPathToAliasIndexKt;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.inspections.core.GoProblemsHolderImpl;
import com.goide.quickfix.GoDeleteQuickFix;
import com.goide.util.GoUtil;
import com.goide.vgo.mod.highlighting.VgoAnnotator;
import com.goide.vgo.mod.psi.VgoModuleSpec;
import com.goide.vgo.mod.psi.VgoReplaceDirective;
import com.goide.vgo.mod.psi.VgoReplacement;
import com.goide.vgo.mod.psi.VgoRequireDirective;
import com.goide.vgo.mod.psi.VgoUseDirective;
import com.goide.vgo.mod.psi.VgoVisitor;
import com.goide.vgo.mod.psi.impl.VgoReference;
import com.goide.vgo.mod.quickfix.VgoAddModuleToWorkspaceFix;
import com.goide.vgo.mod.quickfix.VgoDownloadAllMissingModulesFix;
import com.goide.vgo.mod.quickfix.VgoDownloadSingleMissingModuleFix;
import com.goide.vgo.mod.quickfix.VgoSyncDependencyFix;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoModule;
import com.goide.vgo.project.VgoModuleOrWorkspace;
import com.goide.vgo.project.VgoModulesRegistry;
import com.goide.vgo.project.VgoWorkspace;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.CharTrie;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VgoUnusedDependencyInspection
extends LocalInspectionTool {
    private static final Key<Set<String>> MODULES_ROOTS = Key.create((String)"VGO_MODULES_ROOTS");
    private static final Key<VgoModuleOrWorkspace> CURRENT_MODULE_OR_WORKSPACE = Key.create((String)"VGO_MODULE_OR_WORKSPACE");

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder unwrappedHolder, boolean isOnTheFly, final @NotNull LocalInspectionToolSession session) {
        if (unwrappedHolder == null) {
            VgoUnusedDependencyInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            VgoUnusedDependencyInspection.$$$reportNull$$$0(1);
        }
        final GoProblemsHolderImpl holder = new GoProblemsHolderImpl(unwrappedHolder);
        return new VgoVisitor(){

            @Override
            public void visitModuleSpec(@NotNull VgoModuleSpec moduleSpec) {
                boolean isUnused;
                if (moduleSpec == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitModuleSpec(moduleSpec);
                if ("go.work".equals(holder.getFile().getName())) {
                    return;
                }
                PsiElement identifier = moduleSpec.getIdentifier();
                VgoModule currentModuleOrWorkspace = (VgoModule)ObjectUtils.tryCast((Object)this.getCurrentModuleOrWorkspace(), VgoModule.class);
                if (currentModuleOrWorkspace == null) {
                    Module module = GoUtil.module(moduleSpec);
                    GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.go.mod.error.annotator.unresolved.dependency");
                    holder.registerProblem(identifier, (GoInspectionMessage)message, ProblemHighlightType.ERROR, LocalQuickFix.notNullElements((LocalQuickFix)VgoAddModuleToWorkspaceFix.createFix(module, holder.getFile().getVirtualFile())));
                    return;
                }
                VgoRequireDirective requireDirective = (VgoRequireDirective)ObjectUtils.tryCast((Object)moduleSpec.getParent(), VgoRequireDirective.class);
                if (requireDirective == null) {
                    return;
                }
                if (moduleSpec.isIndirect() && Optional.of(moduleSpec.getContainingFile()).map(PsiFile::getOriginalFile).map(PsiFile::getContainingDirectory).map(p -> p.findSubdirectory("vendor")).isPresent()) {
                    return;
                }
                String modulePath = StringUtil.unquoteString((String)identifier.getText());
                if (VgoReference.isLocalPath(moduleSpec)) {
                    return;
                }
                Object problemElement = requireDirective.getLparen() == null ? requireDirective : moduleSpec;
                boolean fixableByDownload = !VgoAnnotator.hasResolvableFileReference(moduleSpec) && !VgoSyncDependencyFix.shouldUpdateVendor(moduleSpec.getProject(), currentModuleOrWorkspace);
                Object[] fixes = fixableByDownload ? 1.createDownloadFixes(modulePath, null) : LocalQuickFix.EMPTY_ARRAY;
                LocalQuickFix[] unusedDepFixes = (LocalQuickFix[])ArrayUtil.prepend((Object)new VgoSyncDependencyFix(moduleSpec.getProject(), currentModuleOrWorkspace, VgoSyncDependencyFix.Action.TIDY), (Object[])fixes);
                boolean bl = isUnused = moduleSpec.isIndirect() ? this.registerProblemIfDependencyIsUnusedTransitively((PsiElement)problemElement, currentModuleOrWorkspace, modulePath, unusedDepFixes) : this.registerProblemIfDependencyIsUnused((PsiElement)problemElement, modulePath, unusedDepFixes);
                if (!isUnused && !VgoAnnotator.hasResolvableFileReference(moduleSpec)) {
                    this.registerMissingDependencyProblem(identifier, currentModuleOrWorkspace, (LocalQuickFix[])fixes);
                }
            }

            @Override
            public void visitReplacement(@NotNull VgoReplacement replacement) {
                VgoModule vgoModule;
                if (replacement == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitReplacement(replacement);
                VgoModuleOrWorkspace moduleOrWorkspace = this.getCurrentModuleOrWorkspace();
                if (moduleOrWorkspace == null || moduleOrWorkspace instanceof VgoModule && (vgoModule = (VgoModule)moduleOrWorkspace).dependenciesAreUnknown()) {
                    return;
                }
                VgoModuleSpec sourceModuleSpec = replacement.getSource();
                String sourceModulePath = StringUtil.unquoteString((String)sourceModuleSpec.getIdentifier().getText());
                if (!ContainerUtil.exists(moduleOrWorkspace.getDependencies(), dep -> Objects.equals(dep.getImportPath(), sourceModulePath))) {
                    Module module = GoUtil.module(replacement);
                    1.processNonLocalModuleIdentifiersInReplacement(replacement, identifier -> holder.registerProblem((PsiElement)identifier, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.go.mod.error.annotator.unresolved.dependency"), ProblemHighlightType.WEAK_WARNING, LocalQuickFix.notNullElements((LocalQuickFix[])new LocalQuickFix[]{VgoAddModuleToWorkspaceFix.createFix(module, holder.getFile().getVirtualFile()), new VgoSyncDependencyFix(replacement.getProject(), moduleOrWorkspace)})));
                    return;
                }
                VgoReplaceDirective replaceDirective = (VgoReplaceDirective)ObjectUtils.tryCast((Object)replacement.getParent(), VgoReplaceDirective.class);
                VgoReplacement problemElement = replaceDirective != null && replaceDirective.getReplacementList().size() == 1 ? replaceDirective : replacement;
                VgoModuleSpec targetModuleSpec = replacement.getTarget();
                String targetModulePath = (String)ObjectUtils.doIfNotNull((Object)targetModuleSpec, moduleSpec -> moduleSpec.getIdentifier().getText());
                boolean fixableByDownload = !VgoAnnotator.hasResolvableFileReference(sourceModuleSpec) && !VgoSyncDependencyFix.shouldUpdateVendor(replacement.getProject(), moduleOrWorkspace) && !VgoReference.isLocalPath(targetModuleSpec);
                Object[] downloadFixes = fixableByDownload ? 1.createDownloadFixes(sourceModulePath, targetModulePath) : LocalQuickFix.EMPTY_ARRAY;
                LocalQuickFix[] unusedDepFixes = (LocalQuickFix[])ArrayUtil.prepend((Object)new GoDeleteQuickFix(() -> GoBundle.message((String)"vgo.fix.delete.replacement", (Object[])new Object[0]), problemElement.getClass()), (Object[])downloadFixes);
                if (!this.registerProblemIfDependencyIsUnusedTransitively(problemElement, moduleOrWorkspace, sourceModulePath, unusedDepFixes) && !VgoAnnotator.hasResolvableFileReference(sourceModuleSpec)) {
                    1.processNonLocalModuleIdentifiersInReplacement(replacement, arg_0 -> this.lambda$visitReplacement$5(moduleOrWorkspace, (LocalQuickFix[])downloadFixes, arg_0));
                }
            }

            @Override
            public void visitUseDirective(@NotNull VgoUseDirective useDirective) {
                if (useDirective == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitUseDirective(useDirective);
                for (VgoModuleSpec moduleSpec : useDirective.getModuleSpecList()) {
                    if (VgoAnnotator.hasResolvableFileReference(moduleSpec)) continue;
                    holder.registerProblem((PsiElement)moduleSpec, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.go.work.error.unresolved.path"), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
                }
            }

            private static void processNonLocalModuleIdentifiersInReplacement(@NotNull VgoReplacement replacement, @NotNull Consumer<PsiElement> consumer) {
                if (replacement == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (consumer == null) {
                    1.$$$reportNull$$$0(4);
                }
                ((StreamEx)StreamEx.of((Object[])new VgoModuleSpec[]{replacement.getSource(), replacement.getTarget()}).nonNull().filter(moduleSpec -> !VgoReference.isLocalPath(moduleSpec))).map(moduleSpec -> moduleSpec.getIdentifier()).forEach(consumer);
            }

            @NotNull
            private static @NotNull LocalQuickFix @NotNull [] createDownloadFixes(@NlsSafe @NotNull String modulePath, @NlsSafe @Nullable String replacementModulePath) {
                if (modulePath == null) {
                    1.$$$reportNull$$$0(5);
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new VgoDownloadSingleMissingModuleFix(modulePath, replacementModulePath), new VgoDownloadAllMissingModulesFix()};
                if (localQuickFixArray == null) {
                    1.$$$reportNull$$$0(6);
                }
                return localQuickFixArray;
            }

            private void registerMissingDependencyProblem(@NotNull PsiElement problemElement, @NotNull VgoModuleOrWorkspace moduleOrWorkspace, @NotNull @NotNull LocalQuickFix @NotNull [] downloadFixes) {
                if (problemElement == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (moduleOrWorkspace == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (downloadFixes == null) {
                    1.$$$reportNull$$$0(9);
                }
                holder.registerProblem(problemElement, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.go.mod.error.annotator.missing.dependency"), ProblemHighlightType.ERROR, (LocalQuickFix[])ArrayUtil.prepend((Object)new VgoSyncDependencyFix(problemElement.getProject(), moduleOrWorkspace), (Object[])downloadFixes));
            }

            private boolean registerProblemIfDependencyIsUnused(@NotNull PsiElement problemElement, @NotNull String modulePath, @NotNull @NotNull LocalQuickFix @NotNull [] fixes) {
                if (problemElement == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (modulePath == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (fixes == null) {
                    1.$$$reportNull$$$0(12);
                }
                if (this.checkIfDependencyIsUnused(modulePath)) {
                    holder.registerProblem(problemElement, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.inspection.problem.unused.dependency"), ProblemHighlightType.LIKE_UNUSED_SYMBOL, fixes);
                    return true;
                }
                return false;
            }

            private boolean registerProblemIfDependencyIsUnusedTransitively(@NotNull PsiElement problemElement, @NotNull VgoModuleOrWorkspace moduleOrWorkspace, @NotNull String modulePath, @NotNull @NotNull LocalQuickFix @NotNull [] fixes) {
                Project project;
                ThreeState isUnused;
                if (problemElement == null) {
                    1.$$$reportNull$$$0(13);
                }
                if (moduleOrWorkspace == null) {
                    1.$$$reportNull$$$0(14);
                }
                if (modulePath == null) {
                    1.$$$reportNull$$$0(15);
                }
                if (fixes == null) {
                    1.$$$reportNull$$$0(16);
                }
                if ((isUnused = this.checkIfDependencyIsUnusedTransitively(project = holder.getProject(), moduleOrWorkspace, modulePath)) == ThreeState.YES) {
                    holder.registerProblem(problemElement, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.inspection.problem.unused.dependency"), ProblemHighlightType.LIKE_UNUSED_SYMBOL, fixes);
                    return true;
                }
                if (isUnused == ThreeState.UNSURE) {
                    LocalQuickFix[] uncertaintyFixes = 1.prioritizeDownloadAllFix(project, fixes, moduleOrWorkspace);
                    holder.registerProblem(problemElement, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.inspection.problem.possibly.unused.dependency"), ProblemHighlightType.WEAK_WARNING, uncertaintyFixes);
                    return true;
                }
                return false;
            }

            private static LocalQuickFix @NotNull [] prioritizeDownloadAllFix(@NotNull Project project, @NotNull @NotNull LocalQuickFix @NotNull [] downloadFixes, @NotNull VgoModuleOrWorkspace moduleOrWorkspace) {
                VgoModule vgoModule;
                if (project == null) {
                    1.$$$reportNull$$$0(17);
                }
                if (moduleOrWorkspace == null) {
                    1.$$$reportNull$$$0(18);
                }
                if (downloadFixes == null) {
                    1.$$$reportNull$$$0(19);
                }
                VgoDownloadAllMissingModulesFix highPriorityFix = new VgoDownloadAllMissingModulesFix(PriorityAction.Priority.HIGH);
                int downloadAllFixIndex = ArrayUtil.indexOf((Object[])downloadFixes, null, (fix, __) -> fix instanceof VgoDownloadAllMissingModulesFix);
                if (downloadAllFixIndex > 0) {
                    downloadFixes = (LocalQuickFix[])downloadFixes.clone();
                    downloadFixes[downloadAllFixIndex] = highPriorityFix;
                }
                if (!(downloadAllFixIndex >= 0 || moduleOrWorkspace instanceof VgoModule && (vgoModule = (VgoModule)moduleOrWorkspace).hasVendor(project))) {
                    downloadFixes = (LocalQuickFix[])ArrayUtil.prepend((Object)highPriorityFix, (Object[])downloadFixes);
                }
                if (downloadFixes == null) {
                    1.$$$reportNull$$$0(20);
                }
                return downloadFixes;
            }

            private boolean checkIfDependencyIsUnused(@NotNull String unquotedDependencyName) {
                VirtualFile currentFile;
                if (unquotedDependencyName == null) {
                    1.$$$reportNull$$$0(21);
                }
                if ((currentFile = holder.getFile().getVirtualFile()) == null) {
                    return false;
                }
                VirtualFile moduleRootDirectory = currentFile.getParent();
                Set<String> moduleRoots = this.getModulesRoots();
                if (moduleRoots == null) {
                    return false;
                }
                GlobalSearchScope scope = GlobalSearchScopesCore.directoryScope((Project)holder.getProject(), (VirtualFile)moduleRootDirectory, (boolean)true);
                return GoImportPathPrefixIndexKt.processFilesContainingImportPrefix(scope, unquotedDependencyName, (Processor<? super VirtualFile>)((Processor)file -> {
                    for (VirtualFile dir = file.getParent(); dir != null; dir = dir.getParent()) {
                        String path = dir.getPath();
                        if (!moduleRoots.contains(path)) continue;
                        return !moduleRootDirectory.getPath().equals(path);
                    }
                    return true;
                }));
            }

            @NotNull
            private ThreeState checkIfDependencyIsUnusedTransitively(@NotNull Project project, @NotNull VgoModuleOrWorkspace moduleOrWorkspace, @NotNull String searchedModule) {
                VgoModule vgoModule;
                if (project == null) {
                    1.$$$reportNull$$$0(22);
                }
                if (moduleOrWorkspace == null) {
                    1.$$$reportNull$$$0(23);
                }
                if (searchedModule == null) {
                    1.$$$reportNull$$$0(24);
                }
                MyModuleDependenciesHolder.Result calculationResult = (MyModuleDependenciesHolder.Result)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)session, () -> CachedValueProvider.Result.create((Object)new MyModuleDependenciesHolder(project, moduleOrWorkspace).collectUsedModules(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
                if (calculationResult.usedModules.contains(searchedModule)) {
                    ThreeState threeState = ThreeState.NO;
                    if (threeState == null) {
                        1.$$$reportNull$$$0(25);
                    }
                    return threeState;
                }
                ThreeState threeState = calculationResult.haveMissingPackages || moduleOrWorkspace instanceof VgoModule && (vgoModule = (VgoModule)moduleOrWorkspace).hasVendor(project) ? ThreeState.UNSURE : ThreeState.YES;
                if (threeState == null) {
                    1.$$$reportNull$$$0(26);
                }
                return threeState;
            }

            @Nullable
            private Set<String> getModulesRoots() {
                Set modulesRoots = (Set)session.getUserData(MODULES_ROOTS);
                if (modulesRoots == null) {
                    Module module = GoUtil.module((PsiElement)holder.getFile());
                    if (module == null) {
                        return null;
                    }
                    modulesRoots = ContainerUtil.map2Set(VgoModulesRegistry.getInstance(holder.getProject()).getModules(module), m -> m.getRoot().getPath());
                    session.putUserData(MODULES_ROOTS, (Object)modulesRoots);
                }
                return modulesRoots;
            }

            @Nullable
            private VgoModuleOrWorkspace getCurrentModuleOrWorkspace() {
                VgoModuleOrWorkspace moduleOrWorkspace = (VgoModuleOrWorkspace)session.getUserData(CURRENT_MODULE_OR_WORKSPACE);
                if (moduleOrWorkspace == null) {
                    PsiFile holderFile = holder.getFile();
                    Module module = GoUtil.module((PsiElement)holderFile);
                    if (module == null) {
                        return null;
                    }
                    moduleOrWorkspace = VgoModulesRegistry.getInstance(holder.getProject()).findVgoModuleOrWorkspace(module, holderFile.getVirtualFile());
                    session.putUserData(CURRENT_MODULE_OR_WORKSPACE, (Object)moduleOrWorkspace);
                }
                return moduleOrWorkspace;
            }

            private /* synthetic */ void lambda$visitReplacement$5(VgoModuleOrWorkspace moduleOrWorkspace, LocalQuickFix[] downloadFixes, PsiElement identifier) {
                this.registerMissingDependencyProblem(identifier, moduleOrWorkspace, downloadFixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 6, 20, 25, 26 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "moduleSpec";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "replacement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "useDirective";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "consumer";
                        break;
                    }
                    case 5: 
                    case 11: 
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "modulePath";
                        break;
                    }
                    case 6: 
                    case 20: 
                    case 25: 
                    case 26: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/goide/vgo/mod/inspections/VgoUnusedDependencyInspection$1";
                        break;
                    }
                    case 7: 
                    case 10: 
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "problemElement";
                        break;
                    }
                    case 8: 
                    case 14: 
                    case 18: 
                    case 23: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "moduleOrWorkspace";
                        break;
                    }
                    case 9: 
                    case 19: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "downloadFixes";
                        break;
                    }
                    case 12: 
                    case 16: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fixes";
                        break;
                    }
                    case 17: 
                    case 22: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 21: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "unquotedDependencyName";
                        break;
                    }
                    case 24: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "searchedModule";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/goide/vgo/mod/inspections/VgoUnusedDependencyInspection$1";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createDownloadFixes";
                        break;
                    }
                    case 20: {
                        objectArray = objectArray2;
                        objectArray2[1] = "prioritizeDownloadAllFix";
                        break;
                    }
                    case 25: 
                    case 26: {
                        objectArray = objectArray2;
                        objectArray2[1] = "checkIfDependencyIsUnusedTransitively";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitModuleSpec";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "visitReplacement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "visitUseDirective";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "processNonLocalModuleIdentifiersInReplacement";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "createDownloadFixes";
                        break;
                    }
                    case 6: 
                    case 20: 
                    case 25: 
                    case 26: {
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "registerMissingDependencyProblem";
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "registerProblemIfDependencyIsUnused";
                        break;
                    }
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: {
                        objectArray = objectArray;
                        objectArray[2] = "registerProblemIfDependencyIsUnusedTransitively";
                        break;
                    }
                    case 17: 
                    case 18: 
                    case 19: {
                        objectArray = objectArray;
                        objectArray[2] = "prioritizeDownloadAllFix";
                        break;
                    }
                    case 21: {
                        objectArray = objectArray;
                        objectArray[2] = "checkIfDependencyIsUnused";
                        break;
                    }
                    case 22: 
                    case 23: 
                    case 24: {
                        objectArray = objectArray;
                        objectArray[2] = "checkIfDependencyIsUnusedTransitively";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 6, 20, 25, 26 -> new IllegalStateException(string);
                };
            }
        };
    }

    @Deprecated(forRemoval=true)
    public static boolean hasIndirectComment(@NotNull VgoModuleSpec moduleSpec) {
        if (moduleSpec == null) {
            VgoUnusedDependencyInspection.$$$reportNull$$$0(2);
        }
        return moduleSpec.isIndirect();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unwrappedHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSpec";
                break;
            }
        }
        objectArray2[1] = "com/goide/vgo/mod/inspections/VgoUnusedDependencyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasIndirectComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyModuleDependenciesHolder {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VgoModuleOrWorkspace myModuleOrWorkspace;
        @Nullable
        private final VirtualFile myVendorDir;
        @NotNull
        private final Int2ObjectMap<VirtualFile> myDependencyDirMap;
        @NotNull
        private final CharTrie myTrie;
        @NotNull
        private final Queue<String> mySearchQueue;
        @NotNull
        private final Set<String> myUsedPackages;
        private boolean haveMissingPackages;
        private static final Logger LOG = Logger.getInstance(MyModuleDependenciesHolder.class);

        private MyModuleDependenciesHolder(@NotNull Project project, @NotNull VgoModuleOrWorkspace moduleOrWorkspace) {
            if (project == null) {
                MyModuleDependenciesHolder.$$$reportNull$$$0(0);
            }
            if (moduleOrWorkspace == null) {
                MyModuleDependenciesHolder.$$$reportNull$$$0(1);
            }
            this.myDependencyDirMap = new Int2ObjectOpenHashMap();
            this.myTrie = new CharTrie();
            this.mySearchQueue = new ArrayDeque<String>();
            this.myUsedPackages = new HashSet<String>();
            this.haveMissingPackages = false;
            this.myProject = project;
            this.myModuleOrWorkspace = moduleOrWorkspace;
            VirtualFile moduleOrWorkspaceRoot = moduleOrWorkspace.getRoot();
            VirtualFile vendorFile = moduleOrWorkspaceRoot.findChild("vendor");
            this.myVendorDir = vendorFile != null && vendorFile.isDirectory() ? vendorFile : null;
        }

        @NotNull
        private Result collectUsedModules() {
            VgoModuleOrWorkspace vgoModuleOrWorkspace = this.myModuleOrWorkspace;
            if (vgoModuleOrWorkspace instanceof VgoDependency) {
                VgoDependency vgoDependency = (VgoDependency)((Object)vgoModuleOrWorkspace);
                this.addDependencyToTrieAndMap(vgoDependency);
            }
            for (VgoDependency dep : this.myModuleOrWorkspace.getDependencies()) {
                this.addDependencyToTrieAndMap(dep);
            }
            Collection<VgoDependency> mainModules = this.myModuleOrWorkspace instanceof VgoWorkspace ? ((VgoWorkspace)this.myModuleOrWorkspace).getMainModules() : Collections.singleton((VgoModule)this.myModuleOrWorkspace);
            Collection excludedDirs = ContainerUtil.subtract((Collection)ContainerUtil.map2Set(VgoModulesRegistry.getInstance(this.myProject).getModules(), mod -> mod.getRoot()), (Collection)ContainerUtil.map(mainModules, mainModule -> mainModule.getRoot()));
            long time = TimeoutUtil.measureExecutionTime(() -> {
                for (VgoDependency mainModule : mainModules) {
                    VirtualFile root = mainModule.getRoot();
                    if (root == null) continue;
                    this.scanDirectory(root, filtered -> !excludedDirs.contains(filtered) && !filtered.equals(this.myVendorDir));
                }
                this.findDependencies();
            });
            LOG.debug(String.format("collectUsedModules took %d ms", time));
            return new Result(this.calcUsedModules(), this.haveMissingPackages);
        }

        private void addDependencyToTrieAndMap(@NotNull VgoDependency dep) {
            if (dep == null) {
                MyModuleDependenciesHolder.$$$reportNull$$$0(2);
            }
            VirtualFile root = null;
            if (this.myVendorDir != null) {
                root = this.myVendorDir.findFileByRelativePath(dep.getImportPath());
            }
            if (root == null) {
                root = dep.getRoot();
            }
            int hashCode = this.myTrie.getHashCode((CharSequence)dep.getImportPath());
            this.myDependencyDirMap.put(hashCode, (Object)root);
        }

        private void scanDirectory(@NotNull VirtualFile dir, @Nullable VirtualFileFilter filter) {
            if (dir == null) {
                MyModuleDependenciesHolder.$$$reportNull$$$0(3);
            }
            VfsUtilCore.iterateChildrenRecursively((VirtualFile)dir, (VirtualFileFilter)filter, file -> {
                this.scanFile(file);
                return true;
            });
        }

        private void findDependencies() {
            while (!this.mySearchQueue.isEmpty()) {
                Pair<VirtualFile, Integer> moduleInfo;
                String currentPkg = this.mySearchQueue.remove();
                if (!this.myUsedPackages.add(currentPkg) || (moduleInfo = this.findModuleDirectoryAndNameLength(currentPkg)) == null) continue;
                if (moduleInfo.first == null) {
                    this.haveMissingPackages = true;
                    continue;
                }
                VirtualFile pkgDir = ((VirtualFile)moduleInfo.first).findFileByRelativePath(currentPkg.substring((Integer)moduleInfo.second));
                if (pkgDir == null) continue;
                for (VirtualFile file : pkgDir.getChildren()) {
                    this.scanFile(file);
                }
            }
        }

        private void scanFile(VirtualFile file) {
            ProgressManager.checkCanceled();
            GoImportPathToAliasIndexKt.processImportPathsInFile(this.myProject, file, (Processor<? super String>)new CommonProcessors.CollectProcessor(this.mySearchQueue));
        }

        @Nullable
        private @Nullable Pair<@Nullable VirtualFile, Integer> findModuleDirectoryAndNameLength(@NotNull String packageName) {
            boolean prependSlash;
            String element;
            int newIndex;
            if (packageName == null) {
                MyModuleDependenciesHolder.$$$reportNull$$$0(4);
            }
            Iterable packageNameElements = StringUtil.tokenize((String)packageName, (String)"/");
            int index = 0;
            int length = 0;
            Iterator iterator = packageNameElements.iterator();
            while (iterator.hasNext() && (newIndex = this.findElementInTrie(index, element = (String)iterator.next(), prependSlash = length != 0)) != 0) {
                index = newIndex;
                if (prependSlash) {
                    ++length;
                }
                length += element.length();
            }
            if (index == 0) {
                return null;
            }
            VirtualFile dependency = (VirtualFile)this.myDependencyDirMap.getOrDefault(index, (Object)NullVirtualFile.INSTANCE);
            if (NullVirtualFile.INSTANCE.equals(dependency)) {
                return null;
            }
            return Pair.create((Object)dependency, (Object)length);
        }

        private int findElementInTrie(int index, @NotNull String element, boolean prependSlash) {
            if (element == null) {
                MyModuleDependenciesHolder.$$$reportNull$$$0(5);
            }
            if (prependSlash && (index = this.myTrie.findSubNode(index, '/')) == 0) {
                return 0;
            }
            for (int i = 0; i < element.length(); ++i) {
                if ((index = this.myTrie.findSubNode(index, element.charAt(i))) != 0) continue;
                return 0;
            }
            return index;
        }

        @NotNull
        private Set<String> calcUsedModules() {
            HashSet<String> usedModules = new HashSet<String>();
            for (String pkg : this.myUsedPackages) {
                Pair<VirtualFile, Integer> moduleInfo = this.findModuleDirectoryAndNameLength(pkg);
                if (moduleInfo == null) continue;
                usedModules.add(pkg.substring(0, (Integer)moduleInfo.second));
            }
            HashSet<String> hashSet = usedModules;
            if (hashSet == null) {
                MyModuleDependenciesHolder.$$$reportNull$$$0(6);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleOrWorkspace";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dep";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/vgo/mod/inspections/VgoUnusedDependencyInspection$MyModuleDependenciesHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/vgo/mod/inspections/VgoUnusedDependencyInspection$MyModuleDependenciesHolder";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calcUsedModules";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addDependencyToTrieAndMap";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "scanDirectory";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findModuleDirectoryAndNameLength";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findElementInTrie";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }

        private static class Result {
            @NotNull
            private final Set<String> usedModules;
            private final boolean haveMissingPackages;

            private Result(@NotNull Set<String> usedModules, boolean haveMissingPackages) {
                if (usedModules == null) {
                    Result.$$$reportNull$$$0(0);
                }
                this.usedModules = usedModules;
                this.haveMissingPackages = haveMissingPackages;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usedModules", "com/goide/vgo/mod/inspections/VgoUnusedDependencyInspection$MyModuleDependenciesHolder$Result", "<init>"));
            }
        }
    }
}

