/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.mod.highlighting;

import com.goide.highlighting.GoSyntaxHighlightingColors;
import com.goide.vgo.mod.highlighting.VgoSyntaxHighlightingColors;
import com.goide.vgo.mod.psi.VgoModuleDirective;
import com.goide.vgo.mod.psi.VgoModuleSpec;
import com.goide.vgo.mod.psi.VgoRetractDirective;
import com.goide.vgo.mod.psi.VgoRetractSpec;
import com.goide.vgo.mod.psi.VgoToolchainDirective;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public final class VgoHighlightingAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        VgoToolchainDirective toolchainDirective;
        PsiElement version3;
        if (element == null) {
            VgoHighlightingAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            VgoHighlightingAnnotator.$$$reportNull$$$0(1);
        }
        if (element instanceof VgoModuleDirective) {
            PsiElement moduleName = ((VgoModuleDirective)element).getIdentifierOrString();
            if (moduleName != null) {
                VgoHighlightingAnnotator.setHighlighting(moduleName, holder, GoSyntaxHighlightingColors.PACKAGE);
            }
        } else if (element instanceof VgoModuleSpec) {
            VgoHighlightingAnnotator.setHighlighting(((VgoModuleSpec)element).getIdentifier(), holder, DefaultLanguageHighlighterColors.STRING);
            PsiElement version4 = ((VgoModuleSpec)element).getModuleVersion();
            if (version4 != null) {
                VgoHighlightingAnnotator.setHighlighting(version4, holder, VgoSyntaxHighlightingColors.MODULE_VERSION);
            }
        } else if (element instanceof VgoRetractDirective) {
            for (VgoRetractSpec spec : ((VgoRetractDirective)element).getRetractSpecList()) {
                if (spec.getVersion() != null) {
                    VgoHighlightingAnnotator.setHighlighting(spec.getVersion(), holder, VgoSyntaxHighlightingColors.MODULE_VERSION);
                    continue;
                }
                if (spec.getVersionRange() == null) continue;
                spec.getVersionRange().getVersions().forEach(version2 -> VgoHighlightingAnnotator.setHighlighting(version2, holder, VgoSyntaxHighlightingColors.MODULE_VERSION));
            }
        } else if (element instanceof VgoToolchainDirective && (version3 = (toolchainDirective = (VgoToolchainDirective)element).getToolchainVersion()) != null) {
            VgoHighlightingAnnotator.setHighlighting(version3, holder, version3.textMatches((CharSequence)"default") ? GoSyntaxHighlightingColors.STRING : GoSyntaxHighlightingColors.NUMBER);
        }
    }

    private static void setHighlighting(@NotNull PsiElement element, @NotNull AnnotationHolder holder, @NotNull TextAttributesKey key) {
        if (element == null) {
            VgoHighlightingAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            VgoHighlightingAnnotator.$$$reportNull$$$0(3);
        }
        if (key == null) {
            VgoHighlightingAnnotator.$$$reportNull$$$0(4);
        }
        AnnotationBuilder annotationBuilder = ApplicationManager.getApplication().isUnitTestMode() ? holder.newAnnotation(HighlightSeverity.INFORMATION, key.getExternalName()) : holder.newSilentAnnotation(HighlightSeverity.INFORMATION);
        annotationBuilder.range(element).textAttributes(key).create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/goide/vgo/mod/highlighting/VgoHighlightingAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setHighlighting";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

