/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo;

import com.goide.project.GoProjectLifecycle;
import com.goide.vgo.VgoModFileIsAbsentNotificationManager;
import com.goide.vgo.VgoUtilKt;
import com.goide.vgo.configuration.VgoEnvironmentVariable;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/goide/vgo/VgoInitialConfigurator;", "", "()V", "patchGoProxyInChina", "", "project", "Lcom/intellij/openapi/project/Project;", "startModFileIsAbsentNotificationManagerLater", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.go.impl"})
public final class VgoInitialConfigurator {
    @NotNull
    public static final VgoInitialConfigurator INSTANCE = new VgoInitialConfigurator();

    private VgoInitialConfigurator() {
    }

    @JvmStatic
    public static final void patchGoProxyInChina(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VgoProjectSettings vgoProjectSettings = VgoProjectSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)vgoProjectSettings, (String)"getInstance(...)");
        VgoProjectSettings vgoProjectSettings2 = vgoProjectSettings;
        if (!vgoProjectSettings2.isIntegrationEnabled()) {
            return;
        }
        String string = VgoEnvironmentVariable.GOPROXY.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String systemGoProxy = VgoUtilKt.getVariableFromSystemEnvironment(string);
        if (systemGoProxy != null) {
            return;
        }
        boolean enabled = AdvancedSettings.Companion.getBoolean("go.automatic.goproxy.switch");
        boolean isMainlandChinaLocaleSet = Intrinsics.areEqual((Object)Locale.CHINA.getCountry(), (Object)Locale.getDefault().getCountry());
        if (isMainlandChinaLocaleSet && enabled) {
            vgoProjectSettings2.setAutoConfiguredGoProxy("https://goproxy.cn,direct");
        }
    }

    @JvmStatic
    public static final void startModFileIsAbsentNotificationManagerLater(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        GoProjectLifecycle.runWhenProjectSetupFinished(project, () -> VgoInitialConfigurator.startModFileIsAbsentNotificationManagerLater$lambda$0(project, parentDisposable));
    }

    private static final void startModFileIsAbsentNotificationManagerLater$lambda$0(Project $project, Disposable $parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$parentDisposable, (String)"$parentDisposable");
        new VgoModFileIsAbsentNotificationManager($project, $parentDisposable);
    }
}

