/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo;

import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoDependencyImpl;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonToken;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.io.JsonUtil;

public class GoListOutputParser {
    private final Function<String, String> myDirMapper;

    public GoListOutputParser() {
        this(Function.identity());
    }

    public GoListOutputParser(@NotNull Function<@Nullable String, @Nullable String> dirMapper) {
        if (dirMapper == null) {
            GoListOutputParser.$$$reportNull$$$0(0);
        }
        this.myDirMapper = dirMapper;
    }

    @NotNull
    public BuildList readDependencies(@NotNull String jsonText) throws JsonParseException {
        if (jsonText == null) {
            GoListOutputParser.$$$reportNull$$$0(1);
        }
        ArrayList<VgoDependency> mainModules = new ArrayList<VgoDependency>();
        ArrayList<VgoDependency> dependencies = new ArrayList<VgoDependency>();
        try (JsonReaderEx reader = new JsonReaderEx((CharSequence)jsonText);){
            reader.setLenient(true);
            while (reader.peek() != JsonToken.END_DOCUMENT) {
                if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                    reader.nextString();
                    continue;
                }
                Pair<VgoDependencyImpl, Boolean> pair = this.readDependency(reader);
                if (pair == null) continue;
                VgoDependency dependency = (VgoDependency)pair.first;
                ((Boolean)pair.second != false ? mainModules : dependencies).add(dependency);
            }
        }
        return new BuildList(mainModules, dependencies);
    }

    @Nullable
    private Pair<VgoDependencyImpl, Boolean> readDependency(@NotNull JsonReaderEx reader) {
        if (reader == null) {
            GoListOutputParser.$$$reportNull$$$0(2);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            return null;
        }
        reader.beginObject();
        String path = null;
        String version2 = null;
        String goVersion = null;
        String dir = null;
        VgoDependencyImpl replace = null;
        boolean main = false;
        boolean indirect = false;
        VgoDependencyImpl update = null;
        List versions = null;
        String retractedNotice = null;
        String deprecationNotice = null;
        block26: while (reader.hasNext()) {
            String name = reader.nextNameOrNull();
            if (name == null) {
                reader.skipValue();
                continue;
            }
            switch (name) {
                case "Path": {
                    path = reader.nextString();
                    continue block26;
                }
                case "Version": {
                    version2 = reader.nextString();
                    continue block26;
                }
                case "Dir": {
                    dir = reader.nextString();
                    continue block26;
                }
                case "Replace": {
                    replace = (VgoDependencyImpl)ObjectUtils.doIfNotNull(this.readDependency(reader), it -> (VgoDependencyImpl)it.first);
                    continue block26;
                }
                case "Main": {
                    main = reader.nextBoolean();
                    continue block26;
                }
                case "Indirect": {
                    indirect = reader.nextBoolean();
                    continue block26;
                }
                case "GoVersion": {
                    goVersion = reader.nextString();
                    continue block26;
                }
                case "Deprecated": {
                    deprecationNotice = reader.nextString();
                    continue block26;
                }
                case "Retracted": {
                    retractedNotice = String.join((CharSequence)"\\n", JsonUtil.nextStringList((JsonReaderEx)reader));
                    continue block26;
                }
                case "Versions": {
                    versions = JsonUtil.nextStringList((JsonReaderEx)reader);
                    continue block26;
                }
                case "Update": {
                    update = (VgoDependencyImpl)ObjectUtils.doIfNotNull(this.readDependency(reader), it -> (VgoDependencyImpl)it.first);
                    continue block26;
                }
            }
            reader.skipValue();
        }
        while (reader.peek() != JsonToken.END_DOCUMENT) {
            if (reader.peek() == JsonToken.END_OBJECT) {
                reader.endObject();
                break;
            }
            reader.nextString();
        }
        if (path == null) {
            return null;
        }
        return Pair.create((Object)new VgoDependencyImpl(path, version2, goVersion, PathUtil.toSystemIndependentName((String)this.myDirMapper.apply(dir)), replace, indirect, update, versions, deprecationNotice, retractedNotice), (Object)main);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirMapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        objectArray2[1] = "com/goide/vgo/GoListOutputParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readDependencies";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readDependency";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class BuildList {
        @NotNull
        private final List<VgoDependency> myMainModules;
        @NotNull
        private final List<VgoDependency> myDependencies;

        public BuildList(@NotNull List<VgoDependency> mainModules, @NotNull List<VgoDependency> dependencies) {
            if (mainModules == null) {
                BuildList.$$$reportNull$$$0(0);
            }
            if (dependencies == null) {
                BuildList.$$$reportNull$$$0(1);
            }
            this.myMainModules = mainModules;
            this.myDependencies = dependencies;
        }

        @NotNull
        public List<VgoDependency> getMainModules() {
            List<VgoDependency> list = this.myMainModules;
            if (list == null) {
                BuildList.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        public List<VgoDependency> getDependencies() {
            List<VgoDependency> list = this.myDependencies;
            if (list == null) {
                BuildList.$$$reportNull$$$0(3);
            }
            return list;
        }

        @NotNull
        public List<VgoDependency> getAllModules() {
            List list = ContainerUtil.concat(this.myMainModules, this.myDependencies);
            if (list == null) {
                BuildList.$$$reportNull$$$0(4);
            }
            return list;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BuildList buildList = (BuildList)o;
            return this.myMainModules.equals(buildList.myMainModules) && this.myDependencies.equals(buildList.myDependencies);
        }

        public int hashCode() {
            return Objects.hash(this.myMainModules, this.myDependencies);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mainModules";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/vgo/GoListOutputParser$BuildList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/vgo/GoListOutputParser$BuildList";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMainModules";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllModules";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

