/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vendor;

import com.goide.GoPluginDisposable;
import com.goide.sdk.GoSdkUtil;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
public final class GoVendoredFileChangeTracker {
    public static final Key<Boolean> VENDORED_FILE_CHANGE_TRACKER_TEST_FLAG = Key.create((String)"VENDORED_FILE_CHANGE_TRACKER");
    private final SingleAlarm myCheckingQueue;
    private final Set<VirtualFile> myFilesToCheck;
    private final Set<VirtualFile> myEditedVendoredFiles;
    private final Project myProject;

    @NotNull
    public static GoVendoredFileChangeTracker getInstance(@NotNull Project project) {
        if (project == null) {
            GoVendoredFileChangeTracker.$$$reportNull$$$0(0);
        }
        GoVendoredFileChangeTracker goVendoredFileChangeTracker = (GoVendoredFileChangeTracker)project.getService(GoVendoredFileChangeTracker.class);
        if (goVendoredFileChangeTracker == null) {
            GoVendoredFileChangeTracker.$$$reportNull$$$0(1);
        }
        return goVendoredFileChangeTracker;
    }

    public GoVendoredFileChangeTracker(@NotNull Project project) {
        if (project == null) {
            GoVendoredFileChangeTracker.$$$reportNull$$$0(2);
        }
        this.myFilesToCheck = Collections.synchronizedSet(new HashSet());
        this.myEditedVendoredFiles = Collections.synchronizedSet(new HashSet());
        this.myProject = project;
        this.myCheckingQueue = new SingleAlarm(this::checkFiles, 500, Alarm.ThreadToUse.POOLED_THREAD, GoPluginDisposable.getInstance(project));
    }

    public boolean isEditedVendoredFile(@NotNull VirtualFile file) {
        if (file == null) {
            GoVendoredFileChangeTracker.$$$reportNull$$$0(3);
        }
        return this.myEditedVendoredFiles.contains(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFiles() {
        VirtualFile[] files;
        Set<VirtualFile> set = this.myFilesToCheck;
        synchronized (set) {
            files = this.myFilesToCheck.toArray(VirtualFile.EMPTY_ARRAY);
            this.myFilesToCheck.clear();
        }
        NonBlockingReadAction readAction = ReadAction.nonBlocking(() -> {
            ArrayList<VirtualFile> newEditedVendoredFiles = new ArrayList<VirtualFile>();
            Collection<Module> modules = GoSdkUtil.getGoModules(this.myProject);
            if (modules.isEmpty()) {
                return Collections.emptyList();
            }
            block0: for (VirtualFile file : files) {
                for (Module module : modules) {
                    if (!GoVendoringUtil.isVendoredFile(file, module)) continue;
                    newEditedVendoredFiles.add(file);
                    continue block0;
                }
            }
            return newEditedVendoredFiles;
        }).expireWith(GoPluginDisposable.getInstance(this.myProject));
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            List editedVendoredFiles = (List)readAction.executeSynchronously();
            this.myEditedVendoredFiles.addAll(editedVendoredFiles);
        } else {
            readAction.finishOnUiThread(ModalityState.defaultModalityState(), newFiles -> {
                if (!newFiles.isEmpty()) {
                    this.myEditedVendoredFiles.addAll((Collection<VirtualFile>)newFiles);
                    EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
                }
            }).submit((Executor)NonUrgentExecutor.getInstance());
        }
    }

    private static boolean isActive() {
        return !ApplicationManager.getApplication().isHeadlessEnvironment() || TestModeFlags.is(VENDORED_FILE_CHANGE_TRACKER_TEST_FLAG);
    }

    @TestOnly
    void waitForAlarm() throws Exception {
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not wait for the alarm under write action");
        }
        this.myCheckingQueue.waitForAllExecuted(10L, TimeUnit.SECONDS);
    }

    @TestOnly
    boolean isInFilesToCheck(@NotNull VirtualFile file) {
        if (file == null) {
            GoVendoredFileChangeTracker.$$$reportNull$$$0(4);
        }
        return this.myFilesToCheck.contains(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vendor/GoVendoredFileChangeTracker";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vendor/GoVendoredFileChangeTracker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEditedVendoredFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInFilesToCheck";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    static class MyModuleRootListener
    implements ModuleRootListener {
        private final Project myProject;

        MyModuleRootListener(@NotNull Project project) {
            if (project == null) {
                MyModuleRootListener.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            if (event == null) {
                MyModuleRootListener.$$$reportNull$$$0(1);
            }
            if (!GoVendoredFileChangeTracker.isActive()) {
                return;
            }
            GoVendoredFileChangeTracker tracker = GoVendoredFileChangeTracker.getInstance(this.myProject);
            tracker.myFilesToCheck.addAll(tracker.myEditedVendoredFiles);
            tracker.myEditedVendoredFiles.clear();
            tracker.myCheckingQueue.cancelAndRequest();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/goide/vendor/GoVendoredFileChangeTracker$MyModuleRootListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rootsChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        private final Project myProject;

        MyFileEditorManagerListener(@NotNull Project project) {
            if (project == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(1);
            }
            if (file == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(2);
            }
            if (!GoVendoredFileChangeTracker.isActive()) {
                return;
            }
            GoVendoredFileChangeTracker.getInstance((Project)this.myProject).myEditedVendoredFiles.remove(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/goide/vendor/GoVendoredFileChangeTracker$MyFileEditorManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileClosed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class MyFileDocumentManagerListener
    implements FileDocumentManagerListener {
        private final Project myProject;

        MyFileDocumentManagerListener(@NotNull Project project) {
            if (project == null) {
                MyFileDocumentManagerListener.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void fileContentReloaded(@NotNull VirtualFile file, @NotNull Document document) {
            if (file == null) {
                MyFileDocumentManagerListener.$$$reportNull$$$0(1);
            }
            if (document == null) {
                MyFileDocumentManagerListener.$$$reportNull$$$0(2);
            }
            if (!GoVendoredFileChangeTracker.isActive()) {
                return;
            }
            GoVendoredFileChangeTracker tracker = GoVendoredFileChangeTracker.getInstance(this.myProject);
            tracker.myFilesToCheck.remove(file);
            if (tracker.myEditedVendoredFiles.remove(file)) {
                EditorNotifications.getInstance((Project)this.myProject).updateNotifications(file);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            objectArray2[1] = "com/goide/vendor/GoVendoredFileChangeTracker$MyFileDocumentManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileContentReloaded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MyDocumentListener
    implements DocumentListener {
        MyDocumentListener() {
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            if (!GoVendoredFileChangeTracker.isActive()) {
                return;
            }
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                if (project.isDisposed()) continue;
                VirtualFile file = FileDocumentManager.getInstance().getFile(e.getDocument());
                GoVendoredFileChangeTracker tracker = GoVendoredFileChangeTracker.getInstance(project);
                if (file == null || !ProjectFileIndex.getInstance((Project)project).isInLibrary(file)) continue;
                tracker.myFilesToCheck.add(file);
                tracker.myCheckingQueue.cancelAndRequest();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/goide/vendor/GoVendoredFileChangeTracker$MyDocumentListener", "documentChanged"));
        }
    }
}

