/*
 * Decompiled with CFR 0.152.
 */
package com.goide.util;

import com.goide.GoConstants;
import com.goide.GoOsManager;
import com.goide.completion.GoImportsFilter;
import com.goide.execution.testing.GoTestFinder;
import com.goide.psi.GoFile;
import com.goide.psi.GoLabelDefinition;
import com.goide.psi.GoLabelRef;
import com.goide.psi.GoLangSupport;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoReferenceExpressionBase;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.sdk.GoPackageUtil;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoBuildMatcher;
import com.goide.util.GoPathProjectScope;
import com.goide.util.GoPathResolveScope;
import com.goide.util.GoPathUseScope;
import com.goide.util.GoTargetSystem;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.system.CpuArch;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class GoUtil {
    public static final String PLUGIN_ID = "org.jetbrains.plugins.go";
    private static final Logger LOG = Logger.getInstance(GoUtil.class);

    private GoUtil() {
    }

    public static boolean matchedForModuleBuildTarget(@NotNull PsiFile file, @Nullable Module module) {
        if (file == null) {
            GoUtil.$$$reportNull$$$0(0);
        }
        return new GoBuildMatcher(GoTargetSystem.forModule(module)).matchFile(file);
    }

    public static boolean isExcludedFile(@NotNull GoFile file) {
        if (file == null) {
            GoUtil.$$$reportNull$$$0(1);
        }
        List importsFilters = GoImportsFilter.EP_NAME.getExtensionList();
        return ContainerUtil.or((Iterable)importsFilters, filter -> filter.isExcluded(file));
    }

    @NotNull
    public static String systemOS() {
        if (GoOsManager.isMac()) {
            return "darwin";
        }
        if (SystemInfo.isFreeBSD) {
            return "freebsd";
        }
        if (GoOsManager.isLinux()) {
            return "linux";
        }
        if (SystemInfo.isSolaris) {
            return "solaris";
        }
        if (GoOsManager.isWindows()) {
            return "windows";
        }
        return "unknown";
    }

    @NotNull
    public static String systemArch() {
        String arch;
        if (ApplicationManager.getApplication().isUnitTestMode() && (arch = (String)TestModeFlags.get(GoOsManager.TESTING_ARCH)) != null) {
            String string = arch;
            if (string == null) {
                GoUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (CpuArch.isArm64()) {
            return "arm64";
        }
        if (CpuArch.isIntel64()) {
            return "amd64";
        }
        if (CpuArch.isIntel32()) {
            if (GoOsManager.isWindows()) {
                arch = System.getenv("PROCESSOR_ARCHITECTURE");
                String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
                if (arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64")) {
                    return "amd64";
                }
            }
            return "386";
        }
        return "unknown";
    }

    @NotNull
    public static ThreeState systemCgo(@NotNull String os, @NotNull String arch) {
        if (os == null) {
            GoUtil.$$$reportNull$$$0(3);
        }
        if (arch == null) {
            GoUtil.$$$reportNull$$$0(4);
        }
        ThreeState threeState = GoConstants.KNOWN_CGO.contains(os + "/" + arch) ? ThreeState.YES : ThreeState.NO;
        if (threeState == null) {
            GoUtil.$$$reportNull$$$0(5);
        }
        return threeState;
    }

    public static boolean fileToIgnore(@NotNull CharSequence fileName) {
        if (fileName == null) {
            GoUtil.$$$reportNull$$$0(6);
        }
        return StringUtil.startsWithChar((CharSequence)fileName, (char)'_') || StringUtil.startsWithChar((CharSequence)fileName, (char)'.');
    }

    @NotNull
    public static GlobalSearchScope goPathUseScope(@NotNull PsiElement context) {
        if (context == null) {
            GoUtil.$$$reportNull$$$0(7);
        }
        GlobalSearchScope globalSearchScope = GoPathUseScope.create(context);
        if (globalSearchScope == null) {
            GoUtil.$$$reportNull$$$0(8);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope goPathResolveScope(@NotNull PsiElement context) {
        if (context == null) {
            GoUtil.$$$reportNull$$$0(9);
        }
        GlobalSearchScope globalSearchScope = GoPathResolveScope.create(context.getProject(), GoUtil.module(context), context);
        if (globalSearchScope == null) {
            GoUtil.$$$reportNull$$$0(10);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope goPathResolveScope(@NotNull Module module, @Nullable PsiElement context) {
        if (module == null) {
            GoUtil.$$$reportNull$$$0(11);
        }
        GlobalSearchScope globalSearchScope = GoPathResolveScope.create(module.getProject(), module, context);
        if (globalSearchScope == null) {
            GoUtil.$$$reportNull$$$0(12);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope goPathProjectScope(@NotNull PsiElement context) {
        if (context == null) {
            GoUtil.$$$reportNull$$$0(13);
        }
        GlobalSearchScope globalSearchScope = GoPathProjectScope.create(context);
        if (globalSearchScope == null) {
            GoUtil.$$$reportNull$$$0(14);
        }
        return globalSearchScope;
    }

    @Nullable
    public static Module module(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        Module[] modules = ModuleManager.getInstance((Project)element.getProject()).getModules();
        if (modules.length == 0) {
            return null;
        }
        if (modules.length == 1) {
            return modules[0];
        }
        return GoUtil.doFindModuleForPsiElement(element);
    }

    @VisibleForTesting
    @Nullable
    public static Module doFindModuleForPsiElement(@NotNull PsiElement element) {
        PsiFileSystemItem file;
        if (element == null) {
            GoUtil.$$$reportNull$$$0(15);
        }
        Object object = file = element instanceof PsiFileSystemItem ? (PsiFileSystemItem)element : element.getContainingFile();
        if (file == null) {
            return null;
        }
        if (!(file = (PsiFileSystemItem)CompletionUtil.getOriginalOrSelf((PsiElement)file)).isValid()) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module != null) {
            return module;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        Project project = element.getProject();
        return GoUtil.moduleForLibraryFile(virtualFile, project);
    }

    @Nullable
    public static Module module(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            GoUtil.$$$reportNull$$$0(16);
        }
        if (virtualFile == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module != null) {
            return module;
        }
        return GoUtil.moduleForLibraryFile(virtualFile, project);
    }

    @Nullable
    private static Module moduleForLibraryFile(@Nullable VirtualFile virtualFile, @NotNull Project project) {
        if (project == null) {
            GoUtil.$$$reportNull$$$0(17);
        }
        if (virtualFile == null) {
            return null;
        }
        Collection<Module> goModules = GoSdkUtil.getGoModules(project);
        for (Module goModule : goModules) {
            if (GoVendoringUtil.isVendoredFile(virtualFile, goModule)) {
                return goModule;
            }
            VirtualFile srcDir = GoSdkUtil.getSdkSources(project, goModule);
            if (srcDir != null && VfsUtilCore.isAncestor((VirtualFile)srcDir, (VirtualFile)virtualFile, (boolean)false)) {
                return goModules.size() == 1 ? goModule : null;
            }
            for (VirtualFile gopath : GoSdkUtil.getGoPathSources(project, goModule, false)) {
                if (!VfsUtilCore.isAncestor((VirtualFile)gopath, (VirtualFile)virtualFile, (boolean)false)) continue;
                return goModules.size() == 1 ? goModule : null;
            }
        }
        return null;
    }

    @NotNull
    public static GlobalSearchScope moduleScope(@NotNull Module module) {
        if (module == null) {
            GoUtil.$$$reportNull$$$0(18);
        }
        Project project = module.getProject();
        Collection<VirtualFile> goPathSources = GoSdkUtil.getGoPathSources(project, module, false);
        ContainerUtil.addIfNotNull(goPathSources, (Object)GoSdkUtil.getSdkSources(project, module));
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module).uniteWith(module.getModuleContentWithDependenciesScope()).uniteWith(GlobalSearchScopesCore.directoriesScope((Project)project, (boolean)true, (VirtualFile[])goPathSources.toArray(VirtualFile.EMPTY_ARRAY)));
        if (globalSearchScope == null) {
            GoUtil.$$$reportNull$$$0(19);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleScopeWithoutLibraries(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            GoUtil.$$$reportNull$$$0(20);
        }
        GlobalSearchScope globalSearchScope = module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module).uniteWith(module.getModuleContentWithDependenciesScope()) : GlobalSearchScope.projectScope((Project)project);
        if (globalSearchScope == null) {
            GoUtil.$$$reportNull$$$0(21);
        }
        return globalSearchScope;
    }

    @Nullable
    public static IdeaPluginDescriptor getPlugin() {
        return PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)PLUGIN_ID));
    }

    public static boolean couldBeReferenceTo(@NotNull PsiElement definition, @NotNull PsiElement referenceElement) {
        if (definition == null) {
            GoUtil.$$$reportNull$$$0(22);
        }
        if (referenceElement == null) {
            GoUtil.$$$reportNull$$$0(23);
        }
        if (definition instanceof PomTargetPsiElement && ((PomTargetPsiElement)definition).getTarget() instanceof GoPackage && referenceElement instanceof GoReferenceExpressionBase) {
            return true;
        }
        if (referenceElement instanceof GoLabelRef && !(definition instanceof GoLabelDefinition)) {
            return false;
        }
        PsiFile definitionFile = definition.getContainingFile();
        PsiFile referenceFile = referenceElement.getContainingFile();
        if (!(definitionFile instanceof GoFile) || !GoLangSupport.Util.mayHaveReferencesToGo(referenceFile)) {
            return false;
        }
        if (GoUtil.isDirectlyAccessible(definitionFile, referenceFile)) {
            return true;
        }
        return !(referenceElement instanceof GoNamedElement) || ((GoNamedElement)referenceElement).isPublic();
    }

    @Contract(value="null, _ -> false; _, null -> false")
    public static boolean isDirectlyAccessible(@Nullable PsiFile definitionFile, @Nullable PsiFile referenceFile) {
        if (GoTestFinder.isTestFile(definitionFile) && !GoTestFinder.isTestFile(referenceFile)) {
            return false;
        }
        return GoUtil.inSamePackage(definitionFile, referenceFile, true);
    }

    @Contract(value="null, _ -> false; _, null -> false")
    public static boolean inSamePackage(@Nullable PsiFile definitionFile, @Nullable PsiFile referenceFile) {
        return GoUtil.inSamePackage(definitionFile, referenceFile, false);
    }

    @Contract(value="null, _, _ -> false; _, null, _ -> false")
    public static boolean inSamePackage(@Nullable PsiFile definitionFile, @Nullable PsiFile referenceFile, boolean compareExactPackageNames) {
        if (referenceFile == null || definitionFile == null) {
            return false;
        }
        if (referenceFile.isEquivalentTo((PsiElement)definitionFile)) {
            return true;
        }
        if (!(referenceFile instanceof GoFile) || !(definitionFile instanceof GoFile)) {
            PsiDirectory containingDirectory = referenceFile.getContainingDirectory();
            return containingDirectory != null && containingDirectory.equals(definitionFile.getContainingDirectory());
        }
        GoPackage definitionPackage = GoPackage.of((GoFile)definitionFile.getOriginalFile());
        if (definitionPackage == null || !definitionPackage.equals(GoPackage.of((GoFile)referenceFile.getOriginalFile()))) {
            return false;
        }
        if (!compareExactPackageNames) {
            return true;
        }
        String definitionPackageName = ((GoFile)referenceFile).getPackageName();
        return definitionPackageName == null || definitionPackageName.equals(((GoFile)definitionFile).getPackageName());
    }

    @NotNull
    public static String suggestPackageForDirectory(@Nullable PsiDirectory directory) {
        String packageName = GoPsiImplUtil.sanitizePackageName(directory != null ? directory.getName() : "");
        String string = (String)ContainerUtil.getFirstItem(GoPackageUtil.getAllPackagesInDirectory(directory, null, true), (Object)packageName);
        if (string == null) {
            GoUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    public static void cleanResolveCache(@NotNull Project project) {
        if (project == null) {
            GoUtil.$$$reportNull$$$0(25);
        }
        PsiManager.getInstance((Project)project).dropPsiCaches();
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    public static boolean isInProject(@NotNull PsiFile file) {
        if (file == null) {
            GoUtil.$$$reportNull$$$0(26);
        }
        if (file.getManager().isInProject((PsiElement)file)) {
            return true;
        }
        return ScratchUtil.isScratch((VirtualFile)file.getVirtualFile());
    }

    public static boolean isInProject(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            GoUtil.$$$reportNull$$$0(27);
        }
        if (file == null) {
            return false;
        }
        FileIndexFacade indexFacade = FileIndexFacade.getInstance((Project)project);
        return ScratchUtil.isScratch((VirtualFile)file) || indexFacade.isInContent(file) && !indexFacade.isExcludedFile(file);
    }

    public static boolean checkPrefix(@Nullable String name, @NotNull String prefix) {
        if (prefix == null) {
            GoUtil.$$$reportNull$$$0(28);
        }
        return GoUtil.checkPrefix(name, prefix, false);
    }

    public static boolean checkPrefix(@Nullable String name, @NotNull String prefix, boolean ignorePrefixCase) {
        if (prefix == null) {
            GoUtil.$$$reportNull$$$0(29);
        }
        if (name == null || (ignorePrefixCase ? !StringUtil.startsWithIgnoreCase((String)name, (String)prefix) : !name.startsWith(prefix))) {
            return false;
        }
        if (prefix.length() == name.length()) {
            return true;
        }
        char c = name.charAt(prefix.length());
        return !Character.isLetter(c) || !Character.isLowerCase(c);
    }

    public static String substringAfter(@NotNull String s, char c) {
        int i;
        if (s == null) {
            GoUtil.$$$reportNull$$$0(30);
        }
        if ((i = s.indexOf(c)) == -1) {
            return "";
        }
        return s.substring(i + 1);
    }

    public static <T> T logExecTime(Computable<T> computation, int threshold, Function<? super Long, String> message) {
        if (!LOG.isDebugEnabled()) {
            return (T)computation.compute();
        }
        long start = System.currentTimeMillis();
        Object result = computation.compute();
        long ms = System.currentTimeMillis() - start;
        if (ms > (long)threshold) {
            LOG.debug((String)message.fun((Object)ms));
        }
        return (T)result;
    }

    @Nullable
    public static String findModuleName(@NotNull CharSequence goModContent) {
        int indexOfModuleName;
        int indexOf;
        if (goModContent == null) {
            GoUtil.$$$reportNull$$$0(31);
        }
        if ((indexOf = StringUtil.indexOf((CharSequence)goModContent, (CharSequence)"module ")) == -1) {
            return null;
        }
        int indexOfNewLine = StringUtil.indexOf((CharSequence)goModContent, (CharSequence)"\n", (int)(indexOfModuleName = indexOf + "module ".length()));
        CharSequence subSequence = goModContent.subSequence(indexOfModuleName, indexOfNewLine > -1 ? indexOfNewLine : goModContent.length());
        String moduleName = StringUtil.unquoteString((String)subSequence.toString().trim());
        if (moduleName.isEmpty()) {
            return null;
        }
        return moduleName;
    }

    @Nullable
    public static String getModuleName(@NotNull VirtualFile goModFile) {
        if (goModFile == null) {
            GoUtil.$$$reportNull$$$0(32);
        }
        try {
            return GoUtil.findModuleName(VfsUtilCore.loadText((VirtualFile)goModFile));
        }
        catch (IOException ignore) {
            return null;
        }
    }

    @Nullable
    public static String getImportPath(@NotNull PsiElement element, @Nullable PsiElement context) {
        GoFile file;
        if (element == null) {
            GoUtil.$$$reportNull$$$0(33);
        }
        return (file = (GoFile)((Object)ObjectUtils.tryCast((Object)element.getContainingFile(), GoFile.class))) != null ? file.getImportPath(GoVendoringUtil.isVendoringEnabled(context)) : null;
    }

    public static boolean isBeforeNewLine(@NotNull CharSequence text, int offset) {
        if (text == null) {
            GoUtil.$$$reportNull$$$0(34);
        }
        while (offset < text.length() && StringUtil.isWhiteSpace((char)text.charAt(offset))) {
            if (text.charAt(offset) == '\n') {
                return true;
            }
            ++offset;
        }
        return false;
    }

    public static boolean isValidGoIdentifierCharacter(char c) {
        return c == '_' || Character.isDigit(c) || Character.isAlphabetic(c);
    }

    public static boolean isValidGoIdentifier(@Nullable String identifier) {
        if (StringUtil.isEmpty((String)identifier)) {
            return false;
        }
        for (int i = 0; i < identifier.length(); ++i) {
            if (GoUtil.isValidGoIdentifierCharacter(identifier.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isGoFile(@NotNull CharSequence fileName) {
        if (fileName == null) {
            GoUtil.$$$reportNull$$$0(35);
        }
        return "go".contentEquals(FileUtilRt.getExtension((CharSequence)fileName));
    }

    public static boolean isGo2File(@NotNull CharSequence fileName) {
        if (fileName == null) {
            GoUtil.$$$reportNull$$$0(36);
        }
        return "go2".contentEquals(FileUtilRt.getExtension((CharSequence)fileName));
    }

    @NotNull
    public static Path getGoLandTempDirectory() {
        Path path = Path.of(PathManager.getTempPath(), "GoLand");
        if (path == null) {
            GoUtil.$$$reportNull$$$0(37);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 8, 10, 12, 14, 19, 21, 24, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 21: 
            case 24: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/util/GoUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "os";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arch";
                break;
            }
            case 6: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 15: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: 
            case 17: 
            case 20: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goModContent";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goModFile";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/util/GoUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "systemArch";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "systemCgo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "goPathUseScope";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "goPathResolveScope";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "goPathProjectScope";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleScope";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleScopeWithoutLibraries";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestPackageForDirectory";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoLandTempDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matchedForModuleBuildTarget";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isExcludedFile";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 21: 
            case 24: 
            case 37: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "systemCgo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fileToIgnore";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "goPathUseScope";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "goPathResolveScope";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "goPathProjectScope";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doFindModuleForPsiElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "module";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "moduleForLibraryFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "moduleScope";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "moduleScopeWithoutLibraries";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "couldBeReferenceTo";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "cleanResolveCache";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isInProject";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "checkPrefix";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "substringAfter";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findModuleName";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getImportPath";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isBeforeNewLine";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isGoFile";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isGo2File";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 8, 10, 12, 14, 19, 21, 24, 37 -> new IllegalStateException(string);
        };
    }

    public static class TestsScope
    extends DelegatingGlobalSearchScope {
        public TestsScope(@NotNull GlobalSearchScope baseScope) {
            if (baseScope == null) {
                TestsScope.$$$reportNull$$$0(0);
            }
            super(baseScope);
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                TestsScope.$$$reportNull$$$0(1);
            }
            return GoTestFinder.isTestFile(file) && super.contains(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseScope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/goide/util/GoUtil$TestsScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ExceptTestsScope
    extends DelegatingGlobalSearchScope {
        public ExceptTestsScope(@NotNull GlobalSearchScope baseScope) {
            if (baseScope == null) {
                ExceptTestsScope.$$$reportNull$$$0(0);
            }
            super(baseScope);
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                ExceptTestsScope.$$$reportNull$$$0(1);
            }
            return !GoTestFinder.isTestFile(file) && super.contains(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseScope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/goide/util/GoUtil$ExceptTestsScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

