/*
 * Decompiled with CFR 0.152.
 */
package com.goide.util;

import com.goide.project.GoModuleSettings;
import com.goide.util.GoUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ThreeState;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoTargetSystem {
    public static final String GAE_BUILD_FLAG = "appengine";
    @NotNull
    public final String os;
    @NotNull
    public final String arch;
    @Nullable
    public final String goVersion;
    @Nullable
    public final String compiler;
    @NotNull
    public final ThreeState cgoEnabled;
    private final Set<String> customFlags;
    private final Set<String> experiments;

    public GoTargetSystem(@NotNull String os, @NotNull String arch, @Nullable String goVersion, @Nullable String compiler, @NotNull ThreeState cgoEnabled, String @NotNull [] customFlags, String @NotNull [] experiments) {
        if (os == null) {
            GoTargetSystem.$$$reportNull$$$0(0);
        }
        if (arch == null) {
            GoTargetSystem.$$$reportNull$$$0(1);
        }
        if (cgoEnabled == null) {
            GoTargetSystem.$$$reportNull$$$0(2);
        }
        if (customFlags == null) {
            GoTargetSystem.$$$reportNull$$$0(3);
        }
        if (experiments == null) {
            GoTargetSystem.$$$reportNull$$$0(4);
        }
        this.customFlags = new HashSet<String>();
        this.experiments = new HashSet<String>();
        this.os = os;
        this.arch = arch;
        this.goVersion = goVersion != null ? StringUtil.trimStart((String)goVersion, (String)"go") : null;
        this.compiler = compiler;
        this.cgoEnabled = cgoEnabled;
        Collections.addAll(this.customFlags, customFlags);
        Collections.addAll(this.experiments, experiments);
    }

    public boolean supportsFlag(@NotNull String flag) {
        if (flag == null) {
            GoTargetSystem.$$$reportNull$$$0(5);
        }
        return this.customFlags.contains(flag);
    }

    public boolean supportsExperiment(@NotNull String experiment) {
        if (experiment == null) {
            GoTargetSystem.$$$reportNull$$$0(6);
        }
        return this.experiments.contains(experiment);
    }

    @NotNull
    public static GoTargetSystem forModule(@Nullable Module module) {
        if (module == null) {
            String os = GoUtil.systemOS();
            String arch = GoUtil.systemArch();
            return new GoTargetSystem(os, arch, null, null, GoUtil.systemCgo(os, arch), ArrayUtilRt.EMPTY_STRING_ARRAY, ArrayUtilRt.EMPTY_STRING_ARRAY);
        }
        GoTargetSystem goTargetSystem = GoModuleSettings.getInstance(module).getTargetSystem();
        if (goTargetSystem == null) {
            GoTargetSystem.$$$reportNull$$$0(7);
        }
        return goTargetSystem;
    }

    public String toString() {
        return "GoTargetSystem{os='" + this.os + "', arch='" + this.arch + "', goVersion='" + this.goVersion + "', compiler='" + this.compiler + "', cgoEnabled=" + this.cgoEnabled + ", customFlags=" + this.customFlags + ", experiments=" + this.experiments + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "os";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arch";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cgoEnabled";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customFlags";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "experiments";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flag";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "experiment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/util/GoTargetSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/util/GoTargetSystem";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "forModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "supportsFlag";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "supportsExperiment";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

