/*
 * Decompiled with CFR 0.152.
 */
package com.goide.util;

import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoExecutor;
import com.goide.util.GoGetUpdateType;
import com.goide.vgo.project.VgoModule;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoGetPackageUtil {
    public static void installTool(@NotNull Project project, @Nullable Module module, @Nullable String workingDirectory, @NotNull String importPathWithVersion) {
        if (project == null) {
            GoGetPackageUtil.$$$reportNull$$$0(0);
        }
        if (importPathWithVersion == null) {
            GoGetPackageUtil.$$$reportNull$$$0(1);
        }
        GoSdk sdk = GoSdkService.getInstance(project).getSdk(module);
        GoGetPackageUtil.installTool(project, module, workingDirectory, importPathWithVersion, sdk.prefersInstallOverGet());
    }

    public static void installTool(@NotNull Project project, @Nullable Module module, @Nullable String workingDirectory, @NotNull String importPathWithVersion, boolean useInstallCommand) {
        if (project == null) {
            GoGetPackageUtil.$$$reportNull$$$0(2);
        }
        if (importPathWithVersion == null) {
            GoGetPackageUtil.$$$reportNull$$$0(3);
        }
        GoGetPackageUtil.goGetPackage(project, module, workingDirectory, importPathWithVersion, false, true, useInstallCommand);
    }

    public static void goGetPackage(@NotNull Project project, @Nullable Module module, @Nullable String workingDirectory, @NotNull String packageImportPath) {
        if (project == null) {
            GoGetPackageUtil.$$$reportNull$$$0(4);
        }
        if (packageImportPath == null) {
            GoGetPackageUtil.$$$reportNull$$$0(5);
        }
        GoGetPackageUtil.goGetPackage(project, module, workingDirectory, packageImportPath, true, false, false);
    }

    private static void goGetPackage(@NotNull Project project, @Nullable Module module, @Nullable String workingDirectory, @NotNull @NlsSafe String importPathWithVersion, boolean startInBackground, boolean refreshGoBinDirs, boolean useInstallCommand) {
        String[] stringArray;
        GoSdk sdk;
        if (project == null) {
            GoGetPackageUtil.$$$reportNull$$$0(6);
        }
        if (importPathWithVersion == null) {
            GoGetPackageUtil.$$$reportNull$$$0(7);
        }
        if (!(sdk = GoSdkService.getInstance(project).getSdk(module)).isValid()) {
            return;
        }
        String packageImportPath = StringUtil.substringBeforeLast((String)importPathWithVersion, (String)"@");
        String versionQuery = (String)ObjectUtils.notNull((Object)StringUtil.substringAfterLast((String)packageImportPath, (String)"@"), (Object)"latest");
        if (useInstallCommand) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "install";
            stringArray = stringArray2;
            stringArray2[1] = packageImportPath + "@" + versionQuery;
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "get";
            stringArray3[1] = "-t";
            stringArray3[2] = "-v";
            stringArray = stringArray3;
            stringArray3[3] = packageImportPath + "/...";
        }
        String[] args = stringArray;
        CommandProcessor.getInstance().runUndoTransparentAction(() -> {
            @NlsSafe String presentableName = "go " + String.join((CharSequence)" ", args);
            GoExecutor executor = GoExecutor.in(project, module).disablePty().withPresentableName(presentableName).withParameters(args).withPrintingOutputAsStatus().showNotifications(false, true);
            if (workingDirectory != null) {
                executor.withWorkDirectory(workingDirectory);
            }
            executor.executeWithProgress(startInBackground, true, (Consumer<? super GoExecutor.ExecutionResult>)((Consumer)__ -> {
                VirtualFileManager.getInstance().asyncRefresh();
                if (!(!refreshGoBinDirs || project.isDisposed() || module != null && module.isDisposed())) {
                    Collection<VirtualFile> binDirs = GoSdkUtil.getGoPathBins(project, module, false);
                    WriteAction.run(() -> {
                        for (VirtualFile binDir : binDirs) {
                            binDir.refresh(false, false);
                        }
                    });
                }
            }));
        });
    }

    public static void addDependency(@NotNull String importPath, @NotNull Project project, @Nullable String workDirectory) {
        if (importPath == null) {
            GoGetPackageUtil.$$$reportNull$$$0(8);
        }
        if (project == null) {
            GoGetPackageUtil.$$$reportNull$$$0(9);
        }
        @NlsSafe String presentableName = "go get %s".formatted(importPath);
        GoGetPackageUtil.updateDependencies(project, workDirectory, presentableName, Collections.emptyList(), Collections.singletonList(importPath));
    }

    public static void updateAllDependencies(@NotNull Project project, @NotNull VgoModule vgoModule, @NotNull GoGetUpdateType updateType) {
        if (project == null) {
            GoGetPackageUtil.$$$reportNull$$$0(10);
        }
        if (vgoModule == null) {
            GoGetPackageUtil.$$$reportNull$$$0(11);
        }
        if (updateType == null) {
            GoGetPackageUtil.$$$reportNull$$$0(12);
        }
        @NlsSafe String presentableName = "go get %s all (%s)".formatted(updateType.getCliArgument(), vgoModule.getImportPath());
        GoGetPackageUtil.updateDependencies(project, vgoModule.getRoot().getPath(), presentableName, List.of(updateType.getCliArgument(), "all"), Collections.emptyList());
    }

    public static void updateDependencies(@NotNull @NotNull Collection<@NotNull String> importPaths, @NotNull Project project, @NotNull VgoModule vgoModule, @NotNull GoGetUpdateType updateType) {
        if (importPaths == null) {
            GoGetPackageUtil.$$$reportNull$$$0(13);
        }
        if (project == null) {
            GoGetPackageUtil.$$$reportNull$$$0(14);
        }
        if (vgoModule == null) {
            GoGetPackageUtil.$$$reportNull$$$0(15);
        }
        if (updateType == null) {
            GoGetPackageUtil.$$$reportNull$$$0(16);
        }
        @NlsSafe String presentableName = "go get %s (%s)".formatted(updateType.getCliArgument(), vgoModule.getImportPath());
        GoGetPackageUtil.updateDependencies(project, vgoModule.getRoot().getPath(), presentableName, Collections.singletonList(updateType.getCliArgument()), importPaths);
    }

    private static void updateDependencies(@NotNull Project project, @Nullable String workDirectory, @NlsContexts.ProgressTitle String presentableName, Collection<String> extraFlags, Collection<String> packages2) {
        GoSdk sdk;
        if (project == null) {
            GoGetPackageUtil.$$$reportNull$$$0(17);
        }
        if (!(sdk = GoSdkService.getInstance(project).getSdk(null)).isValid()) {
            return;
        }
        CommandProcessor.getInstance().runUndoTransparentAction(() -> {
            GoExecutor executor = GoExecutor.in(project, null).disablePty().withPresentableName(presentableName).withParameters("get", "-d", "-v").withParameters(extraFlags).withParameters(packages2).withWorkDirectory(workDirectory).withPrintingOutputAsStatus().showNotifications(false, true);
            executor.executeWithProgress(true, true, (Consumer<? super GoExecutor.ExecutionResult>)((Consumer)__ -> VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)false, (File[])new File[]{new File(workDirectory, "go.mod"), new File(workDirectory, "go.sum")})));
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPathWithVersion";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageImportPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vgoModule";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPaths";
                break;
            }
        }
        objectArray2[1] = "com/goide/util/GoGetPackageUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "installTool";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "goGetPackage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addDependency";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "updateAllDependencies";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "updateDependencies";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

