/*
 * Decompiled with CFR 0.152.
 */
package com.goide.util;

import com.goide.execution.target.GoCommandLineSetup;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public interface GoCommandLineParameter {
    public static final GoCommandLineParameter[] EMPTY_ARRAY = new GoCommandLineParameter[0];

    @NotNull
    public static GoCommandLineParameter string(@NotNull String s) {
        if (s == null) {
            GoCommandLineParameter.$$$reportNull$$$0(0);
        }
        return new StringParameter(s);
    }

    @NotNull
    public static PathParameter path(@NotNull String path) {
        if (path == null) {
            GoCommandLineParameter.$$$reportNull$$$0(1);
        }
        return new PathParameter(path);
    }

    @NotNull
    public static GoCommandLineParameter wslPath(@NotNull String windowsPath, @NotNull String wslPath) {
        if (windowsPath == null) {
            GoCommandLineParameter.$$$reportNull$$$0(2);
        }
        if (wslPath == null) {
            GoCommandLineParameter.$$$reportNull$$$0(3);
        }
        return new WslPathParameter(windowsPath, wslPath);
    }

    @NotNull
    public static GoCommandLineParameter map(@NotNull GoCommandLineParameter parameter, @NotNull Function<? super String, String> mapper) {
        if (parameter == null) {
            GoCommandLineParameter.$$$reportNull$$$0(4);
        }
        if (mapper == null) {
            GoCommandLineParameter.$$$reportNull$$$0(5);
        }
        return new MapParameter(parameter, mapper);
    }

    default public void prepare(@NotNull GoCommandLineSetup setup) {
        if (setup == null) {
            GoCommandLineParameter.$$$reportNull$$$0(6);
        }
    }

    public TargetValue<String> toValue();

    @NotNull
    public String toPresentableString();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowsPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setup";
                break;
            }
        }
        objectArray2[1] = "com/goide/util/GoCommandLineParameter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "string";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "path";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "wslPath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "map";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "prepare";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class StringParameter
    implements GoCommandLineParameter {
        @NotNull
        private final String myValue;

        public StringParameter(@NotNull String value) {
            if (value == null) {
                StringParameter.$$$reportNull$$$0(0);
            }
            this.myValue = value;
        }

        @Override
        public TargetValue<String> toValue() {
            return TargetValue.fixed((Object)this.myValue);
        }

        @Override
        @NotNull
        public String toPresentableString() {
            String string = this.myValue;
            if (string == null) {
                StringParameter.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/util/GoCommandLineParameter$StringParameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/util/GoCommandLineParameter$StringParameter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toPresentableString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class PathParameter
    implements GoCommandLineParameter {
        private final String myPath;
        private final LanguageRuntimeType.VolumeDescriptor myVolume;
        private volatile TargetValue<String> myValue;

        public PathParameter(@NotNull String path) {
            if (path == null) {
                PathParameter.$$$reportNull$$$0(0);
            }
            this(path, null);
        }

        public PathParameter(@NotNull String path, @Nullable LanguageRuntimeType.VolumeDescriptor volumeDescriptor) {
            if (path == null) {
                PathParameter.$$$reportNull$$$0(1);
            }
            this.myPath = path;
            this.myVolume = volumeDescriptor;
        }

        @Override
        public void prepare(@NotNull GoCommandLineSetup setup) {
            if (setup == null) {
                PathParameter.$$$reportNull$$$0(2);
            }
            this.myValue = this.myVolume != null ? setup.requestUploadIntoTarget(this.myVolume, this.myPath) : setup.requestUploadIntoTarget(this.myPath);
        }

        @NotNull
        public GoCommandLineParameter withVolumeDescriptor(@NotNull LanguageRuntimeType.VolumeDescriptor volumeDescriptor) {
            if (volumeDescriptor == null) {
                PathParameter.$$$reportNull$$$0(3);
            }
            return new PathParameter(this.myPath, volumeDescriptor);
        }

        @Override
        public TargetValue<String> toValue() {
            return this.myValue;
        }

        @Override
        @NotNull
        public String toPresentableString() {
            String string = this.myPath;
            if (string == null) {
                PathParameter.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "setup";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "volumeDescriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/util/GoCommandLineParameter$PathParameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/util/GoCommandLineParameter$PathParameter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toPresentableString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "prepare";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "withVolumeDescriptor";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class WslPathParameter
    implements GoCommandLineParameter {
        private final String myWindowsPath;
        private final String myWslPath;

        WslPathParameter(@NotNull String windowsPath, @NotNull String wslPath) {
            if (windowsPath == null) {
                WslPathParameter.$$$reportNull$$$0(0);
            }
            if (wslPath == null) {
                WslPathParameter.$$$reportNull$$$0(1);
            }
            this.myWindowsPath = windowsPath;
            this.myWslPath = wslPath;
        }

        @Override
        public TargetValue<String> toValue() {
            return TargetValue.create((Object)this.myWindowsPath, (Promise)Promises.resolvedPromise((Object)this.myWslPath));
        }

        @Override
        @NotNull
        public String toPresentableString() {
            String string = this.myWslPath;
            if (string == null) {
                WslPathParameter.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "windowsPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wslPath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/util/GoCommandLineParameter$WslPathParameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/util/GoCommandLineParameter$WslPathParameter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toPresentableString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class MapParameter
    implements GoCommandLineParameter {
        private final GoCommandLineParameter myParameter;
        @NotNull
        private final Function<? super String, String> myMapper;

        public MapParameter(@NotNull GoCommandLineParameter parameter, @NotNull Function<? super String, String> mapper) {
            if (parameter == null) {
                MapParameter.$$$reportNull$$$0(0);
            }
            if (mapper == null) {
                MapParameter.$$$reportNull$$$0(1);
            }
            this.myParameter = parameter;
            this.myMapper = mapper;
        }

        @Override
        public void prepare(@NotNull GoCommandLineSetup setup) {
            if (setup == null) {
                MapParameter.$$$reportNull$$$0(2);
            }
            this.myParameter.prepare(setup);
        }

        @Override
        public TargetValue<String> toValue() {
            return TargetValue.map(this.myParameter.toValue(), this.myMapper);
        }

        @Override
        @NotNull
        public String toPresentableString() {
            String string = (String)this.myMapper.fun((Object)this.myParameter.toPresentableString());
            if (string == null) {
                MapParameter.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "setup";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/util/GoCommandLineParameter$MapParameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/util/GoCommandLineParameter$MapParameter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toPresentableString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "prepare";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

