/*
 * Decompiled with CFR 0.152.
 */
package com.goide.tree;

import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.presentation.GoPsiPresentationBuilder;
import com.goide.tree.GoExportabilitySorter;
import com.goide.tree.GoNaturalSorter;
import com.goide.tree.GoOutsideContextFileFilter;
import com.goide.tree.GoPrivateMembersFilter;
import com.goide.util.GoCacheUtilKt;
import com.goide.util.GoUtil;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.PlaceHolder;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoStructureViewFactory
implements PsiStructureViewFactory {
    @NotNull
    public StructureViewBuilder getStructureViewBuilder(final @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            GoStructureViewFactory.$$$reportNull$$$0(0);
        }
        return new TreeBasedStructureViewBuilder(){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                return new Model(psiFile, editor);
            }

            public boolean isRootNodeShown() {
                return false;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/goide/tree/GoStructureViewFactory", "getStructureViewBuilder"));
    }

    public static class Element
    extends PsiTreeElementBase<PsiElement> {
        private static final Logger LOG = Logger.getInstance(GoStructureViewFactory.class);
        @Nullable
        private final String myLocationString;
        @Nullable
        private final PsiFile myContextFile;
        private final boolean myIsOutsideContextFile;
        @Nullable
        private String myPresentation;

        public Element(@NotNull PsiElement e) {
            if (e == null) {
                Element.$$$reportNull$$$0(0);
            }
            this(e, null);
        }

        public Element(@NotNull PsiElement e, @Nullable PsiFile contextFile) {
            if (e == null) {
                Element.$$$reportNull$$$0(1);
            }
            super(e);
            PsiFile containingFile = e.getContainingFile();
            this.myContextFile = contextFile;
            this.myIsOutsideContextFile = this.myContextFile != null && !this.myContextFile.equals(containingFile);
            this.myLocationString = this.myIsOutsideContextFile ? containingFile.getName() : null;
        }

        public boolean isOutsideContextFile() {
            return this.myIsOutsideContextFile;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            PsiElement element = this.getElement();
            if (element == null) {
                List<StructureViewTreeElement> list = Collections.emptyList();
                if (list == null) {
                    Element.$$$reportNull$$$0(2);
                }
                return list;
            }
            Collection elements = (Collection)CachedValuesManager.getCachedValue((PsiElement)element, () -> {
                LinkedHashSet<PsiElement> result = new LinkedHashSet<PsiElement>();
                if (element instanceof GoFile) {
                    Element.addFilesChildren(result, (GoFile)element);
                    GoPackage aPackage = GoPackage.of((GoFile)element);
                    if (aPackage != null) {
                        Element.addPackageChildren(result, aPackage, (GoFile)element);
                    }
                } else if (element instanceof GoTypeSpec) {
                    GoTypeSpec typeSpec = (GoTypeSpec)element;
                    result.addAll(typeSpec.getMethods());
                    Element.addTypesChildren(result, typeSpec.getSpecType().getType());
                } else if (element instanceof GoFieldDefinition) {
                    Element.addTypesChildren(result, ((GoFieldDefinition)element).findSiblingType());
                } else if (element instanceof GoVarOrConstDefinition) {
                    Element.addTypesChildren(result, ((GoVarOrConstDefinition)element).findSiblingType());
                } else if (element instanceof GoFunctionOrMethodDeclaration && element instanceof StubBasedPsiElement) {
                    StubElement stub = ((StubBasedPsiElement)element).getStub();
                    List list = stub != null ? PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)element, GoTypeSpec.class) : SyntaxTraverser.psiTraverser((PsiElement)((GoFunctionOrMethodDeclaration)element).getBlock()).filter(GoTypeSpec.class);
                    for (GoTypeSpec s : list) {
                        result.add(s);
                    }
                }
                return GoCacheUtilKt.createResolveDependentResult(element.getProject(), result, new Object[0]);
            });
            Set set = ContainerUtil.map2LinkedSet((Collection)elements, e -> new Element((PsiElement)e, this.myContextFile));
            if (set == null) {
                Element.$$$reportNull$$$0(3);
            }
            return set;
        }

        private static void addPackageChildren(@NotNull Collection<PsiElement> result, @NotNull GoPackage aPackage, @NotNull GoFile orig) {
            if (result == null) {
                Element.$$$reportNull$$$0(4);
            }
            if (aPackage == null) {
                Element.$$$reportNull$$$0(5);
            }
            if (orig == null) {
                Element.$$$reportNull$$$0(6);
            }
            Set packageChildren = (Set)CachedValuesManager.getCachedValue((PsiElement)orig, () -> {
                LinkedHashSet packageResult = new LinkedHashSet();
                aPackage.processFiles((Processor<? super PsiFile>)((Processor)f -> {
                    if (f != orig && GoUtil.isDirectlyAccessible(f, (PsiFile)orig)) {
                        Element.addFilesChildren(packageResult, (GoFile)((Object)((Object)f)));
                    }
                    return true;
                }));
                return CachedValueProvider.Result.create(packageResult, (Object[])new Object[]{aPackage.getModificationTracker()});
            });
            result.addAll(packageChildren);
        }

        private static void addFilesChildren(@NotNull Collection<PsiElement> result, @NotNull GoFile file) {
            if (result == null) {
                Element.$$$reportNull$$$0(7);
            }
            if (file == null) {
                Element.$$$reportNull$$$0(8);
            }
            result.addAll(file.getTypes());
            result.addAll(file.getConstants());
            result.addAll(file.getVars());
            result.addAll(file.getFunctions());
        }

        private static void addTypesChildren(@NotNull Collection<PsiElement> result, @Nullable GoType type2) {
            if (result == null) {
                Element.$$$reportNull$$$0(9);
            }
            if (type2 instanceof GoStructType) {
                result.addAll(((GoStructType)type2).getFieldDefinitions());
            } else if (type2 instanceof GoInterfaceType) {
                result.addAll(((GoInterfaceType)type2).getMethodSpecList());
            }
        }

        @Nullable
        public String getPresentableText() {
            if (this.myPresentation == null) {
                String textInner = this.getPresentationTextInner();
                this.myPresentation = textInner != null ? textInner.replaceAll("\\(\\n", "(").replaceAll("\\n\\)", ")") : null;
            }
            return this.myPresentation;
        }

        @Nullable
        public String getLocationString() {
            return this.myLocationString;
        }

        @NonNls
        @Nullable
        private String getPresentationTextInner() {
            PsiElement element = this.getElement();
            if (element == null) {
                return null;
            }
            if (element instanceof GoFile) {
                return ((GoFile)element).getName();
            }
            if (element instanceof GoSignatureOwner) {
                return GoPsiPresentationBuilder.create().withoutResolve().withoutStructureAndInterfaceContent().oneline().build((GoSignatureOwner)element, false);
            }
            if (element instanceof GoTypeSpec) {
                return Element.typedElementPresentation((GoTypeSpec)element, ((GoTypeSpec)element).getSpecType().getType());
            }
            if (element instanceof GoNamedElement) {
                try {
                    return Element.typedElementPresentation((GoNamedElement)element, ((GoNamedElement)element).findSiblingType());
                }
                catch (IndexNotReadyException ignore) {
                    return null;
                }
            }
            LOG.error("Cannot get presentation for " + element.getClass().getName());
            return null;
        }

        @NonNls
        @Nullable
        private static String typedElementPresentation(@NotNull GoNamedElement element, @Nullable GoType type2) {
            if (element == null) {
                Element.$$$reportNull$$$0(10);
            }
            if (type2 == null || type2 instanceof GoStructType || type2 instanceof GoInterfaceType) {
                return element.getName();
            }
            return element.getName() + ": " + type2.getPresentationText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/tree/GoStructureViewFactory$Element";
                    break;
                }
                case 4: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aPackage";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "orig";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/tree/GoStructureViewFactory$Element";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addPackageChildren";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addFilesChildren";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addTypesChildren";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "typedElementPresentation";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static final class Model
    extends StructureViewModelBase
    implements StructureViewModel.ElementInfoProvider,
    PlaceHolder {
        private String myPlace;

        Model(@NotNull PsiFile file, @Nullable Editor editor) {
            if (file == null) {
                Model.$$$reportNull$$$0(0);
            }
            super(file, editor, (StructureViewTreeElement)new Element((PsiElement)file, file));
            this.withSuitableClasses(new Class[]{GoFile.class, GoNamedElement.class});
        }

        public Filter @NotNull [] getFilters() {
            Filter[] filterArray = new Filter[]{new GoPrivateMembersFilter(), new GoOutsideContextFileFilter()};
            if (filterArray == null) {
                Model.$$$reportNull$$$0(1);
            }
            return filterArray;
        }

        public Sorter @NotNull [] getSorters() {
            Sorter[] sorterArray = new Sorter[]{GoNaturalSorter.INSTANCE, GoExportabilitySorter.INSTANCE, Sorter.ALPHA_SORTER};
            if (sorterArray == null) {
                Model.$$$reportNull$$$0(2);
            }
            return sorterArray;
        }

        public boolean isAlwaysShowsPlus(StructureViewTreeElement structureViewTreeElement) {
            return false;
        }

        public boolean isAlwaysLeaf(StructureViewTreeElement structureViewTreeElement) {
            return false;
        }

        public void setPlace(@NotNull String place) {
            if (place == null) {
                Model.$$$reportNull$$$0(3);
            }
            this.myPlace = place;
        }

        public String getPlace() {
            return this.myPlace;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/tree/GoStructureViewFactory$Model";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/tree/GoStructureViewFactory$Model";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilters";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSorters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setPlace";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

