/*
 * Decompiled with CFR 0.152.
 */
package com.goide.statistics.errors;

import com.goide.statistics.errors.GoErrorRegexDictionary;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.intellij.internal.statistic.eventLog.StatisticsEventEscaper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

@Service
public final class GoStatisticsWhiteListsService {
    private static final String COMPILATION_ERRORS_DICTIONARY_ID = "dictionary.go.compiler.errors";
    private static final String RUNTIME_ERRORS_DICTIONARY_ID = "dictionary.go.runtime.errors";
    private static final String IMPORTS_SET_ID = "awesome.go.packages";
    private static final String STD_IMPORTS_SET_ID = "std.packages";
    private static final Logger LOG = Logger.getInstance(GoStatisticsWhiteListsService.class);
    private static final GoErrorRegexDictionary EMPTY = new GoErrorRegexDictionary(Collections.emptyMap());
    @NotNull
    private GoErrorRegexDictionary myCompilationErrorsDictionary = EMPTY;
    @NotNull
    private GoErrorRegexDictionary myRuntimeErrorsDictionary = EMPTY;
    @NotNull
    private Set<String> myImportsSet = Collections.emptySet();
    @NotNull
    private Set<String> myStdImportsSet = Collections.emptySet();

    public static GoStatisticsWhiteListsService getInstance() {
        return (GoStatisticsWhiteListsService)ApplicationManager.getApplication().getService(GoStatisticsWhiteListsService.class);
    }

    private GoStatisticsWhiteListsService() {
    }

    public synchronized void init() {
        try {
            this.myCompilationErrorsDictionary = new GoErrorRegexDictionary(GoStatisticsWhiteListsService.loadDictionary(COMPILATION_ERRORS_DICTIONARY_ID));
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        try {
            this.myRuntimeErrorsDictionary = new GoErrorRegexDictionary(GoStatisticsWhiteListsService.loadDictionary(RUNTIME_ERRORS_DICTIONARY_ID));
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        try {
            this.myImportsSet = GoStatisticsWhiteListsService.loadSet(IMPORTS_SET_ID);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        try {
            this.myStdImportsSet = GoStatisticsWhiteListsService.loadSet(STD_IMPORTS_SET_ID);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @NotNull
    public synchronized GoErrorRegexDictionary getCompilationErrorsDictionary() {
        GoErrorRegexDictionary goErrorRegexDictionary = this.myCompilationErrorsDictionary;
        if (goErrorRegexDictionary == null) {
            GoStatisticsWhiteListsService.$$$reportNull$$$0(0);
        }
        return goErrorRegexDictionary;
    }

    @NotNull
    public synchronized GoErrorRegexDictionary getRuntimeErrorsDictionary() {
        GoErrorRegexDictionary goErrorRegexDictionary = this.myRuntimeErrorsDictionary;
        if (goErrorRegexDictionary == null) {
            GoStatisticsWhiteListsService.$$$reportNull$$$0(1);
        }
        return goErrorRegexDictionary;
    }

    @NotNull
    public synchronized Set<String> getImportsSet() {
        Set<String> set = this.myImportsSet;
        if (set == null) {
            GoStatisticsWhiteListsService.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public synchronized Set<String> getStdImportsSet() {
        Set<String> set = this.myStdImportsSet;
        if (set == null) {
            GoStatisticsWhiteListsService.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    private static Map<String, List<String>> loadDictionary(@NotNull String id) throws IOException {
        Map map;
        if (id == null) {
            GoStatisticsWhiteListsService.$$$reportNull$$$0(4);
        }
        String content2 = GoStatisticsWhiteListsService.loadResourceText(id + ".json");
        try {
            Type mapType = new TypeToken<Map<String, List<String>>>(){}.getType();
            Map dictionary = (Map)new GsonBuilder().create().fromJson(content2, mapType);
            if (dictionary == null) {
                throw new IOException("Unexpected dictionary format");
            }
            map = dictionary;
        }
        catch (JsonParseException e) {
            throw new IOException("Failed to parse dictionary", e);
        }
        if (map == null) {
            GoStatisticsWhiteListsService.$$$reportNull$$$0(5);
        }
        return map;
    }

    @NotNull
    private static String loadResourceText(@NotNull String fileName) throws IOException {
        InputStream stream;
        if (fileName == null) {
            GoStatisticsWhiteListsService.$$$reportNull$$$0(6);
        }
        if ((stream = GoStatisticsWhiteListsService.class.getClassLoader().getResourceAsStream("statistics/" + fileName)) == null) {
            throw new IOException("Failed to read dictionary resource");
        }
        String string = ResourceUtil.loadText((InputStream)stream);
        if (string == null) {
            GoStatisticsWhiteListsService.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static Set<String> loadSet(@NotNull String id) throws IOException {
        if (id == null) {
            GoStatisticsWhiteListsService.$$$reportNull$$$0(8);
        }
        String text = GoStatisticsWhiteListsService.loadResourceText(id + ".txt");
        String[] lines = StringUtil.splitByLines((String)text);
        Set<String> set = Stream.of(lines).map(StatisticsEventEscaper::escape).collect(Collectors.toSet());
        if (set == null) {
            GoStatisticsWhiteListsService.$$$reportNull$$$0(9);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 6, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/statistics/errors/GoStatisticsWhiteListsService";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilationErrorsDictionary";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeErrorsDictionary";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportsSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdImportsSet";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/statistics/errors/GoStatisticsWhiteListsService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDictionary";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadResourceText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadSet";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadDictionary";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadResourceText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadSet";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 6, 8 -> new IllegalArgumentException(string);
        };
    }
}

