/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk.download;

import com.goide.GoNotifications;
import com.goide.execution.GoWslUtil;
import com.goide.i18n.GoBundle;
import com.goide.sdk.GoBasedSdk;
import com.goide.sdk.GoSdkAccessor;
import com.goide.sdk.download.GoBasedDownloadingSdk;
import com.goide.sdk.download.GoDownloadUnpackSdkStrings;
import com.goide.sdk.download.GoSdkProperties;
import com.goide.util.GoUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.PathUtil;
import com.intellij.util.io.Decompressor;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005B9\b\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\t\u0012\u0006\u0010\f\u001a\u00028\u0000\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ5\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00028\u00012\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a2\u0006\u0002\u0010!J(\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H$J\u001b\u0010&\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00028\u0001\u00a2\u0006\u0002\u0010'JF\u0010(\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00028\u00012\r\u0010)\u001a\t\u0018\u00010$\u00a2\u0006\u0002\b*2\u000e\u0010+\u001a\n\u0018\u00010,j\u0004\u0018\u0001`-2\b\u0010.\u001a\u0004\u0018\u00010$H\u0004\u00a2\u0006\u0002\u0010/J\u0015\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u00028\u0000H$\u00a2\u0006\u0002\u00102J\u001d\u00103\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00028\u00012\u0006\u00104\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00105J\u001d\u00106\u001a\u0002072\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u00108JD\u00109\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010\u001c\u001a\u00028\u00012\u0006\u0010<\u001a\u00020\u00132\u000b\u0010=\u001a\u00070$\u00a2\u0006\u0002\b>H\u0002\u00a2\u0006\u0002\u0010?J=\u0010@\u001a\u00020A2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00028\u00012\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010B\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00132\u0006\u0010C\u001a\u00020AH$\u00a2\u0006\u0002\u0010DJ'\u0010E\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010FR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\f\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/goide/sdk/download/GoSdkDownloader;", "Sdk", "Lcom/goide/sdk/GoBasedSdk;", "DownloadingSdk", "Lcom/goide/sdk/download/GoBasedDownloadingSdk;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "mySdkAccessor", "Lkotlin/Function1;", "Lcom/intellij/openapi/project/Project;", "Lcom/goide/sdk/GoSdkAccessor;", "myNullSdk", "myStrings", "Lcom/goide/sdk/download/GoDownloadUnpackSdkStrings;", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function1;Lcom/goide/sdk/GoBasedSdk;Lcom/goide/sdk/download/GoDownloadUnpackSdkStrings;)V", "myDownloadedArchives", "", "Lcom/goide/sdk/download/GoSdkProperties;", "Ljava/nio/file/Path;", "myDownloadingSdks", "", "getMyDownloadingSdks", "()Ljava/util/Set;", "Lcom/goide/sdk/GoBasedSdk;", "copyDir", "", "project", "sdk", "from", "to", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/project/Project;Lcom/goide/sdk/download/GoBasedDownloadingSdk;Ljava/nio/file/Path;Ljava/nio/file/Path;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "doDownload", "fileName", "", "downloadedFile", "downloadSdk", "(Lcom/intellij/openapi/project/Project;Lcom/goide/sdk/download/GoBasedDownloadingSdk;)V", "error", "message", "Lorg/jetbrains/annotations/Nls;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "details", "(Lcom/intellij/openapi/project/Project;Lcom/goide/sdk/download/GoBasedDownloadingSdk;Ljava/lang/String;Ljava/lang/Exception;Ljava/lang/String;)V", "registerDownloadedSdk", "downloadedSdk", "(Lcom/goide/sdk/GoBasedSdk;)V", "replaceDownloadedSdkWithLocal", "localSdk", "(Lcom/goide/sdk/download/GoBasedDownloadingSdk;Lcom/goide/sdk/GoBasedSdk;)V", "scheduleDownloading", "Lkotlinx/coroutines/Job;", "(Lcom/intellij/openapi/project/Project;Lcom/goide/sdk/download/GoBasedDownloadingSdk;)Lkotlinx/coroutines/Job;", "unpackSdk", "wsl", "Lcom/intellij/execution/wsl/WSLDistribution;", "archive", "targetPath", "Lorg/jetbrains/annotations/NonNls;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/intellij/execution/wsl/WSLDistribution;Lcom/goide/sdk/download/GoBasedDownloadingSdk;Ljava/nio/file/Path;Ljava/lang/String;)V", "verifyChecksum", "", "properties", "silent", "(Lcom/intellij/openapi/project/Project;Lcom/goide/sdk/download/GoBasedDownloadingSdk;Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/goide/sdk/download/GoSdkProperties;Ljava/nio/file/Path;Z)Z", "wrapDownload", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/goide/sdk/download/GoBasedDownloadingSdk;)Lcom/goide/sdk/GoBasedSdk;", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nGoSdkDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoSdkDownloader.kt\ncom/goide/sdk/download/GoSdkDownloader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,232:1\n23#2:233\n23#2:234\n*S KotlinDebug\n*F\n+ 1 GoSdkDownloader.kt\ncom/goide/sdk/download/GoSdkDownloader\n*L\n137#1:233\n227#1:234\n*E\n"})
public abstract class GoSdkDownloader<Sdk extends GoBasedSdk, DownloadingSdk extends GoBasedDownloadingSdk<Sdk>> {
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final Function1<Project, GoSdkAccessor<Sdk>> mySdkAccessor;
    @NotNull
    private final Sdk myNullSdk;
    @NotNull
    private final GoDownloadUnpackSdkStrings myStrings;
    @NotNull
    private final Set<DownloadingSdk> myDownloadingSdks;
    @NotNull
    private final Map<GoSdkProperties, Path> myDownloadedArchives;

    protected GoSdkDownloader(@NotNull CoroutineScope cs, @NotNull Function1<? super Project, ? extends GoSdkAccessor<Sdk>> mySdkAccessor, @NotNull Sdk myNullSdk, @NotNull GoDownloadUnpackSdkStrings myStrings) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter(mySdkAccessor, (String)"mySdkAccessor");
        Intrinsics.checkNotNullParameter(myNullSdk, (String)"myNullSdk");
        Intrinsics.checkNotNullParameter((Object)myStrings, (String)"myStrings");
        this.cs = cs;
        this.mySdkAccessor = mySdkAccessor;
        this.myNullSdk = myNullSdk;
        this.myStrings = myStrings;
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        this.myDownloadingSdks = keySetView;
        this.myDownloadedArchives = new ConcurrentHashMap();
    }

    @NotNull
    protected final Set<DownloadingSdk> getMyDownloadingSdks() {
        return this.myDownloadingSdks;
    }

    public final void downloadSdk(@NotNull Project project, @NotNull DownloadingSdk sdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(sdk, (String)"sdk");
        if (this.myDownloadingSdks.add(sdk)) {
            this.scheduleDownloading(project, sdk);
        } else if (sdk.isDownloaded()) {
            Object Sdk2 = sdk.toLocalSdk();
            Intrinsics.checkNotNullExpressionValue(Sdk2, (String)"toLocalSdk(...)");
            this.replaceDownloadedSdkWithLocal(sdk, Sdk2);
        }
    }

    private final Job scheduleDownloading(Project project, DownloadingSdk sdk) {
        return BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, this, sdk, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ GoSdkDownloader<Sdk, DownloadingSdk> this$0;
            final /* synthetic */ DownloadingSdk $sdk;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$sdk = $sdk;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var3_3 = new Object[]{GoSdkDownloader.access$getMyStrings$p(this.this$0).getSdkName(), this.$sdk.getVersion()};
                        v0 = GoBundle.message((String)"go.settings.sdk.download.progress.downloading.status", (Object[])var3_3);
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"message(...)");
                        this.label = 1;
                        v1 = TasksKt.withBackgroundProgress((Project)this.$project, (String)v0, (boolean)true, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Sdk>, Object>(this.this$0, this.$project, this.$sdk, null){
                            int label;
                            final /* synthetic */ GoSdkDownloader<Sdk, DownloadingSdk> this$0;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ DownloadingSdk $sdk;
                            {
                                this.this$0 = $receiver;
                                this.$project = $project;
                                this.$sdk = $sdk;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Sdk>, Object>(this.this$0, this.$project, this.$sdk, null){
                                            int label;
                                            final /* synthetic */ GoSdkDownloader<Sdk, DownloadingSdk> this$0;
                                            final /* synthetic */ Project $project;
                                            final /* synthetic */ DownloadingSdk $sdk;
                                            {
                                                this.this$0 = $receiver;
                                                this.$project = $project;
                                                this.$sdk = $sdk;
                                                super(2, $completion);
                                            }

                                            /*
                                             * WARNING - void declaration
                                             * Enabled force condition propagation
                                             * Lifted jumps to return sites
                                             */
                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        this.label = 1;
                                                        Object object3 = com.intellij.openapi.progress.CoroutinesKt.coroutineToIndicator((Function0)((Function0)new Function0<Sdk>(this.this$0, this.$project, this.$sdk){
                                                            final /* synthetic */ GoSdkDownloader<Sdk, DownloadingSdk> this$0;
                                                            final /* synthetic */ Project $project;
                                                            final /* synthetic */ DownloadingSdk $sdk;
                                                            {
                                                                this.this$0 = $receiver;
                                                                this.$project = $project;
                                                                this.$sdk = $sdk;
                                                                super(0);
                                                            }

                                                            @Nullable
                                                            public final Sdk invoke() {
                                                                GoBasedSdk goBasedSdk;
                                                                try {
                                                                    ProgressIndicator indicator = ProgressManager.getGlobalProgressIndicator();
                                                                    Intrinsics.checkNotNull((Object)indicator);
                                                                    goBasedSdk = GoSdkDownloader.access$wrapDownload(this.this$0, this.$project, indicator, this.$sdk);
                                                                }
                                                                catch (IOException e) {
                                                                    this.this$0.error(this.$project, this.$sdk, e.getMessage(), e, null);
                                                                    goBasedSdk = null;
                                                                }
                                                                return (Sdk)goBasedSdk;
                                                            }
                                                        }), (Continuation)((Continuation)this));
                                                        if (object3 != object2) return object3;
                                                        return object2;
                                                    }
                                                    case 1: {
                                                        void $result;
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        Object object3 = $result;
                                                        return object3;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Sdk> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Sdk> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl16:
                        // 2 sources

                        if ((v2 = (GoBasedSdk)v1) == null) {
                            v2 = GoSdkDownloader.access$getMyNullSdk$p(this.this$0);
                        }
                        downloadedSdk = v2;
                        this.label = 2;
                        v3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$sdk, downloadedSdk, this.$project, null){
                            int label;
                            final /* synthetic */ GoSdkDownloader<Sdk, DownloadingSdk> this$0;
                            final /* synthetic */ DownloadingSdk $sdk;
                            final /* synthetic */ Sdk $downloadedSdk;
                            final /* synthetic */ Project $project;
                            {
                                this.this$0 = $receiver;
                                this.$sdk = $sdk;
                                this.$downloadedSdk = $downloadedSdk;
                                this.$project = $project;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        this.this$0.getMyDownloadingSdks().remove(this.$sdk);
                                        if (this.$downloadedSdk == GoSdkDownloader.access$getMyNullSdk$p(this.this$0)) {
                                            this.this$0.error(this.$project, this.$sdk, GoBundle.message((String)"go.settings.sdk.download.unpacked.sdk.is.corrupted.error", (Object[])new Object[0]), null, "Home url: " + this.$sdk.getHomeUrl());
                                            return Unit.INSTANCE;
                                        }
                                        this.$sdk.setDownloaded(true);
                                        this.label = 1;
                                        v0 = CoroutinesKt.writeAction((Function0)((Function0)new Function0<Unit>(this.this$0, this.$downloadedSdk, this.$sdk){
                                            final /* synthetic */ GoSdkDownloader<Sdk, DownloadingSdk> this$0;
                                            final /* synthetic */ Sdk $downloadedSdk;
                                            final /* synthetic */ DownloadingSdk $sdk;
                                            {
                                                this.this$0 = $receiver;
                                                this.$downloadedSdk = $downloadedSdk;
                                                this.$sdk = $sdk;
                                                super(0);
                                            }

                                            public final void invoke() {
                                                this.this$0.registerDownloadedSdk(this.$downloadedSdk);
                                                GoSdkDownloader.access$replaceDownloadedSdkWithLocal(this.this$0, this.$sdk, this.$downloadedSdk);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (v0 == var3_2) {
                                            return var3_2;
                                        }
                                        ** GOTO lbl19
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl19:
                                        // 2 sources

                                        v1 = GoNotifications.getGeneralGroup();
                                        var2_3 = new Object[]{GoSdkDownloader.access$getMyStrings$p(this.this$0).getSdkName(), this.$downloadedSdk.getVersion()};
                                        v2 = GoBundle.message((String)"go.settings.sdk.download.installed.notification.title", (Object[])var2_3);
                                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"message(...)");
                                        v1.createNotification(v2, NotificationType.INFORMATION).notify(this.$project);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v3 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl27
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl27:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Sdk wrapDownload(Project project, ProgressIndicator indicator, DownloadingSdk sdk) {
        String string;
        WSLDistribution wsl = GoWslUtil.getWsl(VfsUtilCore.urlToPath((String)sdk.getHomeUrl()));
        if (wsl != null) {
            string = "linux";
        } else {
            String string2 = GoUtil.systemOS();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"systemOS(...)");
        }
        String os = string;
        String string3 = GoUtil.systemArch();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"systemArch(...)");
        String arch = string3;
        indicator.setIndeterminate(false);
        String string4 = sdk.getVersion();
        Intrinsics.checkNotNull((Object)string4);
        GoSdkProperties archiveKey = new GoSdkProperties(os, arch, string4);
        Path downloadedArchive = this.myDownloadedArchives.get(archiveKey);
        String fileName = this.myStrings.getFileName(sdk.getVersion(), os, arch);
        if (downloadedArchive == null || !this.verifyChecksum(project, sdk, indicator, archiveKey, downloadedArchive, true)) {
            downloadedArchive = Files.createTempFile("for-actual-downloading-", this.myStrings.getFileExtension(os), new FileAttribute[0]);
            Intrinsics.checkNotNull((Object)fileName);
            this.doDownload(project, fileName, downloadedArchive, indicator);
            indicator.setText2("");
            if (!this.verifyChecksum(project, sdk, indicator, archiveKey, downloadedArchive, false)) {
                return null;
            }
            this.myDownloadedArchives.put(archiveKey, downloadedArchive);
        }
        Path path = downloadedArchive;
        Intrinsics.checkNotNull((Object)path);
        String string5 = VfsUtilCore.urlToPath((String)sdk.getHomeUrl());
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"urlToPath(...)");
        this.unpackSdk(project, indicator, wsl, sdk, path, string5);
        return sdk.toLocalSdk();
    }

    private final void unpackSdk(Project project, ProgressIndicator indicator, WSLDistribution wsl, DownloadingSdk sdk, Path archive, String targetPath) {
        indicator.setIndeterminate(true);
        indicator.setText(GoBundle.message((String)"go.settings.sdk.download.progress.unpacking.status", (Object[])new Object[0]));
        try {
            if (wsl != null) {
                WSLCommandLineOptions options = new WSLCommandLineOptions();
                Path targetDir = Path.of(targetPath, new String[0]);
                Files.createDirectories(targetDir, new FileAttribute[0]);
                options.setRemoteWorkingDirectory(wsl.getWslPath(targetDir.getParent()));
                Object[] objectArray = new String[]{"tar", "xzf", wsl.getWslPath(archive), "--one-top-level=" + targetDir.getFileName(), "--strip-components", "1"};
                List cmd = CollectionsKt.listOf((Object[])objectArray);
                ProcessOutput processOutput2 = wsl.executeOnWsl(cmd, options, 300000, null);
                Intrinsics.checkNotNullExpressionValue((Object)processOutput2, (String)"executeOnWsl(...)");
                ProcessOutput output2 = processOutput2;
                if (output2.getExitCode() != 0) {
                    String message = StringsKt.trimIndent((String)("\n                        Unpack command '" + StringUtil.join((Collection)cmd, (String)" ") + "' failed\n                        exit code: " + output2.getExitCode() + "\n                        stdout: " + output2.getStdout() + "\n                        stderr: " + output2.getStderr() + "\n                        "));
                    GoSdkDownloader $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(GoSdkDownloader.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn(message);
                    Object[] objectArray2 = new Object[]{output2.getExitCode()};
                    throw new IOException(GoBundle.message((String)"go.wsl.sdk.unpack.error", (Object[])objectArray2));
                }
                LocalFileSystem.getInstance().refreshNioFiles((Iterable)targetDir);
                WriteAction.runAndWait(() -> GoSdkDownloader.unpackSdk$lambda$0(targetPath));
                return;
            }
            Path tempDirectory = Files.createTempDirectory("downloaded-sdk-", new FileAttribute[0]);
            if (Intrinsics.areEqual((Object)"zip", (Object)PathUtil.getFileExtension((String)((Object)archive.getFileName()).toString()))) {
                ZipUtil.unzip((ProgressIndicator)indicator, (File)tempDirectory.toFile(), (File)archive.toFile(), null, null, (boolean)false);
            } else {
                new Decompressor.Tar(archive).extract(tempDirectory);
            }
            Path unpacked = tempDirectory.resolve(this.myStrings.unpackedDirectoryName());
            if (!Files.exists(unpacked, new LinkOption[0]) || !Files.isDirectory(unpacked, new LinkOption[0])) {
                this.error(project, sdk, GoBundle.message((String)"go.settings.sdk.download.could.not.find.go.directory.in.downloaded.file.error", (Object[])new Object[0]), null, null);
                return;
            }
            Path targetDir = Files.createDirectories(Paths.get(targetPath, new String[0]), new FileAttribute[0]);
            Intrinsics.checkNotNull((Object)unpacked);
            Intrinsics.checkNotNull((Object)targetDir);
            this.copyDir(project, sdk, unpacked, targetDir, indicator);
            LocalFileSystem.getInstance().refreshNioFiles((Iterable)SetsKt.setOf((Object)targetDir));
            FileUtil.asyncDelete((File)unpacked.toFile());
        }
        catch (IOException e) {
            this.error(project, sdk, GoBundle.message((String)"go.settings.sdk.download.could.not.unpack.downloaded.file.error", (Object[])new Object[0]), e, null);
        }
        catch (ExecutionException e) {
            this.error(project, sdk, GoBundle.message((String)"go.settings.sdk.download.could.not.unpack.downloaded.file.error", (Object[])new Object[0]), (Exception)((Object)e), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyDir(Project project, DownloadingSdk sdk, Path from, Path to, ProgressIndicator indicator) throws IOException {
        indicator.setIndeterminate(true);
        indicator.setText(GoBundle.message((String)"go.settings.sdk.download.progress.copying.status", (Object[])new Object[0]));
        try {
            AutoCloseable autoCloseable = Files.walk(from, new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                Stream filesStream = (Stream)autoCloseable;
                boolean bl = false;
                filesStream.forEach(arg_0 -> GoSdkDownloader.copyDir$lambda$2$lambda$1((Function1)new Function1<Path, Unit>(indicator, from, to){
                    final /* synthetic */ ProgressIndicator $indicator;
                    final /* synthetic */ Path $from;
                    final /* synthetic */ Path $to;
                    {
                        this.$indicator = $indicator;
                        this.$from = $from;
                        this.$to = $to;
                        super(1);
                    }

                    public final void invoke(@NotNull Path f) {
                        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                        try {
                            this.$indicator.checkCanceled();
                            Path relativePath = this.$from.relativize(f);
                            Object[] objectArray = new Object[]{((Object)relativePath).toString()};
                            this.$indicator.setText2(GoBundle.message((String)"go.settings.sdk.download.progress.copying.detailed.status", (Object[])objectArray));
                            Path targetPath = this.$to.resolve(relativePath);
                            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES};
                            Files.copy(f, targetPath, copyOptionArray);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e.getMessage(), e);
                        }
                    }
                }, arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (UncheckedIOException e) {
            this.error(project, sdk, GoBundle.message((String)"go.settings.sdk.download.could.not.copy.unpacked.sdk.error", (Object[])new Object[0]), e, null);
        }
    }

    private final void replaceDownloadedSdkWithLocal(DownloadingSdk sdk, Sdk localSdk) {
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        for (Project project : projectArray) {
            Intrinsics.checkNotNull((Object)project);
            if (!Intrinsics.areEqual(sdk, ((GoSdkAccessor)this.mySdkAccessor.invoke((Object)project)).getSdk(null))) continue;
            ((GoSdkAccessor)this.mySdkAccessor.invoke((Object)project)).setSdk(localSdk);
        }
    }

    protected abstract void doDownload(@NotNull Project var1, @NotNull String var2, @NotNull Path var3, @NotNull ProgressIndicator var4) throws IOException;

    protected abstract boolean verifyChecksum(@NotNull Project var1, @NotNull DownloadingSdk var2, @NotNull ProgressIndicator var3, @NotNull GoSdkProperties var4, @NotNull Path var5, boolean var6);

    protected final void error(@NotNull Project project, @NotNull DownloadingSdk sdk, @Nullable String message, @Nullable Exception e, @Nullable String details) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(sdk, (String)"sdk");
        NotificationGroup notificationGroup = GoNotifications.getGeneralGroup();
        String string = GoBundle.message((String)"go.settings.sdk.download.failed.to.download.notification.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = message;
        if (string2 == null) {
            string2 = "";
        }
        notificationGroup.createNotification(string, string2, NotificationType.ERROR).addAction((AnAction)NotificationAction.createSimpleExpiring((String)RefactoringBundle.message((String)"retry.command"), () -> GoSdkDownloader.error$lambda$3(sdk, this, project))).notify(null);
        GoSdkDownloader $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GoSdkDownloader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        String string3 = details;
        if (string3 == null) {
            string3 = "";
        }
        logger.info(message + ". " + string3, (Throwable)e);
    }

    protected abstract void registerDownloadedSdk(@NotNull Sdk var1);

    private static final void unpackSdk$lambda$0(String $targetPath) {
        Intrinsics.checkNotNullParameter((Object)$targetPath, (String)"$targetPath");
        VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtilCore.pathToUrl((String)$targetPath));
    }

    private static final void copyDir$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void error$lambda$3(GoBasedDownloadingSdk $sdk, GoSdkDownloader this$0, Project $project) {
        Intrinsics.checkNotNullParameter((Object)$sdk, (String)"$sdk");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        if (!$sdk.isDownloaded()) {
            this$0.downloadSdk($project, $sdk);
        }
    }

    public static final /* synthetic */ GoDownloadUnpackSdkStrings access$getMyStrings$p(GoSdkDownloader $this) {
        return $this.myStrings;
    }

    public static final /* synthetic */ GoBasedSdk access$wrapDownload(GoSdkDownloader $this, Project project, ProgressIndicator indicator, GoBasedDownloadingSdk sdk) {
        return $this.wrapDownload(project, indicator, sdk);
    }

    public static final /* synthetic */ GoBasedSdk access$getMyNullSdk$p(GoSdkDownloader $this) {
        return $this.myNullSdk;
    }

    public static final /* synthetic */ void access$replaceDownloadedSdkWithLocal(GoSdkDownloader $this, GoBasedDownloadingSdk sdk, GoBasedSdk localSdk) {
        $this.replaceDownloadedSdkWithLocal(sdk, localSdk);
    }
}

