/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk;

import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkUtil;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum GoSdkVersion {
    UNKNOWN("unknown"),
    GO_1_1("1.1"),
    GO_1_2("1.2"),
    GO_1_3("1.3"),
    GO_1_4("1.4"),
    GO_1_5("1.5"),
    GO_1_6("1.6"),
    GO_1_7("1.7"),
    GO_1_8("1.8"),
    GO_1_9("1.9"),
    GO_1_10("1.10"),
    GO_1_11("1.11"),
    GO_1_12("1.12"),
    GO_1_13("1.13"),
    GO_1_14("1.14"),
    GO_1_15("1.15"),
    GO_1_16("1.16"),
    GO_1_17("1.17"),
    GO_1_18("1.18"),
    GO_1_19("1.19"),
    GO_1_20("1.20"),
    GO_1_21("1.21"),
    GO_1_22("1.22"),
    GO_DEVEL("devel");

    public static final Set<String> KNOWN_VERSIONS;
    private final String myText;

    private GoSdkVersion(String text) {
        if (text == null) {
            GoSdkVersion.$$$reportNull$$$0(0);
        }
        this.myText = text;
    }

    public String toString() {
        return this.myText;
    }

    public boolean isAtLeast(@NotNull GoSdkVersion version2) {
        if (version2 == null) {
            GoSdkVersion.$$$reportNull$$$0(1);
        }
        return version2 != UNKNOWN && this.compareTo(version2) >= 0;
    }

    public boolean isLessThan(@NotNull GoSdkVersion version2) {
        if (version2 == null) {
            GoSdkVersion.$$$reportNull$$$0(2);
        }
        return version2 != UNKNOWN && this.compareTo(version2) < 0;
    }

    @NotNull
    public static GoSdkVersion fromText(@Nullable String version2) {
        if (version2 != null) {
            String majorVersion = GoSdkUtil.getSdkMajorVersion(version2);
            if (majorVersion == null) {
                majorVersion = GoSdkUtil.getDevelSdkMajorVersion(version2);
            }
            if (majorVersion != null) {
                GoSdkVersion[] values = GoSdkVersion.values();
                for (int i = values.length - 1; i >= 0; --i) {
                    GoSdkVersion value = values[i];
                    if (!value.toString().equals(majorVersion)) continue;
                    GoSdkVersion goSdkVersion = value;
                    if (goSdkVersion == null) {
                        GoSdkVersion.$$$reportNull$$$0(3);
                    }
                    return goSdkVersion;
                }
            }
        }
        GoSdkVersion goSdkVersion = GO_DEVEL;
        if (goSdkVersion == null) {
            GoSdkVersion.$$$reportNull$$$0(4);
        }
        return goSdkVersion;
    }

    public boolean supportsDigitSeparator() {
        return this.isAtLeast(GoSdk.DIGIT_SEPARATOR_VERSION);
    }

    public boolean supportsBinaryDigits() {
        return this.isAtLeast(GoSdk.BINARY_DIGITS_VERSION);
    }

    public boolean supportsOctalPrefix() {
        return this.isAtLeast(GoSdk.OCTAL_PREFIX_VERSION);
    }

    public boolean supportsHexFloats() {
        return this.isAtLeast(GoSdk.HEX_FLOATS_VERSION);
    }

    public boolean supportsSignedShift() {
        return this.isAtLeast(GO_1_13);
    }

    public boolean supportsOverlappingEmbeddedInterfaces() {
        return this.isAtLeast(GO_1_14);
    }

    public boolean supportsGoEmbedDirective() {
        return this.isAtLeast(GO_1_16);
    }

    public boolean supportsSliceToArrayPointerConversion() {
        return this.isAtLeast(GO_1_17);
    }

    public boolean supportsFuzzing() {
        return this.isAtLeast(GO_1_18);
    }

    public boolean supportsGenerics() {
        return this.isAtLeast(GO_1_18);
    }

    public boolean supportsReverseTypeInference() {
        return this.isAtLeast(GO_1_21);
    }

    public boolean supportsGoEmbedAllPatternPrefix() {
        return this.isAtLeast(GO_1_18);
    }

    public boolean supportsUnixBuildConstraint() {
        return this.isAtLeast(GO_1_19);
    }

    public boolean supportsSliceToArrayConversion() {
        return this.isAtLeast(GO_1_20);
    }

    public boolean supportsOverlayFiles() {
        return this.isAtLeast(GO_1_16);
    }

    public boolean supportsBasicInterfacesSatisfyingComparable() {
        return this.isAtLeast(GO_1_20);
    }

    public boolean supportsMultiErrors() {
        return this.isAtLeast(GoSdk.MULTI_ERRORS_VERSION);
    }

    public boolean supportsErrorsIsAndErrorsAs() {
        return this.isAtLeast(GoSdk.ERROR_WRAPPERS_VERSION);
    }

    public boolean supportsMinMaxClearBuiltinFunctions() {
        return this.isAtLeast(GO_1_21);
    }

    public boolean supportsRangeOverInt() {
        return this.isAtLeast(GO_1_22);
    }

    public boolean supportsRangeOverFunc() {
        return this.isAtLeast(GO_1_22);
    }

    public boolean requiresExperimentForRangeOverFunc() {
        return this == GO_1_22;
    }

    public boolean hasPerIterationScopeLoopVar() {
        return this.isAtLeast(GO_1_22);
    }

    public boolean reportsAnonymousInterfaceCycles() {
        return this.isAtLeast(GO_1_21);
    }

    static {
        KNOWN_VERSIONS = ((StreamEx)StreamEx.of((Object[])GoSdkVersion.values()).filter(version2 -> version2 != UNKNOWN && version2 != GO_DEVEL)).map(version2 -> version2.myText).toImmutableSet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/sdk/GoSdkVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/sdk/GoSdkVersion";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeast";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isLessThan";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

