/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk;

import com.goide.GoLibrariesUtil;
import com.goide.project.GoModuleSettings;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkAccessor;
import com.goide.sdk.GoSdkImpl;
import com.goide.sdk.combobox.GoSdkList;
import com.goide.sdk.download.GoDownloadSdkService;
import com.goide.sdk.download.GoDownloadingSdk;
import com.goide.util.GoUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="GOROOT", storages={@Storage(value="$WORKSPACE_FILE$"), @Storage(value="$PROJECT_FILE$", deprecated=true)})
@Service(value={Service.Level.PROJECT})
public final class GoSdkService
extends SimpleModificationTracker
implements PersistentStateComponent<GoProjectsSdkState>,
GoSdkAccessor<GoSdk> {
    public static final Key<String> TESTING_SDK_VERSION = Key.create((String)"GO_TESTING_SDK_VERSION");
    public static final Key<GoSdk> CLI_ORIGINAL_SDK = Key.create((String)"go.commandline.original.sdk");
    private final GoProjectsSdkState myState;
    @NotNull
    private final Project myProject;
    @NotNull
    private volatile GoSdk mySdk;

    public GoSdkService(@NotNull Project project) {
        if (project == null) {
            GoSdkService.$$$reportNull$$$0(0);
        }
        this.myState = new GoProjectsSdkState();
        this.mySdk = GoSdk.NULL;
        PluginVerifier.verifyUltimatePlugin();
        this.myProject = project;
    }

    public static GoSdkService getInstance(@NotNull Project project) {
        if (project == null) {
            GoSdkService.$$$reportNull$$$0(1);
        }
        return (GoSdkService)project.getService(GoSdkService.class);
    }

    @Override
    @NotNull
    public GoSdk getSdk(@Nullable Module module) {
        String testSdkVersion;
        if (module != null && module.isDisposed()) {
            GoSdk goSdk = GoSdk.NULL;
            if (goSdk == null) {
                GoSdkService.$$$reportNull$$$0(2);
            }
            return goSdk;
        }
        String goRootUrl = this.myState.goRootUrl;
        if (this.mySdk == GoSdk.NULL && StringUtil.isNotEmpty((String)goRootUrl)) {
            this.setSdk(GoSdk.fromUrl(goRootUrl), false);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (testSdkVersion = (String)TestModeFlags.get(TESTING_SDK_VERSION)) != null) {
            return new GoSdkImpl(this.mySdk.getHomeUrl(), testSdkVersion, null);
        }
        GoSdk goSdk = this.mySdk;
        if (goSdk == null) {
            GoSdkService.$$$reportNull$$$0(3);
        }
        return goSdk;
    }

    @Deprecated(forRemoval=true)
    public void setSdkHomePath(@Nullable String homePath) {
        this.setSdk(GoSdk.fromHomePath(homePath));
    }

    @Override
    public void setSdk(@NotNull GoSdk sdk) {
        if (sdk == null) {
            GoSdkService.$$$reportNull$$$0(4);
        }
        this.setSdk(sdk, true);
    }

    public void setSdk(@NotNull GoSdk sdk, boolean notify) {
        if (sdk == null) {
            GoSdkService.$$$reportNull$$$0(5);
        }
        if (!Comparing.equal((Object)this.mySdk, (Object)sdk)) {
            boolean newSdkIsEmpty = sdk == GoSdk.NULL;
            boolean hadNoSdk = this.mySdk == GoSdk.NULL;
            this.mySdk = sdk;
            this.myState.goRootUrl = sdk.getHomeUrl();
            if (sdk instanceof GoDownloadingSdk) {
                GoDownloadingSdk downloadingSdk = (GoDownloadingSdk)sdk;
                GoDownloadSdkService.getInstance().downloadSdk(this.myProject, downloadingSdk);
            }
            if (!newSdkIsEmpty) {
                GoSdkList.getInstance().addSdk(sdk);
            }
            if (notify && !this.myProject.isDisposed()) {
                Module[] modules;
                ThreadingAssertions.assertEventDispatchThread();
                this.incModificationCount();
                GoUtil.cleanResolveCache(this.myProject);
                GoLibrariesUtil.updateLibraries(this.myProject, RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED, EmptyRunnable.getInstance(), null);
                MessageBus messageBus = this.myProject.getMessageBus();
                for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
                    if ("default".equals(GoModuleSettings.getInstance((Module)module).getBuildTargetSettings().goVersion)) {
                        ((GoModuleSettings.BuildTargetListener)messageBus.syncPublisher(GoModuleSettings.BUILD_TARGET_TOPIC)).changed(module, true);
                    }
                    if (modules.length != 1 || !hadNoSdk && !newSdkIsEmpty) continue;
                    ((GoModuleSettings.GoSupportListener)messageBus.syncPublisher(GoModuleSettings.GO_SUPPORT_TOPIC)).changed(module, true);
                }
            }
        }
    }

    @Contract(value="null -> false")
    public boolean isGoModule(@Nullable Module module) {
        return module != null && !module.isDisposed() && !this.getSdk(module).getHomeUrl().isEmpty() && GoModuleSettings.getInstance(module).isGoSupportEnabled();
    }

    @NotNull
    public GoProjectsSdkState getState() {
        GoProjectsSdkState goProjectsSdkState = this.myState;
        if (goProjectsSdkState == null) {
            GoSdkService.$$$reportNull$$$0(6);
        }
        return goProjectsSdkState;
    }

    public void loadState(@NotNull GoProjectsSdkState state) {
        if (state == null) {
            GoSdkService.$$$reportNull$$$0(7);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/sdk/GoSdkService";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/sdk/GoSdkService";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdk";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSdk";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6 -> new IllegalStateException(string);
        };
    }

    static class GoProjectsSdkState {
        @Attribute(value="url")
        @Nullable
        private volatile String goRootUrl;

        GoProjectsSdkState() {
        }
    }
}

