/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk;

import com.goide.project.GoBuildTargetSettings;
import com.goide.project.GoModuleSettings;
import com.goide.psi.GoFile;
import com.goide.psi.GoPsiTreeChangeProcessor;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.imports.GoImportResolver;
import com.goide.psi.properties.GoFileProperties;
import com.goide.util.GoUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoPackageUtil {
    private static final Key<CachedValue<Set<String>>> PACKAGES_CACHE = Key.create((String)"packages_cache");
    private static final Key<CachedValue<Set<String>>> PACKAGES_TEST_TRIMMED_CACHE = Key.create((String)"packages_test_trimmed_cache");

    private GoPackageUtil() {
    }

    @Contract(value="null -> false")
    public static boolean isBuiltinPackage(@Nullable PsiFileSystemItem directory) {
        return directory instanceof PsiDirectory && "builtin".equals(directory.getName()) && "builtin".equals(GoPackageUtil.findFirstImportPath((PsiDirectory)directory, false));
    }

    @NotNull
    public static GlobalSearchScope packageScope(@NotNull GoFile file) {
        GoPackage aPackage;
        if (file == null) {
            GoPackageUtil.$$$reportNull$$$0(0);
        }
        GlobalSearchScope globalSearchScope = (aPackage = GoPackage.of(file)) != null ? aPackage.getScope() : GlobalSearchScope.EMPTY_SCOPE;
        if (globalSearchScope == null) {
            GoPackageUtil.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    public static GlobalSearchScope packagesScope(@NotNull Collection<GoPackage> packages2) {
        GlobalSearchScope[] scopes;
        if (packages2 == null) {
            GoPackageUtil.$$$reportNull$$$0(2);
        }
        return (scopes = (GlobalSearchScope[])ContainerUtil.map2Array(packages2, GlobalSearchScope.class, GoPackage::getScope)).length > 0 ? GlobalSearchScope.union((GlobalSearchScope[])scopes) : GlobalSearchScope.EMPTY_SCOPE;
    }

    @NotNull
    public static Set<String> getAllPackagesInDirectory(@Nullable PsiDirectory dir, @Nullable Module contextModule, boolean trimTestSuffices) {
        if (dir == null || !dir.isValid()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                GoPackageUtil.$$$reportNull$$$0(3);
            }
            return set;
        }
        if (contextModule != null && GoUtil.module((PsiElement)dir) != contextModule) {
            return GoPackageUtil.getAllPackagesInDirectoryInner(dir, contextModule, trimTestSuffices);
        }
        Key<CachedValue<Set<String>>> key = trimTestSuffices ? PACKAGES_TEST_TRIMMED_CACHE : PACKAGES_CACHE;
        Set set = (Set)CachedValuesManager.getManager((Project)dir.getProject()).getCachedValue((UserDataHolder)dir, key, () -> {
            Module module = GoUtil.module((PsiElement)dir);
            GoBuildTargetSettings buildTargetSettings = module != null ? GoModuleSettings.getInstance(module).getBuildTargetSettings() : null;
            ModificationTracker packageModificationTracker = GoPsiTreeChangeProcessor.packageModificationTracker((PsiElement)dir);
            return buildTargetSettings != null ? CachedValueProvider.Result.create(GoPackageUtil.getAllPackagesInDirectoryInner(dir, module, trimTestSuffices), (Object[])new Object[]{packageModificationTracker, buildTargetSettings}) : CachedValueProvider.Result.create(GoPackageUtil.getAllPackagesInDirectoryInner(dir, null, trimTestSuffices), (Object[])new Object[]{packageModificationTracker});
        }, false);
        if (set == null) {
            GoPackageUtil.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    private static Set<String> getAllPackagesInDirectoryInner(@NotNull PsiDirectory dir, @Nullable Module contextModule, boolean trimTestSuffices) {
        if (dir == null) {
            GoPackageUtil.$$$reportNull$$$0(5);
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (PsiFile file : dir.getFiles()) {
            String packageName;
            GoFileProperties fileProperties = GoFileProperties.of(file);
            if (fileProperties == null) continue;
            String string = packageName = trimTestSuffices ? fileProperties.getCanonicalPackageName(file.getViewProvider().getVirtualFile()) : fileProperties.packageName;
            if (!StringUtil.isNotEmpty((String)packageName) || set.contains(packageName) || !GoPsiImplUtil.allowed(file, null, contextModule)) continue;
            set.add(packageName);
        }
        LinkedHashSet<String> linkedHashSet = set;
        if (linkedHashSet == null) {
            GoPackageUtil.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    @Contract(value="null, _ -> null")
    public static String findFirstImportPath(@Nullable PsiDirectory directory, boolean vendoringEnabled) {
        for (GoPackage aPackage : GoPackage.in(directory)) {
            String importPath = aPackage.getImportPath(vendoringEnabled);
            if (importPath == null) continue;
            return importPath;
        }
        return null;
    }

    @Nullable
    public static VirtualFile findFileByImportPath(@NotNull String importPathWithFileName, @NotNull Project project, @Nullable Module module) {
        if (importPathWithFileName == null) {
            GoPackageUtil.$$$reportNull$$$0(7);
        }
        if (project == null) {
            GoPackageUtil.$$$reportNull$$$0(8);
        }
        if (importPathWithFileName.isEmpty()) {
            return null;
        }
        String parentPath = FileUtil.toSystemIndependentName((String)PathUtil.getParentPath((String)importPathWithFileName));
        String fileName = PathUtil.getFileName((String)importPathWithFileName);
        for (GoPackage aPackage : GoPackageUtil.findByImportPath(parentPath, project, module, ResolveState.initial())) {
            PsiFile file = aPackage.find(f -> fileName.equals(f.getName()));
            if (file == null) continue;
            return file.getVirtualFile();
        }
        return null;
    }

    public static boolean processFilesInPackage(@NotNull String importPath, @NotNull Project project, @Nullable Module module, @NotNull ResolveState resolveState, @NotNull Processor<? super PsiFile> processor2) {
        if (importPath == null) {
            GoPackageUtil.$$$reportNull$$$0(9);
        }
        if (project == null) {
            GoPackageUtil.$$$reportNull$$$0(10);
        }
        if (resolveState == null) {
            GoPackageUtil.$$$reportNull$$$0(11);
        }
        if (processor2 == null) {
            GoPackageUtil.$$$reportNull$$$0(12);
        }
        for (GoPackage aPackage : GoPackageUtil.findByImportPath(importPath, project, module, resolveState)) {
            if (aPackage.processFiles(processor2)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static Collection<GoPackage> findByImportPath(@NotNull String importPath, @NotNull Project project, @Nullable Module module, @NotNull ResolveState resolveState) {
        if (importPath == null) {
            GoPackageUtil.$$$reportNull$$$0(13);
        }
        if (project == null) {
            GoPackageUtil.$$$reportNull$$$0(14);
        }
        if (resolveState == null) {
            GoPackageUtil.$$$reportNull$$$0(15);
        }
        if (module != null && module.isDisposed() || project.isDisposed()) {
            List<GoPackage> list = Collections.emptyList();
            if (list == null) {
                GoPackageUtil.$$$reportNull$$$0(16);
            }
            return list;
        }
        for (GoImportResolver resolver : GoImportResolver.EP_NAME.getExtensionList()) {
            Collection<GoPackage> directory = resolver.resolve(importPath, project, module, resolveState);
            if (directory == null) continue;
            Collection<GoPackage> collection = directory;
            if (collection == null) {
                GoPackageUtil.$$$reportNull$$$0(17);
            }
            return collection;
        }
        List<GoPackage> list = Collections.emptyList();
        if (list == null) {
            GoPackageUtil.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Nullable
    @Contract(value="null -> null")
    public static GoPackage unwrapGoPackage(@Nullable PsiElement element) {
        return element instanceof PomTargetPsiElement ? (GoPackage)ObjectUtils.tryCast((Object)((PomTargetPsiElement)element).getTarget(), GoPackage.class) : null;
    }

    @Contract(value="null -> false")
    public static boolean isGoPackage(@Nullable PsiElement element) {
        return GoPackageUtil.unwrapGoPackage(element) != null;
    }

    @Nullable
    public static PsiElement getFirstNavigableDirectory(@NotNull Collection<GoPackage> packages2) {
        if (packages2 == null) {
            GoPackageUtil.$$$reportNull$$$0(19);
        }
        for (GoPackage aPackage : packages2) {
            PsiElement navigableElement = aPackage.getNavigableElement();
            if (navigableElement == null) continue;
            return navigableElement;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 6, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/sdk/GoPackageUtil";
                break;
            }
            case 2: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPathWithFileName";
                break;
            }
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveState";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/sdk/GoPackageUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "packageScope";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPackagesInDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPackagesInDirectoryInner";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findByImportPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "packageScope";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "packagesScope";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllPackagesInDirectoryInner";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFileByImportPath";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processFilesInPackage";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findByImportPath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFirstNavigableDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 6, 16, 17, 18 -> new IllegalStateException(string);
        };
    }
}

