/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.ui;

import com.goide.GoFileType;
import com.goide.GoIcons;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoFile;
import com.goide.psi.GoNamedElement;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.refactor.GoNamesValidator;
import com.goide.refactor.ui.GoDeclarationInfo;
import com.goide.refactor.ui.GoDeclarationInfoModel;
import com.goide.refactor.ui.GoDeclarationSelectionPanel;
import com.goide.refactor.ui.GoFileTextFieldWithAutocompletion;
import com.goide.sdk.GoPackageUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.BrowseFolderRunnable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.PanelGridBuilder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.components.JBBox;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import kotlin.jvm.functions.Function1;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class GoRefactoringDialogWithDeclarations<Model extends GoDeclarationInfoModel<?>>
extends RefactoringDialog {
    protected final Collection<PsiElement> myDeclarations;
    protected final String myProtocol;
    protected GoDeclarationSelectionPanel<Model> myDeclarationSelectionPanel;
    protected ComboBox<String> myDirectoryComboBox;
    protected GoFileTextFieldWithAutocompletion myFileTextField;
    protected TextFieldWithAutoCompletion<String> myPackageTextField;

    protected GoRefactoringDialogWithDeclarations(@NotNull Collection<PsiElement> declarations, @NotNull Project project) {
        if (declarations == null) {
            GoRefactoringDialogWithDeclarations.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GoRefactoringDialogWithDeclarations.$$$reportNull$$$0(1);
        }
        this(declarations, project, "file");
    }

    @TestOnly
    protected GoRefactoringDialogWithDeclarations(@NotNull Collection<PsiElement> declarations, @NotNull Project project, @NotNull String protocol) {
        if (declarations == null) {
            GoRefactoringDialogWithDeclarations.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GoRefactoringDialogWithDeclarations.$$$reportNull$$$0(3);
        }
        if (protocol == null) {
            GoRefactoringDialogWithDeclarations.$$$reportNull$$$0(4);
        }
        super(project, true, true);
        this.myDeclarations = declarations;
        this.myProtocol = protocol;
        this.setTitle(this.getRefactoringName());
    }

    @Nls
    @NotNull
    protected abstract String getRefactoringName();

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        if (this.myDirectoryComboBox == null || this.myFileTextField == null || this.myPackageTextField == null) {
            List<ValidationInfo> list = Collections.emptyList();
            if (list == null) {
                GoRefactoringDialogWithDeclarations.$$$reportNull$$$0(5);
            }
            return list;
        }
        String directoryPath = this.getDirectoryPath();
        String fileName = this.getFileName();
        String packageName = this.getPackageName();
        Model declarationInfoModel = this.getDeclarationInfoModel();
        ((GoDeclarationInfoModel)((Object)declarationInfoModel)).setDirectoryPath(directoryPath);
        ((GoDeclarationInfoModel)((Object)declarationInfoModel)).setFileName(fileName);
        ((GoDeclarationInfoModel)((Object)declarationInfoModel)).setPackageName(packageName);
        this.myDeclarationSelectionPanel.getTable().repaint();
        ArrayList<ValidationInfo> infos = new ArrayList<ValidationInfo>();
        for (JComponent component2 : this.getComponentsToValidate()) {
            ComponentValidator.getInstance((JComponent)component2).ifPresent(validator -> {
                validator.enableValidation();
                validator.revalidate();
                ContainerUtil.addIfNotNull((Collection)infos, (Object)validator.getValidationInfo());
            });
        }
        if (!((GoDeclarationInfoModel)((Object)declarationInfoModel)).hasDeclarationsToRefactor()) {
            infos.add(new ValidationInfo(GoBundle.message((String)"go.refactoring.less.than.one.declaration.validation.message", (Object[])new Object[0])));
        }
        if (StringUtil.isEmpty((String)directoryPath)) {
            infos.add(new ValidationInfo(GoBundle.message((String)"go.refactoring.empty.target.directory.path.validation.message", (Object[])new Object[0]), this.myDirectoryComboBox));
        }
        if (StringUtil.isEmpty((String)packageName)) {
            infos.add(new ValidationInfo(GoBundle.message((String)"go.refactoring.empty.target.package.validation.message", (Object[])new Object[0]), this.myPackageTextField));
        }
        ArrayList<ValidationInfo> arrayList = infos;
        if (arrayList == null) {
            GoRefactoringDialogWithDeclarations.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    protected void doAction() {
        List<ValidationInfo> infos = this.doValidateAll();
        this.setErrorInfoAll(Collections.emptyList());
        this.setErrorInfoAll(infos);
        if (!infos.isEmpty()) {
            for (JComponent component2 : this.getComponentsToValidate()) {
                if (!this.hasErrors(component2)) continue;
                component2.requestFocusInWindow();
                break;
            }
            return;
        }
        RecentsManager.getInstance((Project)this.getProject()).registerRecentEntry(this.getRecentDirectoriesKey(), StringUtil.trimEnd((String)this.getDirectoryPath(), (char)'/'));
        Model model = this.getDeclarationInfoModel();
        this.invokeRefactoring(this.getRefactoringProcessor(model));
        FileDocumentManager.getInstance().saveAllDocuments();
    }

    @NotNull
    protected List<JComponent> getComponentsToValidate() {
        List<JComponent> list = Arrays.asList(new JComponent[]{this.getComboBoxEditor(this.myDirectoryComboBox), this.myFileTextField, this.myPackageTextField});
        if (list == null) {
            GoRefactoringDialogWithDeclarations.$$$reportNull$$$0(7);
        }
        return list;
    }

    protected Model getDeclarationInfoModel() {
        return this.myDeclarationSelectionPanel.getTable().getDeclarationInfoModel();
    }

    @NotNull
    protected abstract BaseRefactoringProcessor getRefactoringProcessor(@NotNull Model var1);

    protected @SystemIndependent @NotNull String getDirectoryPath() {
        String string = PathUtil.toSystemIndependentName((String)((String)this.myDirectoryComboBox.getEditor().getItem()));
        if (string == null) {
            GoRefactoringDialogWithDeclarations.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private String getFileName() {
        String string = this.myFileTextField.getFileName();
        if (string == null) {
            GoRefactoringDialogWithDeclarations.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private String getPackageName() {
        String string = this.myPackageTextField.getText();
        if (string == null) {
            GoRefactoringDialogWithDeclarations.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JBBox box = JBBox.createVerticalBox();
        List<GoDeclarationInfo> infos = this.getDeclarationInfos();
        this.myDeclarationSelectionPanel = new GoDeclarationSelectionPanel<Model>(infos, this.createDeclarationInfoModel(infos));
        this.myDeclarationSelectionPanel.getTable().addMemberInfoChangeListener(this.getMemberInfoChangeListener());
        box.add((Component)((Object)this.myDeclarationSelectionPanel));
        box.add(Box.createVerticalStrut(10));
        this.myDirectoryComboBox = this.createDirectoryComboBox();
        this.myFileTextField = this.createFileTextField();
        this.myPackageTextField = this.createPackageTextField();
        PanelGridBuilder builder = UI.PanelFactory.grid();
        builder.add((PanelBuilder)UI.PanelFactory.panel(this.myDirectoryComboBox).withLabel(RefactoringBundle.message((String)"move.files.to.directory.label")));
        builder.add((PanelBuilder)UI.PanelFactory.panel((JComponent)((Object)this.myFileTextField)).withLabel(GoBundle.message((String)"go.refactoring.file.label", (Object[])new Object[0])));
        builder.add((PanelBuilder)UI.PanelFactory.panel(this.myPackageTextField).withLabel(RefactoringBundle.message((String)"move.classes.destination.package.prompt")));
        JPanel panel2 = builder.createPanel();
        Dimension preferredSize = panel2.getPreferredSize();
        panel2.setMaximumSize(new Dimension(Integer.MAX_VALUE, preferredSize.height));
        box.add(panel2);
        JBBox jBBox = box;
        if (jBBox == null) {
            GoRefactoringDialogWithDeclarations.$$$reportNull$$$0(11);
        }
        return jBBox;
    }

    @NotNull
    protected MemberInfoChangeListener<GoNamedElement, GoDeclarationInfo> getMemberInfoChangeListener() {
        MemberInfoChangeListener memberInfoChangeListener = e -> {};
        if (memberInfoChangeListener == null) {
            GoRefactoringDialogWithDeclarations.$$$reportNull$$$0(12);
        }
        return memberInfoChangeListener;
    }

    @NotNull
    protected abstract List<GoDeclarationInfo> getDeclarationInfos();

    @NotNull
    protected abstract Model createDeclarationInfoModel(@NotNull List<GoDeclarationInfo> var1);

    @NonNls
    @NotNull
    private String getRecentDirectoriesKey() {
        String string = this.getRefactoringId() + ".RECENT_KEY";
        if (string == null) {
            GoRefactoringDialogWithDeclarations.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private ComboBox<String> createDirectoryComboBox() {
        LinkedHashSet directories = new LinkedHashSet();
        List recentEntries = RecentsManager.getInstance((Project)this.getProject()).getRecentEntries(this.getRecentDirectoriesKey());
        if (recentEntries != null) {
            directories.addAll(recentEntries);
        }
        StreamEx.of(this.myDeclarations).map(PsiElement::getContainingFile).nonNull().map(PsiFile::getContainingDirectory).map(PsiDirectory::getVirtualFile).map(VirtualFile::getPath).forEach(directories::add);
        ComboBox comboBox = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(new ArrayList(directories)), 300);
        comboBox.setEditable(true);
        comboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
            label.setIcon(GoIcons.DIRECTORY);
            label.setText(value);
        }));
        comboBox.addItemListener(__ -> {
            this.updateFileTextField(null);
            this.updatePackageTextField();
        });
        this.initButtonAndCompletion((ComboBox<String>)comboBox);
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            GoRefactoringDialogWithDeclarations.$$$reportNull$$$0(14);
        }
        return comboBox2;
    }

    private void initButtonAndCompletion(@NotNull ComboBox<String> comboBox) {
        if (comboBox == null) {
            GoRefactoringDialogWithDeclarations.$$$reportNull$$$0(15);
        }
        FileChooserDescriptor fileOrFolderDescriptor = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor((FileType)GoFileType.INSTANCE);
        comboBox.initBrowsableEditor((Runnable)new BrowseFolderRunnable(GoBundle.message((String)"go.refactoring.file.chooser.dialog.title", (Object[])new Object[0]), null, this.getProject(), fileOrFolderDescriptor, comboBox, (TextComponentAccessor)new TextComponentAccessor<ComboBox<String>>(){

            public String getText(ComboBox<String> component2) {
                return (String)component2.getEditor().getItem();
            }

            public void setText(ComboBox<String> component2, @NotNull String text) {
                String fileName;
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((fileName = PathUtil.getFileName((String)text)).endsWith(".go")) {
                    String path = PathUtil.getParentPath((String)text);
                    component2.getEditor().setItem(path);
                    GoRefactoringDialogWithDeclarations.this.updateFileTextField(FileUtil.getNameWithoutExtension((String)fileName));
                } else {
                    component2.getEditor().setItem(text);
                }
                GoRefactoringDialogWithDeclarations.this.updatePackageTextField();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/goide/refactor/ui/GoRefactoringDialogWithDeclarations$1", "setText"));
            }
        }), this.getDisposable());
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        JTextField field = this.getComboBoxEditor(comboBox);
        FileChooserFactory.getInstance().installFileCompletion(field, descriptor, false, null);
        new ComponentValidator(this.getDisposable()).withValidator(() -> this.validateDirectory(this.getDirectoryPath())).installOn((JComponent)field).andRegisterOnDocumentListener((JTextComponent)field).andStartOnFocusLost();
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    protected JTextField getComboBoxEditor(@Nullable ComboBox<String> comboBox) {
        return comboBox != null ? (JTextField)comboBox.getEditor().getEditorComponent() : null;
    }

    @Nullable
    protected ValidationInfo validateDirectory(String directoryPath) {
        if (StringUtil.isEmpty((String)directoryPath)) {
            return null;
        }
        PsiDirectory directory = this.findDirectory(directoryPath);
        if (directory != null && !directory.isWritable()) {
            return new ValidationInfo(GoBundle.message((String)"go.refactoring.non.writable.directory.validation.message", (Object[])new Object[0]), this.myDirectoryComboBox);
        }
        return null;
    }

    @NotNull
    private GoFileTextFieldWithAutocompletion createFileTextField() {
        GoFileTextFieldWithAutocompletion goFileTextFieldWithAutocompletion = new GoFileTextFieldWithAutocompletion(this.myProject, this.findDirectory(this.getDirectoryPath()), (Function1<? super PsiDirectory, ? extends List<String>>)((Function1)this::getFilesInDirectory)).installComponentValidator(this.getDisposable());
        if (goFileTextFieldWithAutocompletion == null) {
            GoRefactoringDialogWithDeclarations.$$$reportNull$$$0(16);
        }
        return goFileTextFieldWithAutocompletion;
    }

    @NotNull
    private TextFieldWithAutoCompletion<String> createPackageTextField() {
        List<String> packages2 = this.getPackagesInDirectory();
        String text = (String)ContainerUtil.getOnlyItem(packages2);
        TextFieldWithAutoCompletion field = TextFieldWithAutoCompletion.create((Project)this.getProject(), packages2, (Icon)GoIcons.PACKAGE, (boolean)true, (String)text);
        new ComponentValidator(this.getDisposable()).withValidator(() -> this.validatePackage(this.getDirectoryPath(), this.getFileName(), this.getPackageName())).installOn((JComponent)field).andRegisterOnDocumentListener((JComponent)field).andStartOnFocusLost();
        TextFieldWithAutoCompletion textFieldWithAutoCompletion = field;
        if (textFieldWithAutoCompletion == null) {
            GoRefactoringDialogWithDeclarations.$$$reportNull$$$0(17);
        }
        return textFieldWithAutoCompletion;
    }

    @Nullable
    protected ValidationInfo validatePackage(String directoryPath, String fileName, String packageName) {
        PsiFile file;
        if (StringUtil.isEmpty((String)packageName)) {
            return null;
        }
        if (!GoNamesValidator.INSTANCE.isIdentifier(packageName, null)) {
            return new ValidationInfo(GoBundle.message((String)"go.refactoring.incorrect.package.name.validation.message", (Object[])new Object[0]), this.myPackageTextField);
        }
        PsiDirectory directory = this.findDirectory(directoryPath);
        if (directory != null && (file = directory.findFile(fileName + ".go")) instanceof GoFile && !packageName.equals(((GoFile)file).getPackageName())) {
            return new ValidationInfo(GoBundle.message((String)"go.refactoring.different.package.name.validation.message", (Object[])new Object[0]), this.myPackageTextField);
        }
        return null;
    }

    private void updatePackageTextField() {
        List<String> packages2 = this.getPackagesInDirectory();
        String packageName = (String)ContainerUtil.getOnlyItem(packages2);
        if (packageName != null) {
            this.myPackageTextField.setText(packageName);
        }
        this.myPackageTextField.setVariants(packages2);
    }

    @NotNull
    private List<String> getPackagesInDirectory() {
        String directoryPath = this.getDirectoryPath();
        PsiDirectory directory = this.findDirectory(directoryPath);
        if (directory != null) {
            String packageName;
            PsiFile file = directory.findFile(this.getFileName() + ".go");
            if (file instanceof GoFile && (packageName = ((GoFile)file).getPackageName()) != null) {
                List<String> list = Collections.singletonList(packageName);
                if (list == null) {
                    GoRefactoringDialogWithDeclarations.$$$reportNull$$$0(18);
                }
                return list;
            }
            return new ArrayList<String>(GoPackageUtil.getAllPackagesInDirectory(directory, null, false));
        }
        List<String> list = Collections.singletonList(GoPsiImplUtil.sanitizePackageName(PathUtil.getFileName((String)directoryPath)));
        if (list == null) {
            GoRefactoringDialogWithDeclarations.$$$reportNull$$$0(19);
        }
        return list;
    }

    private void updateFileTextField(@Nullable String fileName) {
        if (fileName != null) {
            this.myFileTextField.setText(fileName);
        }
        this.myFileTextField.setDirectory(this.findDirectory(this.getDirectoryPath()));
    }

    @VisibleForTesting
    protected List<String> getFilesInDirectory(@NotNull PsiDirectory directory) {
        if (directory == null) {
            GoRefactoringDialogWithDeclarations.$$$reportNull$$$0(20);
        }
        return StreamEx.of((Object[])directory.getFiles()).select(GoFile.class).map(PsiFileImpl::getName).map(FileUtil::getNameWithoutExtension).toList();
    }

    @Nullable
    protected PsiDirectory findDirectory(@Nullable String directoryPath) {
        VirtualFile virtualFile;
        if (directoryPath != null && (virtualFile = VirtualFileManager.getInstance().getFileSystem(this.myProtocol).findFileByPath(directoryPath)) != null) {
            return PsiManager.getInstance((Project)this.getProject()).findDirectory(virtualFile);
        }
        return null;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/ui/GoRefactoringDialogWithDeclarations";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/ui/GoRefactoringDialogWithDeclarations";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidateAll";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentsToValidate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberInfoChangeListener";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentDirectoriesKey";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirectoryComboBox";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileTextField";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageTextField";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagesInDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "initButtonAndCompletion";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFilesInDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 18, 19 -> new IllegalStateException(string);
        };
    }
}

