/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.introduce;

import com.goide.GoFileType;
import com.goide.refactor.GoNamesValidator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GoIntroduceNamedElementDialog
extends RefactoringDialog {
    private final String myHelpId;
    private final Collection<String> mySuggestedNames;
    private final int myOccurrencesCount;
    private NameSuggestionsField myNameField;
    private JCheckBox myReplaceAllCheckBox;

    GoIntroduceNamedElementDialog(@NotNull Project project, @NotNull @NlsContexts.DialogTitle String title, @Nullable String helpId, @NotNull Collection<String> suggestedNames, int occurrencesCount) {
        if (project == null) {
            GoIntroduceNamedElementDialog.$$$reportNull$$$0(0);
        }
        if (title == null) {
            GoIntroduceNamedElementDialog.$$$reportNull$$$0(1);
        }
        if (suggestedNames == null) {
            GoIntroduceNamedElementDialog.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.myHelpId = helpId;
        this.mySuggestedNames = suggestedNames;
        this.myOccurrencesCount = occurrencesCount;
        this.setTitle(title);
        this.setModal(true);
        this.init();
    }

    @Nullable
    protected String getHelpId() {
        return this.myHelpId;
    }

    protected boolean hasPreviewButton() {
        return false;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNameField.getFocusableComponent();
    }

    protected void canRun() throws ConfigurationException {
        if (!this.areButtonsValid()) {
            throw new ConfigurationException(RefactoringBundle.message((String)"refactoring.introduce.name.error"), this.getName());
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.createNamePanel(), "Center");
        if (this.myOccurrencesCount > 1) {
            panel2.add((Component)this.createReplaceAllPanel(), "South");
        }
        panel2.setPreferredSize(new Dimension(this.myNameField.getWidth(), -1));
        return panel2;
    }

    private JComponent createNamePanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        String[] names = ArrayUtil.toStringArray(this.mySuggestedNames);
        this.myNameField = new NameSuggestionsField(names, this.myProject, (FileType)GoFileType.INSTANCE);
        this.myNameField.setBorder((Border)JBUI.Borders.empty((int)3, (int)5, (int)2, (int)3));
        this.myNameField.addDataChangedListener(() -> this.validateButtons());
        JLabel label = new JLabel(RefactoringBundle.message((String)"name.prompt"));
        label.setLabelFor((Component)this.myNameField);
        panel2.add((Component)this.myNameField, "Center");
        panel2.add((Component)label, "West");
        return panel2;
    }

    private JComponent createReplaceAllPanel() {
        JPanel panel2 = new JPanel(new FlowLayout());
        String text = RefactoringBundle.message((String)"replace.all.occurences", (Object[])new Object[]{this.myOccurrencesCount});
        this.myReplaceAllCheckBox = new JCheckBox(text);
        panel2.add(this.myReplaceAllCheckBox);
        return panel2;
    }

    protected boolean areButtonsValid() {
        return GoNamesValidator.INSTANCE.isIdentifier(this.getName(), this.myProject);
    }

    protected void doAction() {
        this.closeOKAction();
    }

    @NlsSafe
    public String getName() {
        return this.myNameField.getEnteredName();
    }

    public boolean getReplaceAll() {
        return this.myReplaceAllCheckBox != null && this.myReplaceAllCheckBox.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "suggestedNames";
                break;
            }
        }
        objectArray[1] = "com/goide/refactor/introduce/GoIntroduceNamedElementDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

