/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.extractInterface;

import com.goide.i18n.GoBundle;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoReferenceExpressionBase;
import com.goide.psi.GoSignature;
import com.goide.refactor.ui.GoDeclarationDependencyGraph;
import com.goide.refactor.ui.GoDeclarationInfo;
import com.goide.refactor.util.GoRefactoringUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public class GoExtractInterfaceDependencyGraph
extends GoDeclarationDependencyGraph {
    GoExtractInterfaceDependencyGraph(@NotNull List<GoDeclarationInfo> infos) {
        if (infos == null) {
            GoExtractInterfaceDependencyGraph.$$$reportNull$$$0(0);
        }
        super(infos);
    }

    @TestOnly
    public GoExtractInterfaceDependencyGraph(@NotNull String protocol, @NotNull List<GoDeclarationInfo> infos) {
        if (protocol == null) {
            GoExtractInterfaceDependencyGraph.$$$reportNull$$$0(1);
        }
        if (infos == null) {
            GoExtractInterfaceDependencyGraph.$$$reportNull$$$0(2);
        }
        super(protocol, infos);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected @NotNull MultiMap<PsiElement, @Nls String> getConflictsInternal(@NotNull GoDeclarationInfo info) {
        if (info == null) {
            GoExtractInterfaceDependencyGraph.$$$reportNull$$$0(3);
        }
        @Nls MultiMap conflicts2 = MultiMap.createLinkedSet();
        GoNamedSignatureOwner declaration = (GoNamedSignatureOwner)info.getDeclaration();
        if (this.isNotFromTargetDirectoryOrPackage(declaration)) {
            if (!info.isExported()) {
                String type2 = StringUtil.capitalize((String)UsageViewUtil.getType((PsiElement)declaration));
                String name = GoRefactoringUtil.htmlEmphasize(declaration);
                conflicts2.putValue((Object)declaration, (Object)GoBundle.message((String)"go.refactoring.extract.interface.unexported.method.specification.validation.message", (Object[])new Object[]{type2, name}));
            }
            ArrayList<GoReferenceExpressionBase> references = new ArrayList<GoReferenceExpressionBase>();
            GoSignature signature = declaration.getSignature();
            if (signature != null) {
                references.addAll(GoRefactoringUtil.collectReferencesToNamedElements(signature));
            }
            for (GoReferenceExpressionBase usage : references) {
                PsiElement usageDeclaration = usage.resolve();
                if (!(usageDeclaration instanceof GoNamedElement) || this.isExported((GoNamedElement)usageDeclaration)) continue;
                this.checkWillBeAccessible((MultiMap<PsiElement, String>)conflicts2, usageDeclaration, usage);
            }
        }
        MultiMap multiMap = conflicts2;
        if (multiMap == null) {
            GoExtractInterfaceDependencyGraph.$$$reportNull$$$0(4);
        }
        return multiMap;
    }

    @Override
    @Nls
    @NotNull
    protected String getUnexportedMessage(@NotNull PsiElement declaration, @NotNull PsiElement usage) {
        Object usageDesc;
        if (declaration == null) {
            GoExtractInterfaceDependencyGraph.$$$reportNull$$$0(5);
        }
        if (usage == null) {
            GoExtractInterfaceDependencyGraph.$$$reportNull$$$0(6);
        }
        String descriptionDesc = GoRefactoringUtil.getDescription(declaration, false);
        GoCompositeElement usageDeclaration = GoRefactoringUtil.findDeclarationForElement(usage);
        if (usageDeclaration instanceof GoMethodDeclaration || usageDeclaration instanceof GoMethodSpec) {
            String name = GoRefactoringUtil.htmlEmphasize((GoNamedElement)usageDeclaration);
            usageDesc = GoBundle.message((String)"go.terms.method.specification", (Object[])new Object[0]) + " " + name;
        } else {
            usageDesc = GoRefactoringUtil.getDescription(usage, true);
        }
        String string = GoBundle.message((String)"go.refactoring.extract.interface.unexported.not.be.accessible.validation.message", (Object[])new Object[]{descriptionDesc, usageDesc});
        if (string == null) {
            GoExtractInterfaceDependencyGraph.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/extractInterface/GoExtractInterfaceDependencyGraph";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/extractInterface/GoExtractInterfaceDependencyGraph";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflictsInternal";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnexportedMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConflictsInternal";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUnexportedMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7 -> new IllegalStateException(string);
        };
    }
}

